/*

  OpenLayers.js -- OpenLayers Map Viewer Library

  Copyright 2005-2006 MetaCarta, Inc., released under the BSD license.
  Please see http://svn.openlayers.org/trunk/openlayers/release-license.txt
  for the full text of the license.

  Includes compressed code under the following licenses:

  (For uncompressed versions of the code used please see the
  OpenLayers SVN repository: <http://openlayers.org/>)

*/

/* Contains portions of Prototype.js:
 *
 * Prototype JavaScript framework, version 1.4.0
 *  (c) 2005 Sam Stephenson <sam@conio.net>
 *
 *  Prototype is freely distributable under the terms of an MIT-style license.
 *  For details, see the Prototype web site: http://prototype.conio.net/
 *
/*--------------------------------------------------------------------------*/

/**  
*  
*  Contains portions of Rico <http://openrico.org/>
* 
*  Copyright 2005 Sabre Airline Solutions  
*  
*  Licensed under the Apache License, Version 2.0 (the "License"); you
*  may not use this file except in compliance with the License. You
*  may obtain a copy of the License at
*  
*         http://www.apache.org/licenses/LICENSE-2.0  
*  
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
*  implied. See the License for the specific language governing
*  permissions and limitations under the License. 
*
**/

_OPENLAYERS_SFL_=true;OpenLayers=new Object();OpenLayers._scriptName=(typeof(_OPENLAYERS_SFL_)=="undefined"?"lib/OpenLayers.js":"OpenLayers.js");OpenLayers._getScriptLocation=function(){var scriptLocation="";var SCRIPT_NAME=OpenLayers._scriptName;var scripts=document.getElementsByTagName('script');for(var i=0;i<scripts.length;i++){var src=scripts[i].getAttribute('src');if(src){var index=src.lastIndexOf(SCRIPT_NAME);if((index>-1)&&(index+SCRIPT_NAME.length==src.length)){scriptLocation=src.slice(0,-SCRIPT_NAME.length);break;}}}
return scriptLocation;}
if(typeof(_OPENLAYERS_SFL_)=="undefined"){(function(){var jsfiles=new Array("OpenLayers/BaseTypes.js","OpenLayers/Util.js","Rico/Corner.js","Rico/Color.js","OpenLayers/Ajax.js","OpenLayers/Events.js","OpenLayers/Map.js","OpenLayers/Layer.js","OpenLayers/Icon.js","OpenLayers/Marker.js","OpenLayers/Marker/Box.js","OpenLayers/Popup.js","OpenLayers/Tile.js","OpenLayers/Feature.js","OpenLayers/Feature/Vector.js","OpenLayers/Feature/WFS.js","OpenLayers/Tile/Image.js","OpenLayers/Tile/WFS.js","OpenLayers/Layer/Image.js","OpenLayers/Layer/EventPane.js","OpenLayers/Layer/FixedZoomLevels.js","OpenLayers/Layer/Google.js","OpenLayers/Layer/VirtualEarth.js","OpenLayers/Layer/Yahoo.js","OpenLayers/Layer/HTTPRequest.js","OpenLayers/Layer/Grid.js","OpenLayers/Layer/MapServer.js","OpenLayers/Layer/MapServer/Untiled.js","OpenLayers/Layer/KaMap.js","OpenLayers/Layer/MultiMap.js","OpenLayers/Layer/Markers.js","OpenLayers/Layer/Text.js","OpenLayers/Layer/WorldWind.js","OpenLayers/Layer/WMS.js","OpenLayers/Layer/WMS/Untiled.js","OpenLayers/Layer/GeoRSS.js","OpenLayers/Layer/Boxes.js","OpenLayers/Layer/Canvas.js","OpenLayers/Layer/TMS.js","OpenLayers/Popup/Anchored.js","OpenLayers/Popup/AnchoredBubble.js","OpenLayers/Handler.js","OpenLayers/Handler/Point.js","OpenLayers/Handler/Path.js","OpenLayers/Handler/Polygon.js","OpenLayers/Handler/Feature.js","OpenLayers/Handler/Drag.js","OpenLayers/Handler/Box.js","OpenLayers/Handler/MouseWheel.js","OpenLayers/Handler/Keyboard.js","OpenLayers/Control.js","OpenLayers/Control/ZoomBox.js","OpenLayers/Control/ZoomToMaxExtent.js","OpenLayers/Control/DragPan.js","OpenLayers/Control/Navigation.js","OpenLayers/Control/MouseDefaults.js","OpenLayers/Control/MousePosition.js","OpenLayers/Control/OverviewMap.js","OpenLayers/Control/KeyboardDefaults.js","OpenLayers/Control/PanZoom.js","OpenLayers/Control/PanZoomBar.js","OpenLayers/Control/ArgParser.js","OpenLayers/Control/Permalink.js","OpenLayers/Control/Scale.js","OpenLayers/Control/LayerSwitcher.js","OpenLayers/Control/DrawFeature.js","OpenLayers/Control/Panel.js","OpenLayers/Control/SelectFeature.js","OpenLayers/Geometry.js","OpenLayers/Geometry/Rectangle.js","OpenLayers/Geometry/Collection.js","OpenLayers/Geometry/Point.js","OpenLayers/Geometry/MultiPoint.js","OpenLayers/Geometry/Curve.js","OpenLayers/Geometry/LineString.js","OpenLayers/Geometry/LinearRing.js","OpenLayers/Geometry/Polygon.js","OpenLayers/Geometry/MultiLineString.js","OpenLayers/Geometry/MultiPolygon.js","OpenLayers/Geometry/Surface.js","OpenLayers/Renderer.js","OpenLayers/Renderer/Elements.js","OpenLayers/Renderer/SVG.js","OpenLayers/Renderer/VML.js","OpenLayers/Layer/Vector.js","OpenLayers/Layer/GML.js","OpenLayers/Format.js","OpenLayers/Format/GML.js","OpenLayers/Format/KML.js","OpenLayers/Format/GeoRSS.js","OpenLayers/Format/WFS.js","OpenLayers/Format/WKT.js","OpenLayers/Layer/WFS.js","OpenLayers/Control/MouseToolbar.js","OpenLayers/Control/NavToolbar.js","OpenLayers/Control/EditingToolbar.js");var allScriptTags="";var host=OpenLayers._getScriptLocation()+"lib/";for(var i=0;i<jsfiles.length;i++){if(/MSIE/.test(navigator.userAgent)||/Safari/.test(navigator.userAgent)){var currentScriptTag="<script src='"+host+jsfiles[i]+"'></script>";allScriptTags+=currentScriptTag;}else{var s=document.createElement("script");s.src=host+jsfiles[i];var h=document.getElementsByTagName("head").length?document.getElementsByTagName("head")[0]:document.body;h.appendChild(s);}}
if(allScriptTags)document.write(allScriptTags);})();}
OpenLayers.VERSION_NUMBER="$Revision: 3113 $";OpenLayers.Class={isPrototype:function(){},create:function(){return function(){if(arguments&&arguments[0]!=OpenLayers.Class.isPrototype)
this.initialize.apply(this,arguments);}},inherit:function(){var superClass=arguments[0];var proto=new superClass(OpenLayers.Class.isPrototype);for(var i=1;i<arguments.length;i++){if(typeof arguments[i]=="function"){var mixin=arguments[i];arguments[i]=new mixin(OpenLayers.Class.isPrototype);}
OpenLayers.Util.extend(proto,arguments[i]);if(arguments[i].hasOwnProperty('toString')){proto.toString=arguments[i].toString;}}
return proto;}};OpenLayers.Pixel=OpenLayers.Class.create();OpenLayers.Pixel.prototype={x:0.0,y:0.0,initialize:function(x,y){this.x=parseFloat(x);this.y=parseFloat(y);},toString:function(){return("x="+this.x+",y="+this.y);},clone:function(){return new OpenLayers.Pixel(this.x,this.y);},equals:function(px){var equals=false;if(px!=null){equals=((this.x==px.x&&this.y==px.y)||(isNaN(this.x)&&isNaN(this.y)&&isNaN(px.x)&&isNaN(px.y)));}
return equals;},add:function(x,y){return new OpenLayers.Pixel(this.x+x,this.y+y);},offset:function(px){var newPx=this.clone();if(px){newPx=this.add(px.x,px.y);}
return newPx;},CLASS_NAME:"OpenLayers.Pixel"};OpenLayers.Size=OpenLayers.Class.create();OpenLayers.Size.prototype={w:0.0,h:0.0,initialize:function(w,h){this.w=parseFloat(w);this.h=parseFloat(h);},toString:function(){return("w="+this.w+",h="+this.h);},clone:function(){return new OpenLayers.Size(this.w,this.h);},equals:function(sz){var equals=false;if(sz!=null){equals=((this.w==sz.w&&this.h==sz.h)||(isNaN(this.w)&&isNaN(this.h)&&isNaN(sz.w)&&isNaN(sz.h)));}
return equals;},CLASS_NAME:"OpenLayers.Size"};OpenLayers.LonLat=OpenLayers.Class.create();OpenLayers.LonLat.prototype={lon:0.0,lat:0.0,initialize:function(lon,lat){this.lon=parseFloat(lon);this.lat=parseFloat(lat);},toString:function(){return("lon="+this.lon+",lat="+this.lat);},toShortString:function(){return(this.lon+", "+this.lat);},clone:function(){return new OpenLayers.LonLat(this.lon,this.lat);},add:function(lon,lat){return new OpenLayers.LonLat(this.lon+lon,this.lat+lat);},equals:function(ll){var equals=false;if(ll!=null){equals=((this.lon==ll.lon&&this.lat==ll.lat)||(isNaN(this.lon)&&isNaN(this.lat)&&isNaN(ll.lon)&&isNaN(ll.lat)));}
return equals;},CLASS_NAME:"OpenLayers.LonLat"};OpenLayers.LonLat.fromString=function(str){var pair=str.split(",");return new OpenLayers.LonLat(parseFloat(pair[0]),parseFloat(pair[1]));};OpenLayers.Bounds=OpenLayers.Class.create();OpenLayers.Bounds.prototype={left:0.0,bottom:0.0,right:0.0,top:0.0,initialize:function(left,bottom,right,top){this.left=parseFloat(left);this.bottom=parseFloat(bottom);this.right=parseFloat(right);this.top=parseFloat(top);},clone:function(){return new OpenLayers.Bounds(this.left,this.bottom,this.right,this.top);},equals:function(bounds){var equals=false;if(bounds!=null){equals=((this.left==bounds.left)&&(this.right==bounds.right)&&(this.top==bounds.top)&&(this.bottom==bounds.bottom));}
return equals;},toString:function(){return("left-bottom=("+this.left+","+this.bottom+")"
+" right-top=("+this.right+","+this.top+")");},toBBOX:function(decimal){if(decimal==null){decimal=6;}
var mult=Math.pow(10,decimal);var bbox=Math.round(this.left*mult)/mult+","+
Math.round(this.bottom*mult)/mult+","+
Math.round(this.right*mult)/mult+","+
Math.round(this.top*mult)/mult;return bbox;},getWidth:function(){return(this.right-this.left);},getHeight:function(){return(this.top-this.bottom);},getSize:function(){return new OpenLayers.Size(this.getWidth(),this.getHeight());},getCenterPixel:function(){return new OpenLayers.Pixel((this.left+this.right)/2,(this.bottom+this.top)/2);},getCenterLonLat:function(){return new OpenLayers.LonLat((this.left+this.right)/2,(this.bottom+this.top)/2);},add:function(x,y){return new OpenLayers.Bounds(this.left+x,this.bottom+y,this.right+x,this.top+y);},extend:function(object){var bounds=null;if(object){switch(object.CLASS_NAME){case"OpenLayers.LonLat":bounds=new OpenLayers.Bounds(object.lon,object.lat,object.lon,object.lat);break;case"OpenLayers.Geometry.Point":bounds=new OpenLayers.Bounds(object.x,object.y,object.x,object.y);break;case"OpenLayers.Bounds":bounds=object;break;}
if(bounds){this.left=(bounds.left<this.left)?bounds.left:this.left;this.bottom=(bounds.bottom<this.bottom)?bounds.bottom:this.bottom;this.right=(bounds.right>this.right)?bounds.right:this.right;this.top=(bounds.top>this.top)?bounds.top:this.top;}}},containsLonLat:function(ll,inclusive){return this.contains(ll.lon,ll.lat,inclusive);},containsPixel:function(px,inclusive){return this.contains(px.x,px.y,inclusive);},contains:function(x,y,inclusive){if(inclusive==null){inclusive=true;}
var contains=false;if(inclusive){contains=((x>=this.left)&&(x<=this.right)&&(y>=this.bottom)&&(y<=this.top));}else{contains=((x>this.left)&&(x<this.right)&&(y>this.bottom)&&(y<this.top));}
return contains;},intersectsBounds:function(bounds,inclusive){if(inclusive==null){inclusive=true;}
var inBottom=(bounds.bottom==this.bottom&&bounds.top==this.top)?true:(((bounds.bottom>this.bottom)&&(bounds.bottom<this.top))||((this.bottom>bounds.bottom)&&(this.bottom<bounds.top)));var inTop=(bounds.bottom==this.bottom&&bounds.top==this.top)?true:(((bounds.top>this.bottom)&&(bounds.top<this.top))||((this.top>bounds.bottom)&&(this.top<bounds.top)));var inRight=(bounds.right==this.right&&bounds.left==this.left)?true:(((bounds.right>this.left)&&(bounds.right<this.right))||((this.right>bounds.left)&&(this.right<bounds.right)));var inLeft=(bounds.right==this.right&&bounds.left==this.left)?true:(((bounds.left>this.left)&&(bounds.left<this.right))||((this.left>bounds.left)&&(this.left<bounds.right)));return(this.containsBounds(bounds,true,inclusive)||bounds.containsBounds(this,true,inclusive)||((inTop||inBottom)&&(inLeft||inRight)));},containsBounds:function(bounds,partial,inclusive){if(partial==null){partial=false;}
if(inclusive==null){inclusive=true;}
var inLeft;var inTop;var inRight;var inBottom;if(inclusive){inLeft=(bounds.left>=this.left)&&(bounds.left<=this.right);inTop=(bounds.top>=this.bottom)&&(bounds.top<=this.top);inRight=(bounds.right>=this.left)&&(bounds.right<=this.right);inBottom=(bounds.bottom>=this.bottom)&&(bounds.bottom<=this.top);}else{inLeft=(bounds.left>this.left)&&(bounds.left<this.right);inTop=(bounds.top>this.bottom)&&(bounds.top<this.top);inRight=(bounds.right>this.left)&&(bounds.right<this.right);inBottom=(bounds.bottom>this.bottom)&&(bounds.bottom<this.top);}
return(partial)?(inTop||inBottom)&&(inLeft||inRight):(inTop&&inLeft&&inBottom&&inRight);},determineQuadrant:function(lonlat){var quadrant="";var center=this.getCenterLonLat();quadrant+=(lonlat.lat<center.lat)?"b":"t";quadrant+=(lonlat.lon<center.lon)?"l":"r";return quadrant;},CLASS_NAME:"OpenLayers.Bounds"};OpenLayers.Bounds.fromString=function(str){var bounds=str.split(",");return OpenLayers.Bounds.fromArray(bounds);};OpenLayers.Bounds.fromArray=function(bbox){return new OpenLayers.Bounds(parseFloat(bbox[0]),parseFloat(bbox[1]),parseFloat(bbox[2]),parseFloat(bbox[3]));};OpenLayers.Bounds.fromSize=function(size){return new OpenLayers.Bounds(0,size.h,size.w,0);};OpenLayers.Bounds.oppositeQuadrant=function(quadrant){var opp="";opp+=(quadrant.charAt(0)=='t')?'b':'t';opp+=(quadrant.charAt(1)=='l')?'r':'l';return opp;};OpenLayers.Element={visible:function(element){return OpenLayers.Util.getElement(element).style.display!='none';},toggle:function(){for(var i=0;i<arguments.length;i++){var element=OpenLayers.Util.getElement(arguments[i]);OpenLayers.Element[OpenLayers.Element.visible(element)?'hide':'show'](element);}},hide:function(){for(var i=0;i<arguments.length;i++){var element=OpenLayers.Util.getElement(arguments[i]);element.style.display='none';}},show:function(){for(var i=0;i<arguments.length;i++){var element=OpenLayers.Util.getElement(arguments[i]);element.style.display='';}},remove:function(element){element=OpenLayers.Util.getElement(element);element.parentNode.removeChild(element);},getHeight:function(element){element=OpenLayers.Util.getElement(element);return element.offsetHeight;},getDimensions:function(element){element=OpenLayers.Util.getElement(element);if(OpenLayers.Element.getStyle(element,'display')!='none')
return{width:element.offsetWidth,height:element.offsetHeight};var els=element.style;var originalVisibility=els.visibility;var originalPosition=els.position;els.visibility='hidden';els.position='absolute';els.display='';var originalWidth=element.clientWidth;var originalHeight=element.clientHeight;els.display='none';els.position=originalPosition;els.visibility=originalVisibility;return{width:originalWidth,height:originalHeight};},getStyle:function(element,style){element=OpenLayers.Util.getElement(element);var value=element.style[style.camelize()];if(!value){if(document.defaultView&&document.defaultView.getComputedStyle){var css=document.defaultView.getComputedStyle(element,null);value=css?css.getPropertyValue(style):null;}else if(element.currentStyle){value=element.currentStyle[style.camelize()];}}
if(window.opera&&OpenLayers.Util.indexOf(['left','top','right','bottom'],style)!=-1)
if(OpenLayers.Element.getStyle(element,'position')=='static')value='auto';return value=='auto'?null:value;}};String.prototype.startsWith=function(sStart){return(this.substr(0,sStart.length)==sStart);};String.prototype.contains=function(str){return(this.indexOf(str)!=-1);};String.prototype.trim=function(){var b=0;while(this.substr(b,1)==" "){b++;}
var e=this.length-1;while(this.substr(e,1)==" "){e--;}
return this.substring(b,e+1);};String.indexOf=function(object){for(var i=0;i<this.length;i++)
if(this[i]==object)return i;return-1;};String.prototype.camelize=function(){var oStringList=this.split('-');if(oStringList.length==1)return oStringList[0];var camelizedString=this.indexOf('-')==0?oStringList[0].charAt(0).toUpperCase()+oStringList[0].substring(1):oStringList[0];for(var i=1,len=oStringList.length;i<len;i++){var s=oStringList[i];camelizedString+=s.charAt(0).toUpperCase()+s.substring(1);}
return camelizedString;};Number.prototype.limitSigDigs=function(sig){var number=(sig>0)?this.toString():0;if(sig<number.length){var exp=number.length-sig;number=Math.round(this/Math.pow(10,exp))*Math.pow(10,exp);}
return parseInt(number);}
Function.prototype.bind=function(){var __method=this,args=[],object=arguments[0];for(var i=1;i<arguments.length;i++)
args.push(arguments[i]);return function(moreargs){for(var i=0;i<arguments.length;i++)
args.push(arguments[i]);return __method.apply(object,args);}};Function.prototype.bindAsEventListener=function(object){var __method=this;return function(event){return __method.call(object,event||window.event);}};OpenLayers.Util=new Object();OpenLayers.Util.getElement=function(){var elements=new Array();for(var i=0;i<arguments.length;i++){var element=arguments[i];if(typeof element=='string'){element=document.getElementById(element);}
if(arguments.length==1){return element;}
elements.push(element);}
return elements;};if($==null){var $=OpenLayers.Util.getElement;}
OpenLayers.Util.extend=function(destination,source){for(property in source){destination[property]=source[property];}
return destination;};OpenLayers.Util.removeItem=function(array,item){for(var i=0;i<array.length;i++){if(array[i]==item){array.splice(i,1);}}
return array;};OpenLayers.Util.clearArray=function(array){array.length=0;};OpenLayers.Util.indexOf=function(array,obj){for(var i=0;i<array.length;i++){if(array[i]==obj)return i;}
return-1;};OpenLayers.Util.modifyDOMElement=function(element,id,px,sz,position,border,overflow,opacity){if(id){element.id=id;}
if(px){element.style.left=px.x+"px";element.style.top=px.y+"px";}
if(sz){element.style.width=sz.w+"px";element.style.height=sz.h+"px";}
if(position){element.style.position=position;}
if(border){element.style.border=border;}
if(overflow){element.style.overflow=overflow;}
if(opacity){element.style.opacity=opacity;element.style.filter='alpha(opacity='+(opacity*100)+')';}};OpenLayers.Util.createDiv=function(id,px,sz,imgURL,position,border,overflow,opacity){var dom=document.createElement('div');if(imgURL){dom.style.backgroundImage='url('+imgURL+')';}
if(!id){id=OpenLayers.Util.createUniqueID("OpenLayersDiv");}
if(!position){position="absolute";}
OpenLayers.Util.modifyDOMElement(dom,id,px,sz,position,border,overflow,opacity);return dom;};OpenLayers.Util.createImage=function(id,px,sz,imgURL,position,border,opacity,delayDisplay){var image=document.createElement("img");if(!id){id=OpenLayers.Util.createUniqueID("OpenLayersDiv");}
if(!position){position="relative";}
OpenLayers.Util.modifyDOMElement(image,id,px,sz,position,border,null,opacity);if(delayDisplay){image.style.display="none";OpenLayers.Event.observe(image,"load",OpenLayers.Util.onImageLoad.bindAsEventListener(image));OpenLayers.Event.observe(image,"error",OpenLayers.Util.onImageLoadError.bindAsEventListener(image));}
image.style.alt=id;image.galleryImg="no";if(imgURL){image.src=imgURL;}
return image;};OpenLayers.Util.setOpacity=function(element,opacity){OpenLayers.Util.modifyDOMElement(element,null,null,null,null,null,null,opacity);}
OpenLayers.Util.onImageLoad=function(){if(!this.viewRequestID||(this.map&&this.viewRequestID==this.map.viewRequestID)){this.style.backgroundColor=null;this.style.display="";}};OpenLayers.Util.onImageLoadErrorColor="pink";OpenLayers.IMAGE_RELOAD_ATTEMPTS=0;OpenLayers.Util.onImageLoadError=function(){this._attempts=(this._attempts)?(this._attempts+1):1;if(this._attempts<=OpenLayers.IMAGE_RELOAD_ATTEMPTS){this.src=this.src;}else{this.style.backgroundColor=OpenLayers.Util.onImageLoadErrorColor;}
this.style.display="";};OpenLayers.Util.alphaHack=function(){var arVersion=navigator.appVersion.split("MSIE");var version=parseFloat(arVersion[1]);var filter=false;try{filter=document.body.filters;}catch(e){}
return(filter&&(version>=5.5)&&(version<7));}
OpenLayers.Util.modifyAlphaImageDiv=function(div,id,px,sz,imgURL,position,border,sizing,opacity){OpenLayers.Util.modifyDOMElement(div,id,px,sz);var img=div.childNodes[0];if(imgURL){img.src=imgURL;}
OpenLayers.Util.modifyDOMElement(img,div.id+"_innerImage",null,sz,"relative",border);if(opacity){div.style.opacity=opacity;div.style.filter='alpha(opacity='+(opacity*100)+')';}
if(OpenLayers.Util.alphaHack()){div.style.display="inline-block";if(sizing==null){sizing="scale";}
div.style.filter="progid:DXImageTransform.Microsoft"+".AlphaImageLoader(src='"+img.src+"', "+"sizingMethod='"+sizing+"')";if(div.style.opacity){div.style.filter+=" alpha(opacity="+div.style.opacity*100+")";}
img.style.filter="progid:DXImageTransform.Microsoft"+".Alpha(opacity=0)";}};OpenLayers.Util.createAlphaImageDiv=function(id,px,sz,imgURL,position,border,sizing,opacity,delayDisplay){var div=OpenLayers.Util.createDiv();var img=OpenLayers.Util.createImage(null,null,null,null,null,null,null,false);div.appendChild(img);if(delayDisplay){img.style.display="none";OpenLayers.Event.observe(img,"load",OpenLayers.Util.onImageLoad.bindAsEventListener(div));OpenLayers.Event.observe(img,"error",OpenLayers.Util.onImageLoadError.bindAsEventListener(div));}
OpenLayers.Util.modifyAlphaImageDiv(div,id,px,sz,imgURL,position,border,sizing,opacity);return div;};OpenLayers.Util.upperCaseObject=function(object){var uObject=new Object();for(var key in object){uObject[key.toUpperCase()]=object[key];}
return uObject;};OpenLayers.Util.applyDefaults=function(to,from){for(var key in from){if(to[key]==null){to[key]=from[key];}}};OpenLayers.Util.getParameterString=function(params){paramsArray=new Array();for(var key in params){var value=params[key];if((value!=null)&&(typeof value!='function')){var encodedValue;if(typeof value=='object'&&value.constructor==Array){var encodedItemArray=new Array();for(var itemIndex=0;itemIndex<value.length;itemIndex++){encodedItemArray.push(encodeURIComponent(value[itemIndex]));}
encodedValue=encodedItemArray.join(",");}
else{encodedValue=encodeURIComponent(value);}
paramsArray.push(encodeURIComponent(key)+"="+encodedValue);}}
return paramsArray.join("&");};OpenLayers.ImgPath='';OpenLayers.Util.getImagesLocation=function(){return OpenLayers.ImgPath||(OpenLayers._getScriptLocation()+"img/");};OpenLayers.Util.Try=function(){var returnValue;for(var i=0;i<arguments.length;i++){var lambda=arguments[i];try{returnValue=lambda();break;}catch(e){}}
return returnValue;}
OpenLayers.Util.getNodes=function(p,tagName){var nodes=OpenLayers.Util.Try(function(){return OpenLayers.Util._getNodes(p.documentElement.childNodes,tagName);},function(){return OpenLayers.Util._getNodes(p.childNodes,tagName);});return nodes;};OpenLayers.Util._getNodes=function(nodes,tagName){var retArray=new Array();for(var i=0;i<nodes.length;i++){if(nodes[i].nodeName==tagName){retArray.push(nodes[i]);}}
return retArray;};OpenLayers.Util.getTagText=function(parent,item,index){var result=OpenLayers.Util.getNodes(parent,item);if(result&&(result.length>0))
{if(!index){index=0;}
if(result[index].childNodes.length>1){return result.childNodes[1].nodeValue;}
else if(result[index].childNodes.length==1){return result[index].firstChild.nodeValue;}}else{return"";}};OpenLayers.Util.getXmlNodeValue=function(node){var val=null;OpenLayers.Util.Try(function(){val=node.text;if(!val)
val=node.textContent;if(!val)
val=node.firstChild.nodeValue;},function(){val=node.textContent;});return val;};OpenLayers.Util.mouseLeft=function(evt,div){var target=(evt.relatedTarget)?evt.relatedTarget:evt.toElement;while(target!=div&&target!=null){target=target.parentNode;}
return(target!=div);};OpenLayers.Util.rad=function(x){return x*Math.PI/180;};OpenLayers.Util.distVincenty=function(p1,p2){var a=6378137,b=6356752.3142,f=1/298.257223563;var L=OpenLayers.Util.rad(p2.lon-p1.lon);var U1=Math.atan((1-f)*Math.tan(OpenLayers.Util.rad(p1.lat)));var U2=Math.atan((1-f)*Math.tan(OpenLayers.Util.rad(p2.lat)));var sinU1=Math.sin(U1),cosU1=Math.cos(U1);var sinU2=Math.sin(U2),cosU2=Math.cos(U2);var lambda=L,lambdaP=2*Math.PI;var iterLimit=20;while(Math.abs(lambda-lambdaP)>1e-12&&--iterLimit>0){var sinLambda=Math.sin(lambda),cosLambda=Math.cos(lambda);var sinSigma=Math.sqrt((cosU2*sinLambda)*(cosU2*sinLambda)+
(cosU1*sinU2-sinU1*cosU2*cosLambda)*(cosU1*sinU2-sinU1*cosU2*cosLambda));if(sinSigma==0)return 0;var cosSigma=sinU1*sinU2+cosU1*cosU2*cosLambda;var sigma=Math.atan2(sinSigma,cosSigma);var alpha=Math.asin(cosU1*cosU2*sinLambda/sinSigma);var cosSqAlpha=Math.cos(alpha)*Math.cos(alpha);var cos2SigmaM=cosSigma-2*sinU1*sinU2/cosSqAlpha;var C=f/16*cosSqAlpha*(4+f*(4-3*cosSqAlpha));lambdaP=lambda;lambda=L+(1-C)*f*Math.sin(alpha)*(sigma+C*sinSigma*(cos2SigmaM+C*cosSigma*(-1+2*cos2SigmaM*cos2SigmaM)));}
if(iterLimit==0)return NaN
var uSq=cosSqAlpha*(a*a-b*b)/(b*b);var A=1+uSq/16384*(4096+uSq*(-768+uSq*(320-175*uSq)));var B=uSq/1024*(256+uSq*(-128+uSq*(74-47*uSq)));var deltaSigma=B*sinSigma*(cos2SigmaM+B/4*(cosSigma*(-1+2*cos2SigmaM*cos2SigmaM)-
B/6*cos2SigmaM*(-3+4*sinSigma*sinSigma)*(-3+4*cos2SigmaM*cos2SigmaM)));var s=b*A*(sigma-deltaSigma);var d=s.toFixed(3)/1000;return d;};OpenLayers.Util.getArgs=function(url){if(url==null){url=window.location.href;}
var query=(url.indexOf('?')!=-1)?url.substring(url.indexOf('?')+1):'';var args=new Object();pairs=query.split(/[&;]/);for(var i=0;i<pairs.length;++i){keyValue=pairs[i].split(/=/);if(keyValue.length==2){args[decodeURIComponent(keyValue[0])]=decodeURIComponent(keyValue[1]);}}
return args;}
OpenLayers.Util.lastSeqID=0;OpenLayers.Util.createUniqueID=function(prefix){if(prefix==null){prefix="id_";}
OpenLayers.Util.lastSeqID+=1;return prefix+OpenLayers.Util.lastSeqID;};OpenLayers.INCHES_PER_UNIT={'inches':1.0,'ft':12.0,'mi':63360.0,'m':39.3701,'km':39370.1,'dd':4374754};OpenLayers.INCHES_PER_UNIT["in"]=OpenLayers.INCHES_PER_UNIT.inches;OpenLayers.INCHES_PER_UNIT["degrees"]=OpenLayers.INCHES_PER_UNIT.dd;OpenLayers.DOTS_PER_INCH=72;OpenLayers.Util.normalizeScale=function(scale){var normScale=(scale>1.0)?(1.0/scale):scale;return normScale;};OpenLayers.Util.getResolutionFromScale=function(scale,units){if(units==null){units="degrees";}
var normScale=OpenLayers.Util.normalizeScale(scale);var resolution=1/(normScale*OpenLayers.INCHES_PER_UNIT[units]*OpenLayers.DOTS_PER_INCH);return resolution;};OpenLayers.Util.getScaleFromResolution=function(resolution,units){if(units==null){units="degrees";}
var scale=resolution*OpenLayers.INCHES_PER_UNIT[units]*OpenLayers.DOTS_PER_INCH;return scale;};OpenLayers.Util.safeStopPropagation=function(evt){OpenLayers.Event.stop(evt,true);};OpenLayers.Util.pagePosition=function(forElement){var valueT=0,valueL=0;var element=forElement;do{valueT+=element.offsetTop||0;valueL+=element.offsetLeft||0;if(element.offsetParent==document.body)
if(OpenLayers.Element.getStyle(element,'position')=='absolute')break;}while(element=element.offsetParent);element=forElement;do{valueT-=element.scrollTop||0;valueL-=element.scrollLeft||0;}while(element=element.parentNode);return[valueL,valueT];};OpenLayers.Util.isEquivalentUrl=function(url1,url2,options){options=options||new Object();OpenLayers.Util.applyDefaults(options,{ignoreCase:true,ignorePort80:true,ignoreHash:true});urlObj1=OpenLayers.Util.createUrlObject(url1,options);urlObj2=OpenLayers.Util.createUrlObject(url2,options);for(var key in urlObj1){if(options.test){alert(key+"\n1:"+urlObj1[key]+"\n2:"+urlObj2[key]);}
var val1=urlObj1[key];var val2=urlObj2[key];switch(key){case"args":break;case"host":case"port":case"protocol":if((val1=="")||(val2=="")){break;}
default:if((key!="args")&&(urlObj1[key]!=urlObj2[key])){return false;}
break;}}
for(var key in urlObj1.args){if(urlObj1.args[key]!=urlObj2.args[key]){return false;}
delete urlObj2.args[key];}
for(var key in urlObj2.args){return false;}
return true;};OpenLayers.Util.createUrlObject=function(url,options){options=options||new Object();var urlObject=new Object();if(options.ignoreCase){url=url.toLowerCase();}
var a=document.createElement('a');a.href=url;urlObject.host=a.host;var port=a.port;if(port.length<=0){var newHostLength=urlObject.host.length-(port.length);urlObject.host=urlObject.host.substring(0,newHostLength);}
urlObject.protocol=a.protocol;urlObject.port=((port=="80")&&(options.ignorePort80))?"":port;urlObject.hash=(options.ignoreHash)?"":a.hash;var queryString=a.search;if(!queryString){var qMark=url.indexOf("?");queryString=(qMark!=-1)?url.substr(qMark):"";}
urlObject.args=OpenLayers.Util.getArgs(queryString);if(((urlObject.protocol=="file:")&&(url.indexOf("file:")!=-1))||((urlObject.protocol!="file:")&&(urlObject.host!=""))){urlObject.pathname=a.pathname;var qIndex=urlObject.pathname.indexOf("?");if(qIndex!=-1){urlObject.pathname=urlObject.pathname.substring(0,qIndex);}}else{var relStr=OpenLayers.Util.removeTail(url);var backs=0;do{var index=relStr.indexOf("../");if(index==0){backs++
relStr=relStr.substr(3);}else if(index>=0){var prevChunk=relStr.substr(0,index-1);var slash=prevChunk.indexOf("/");prevChunk=(slash!=-1)?prevChunk.substr(0,slash+1):"";var postChunk=relStr.substr(index+3);relStr=prevChunk+postChunk;}}while(index!=-1)
var windowAnchor=document.createElement("a");var windowUrl=window.location.href;if(options.ignoreCase){windowUrl=windowUrl.toLowerCase();}
windowAnchor.href=windowUrl;urlObject.protocol=windowAnchor.protocol;var splitter=(windowAnchor.pathname.indexOf("/")!=-1)?"/":"\\";var dirs=windowAnchor.pathname.split(splitter);dirs.pop();while((backs>0)&&(dirs.length>0)){dirs.pop();backs--;}
relStr=dirs.join("/")+"/"+relStr;urlObject.pathname=relStr;}
if((urlObject.protocol=="file:")||(urlObject.protocol=="")){urlObject.host="localhost";}
return urlObject;};OpenLayers.Util.removeTail=function(url){var head=null;var qMark=url.indexOf("?");var hashMark=url.indexOf("#");if(qMark==-1){head=(hashMark!=-1)?url.substr(0,hashMark):url;}else{head=(hashMark!=-1)?url.substr(0,Math.min(qMark,hashMark)):url.substr(0,qMark);}
return head;};OpenLayers.Rico=new Object();OpenLayers.Rico.Corner={round:function(e,options){e=OpenLayers.Util.getElement(e);this._setOptions(options);var color=this.options.color;if(this.options.color=="fromElement")
color=this._background(e);var bgColor=this.options.bgColor;if(this.options.bgColor=="fromParent")
bgColor=this._background(e.offsetParent);this._roundCornersImpl(e,color,bgColor);},changeColor:function(theDiv,newColor){theDiv.style.backgroundColor=newColor;var spanElements=theDiv.parentNode.getElementsByTagName("span");for(var currIdx=0;currIdx<spanElements.length;currIdx++){spanElements[currIdx].style.backgroundColor=newColor;}},changeOpacity:function(theDiv,newOpacity){var mozillaOpacity=newOpacity;var ieOpacity='alpha(opacity='+newOpacity*100+')';theDiv.style.opacity=mozillaOpacity;theDiv.style.filter=ieOpacity;var spanElements=theDiv.parentNode.getElementsByTagName("span");for(var currIdx=0;currIdx<spanElements.length;currIdx++){spanElements[currIdx].style.opacity=mozillaOpacity;spanElements[currIdx].style.filter=ieOpacity;}},reRound:function(theDiv,options){var topRico=theDiv.parentNode.childNodes[0];var bottomRico=theDiv.parentNode.childNodes[2];theDiv.parentNode.removeChild(topRico);theDiv.parentNode.removeChild(bottomRico);this.round(theDiv.parentNode,options);},_roundCornersImpl:function(e,color,bgColor){if(this.options.border)
this._renderBorder(e,bgColor);if(this._isTopRounded())
this._roundTopCorners(e,color,bgColor);if(this._isBottomRounded())
this._roundBottomCorners(e,color,bgColor);},_renderBorder:function(el,bgColor){var borderValue="1px solid "+this._borderColor(bgColor);var borderL="border-left: "+borderValue;var borderR="border-right: "+borderValue;var style="style='"+borderL+";"+borderR+"'";el.innerHTML="<div "+style+">"+el.innerHTML+"</div>"},_roundTopCorners:function(el,color,bgColor){var corner=this._createCorner(bgColor);for(var i=0;i<this.options.numSlices;i++)
corner.appendChild(this._createCornerSlice(color,bgColor,i,"top"));el.style.paddingTop=0;el.insertBefore(corner,el.firstChild);},_roundBottomCorners:function(el,color,bgColor){var corner=this._createCorner(bgColor);for(var i=(this.options.numSlices-1);i>=0;i--)
corner.appendChild(this._createCornerSlice(color,bgColor,i,"bottom"));el.style.paddingBottom=0;el.appendChild(corner);},_createCorner:function(bgColor){var corner=document.createElement("div");corner.style.backgroundColor=(this._isTransparent()?"transparent":bgColor);return corner;},_createCornerSlice:function(color,bgColor,n,position){var slice=document.createElement("span");var inStyle=slice.style;inStyle.backgroundColor=color;inStyle.display="block";inStyle.height="1px";inStyle.overflow="hidden";inStyle.fontSize="1px";var borderColor=this._borderColor(color,bgColor);if(this.options.border&&n==0){inStyle.borderTopStyle="solid";inStyle.borderTopWidth="1px";inStyle.borderLeftWidth="0px";inStyle.borderRightWidth="0px";inStyle.borderBottomWidth="0px";inStyle.height="0px";inStyle.borderColor=borderColor;}
else if(borderColor){inStyle.borderColor=borderColor;inStyle.borderStyle="solid";inStyle.borderWidth="0px 1px";}
if(!this.options.compact&&(n==(this.options.numSlices-1)))
inStyle.height="2px";this._setMargin(slice,n,position);this._setBorder(slice,n,position);return slice;},_setOptions:function(options){this.options={corners:"all",color:"fromElement",bgColor:"fromParent",blend:true,border:false,compact:false}
OpenLayers.Util.extend(this.options,options||{});this.options.numSlices=this.options.compact?2:4;if(this._isTransparent())
this.options.blend=false;},_whichSideTop:function(){if(this._hasString(this.options.corners,"all","top"))
return"";if(this.options.corners.indexOf("tl")>=0&&this.options.corners.indexOf("tr")>=0)
return"";if(this.options.corners.indexOf("tl")>=0)
return"left";else if(this.options.corners.indexOf("tr")>=0)
return"right";return"";},_whichSideBottom:function(){if(this._hasString(this.options.corners,"all","bottom"))
return"";if(this.options.corners.indexOf("bl")>=0&&this.options.corners.indexOf("br")>=0)
return"";if(this.options.corners.indexOf("bl")>=0)
return"left";else if(this.options.corners.indexOf("br")>=0)
return"right";return"";},_borderColor:function(color,bgColor){if(color=="transparent")
return bgColor;else if(this.options.border)
return this.options.border;else if(this.options.blend)
return this._blend(bgColor,color);else
return"";},_setMargin:function(el,n,corners){var marginSize=this._marginSize(n);var whichSide=corners=="top"?this._whichSideTop():this._whichSideBottom();if(whichSide=="left"){el.style.marginLeft=marginSize+"px";el.style.marginRight="0px";}
else if(whichSide=="right"){el.style.marginRight=marginSize+"px";el.style.marginLeft="0px";}
else{el.style.marginLeft=marginSize+"px";el.style.marginRight=marginSize+"px";}},_setBorder:function(el,n,corners){var borderSize=this._borderSize(n);var whichSide=corners=="top"?this._whichSideTop():this._whichSideBottom();if(whichSide=="left"){el.style.borderLeftWidth=borderSize+"px";el.style.borderRightWidth="0px";}
else if(whichSide=="right"){el.style.borderRightWidth=borderSize+"px";el.style.borderLeftWidth="0px";}
else{el.style.borderLeftWidth=borderSize+"px";el.style.borderRightWidth=borderSize+"px";}
if(this.options.border!=false)
el.style.borderLeftWidth=borderSize+"px";el.style.borderRightWidth=borderSize+"px";},_marginSize:function(n){if(this._isTransparent())
return 0;var marginSizes=[5,3,2,1];var blendedMarginSizes=[3,2,1,0];var compactMarginSizes=[2,1];var smBlendedMarginSizes=[1,0];if(this.options.compact&&this.options.blend)
return smBlendedMarginSizes[n];else if(this.options.compact)
return compactMarginSizes[n];else if(this.options.blend)
return blendedMarginSizes[n];else
return marginSizes[n];},_borderSize:function(n){var transparentBorderSizes=[5,3,2,1];var blendedBorderSizes=[2,1,1,1];var compactBorderSizes=[1,0];var actualBorderSizes=[0,2,0,0];if(this.options.compact&&(this.options.blend||this._isTransparent()))
return 1;else if(this.options.compact)
return compactBorderSizes[n];else if(this.options.blend)
return blendedBorderSizes[n];else if(this.options.border)
return actualBorderSizes[n];else if(this._isTransparent())
return transparentBorderSizes[n];return 0;},_hasString:function(str){for(var i=1;i<arguments.length;i++)if(str.indexOf(arguments[i])>=0)return true;return false;},_blend:function(c1,c2){var cc1=OpenLayers.Rico.Color.createFromHex(c1);cc1.blend(OpenLayers.Rico.Color.createFromHex(c2));return cc1;},_background:function(el){try{return OpenLayers.Rico.Color.createColorFromBackground(el).asHex();}catch(err){return"#ffffff";}},_isTransparent:function(){return this.options.color=="transparent";},_isTopRounded:function(){return this._hasString(this.options.corners,"all","top","tl","tr");},_isBottomRounded:function(){return this._hasString(this.options.corners,"all","bottom","bl","br");},_hasSingleTextChild:function(el){return el.childNodes.length==1&&el.childNodes[0].nodeType==3;}}
OpenLayers.ProxyHost="";OpenLayers.nullHandler=function(request){alert("Unhandled request return "+request.statusText);};OpenLayers.loadURL=function(uri,params,caller,onComplete,onFailure){if(OpenLayers.ProxyHost&&uri.startsWith("http")){uri=OpenLayers.ProxyHost+escape(uri);}
var success=(onComplete)?onComplete.bind(caller):OpenLayers.nullHandler;var failure=(onFailure)?onFailure.bind(caller):OpenLayers.nullHandler;new OpenLayers.Ajax.Request(uri,{method:'get',parameters:params,onComplete:success,onFailure:failure});};OpenLayers.parseXMLString=function(text){var index=text.indexOf('<');if(index>0){text=text.substring(index);}
var ajaxResponse=OpenLayers.Util.Try(function(){var xmldom=new ActiveXObject('Microsoft.XMLDOM');xmldom.loadXML(text);return xmldom;},function(){return new DOMParser().parseFromString(text,'text/xml');},function(){var req=new XMLHttpRequest();req.open("GET","data:"+"text/xml"+";charset=utf-8,"+encodeURIComponent(text),false);if(req.overrideMimeType){req.overrideMimeType("text/xml");}
req.send(null);return req.responseXML;});return ajaxResponse;};OpenLayers.Ajax={emptyFunction:function(){},getTransport:function(){return OpenLayers.Util.Try(function(){return new ActiveXObject('Msxml2.XMLHTTP')},function(){return new ActiveXObject('Microsoft.XMLHTTP')},function(){return new XMLHttpRequest()})||false;},activeRequestCount:0};OpenLayers.Ajax.Responders={responders:[],register:function(responderToAdd){for(var i=0;i<this.responders.length;i++)
if(responderToAdd==this.responders[i])
return;this.responders.push(responderToAdd);},dispatch:function(callback,request,transport,json){for(var i=0;i<this.responders.length;i++){responder=this.responders[i];if(responder[callback]&&typeof responder[callback]=='function'){try{responder[callback].apply(responder,[request,transport,json]);}catch(e){}}}}};OpenLayers.Ajax.Responders.register({onCreate:function(){OpenLayers.Ajax.activeRequestCount++;},onComplete:function(){OpenLayers.Ajax.activeRequestCount--;}});OpenLayers.Ajax.Base=function(){};OpenLayers.Ajax.Base.prototype={setOptions:function(options){this.options={method:'post',asynchronous:true,parameters:''}
OpenLayers.Util.extend(this.options,options||{});},responseIsSuccess:function(){return this.transport.status==undefined||this.transport.status==0||(this.transport.status>=200&&this.transport.status<300);},responseIsFailure:function(){return!this.responseIsSuccess();}}
OpenLayers.Ajax.Request=OpenLayers.Class.create();OpenLayers.Ajax.Request.Events=['Uninitialized','Loading','Loaded','Interactive','Complete'];OpenLayers.Ajax.Request.prototype=OpenLayers.Class.inherit(OpenLayers.Ajax.Base,{initialize:function(url,options){this.transport=OpenLayers.Ajax.getTransport();this.setOptions(options);this.request(url);},request:function(url){var parameters=this.options.parameters||'';if(parameters.length>0)parameters+='&_=';try{this.url=url;if(this.options.method=='get'&&parameters.length>0)
this.url+=(this.url.match(/\?/)?'&':'?')+parameters;OpenLayers.Ajax.Responders.dispatch('onCreate',this,this.transport);this.transport.open(this.options.method,this.url,this.options.asynchronous);if(this.options.asynchronous){this.transport.onreadystatechange=this.onStateChange.bind(this);setTimeout((function(){this.respondToReadyState(1)}).bind(this),10);}
this.setRequestHeaders();var body=this.options.postBody?this.options.postBody:parameters;this.transport.send(this.options.method=='post'?body:null);}catch(e){this.dispatchException(e);}},setRequestHeaders:function(){var requestHeaders=['X-Requested-With','XMLHttpRequest','X-Prototype-Version','OpenLayers'];if(this.options.method=='post'&&!this.options.postBody){requestHeaders.push('Content-type','application/x-www-form-urlencoded');if(this.transport.overrideMimeType)
requestHeaders.push('Connection','close');}
if(this.options.requestHeaders)
requestHeaders.push.apply(requestHeaders,this.options.requestHeaders);for(var i=0;i<requestHeaders.length;i+=2)
this.transport.setRequestHeader(requestHeaders[i],requestHeaders[i+1]);},onStateChange:function(){var readyState=this.transport.readyState;if(readyState!=1)
this.respondToReadyState(this.transport.readyState);},header:function(name){try{return this.transport.getResponseHeader(name);}catch(e){}},evalJSON:function(){try{return eval(this.header('X-JSON'));}catch(e){}},evalResponse:function(){try{return eval(this.transport.responseText);}catch(e){this.dispatchException(e);}},respondToReadyState:function(readyState){var event=OpenLayers.Ajax.Request.Events[readyState];var transport=this.transport,json=this.evalJSON();if(event=='Complete'){try{(this.options['on'+this.transport.status]||this.options['on'+(this.responseIsSuccess()?'Success':'Failure')]||OpenLayers.Ajax.emptyFunction)(transport,json);}catch(e){this.dispatchException(e);}
if((this.header('Content-type')||'').match(/^text\/javascript/i))
this.evalResponse();}
try{(this.options['on'+event]||OpenLayers.Ajax.emptyFunction)(transport,json);OpenLayers.Ajax.Responders.dispatch('on'+event,this,transport,json);}catch(e){this.dispatchException(e);}
if(event=='Complete')
this.transport.onreadystatechange=OpenLayers.Ajax.emptyFunction;},dispatchException:function(exception){(this.options.onException||OpenLayers.Ajax.emptyFunction)(this,exception);OpenLayers.Ajax.Responders.dispatch('onException',this,exception);}});OpenLayers.Ajax.getElementsByTagNameNS=function(parentnode,nsuri,nsprefix,tagname){return parentnode.getElementsByTagNameNS?parentnode.getElementsByTagNameNS(nsuri,tagname):parentnode.getElementsByTagName(nsprefix+':'+tagname);}
OpenLayers.Ajax.serializeXMLToString=function(xmldom){var serializer=new XMLSerializer();data=serializer.serializeToString(xmldom);return data;}
OpenLayers.Control=OpenLayers.Class.create();OpenLayers.Control.TYPE_BUTTON=1;OpenLayers.Control.TYPE_TOGGLE=2;OpenLayers.Control.TYPE_TOOL=3;OpenLayers.Control.prototype={id:null,map:null,div:null,type:null,displayClass:"",active:null,handler:null,initialize:function(options){this.displayClass=this.CLASS_NAME.replace("OpenLayers.","ol").replace(".","");OpenLayers.Util.extend(this,options);this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_");},destroy:function(){if(this.handler){this.handler.destroy();}
this.map=null;},setMap:function(map){this.map=map;if(this.handler){this.handler.setMap(map);}},draw:function(px){if(this.div==null){this.div=OpenLayers.Util.createDiv();this.div.id=this.id;this.div.className=this.displayClass;}
if(px!=null){this.position=px.clone();}
this.moveTo(this.position);return this.div;},moveTo:function(px){if((px!=null)&&(this.div!=null)){this.div.style.left=px.x+"px";this.div.style.top=px.y+"px";}},activate:function(){if(this.active){return false;}
if(this.handler){this.handler.activate();}
this.active=true;return true;},deactivate:function(){if(this.active){if(this.handler){this.handler.deactivate();}
this.active=false;return true;}
return false;},CLASS_NAME:"OpenLayers.Control"};OpenLayers.Handler=OpenLayers.Class.create();OpenLayers.Handler.MOD_NONE=0;OpenLayers.Handler.MOD_SHIFT=1;OpenLayers.Handler.MOD_CTRL=2;OpenLayers.Handler.MOD_ALT=4;OpenLayers.Handler.prototype={id:null,control:null,map:null,keyMask:null,active:false,initialize:function(control,callbacks,options){OpenLayers.Util.extend(this,options);this.control=control;this.callbacks=callbacks;if(control.map){this.setMap(control.map);}
OpenLayers.Util.extend(this,options);this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_");},setMap:function(map){this.map=map;},checkModifiers:function(evt){if(this.keyMask==null){return true;}
var keyModifiers=(evt.shiftKey?OpenLayers.Handler.MOD_SHIFT:0)|(evt.ctrlKey?OpenLayers.Handler.MOD_CTRL:0)|(evt.altKey?OpenLayers.Handler.MOD_ALT:0);return(keyModifiers==this.keyMask);},activate:function(){if(this.active){return false;}
var events=OpenLayers.Events.prototype.BROWSER_EVENTS;for(var i=0;i<events.length;i++){if(this[events[i]]){this.register(events[i],this[events[i]]);}}
this.active=true;return true;},deactivate:function(){if(!this.active){return false;}
var events=OpenLayers.Events.prototype.BROWSER_EVENTS;for(var i=0;i<events.length;i++){if(this[events[i]]){this.unregister(events[i],this[events[i]]);}}
this.active=false;return true;},callback:function(name,args){if(this.callbacks[name]){this.callbacks[name].apply(this.control,args);}},register:function(name,method){this.map.events.registerPriority(name,this,method);},unregister:function(name,method){this.map.events.unregister(name,this,method);},destroy:function(){this.control=this.map=null;},CLASS_NAME:"OpenLayers.Handler"};OpenLayers.Icon=OpenLayers.Class.create();OpenLayers.Icon.prototype={url:null,size:null,offset:null,calculateOffset:null,imageDiv:null,px:null,initialize:function(url,size,offset,calculateOffset){this.url=url;this.size=(size)?size:new OpenLayers.Size(20,20);this.offset=offset?offset:new OpenLayers.Pixel(-(this.size.w/2),-(this.size.h/2));this.calculateOffset=calculateOffset;var id=OpenLayers.Util.createUniqueID("OL_Icon_");this.imageDiv=OpenLayers.Util.createAlphaImageDiv(id);},destroy:function(){OpenLayers.Event.stopObservingElement(this.imageDiv.firstChild);this.imageDiv.innerHTML="";this.imageDiv=null;},clone:function(){return new OpenLayers.Icon(this.url,this.size,this.offset,this.calculateOffset);},setSize:function(size){if(size!=null){this.size=size;}
this.draw();},draw:function(px){OpenLayers.Util.modifyAlphaImageDiv(this.imageDiv,null,null,this.size,this.url,"absolute");this.moveTo(px);return this.imageDiv;},setOpacity:function(opacity){OpenLayers.Util.modifyAlphaImageDiv(this.imageDiv,null,null,null,null,null,null,null,opacity);},moveTo:function(px){if(px!=null){this.px=px;}
if(this.imageDiv!=null){if(this.px==null){this.display(false);}else{if(this.calculateOffset){this.offset=this.calculateOffset(this.size);}
var offsetPx=this.px.offset(this.offset);OpenLayers.Util.modifyAlphaImageDiv(this.imageDiv,null,offsetPx);}}},display:function(display){this.imageDiv.style.display=(display)?"":"none";},CLASS_NAME:"OpenLayers.Icon"};OpenLayers.Popup=OpenLayers.Class.create();OpenLayers.Popup.WIDTH=200;OpenLayers.Popup.HEIGHT=200;OpenLayers.Popup.COLOR="white";OpenLayers.Popup.OPACITY=1;OpenLayers.Popup.BORDER="0px";OpenLayers.Popup.prototype={events:null,id:"",lonlat:null,div:null,size:null,contentHTML:"",backgroundColor:"",opacity:"",border:"",contentDiv:null,padding:5,map:null,initialize:function(id,lonlat,size,contentHTML,closeBox){if(id==null){id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_");}
this.id=id;this.lonlat=lonlat;this.size=(size!=null)?size:new OpenLayers.Size(OpenLayers.Popup.WIDTH,OpenLayers.Popup.HEIGHT);if(contentHTML!=null){this.contentHTML=contentHTML;}
this.backgroundColor=OpenLayers.Popup.COLOR;this.opacity=OpenLayers.Popup.OPACITY;this.border=OpenLayers.Popup.BORDER;this.div=OpenLayers.Util.createDiv(this.id,null,null,null,null,null,"hidden");this.div.className='olPopup';var id=this.div.id+"_contentDiv";this.contentDiv=OpenLayers.Util.createDiv(id,null,this.size.clone(),null,"relative",null,"hidden");this.contentDiv.className='olPopupContent';this.div.appendChild(this.contentDiv);if(closeBox==true){var closeSize=new OpenLayers.Size(17,17);var img=OpenLayers.Util.getImagesLocation()+"close.gif";var closeImg=OpenLayers.Util.createAlphaImageDiv(this.id+"_close",null,closeSize,img);closeImg.style.right=this.padding+"px";closeImg.style.top=this.padding+"px";this.div.appendChild(closeImg);var closePopup=function(e){this.hide();OpenLayers.Event.stop(e);}
OpenLayers.Event.observe(closeImg,"click",closePopup.bindAsEventListener(this));}
this.registerEvents();},destroy:function(){if(this.map!=null){this.map.removePopup(this);this.map=null;}
this.events.destroy();this.events=null;this.div=null;},draw:function(px){if(px==null){if((this.lonlat!=null)&&(this.map!=null)){px=this.map.getLayerPxFromLonLat(this.lonlat);}}
this.setSize();this.setBackgroundColor();this.setOpacity();this.setBorder();this.setContentHTML();this.moveTo(px);return this.div;},updatePosition:function(){if((this.lonlat)&&(this.map)){var px=this.map.getLayerPxFromLonLat(this.lonlat);this.moveTo(px);}},moveTo:function(px){if((px!=null)&&(this.div!=null)){this.div.style.left=px.x+"px";this.div.style.top=px.y+"px";}},visible:function(){return OpenLayers.Element.visible(this.div);},toggle:function(){OpenLayers.Element.toggle(this.div);},show:function(){OpenLayers.Element.show(this.div);},hide:function(){OpenLayers.Element.hide(this.div);},setSize:function(size){if(size!=undefined){this.size=size;}
if(this.div!=null){this.div.style.width=this.size.w+"px";this.div.style.height=this.size.h+"px";}
if(this.contentDiv!=null){this.contentDiv.style.width=this.size.w+"px";this.contentDiv.style.height=this.size.h+"px";}},setBackgroundColor:function(color){if(color!=undefined){this.backgroundColor=color;}
if(this.div!=null){this.div.style.backgroundColor=this.backgroundColor;}},setOpacity:function(opacity){if(opacity!=undefined){this.opacity=opacity;}
if(this.div!=null){this.div.style.opacity=this.opacity;this.div.style.filter='alpha(opacity='+this.opacity*100+')';}},setBorder:function(border){if(border!=undefined){this.border=border;}
if(this.div!=null){this.div.style.border=this.border;}},setContentHTML:function(contentHTML){if(contentHTML!=null){this.contentHTML=contentHTML;}
if(this.contentDiv!=null){this.contentDiv.innerHTML=this.contentHTML;}},registerEvents:function(){this.events=new OpenLayers.Events(this,this.div,null,true);this.events.register("mousedown",this,this.onmousedown);this.events.register("mousemove",this,this.onmousemove);this.events.register("mouseup",this,this.onmouseup);this.events.register("click",this,this.onclick);this.events.register("mouseout",this,this.onmouseout);this.events.register("dblclick",this,this.ondblclick);},onmousedown:function(evt){this.mousedown=true;OpenLayers.Event.stop(evt,true);},onmousemove:function(evt){if(this.mousedown){OpenLayers.Event.stop(evt,true);}},onmouseup:function(evt){if(this.mousedown){this.mousedown=false;OpenLayers.Event.stop(evt,true);}},onclick:function(evt){OpenLayers.Event.stop(evt,true);},onmouseout:function(evt){this.mousedown=false;},ondblclick:function(evt){OpenLayers.Event.stop(evt,true);},CLASS_NAME:"OpenLayers.Popup"};OpenLayers.Renderer=OpenLayers.Class.create();OpenLayers.Renderer.prototype={container:null,extent:null,size:null,resolution:null,map:null,initialize:function(containerID){this.container=$(containerID);},destroy:function(){this.container=null;this.extent=null;this.size=null;this.resolution=null;this.map=null;},supported:function(){return false;},setExtent:function(extent){this.extent=extent.clone();this.resolution=null;},setSize:function(size){this.size=size.clone();this.resolution=null;},getResolution:function(){this.resolution=this.resolution||this.map.getResolution();return this.resolution;},drawFeature:function(feature,style){if(style==null){style=feature.style;}
this.drawGeometry(feature.geometry,style,feature.id);},drawGeometry:function(geometry,style,featureId){},clear:function(){},getFeatureIdFromEvent:function(evt){},eraseFeatures:function(features){if(!(features instanceof Array)){features=[features];}
for(var i=0;i<features.length;++i){this.eraseGeometry(features[i].geometry);}},eraseGeometry:function(geometry){},CLASS_NAME:"OpenLayers.Renderer"};OpenLayers.Rico.Color=OpenLayers.Class.create();OpenLayers.Rico.Color.prototype={initialize:function(red,green,blue){this.rgb={r:red,g:green,b:blue};},setRed:function(r){this.rgb.r=r;},setGreen:function(g){this.rgb.g=g;},setBlue:function(b){this.rgb.b=b;},setHue:function(h){var hsb=this.asHSB();hsb.h=h;this.rgb=OpenLayers.Rico.Color.HSBtoRGB(hsb.h,hsb.s,hsb.b);},setSaturation:function(s){var hsb=this.asHSB();hsb.s=s;this.rgb=OpenLayers.Rico.Color.HSBtoRGB(hsb.h,hsb.s,hsb.b);},setBrightness:function(b){var hsb=this.asHSB();hsb.b=b;this.rgb=OpenLayers.Rico.Color.HSBtoRGB(hsb.h,hsb.s,hsb.b);},darken:function(percent){var hsb=this.asHSB();this.rgb=OpenLayers.Rico.Color.HSBtoRGB(hsb.h,hsb.s,Math.max(hsb.b-percent,0));},brighten:function(percent){var hsb=this.asHSB();this.rgb=OpenLayers.Rico.Color.HSBtoRGB(hsb.h,hsb.s,Math.min(hsb.b+percent,1));},blend:function(other){this.rgb.r=Math.floor((this.rgb.r+other.rgb.r)/2);this.rgb.g=Math.floor((this.rgb.g+other.rgb.g)/2);this.rgb.b=Math.floor((this.rgb.b+other.rgb.b)/2);},isBright:function(){var hsb=this.asHSB();return this.asHSB().b>0.5;},isDark:function(){return!this.isBright();},asRGB:function(){return"rgb("+this.rgb.r+","+this.rgb.g+","+this.rgb.b+")";},asHex:function(){return"#"+this.rgb.r.toColorPart()+this.rgb.g.toColorPart()+this.rgb.b.toColorPart();},asHSB:function(){return OpenLayers.Rico.Color.RGBtoHSB(this.rgb.r,this.rgb.g,this.rgb.b);},toString:function(){return this.asHex();}};OpenLayers.Rico.Color.createFromHex=function(hexCode){if(hexCode.length==4){var shortHexCode=hexCode;var hexCode='#';for(var i=1;i<4;i++)hexCode+=(shortHexCode.charAt(i)+
shortHexCode.charAt(i));}
if(hexCode.indexOf('#')==0)
hexCode=hexCode.substring(1);var red=hexCode.substring(0,2);var green=hexCode.substring(2,4);var blue=hexCode.substring(4,6);return new OpenLayers.Rico.Color(parseInt(red,16),parseInt(green,16),parseInt(blue,16));}
OpenLayers.Rico.Color.createColorFromBackground=function(elem){var actualColor=RicoUtil.getElementsComputedStyle(OpenLayers.Util.getElement(elem),"backgroundColor","background-color");if(actualColor=="transparent"&&elem.parentNode)
return OpenLayers.Rico.Color.createColorFromBackground(elem.parentNode);if(actualColor==null)
return new OpenLayers.Rico.Color(255,255,255);if(actualColor.indexOf("rgb(")==0){var colors=actualColor.substring(4,actualColor.length-1);var colorArray=colors.split(",");return new OpenLayers.Rico.Color(parseInt(colorArray[0]),parseInt(colorArray[1]),parseInt(colorArray[2]));}
else if(actualColor.indexOf("#")==0){return OpenLayers.Rico.Color.createFromHex(actualColor);}
else
return new OpenLayers.Rico.Color(255,255,255);}
OpenLayers.Rico.Color.HSBtoRGB=function(hue,saturation,brightness){var red=0;var green=0;var blue=0;if(saturation==0){red=parseInt(brightness*255.0+0.5);green=red;blue=red;}
else{var h=(hue-Math.floor(hue))*6.0;var f=h-Math.floor(h);var p=brightness*(1.0-saturation);var q=brightness*(1.0-saturation*f);var t=brightness*(1.0-(saturation*(1.0-f)));switch(parseInt(h)){case 0:red=(brightness*255.0+0.5);green=(t*255.0+0.5);blue=(p*255.0+0.5);break;case 1:red=(q*255.0+0.5);green=(brightness*255.0+0.5);blue=(p*255.0+0.5);break;case 2:red=(p*255.0+0.5);green=(brightness*255.0+0.5);blue=(t*255.0+0.5);break;case 3:red=(p*255.0+0.5);green=(q*255.0+0.5);blue=(brightness*255.0+0.5);break;case 4:red=(t*255.0+0.5);green=(p*255.0+0.5);blue=(brightness*255.0+0.5);break;case 5:red=(brightness*255.0+0.5);green=(p*255.0+0.5);blue=(q*255.0+0.5);break;}}
return{r:parseInt(red),g:parseInt(green),b:parseInt(blue)};}
OpenLayers.Rico.Color.RGBtoHSB=function(r,g,b){var hue;var saturation;var brightness;var cmax=(r>g)?r:g;if(b>cmax)
cmax=b;var cmin=(r<g)?r:g;if(b<cmin)
cmin=b;brightness=cmax/255.0;if(cmax!=0)
saturation=(cmax-cmin)/cmax;else
saturation=0;if(saturation==0)
hue=0;else{var redc=(cmax-r)/(cmax-cmin);var greenc=(cmax-g)/(cmax-cmin);var bluec=(cmax-b)/(cmax-cmin);if(r==cmax)
hue=bluec-greenc;else if(g==cmax)
hue=2.0+redc-bluec;else
hue=4.0+greenc-redc;hue=hue/6.0;if(hue<0)
hue=hue+1.0;}
return{h:hue,s:saturation,b:brightness};}
OpenLayers.Control.ArgParser=OpenLayers.Class.create();OpenLayers.Control.ArgParser.prototype=OpenLayers.Class.inherit(OpenLayers.Control,{center:null,zoom:null,layers:null,initialize:function(element,base){OpenLayers.Control.prototype.initialize.apply(this,arguments);},setMap:function(map){OpenLayers.Control.prototype.setMap.apply(this,arguments);for(var i=0;i<this.map.controls.length;i++){var control=this.map.controls[i];if((control!=this)&&(control.CLASS_NAME=="OpenLayers.Control.ArgParser")){break;}}
if(i==this.map.controls.length){var args=OpenLayers.Util.getArgs();if(args.lat&&args.lon){this.center=new OpenLayers.LonLat(parseFloat(args.lon),parseFloat(args.lat));if(args.zoom){this.zoom=parseInt(args.zoom);}
this.map.events.register('changebaselayer',this,this.setCenter);this.setCenter();}
if(args.layers){this.layers=args.layers;this.map.events.register('addlayer',this,this.configureLayers);this.configureLayers();}}},setCenter:function(){if(this.map.baseLayer){this.map.events.unregister('changebaselayer',this,this.setCenter);this.map.setCenter(this.center,this.zoom);}},configureLayers:function(){if(this.layers.length==this.map.layers.length){this.map.events.unregister('addlayer',this,this.configureLayers);for(var i=0;i<this.layers.length;i++){var layer=this.map.layers[i];var c=this.layers.charAt(i);if(c=="B"){this.map.setBaseLayer(layer);}else if((c=="T")||(c=="F")){layer.setVisibility(c=="T");}}}},CLASS_NAME:"OpenLayers.Control.ArgParser"});OpenLayers.Control.LayerSwitcher=OpenLayers.Class.create();OpenLayers.Control.LayerSwitcher.prototype=OpenLayers.Class.inherit(OpenLayers.Control,{activeColor:"darkblue",layersDiv:null,baseLayersDiv:null,baseLayers:null,dataLbl:null,dataLayersDiv:null,dataLayers:null,minimizeDiv:null,maximizeDiv:null,ascending:true,initialize:function(options){OpenLayers.Control.prototype.initialize.apply(this,arguments);},destroy:function(){OpenLayers.Event.stopObservingElement(this.div);OpenLayers.Event.stopObservingElement(this.minimizeDiv);OpenLayers.Event.stopObservingElement(this.maximizeDiv);this.clearLayersArray("base");this.clearLayersArray("data");this.map.events.unregister("addlayer",this,this.redraw);this.map.events.unregister("changelayer",this,this.redraw);this.map.events.unregister("removelayer",this,this.redraw);this.map.events.unregister("changebaselayer",this,this.redraw);OpenLayers.Control.prototype.destroy.apply(this,arguments);},setMap:function(map){OpenLayers.Control.prototype.setMap.apply(this,arguments);this.map.events.register("addlayer",this,this.redraw);this.map.events.register("changelayer",this,this.redraw);this.map.events.register("removelayer",this,this.redraw);this.map.events.register("changebaselayer",this,this.redraw);},draw:function(){OpenLayers.Control.prototype.draw.apply(this);this.loadContents();this.minimizeControl();this.redraw();return this.div;},clearLayersArray:function(layersType){var layers=this[layersType+"Layers"];if(layers){for(var i=0;i<layers.length;i++){var layer=layers[i];OpenLayers.Event.stopObservingElement(layer.inputElem);OpenLayers.Event.stopObservingElement(layer.labelSpan);}}
this[layersType+"LayersDiv"].innerHTML="";this[layersType+"Layers"]=new Array();},redraw:function(){this.clearLayersArray("base");this.clearLayersArray("data");var containsOverlays=false;var layers=this.map.layers.slice();if(!this.ascending){layers.reverse();}
for(var i=0;i<layers.length;i++){var layer=layers[i];var baseLayer=layer.isBaseLayer;if(baseLayer||layer.displayInLayerSwitcher){if(!baseLayer){containsOverlays=true;}
var checked=(baseLayer)?(layer==this.map.baseLayer):layer.getVisibility();var inputElem=document.createElement("input");inputElem.id="input_"+layer.name;inputElem.name=(baseLayer)?"baseLayers":layer.name;inputElem.type=(baseLayer)?"radio":"checkbox";inputElem.value=layer.name;inputElem.checked=checked;inputElem.defaultChecked=checked;if(!baseLayer&&!layer.inRange){inputElem.disabled=true;}
var context={'inputElem':inputElem,'layer':layer,'layerSwitcher':this}
OpenLayers.Event.observe(inputElem,"mouseup",this.onInputClick.bindAsEventListener(context));var labelSpan=document.createElement("span");if(!baseLayer&&!layer.inRange){labelSpan.style.color="gray";}
labelSpan.innerHTML=layer.name;labelSpan.style.verticalAlign=(baseLayer)?"bottom":"baseline";OpenLayers.Event.observe(labelSpan,"click",this.onInputClick.bindAsEventListener(context));var br=document.createElement("br");var groupArray=(baseLayer)?this.baseLayers:this.dataLayers;groupArray.push({'layer':layer,'inputElem':inputElem,'labelSpan':labelSpan});var groupDiv=(baseLayer)?this.baseLayersDiv:this.dataLayersDiv;groupDiv.appendChild(inputElem);groupDiv.appendChild(labelSpan);groupDiv.appendChild(br);}}
this.dataLbl.style.display=(containsOverlays)?"":"none";return this.div;},onInputClick:function(e){if(!this.inputElem.disabled){if(this.inputElem.type=="radio"){this.inputElem.checked=true;this.layer.map.setBaseLayer(this.layer,true);this.layer.map.events.triggerEvent("changebaselayer");}else{this.inputElem.checked=!this.inputElem.checked;this.layerSwitcher.updateMap();}}
OpenLayers.Event.stop(e);},onLayerClick:function(e){this.updateMap();},updateMap:function(){for(var i=0;i<this.baseLayers.length;i++){var layerEntry=this.baseLayers[i];if(layerEntry.inputElem.checked){this.map.setBaseLayer(layerEntry.layer,false);}}
for(var i=0;i<this.dataLayers.length;i++){var layerEntry=this.dataLayers[i];layerEntry.layer.setVisibility(layerEntry.inputElem.checked,true);}},maximizeControl:function(e){this.div.style.width="20em";this.div.style.height="";this.showControls(false);if(e!=null){OpenLayers.Event.stop(e);}},minimizeControl:function(e){this.div.style.width="0px";this.div.style.height="0px";this.showControls(true);if(e!=null){OpenLayers.Event.stop(e);}},showControls:function(minimize){this.maximizeDiv.style.display=minimize?"":"none";this.minimizeDiv.style.display=minimize?"none":"";this.layersDiv.style.display=minimize?"none":"";},loadContents:function(){this.div.style.position="absolute";this.div.style.top="25px";this.div.style.right="0px";this.div.style.left="";this.div.style.fontFamily="sans-serif";this.div.style.fontWeight="bold";this.div.style.marginTop="3px";this.div.style.marginLeft="3px";this.div.style.marginBottom="3px";this.div.style.fontSize="smaller";this.div.style.color="white";this.div.style.backgroundColor="transparent";OpenLayers.Event.observe(this.div,"mouseup",this.mouseUp.bindAsEventListener(this));OpenLayers.Event.observe(this.div,"click",this.ignoreEvent);OpenLayers.Event.observe(this.div,"mousedown",this.mouseDown.bindAsEventListener(this));OpenLayers.Event.observe(this.div,"dblclick",this.ignoreEvent);this.layersDiv=document.createElement("div");this.layersDiv.id="layersDiv";this.layersDiv.style.paddingTop="5px";this.layersDiv.style.paddingLeft="10px";this.layersDiv.style.paddingBottom="5px";this.layersDiv.style.paddingRight="75px";this.layersDiv.style.backgroundColor=this.activeColor;this.layersDiv.style.width="100%";this.layersDiv.style.height="100%";var baseLbl=document.createElement("div");baseLbl.innerHTML="<u>Base Layer</u>";baseLbl.style.marginTop="3px";baseLbl.style.marginLeft="3px";baseLbl.style.marginBottom="3px";this.baseLayersDiv=document.createElement("div");this.baseLayersDiv.style.paddingLeft="10px";this.dataLbl=document.createElement("div");this.dataLbl.innerHTML="<u>Overlays</u>";this.dataLbl.style.marginTop="3px";this.dataLbl.style.marginLeft="3px";this.dataLbl.style.marginBottom="3px";this.dataLayersDiv=document.createElement("div");this.dataLayersDiv.style.paddingLeft="10px";if(this.ascending){this.layersDiv.appendChild(baseLbl);this.layersDiv.appendChild(this.baseLayersDiv);this.layersDiv.appendChild(this.dataLbl);this.layersDiv.appendChild(this.dataLayersDiv);}else{this.layersDiv.appendChild(this.dataLbl);this.layersDiv.appendChild(this.dataLayersDiv);this.layersDiv.appendChild(baseLbl);this.layersDiv.appendChild(this.baseLayersDiv);}
this.div.appendChild(this.layersDiv);OpenLayers.Rico.Corner.round(this.div,{corners:"tl bl",bgColor:"transparent",color:this.activeColor,blend:false});OpenLayers.Rico.Corner.changeOpacity(this.layersDiv,0.75);var imgLocation=OpenLayers.Util.getImagesLocation();var sz=new OpenLayers.Size(18,18);var img=imgLocation+'layer-switcher-maximize.png';this.maximizeDiv=OpenLayers.Util.createAlphaImageDiv("OpenLayers_Control_MaximizeDiv",null,sz,img,"absolute");this.maximizeDiv.style.top="5px";this.maximizeDiv.style.right="0px";this.maximizeDiv.style.left="";this.maximizeDiv.style.display="none";OpenLayers.Event.observe(this.maximizeDiv,"click",this.maximizeControl.bindAsEventListener(this));this.div.appendChild(this.maximizeDiv);var img=imgLocation+'layer-switcher-minimize.png';var sz=new OpenLayers.Size(18,18);this.minimizeDiv=OpenLayers.Util.createAlphaImageDiv("OpenLayers_Control_MinimizeDiv",null,sz,img,"absolute");this.minimizeDiv.style.top="5px";this.minimizeDiv.style.right="0px";this.minimizeDiv.style.left="";this.minimizeDiv.style.display="none";OpenLayers.Event.observe(this.minimizeDiv,"click",this.minimizeControl.bindAsEventListener(this));this.div.appendChild(this.minimizeDiv);},ignoreEvent:function(evt){OpenLayers.Event.stop(evt);},mouseDown:function(evt){this.mouseDown=true;this.ignoreEvent(evt);},mouseUp:function(evt){if(this.mouseDown){this.mouseDown=false;this.ignoreEvent(evt);}},CLASS_NAME:"OpenLayers.Control.LayerSwitcher"});OpenLayers.Control.MouseDefaults=OpenLayers.Class.create();OpenLayers.Control.MouseDefaults.prototype=OpenLayers.Class.inherit(OpenLayers.Control,{performedDrag:false,wheelObserver:null,initialize:function(){OpenLayers.Control.prototype.initialize.apply(this,arguments);},destroy:function(){if(this.handler){this.handler.destroy();}
this.handler=null;this.map.events.unregister("click",this,this.defaultClick);this.map.events.unregister("dblclick",this,this.defaultDblClick);this.map.events.unregister("mousedown",this,this.defaultMouseDown);this.map.events.unregister("mouseup",this,this.defaultMouseUp);this.map.events.unregister("mousemove",this,this.defaultMouseMove);this.map.events.unregister("mouseout",this,this.defaultMouseOut);OpenLayers.Event.stopObserving(window,"DOMMouseScroll",this.wheelObserver);OpenLayers.Event.stopObserving(window,"mousewheel",this.wheelObserver);OpenLayers.Event.stopObserving(document,"mousewheel",this.wheelObserver);this.wheelObserver=null;OpenLayers.Control.prototype.destroy.apply(this,arguments);},draw:function(){this.map.events.register("click",this,this.defaultClick);this.map.events.register("dblclick",this,this.defaultDblClick);this.map.events.register("mousedown",this,this.defaultMouseDown);this.map.events.register("mouseup",this,this.defaultMouseUp);this.map.events.register("mousemove",this,this.defaultMouseMove);this.map.events.register("mouseout",this,this.defaultMouseOut);this.registerWheelEvents();},registerWheelEvents:function(){this.wheelObserver=this.onWheelEvent.bindAsEventListener(this);OpenLayers.Event.observe(window,"DOMMouseScroll",this.wheelObserver);OpenLayers.Event.observe(window,"mousewheel",this.wheelObserver);OpenLayers.Event.observe(document,"mousewheel",this.wheelObserver);},defaultClick:function(evt){if(!OpenLayers.Event.isLeftClick(evt))return;var notAfterDrag=!this.performedDrag;this.performedDrag=false;return notAfterDrag;},defaultDblClick:function(evt){var newCenter=this.map.getLonLatFromViewPortPx(evt.xy);this.map.setCenter(newCenter,this.map.zoom+1);OpenLayers.Event.stop(evt);return false;},defaultMouseDown:function(evt){if(!OpenLayers.Event.isLeftClick(evt))return;this.mouseDragStart=evt.xy.clone();this.performedDrag=false;if(evt.shiftKey){this.map.div.style.cursor="crosshair";this.zoomBox=OpenLayers.Util.createDiv('zoomBox',this.mouseDragStart,null,null,"absolute","2px solid red");this.zoomBox.style.backgroundColor="white";this.zoomBox.style.filter="alpha(opacity=50)";this.zoomBox.style.opacity="0.50";this.zoomBox.style.fontSize="1px";this.zoomBox.style.zIndex=this.map.Z_INDEX_BASE["Popup"]-1;this.map.viewPortDiv.appendChild(this.zoomBox);}
document.onselectstart=function(){return false;}
OpenLayers.Event.stop(evt);},defaultMouseMove:function(evt){this.mousePosition=evt.xy.clone();if(this.mouseDragStart!=null){if(this.zoomBox){var deltaX=Math.abs(this.mouseDragStart.x-evt.xy.x);var deltaY=Math.abs(this.mouseDragStart.y-evt.xy.y);this.zoomBox.style.width=Math.max(1,deltaX)+"px";this.zoomBox.style.height=Math.max(1,deltaY)+"px";if(evt.xy.x<this.mouseDragStart.x){this.zoomBox.style.left=evt.xy.x+"px";}
if(evt.xy.y<this.mouseDragStart.y){this.zoomBox.style.top=evt.xy.y+"px";}}else{var deltaX=this.mouseDragStart.x-evt.xy.x;var deltaY=this.mouseDragStart.y-evt.xy.y;var size=this.map.getSize();var newXY=new OpenLayers.Pixel(size.w/2+deltaX,size.h/2+deltaY);var newCenter=this.map.getLonLatFromViewPortPx(newXY);this.map.setCenter(newCenter,null,true);this.mouseDragStart=evt.xy.clone();this.map.div.style.cursor="move";}
this.performedDrag=true;}},defaultMouseUp:function(evt){if(!OpenLayers.Event.isLeftClick(evt))return;if(this.zoomBox){this.zoomBoxEnd(evt);}else{if(this.performedDrag){this.map.setCenter(this.map.center);}}
document.onselectstart=null;this.mouseDragStart=null;this.map.div.style.cursor="";},defaultMouseOut:function(evt){if(this.mouseDragStart!=null&&OpenLayers.Util.mouseLeft(evt,this.map.div)){if(this.zoomBox){this.removeZoomBox();}
this.mouseDragStart=null;}},defaultWheelUp:function(evt){if(this.map.getZoom()<=this.map.getNumZoomLevels()){this.map.setCenter(this.map.getLonLatFromPixel(evt.xy),this.map.getZoom()+1);}},defaultWheelDown:function(evt){if(this.map.getZoom()>0){this.map.setCenter(this.map.getLonLatFromPixel(evt.xy),this.map.getZoom()-1);}},zoomBoxEnd:function(evt){if(this.mouseDragStart!=null){if(Math.abs(this.mouseDragStart.x-evt.xy.x)>5||Math.abs(this.mouseDragStart.y-evt.xy.y)>5){var start=this.map.getLonLatFromViewPortPx(this.mouseDragStart);var end=this.map.getLonLatFromViewPortPx(evt.xy);var top=Math.max(start.lat,end.lat);var bottom=Math.min(start.lat,end.lat);var left=Math.min(start.lon,end.lon);var right=Math.max(start.lon,end.lon);var bounds=new OpenLayers.Bounds(left,bottom,right,top);this.map.zoomToExtent(bounds);}else{var end=this.map.getLonLatFromViewPortPx(evt.xy);this.map.setCenter(new OpenLayers.LonLat((end.lon),(end.lat)),this.map.getZoom()+1);}
this.removeZoomBox();}},removeZoomBox:function(){this.map.viewPortDiv.removeChild(this.zoomBox);this.zoomBox=null;},onWheelEvent:function(e){var inMap=false;var elem=OpenLayers.Event.element(e);while(elem!=null){if(this.map&&elem==this.map.div){inMap=true;break;}
elem=elem.parentNode;}
if(inMap){var delta=0;if(!e){e=window.event;}
if(e.wheelDelta){delta=e.wheelDelta/120;if(window.opera){delta=-delta;}}else if(e.detail){delta=-e.detail/3;}
if(delta){e.xy=this.mousePosition;if(delta<0){this.defaultWheelDown(e);}else{this.defaultWheelUp(e);}}
OpenLayers.Event.stop(e);}},CLASS_NAME:"OpenLayers.Control.MouseDefaults"});OpenLayers.Control.MousePosition=OpenLayers.Class.create();OpenLayers.Control.MousePosition.prototype=OpenLayers.Class.inherit(OpenLayers.Control,{element:null,prefix:'',separator:', ',suffix:'',numdigits:5,granularity:10,lastXy:null,initialize:function(options){OpenLayers.Control.prototype.initialize.apply(this,arguments);},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);if(!this.element){this.div.left="";this.div.top="";this.div.className=this.displayClass;this.element=this.div;}
this.redraw();return this.div;},redraw:function(evt){var lonLat;if(evt==null){lonLat=new OpenLayers.LonLat(0,0);}else{if(this.lastXy==null||Math.abs(evt.xy.x-this.lastXy.x)>this.granularity||Math.abs(evt.xy.y-this.lastXy.y)>this.granularity)
{this.lastXy=evt.xy;return;}
lonLat=this.map.getLonLatFromPixel(evt.xy);this.lastXy=evt.xy;}
var digits=parseInt(this.numdigits);var newHtml=this.prefix+
lonLat.lon.toFixed(digits)+
this.separator+
lonLat.lat.toFixed(digits)+this.separator+this.map.getZoom()+
this.suffix;if(newHtml!=this.element.innerHTML){this.element.innerHTML=newHtml;}},setMap:function(){OpenLayers.Control.prototype.setMap.apply(this,arguments);this.map.events.register('mousemove',this,this.redraw);},CLASS_NAME:"OpenLayers.Control.MousePosition"});OpenLayers.Control.PanZoom=OpenLayers.Class.create();OpenLayers.Control.PanZoom.X=4;OpenLayers.Control.PanZoom.Y=4;OpenLayers.Control.PanZoom.prototype=OpenLayers.Class.inherit(OpenLayers.Control,{slideFactor:50,buttons:null,position:null,initialize:function(){this.position=new OpenLayers.Pixel(OpenLayers.Control.PanZoom.X,OpenLayers.Control.PanZoom.Y);OpenLayers.Control.prototype.initialize.apply(this,arguments);},destroy:function(){OpenLayers.Control.prototype.destroy.apply(this,arguments);while(this.buttons.length){var btn=this.buttons.shift();btn.map=null;OpenLayers.Event.stopObservingElement(btn);}
this.buttons=null;this.position=null;},draw:function(px){OpenLayers.Control.prototype.draw.apply(this,arguments);px=this.position;this.buttons=new Array();var sz=new OpenLayers.Size(18,18);var centered=new OpenLayers.Pixel(px.x+sz.w/2,px.y);this._addButton("panup","north-mini.png",centered,sz);px.y=centered.y+sz.h;this._addButton("panleft","west-mini.png",px,sz);this._addButton("panright","east-mini.png",px.add(sz.w,0),sz);this._addButton("pandown","south-mini.png",centered.add(0,sz.h*2),sz);this._addButton("zoomin","zoom-plus-mini.png",centered.add(0,sz.h*3+5),sz);this._addButton("zoomworld","zoom-world-mini.png",centered.add(0,sz.h*4+5),sz);this._addButton("zoomout","zoom-minus-mini.png",centered.add(0,sz.h*5+5),sz);return this.div;},_addButton:function(id,img,xy,sz){var imgLocation=OpenLayers.Util.getImagesLocation()+img;var btn=OpenLayers.Util.createAlphaImageDiv("OpenLayers_Control_PanZoom_"+id,xy,sz,imgLocation,"absolute");this.div.appendChild(btn);OpenLayers.Event.observe(btn,"mousedown",this.buttonDown.bindAsEventListener(btn));OpenLayers.Event.observe(btn,"mouseup",this.doubleClick.bindAsEventListener(btn));OpenLayers.Event.observe(btn,"dblclick",this.doubleClick.bindAsEventListener(btn));OpenLayers.Event.observe(btn,"click",this.doubleClick.bindAsEventListener(btn));btn.action=id;btn.map=this.map;btn.slideFactor=this.slideFactor;this.buttons.push(btn);return btn;},doubleClick:function(evt){OpenLayers.Event.stop(evt);return false;},buttonDown:function(evt){if(!OpenLayers.Event.isLeftClick(evt))return;switch(this.action){case"panup":this.map.pan(0,-50);break;case"pandown":this.map.pan(0,50);break;case"panleft":this.map.pan(-50,0);break;case"panright":this.map.pan(50,0);break;case"zoomin":this.map.zoomIn();break;case"zoomout":this.map.zoomOut();break;case"zoomworld":this.map.zoomToMaxExtent();break;}
OpenLayers.Event.stop(evt);},CLASS_NAME:"OpenLayers.Control.PanZoom"});OpenLayers.Control.Panel=OpenLayers.Class.create();OpenLayers.Control.Panel.prototype=OpenLayers.Class.inherit(OpenLayers.Control,{controls:null,defaultControl:null,initialize:function(element){OpenLayers.Control.prototype.initialize.apply(this,arguments);this.controls=[];},destroy:function(){OpenLayers.Control.prototype.destroy.apply(this,arguments);for(var i=this.controls.length-1;i>=0;i--){OpenLayers.Event.stopObservingElement(this.controls[i].panel_div);this.controls[i].panel_div=null;}},activate:function(){if(OpenLayers.Control.prototype.activate.apply(this,arguments)){for(var i=0;i<this.controls.length;i++){if(this.controls[i]==this.defaultControl){this.controls[i].activate();}}
this.redraw();return true;}else{return false;}},deactivate:function(){if(OpenLayers.Control.prototype.deactivate.apply(this,arguments)){for(var i=0;i<this.controls.length;i++){this.controls[i].deactivate();}
this.redraw();return true;}else{return false;}},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);for(var i=0;i<this.controls.length;i++){this.map.addControl(this.controls[i]);this.controls[i].deactivate();}
this.activate();return this.div;},redraw:function(){this.div.innerHTML="";if(this.active){for(var i=0;i<this.controls.length;i++){var element=this.controls[i].panel_div;if(this.controls[i].active){element.className=this.controls[i].displayClass+"ItemActive";}else{element.className=this.controls[i].displayClass+"ItemInactive";}
this.div.appendChild(element);}}},activateControl:function(control){if(!this.active){return false;}
if(control.type==OpenLayers.Control.TYPE_BUTTON){control.trigger();return;}
for(var i=0;i<this.controls.length;i++){if(this.controls[i]==control){control.activate();}else{this.controls[i].deactivate();}}
this.redraw();},addControls:function(controls){if(!(controls instanceof Array)){controls=[controls];}
this.controls=this.controls.concat(controls);for(var i=0;i<controls.length;i++){var element=document.createElement("div");var textNode=document.createTextNode(" ");controls[i].panel_div=element;OpenLayers.Event.observe(controls[i].panel_div,"click",this.onClick.bind(this,controls[i]));OpenLayers.Event.observe(controls[i].panel_div,"mousedown",OpenLayers.Event.stop.bindAsEventListener());}
if(this.map){for(var i=0;i<controls.length;i++){this.map.addControl(controls[i]);controls[i].deactivate();}
this.redraw();}},onClick:function(ctrl,evt){OpenLayers.Event.stop(evt?evt:window.event);this.activateControl(ctrl);},CLASS_NAME:"OpenLayers.Control.Panel"});OpenLayers.Control.Permalink=OpenLayers.Class.create();OpenLayers.Control.Permalink.prototype=OpenLayers.Class.inherit(OpenLayers.Control,{element:null,base:'',initialize:function(element,base){OpenLayers.Control.prototype.initialize.apply(this,arguments);this.element=OpenLayers.Util.getElement(element);if(base){this.base=base;}},destroy:function(){if(this.element.parentNode==this.div){this.div.removeChild(this.element);}
this.element=null;this.map.events.unregister('moveend',this,this.updateLink);OpenLayers.Control.prototype.destroy.apply(this,arguments);},setMap:function(map){OpenLayers.Control.prototype.setMap.apply(this,arguments);for(var i=0;i<this.map.controls.length;i++){var control=this.map.controls[i];if(control.CLASS_NAME=="OpenLayers.Control.ArgParser"){break;}}
if(i==this.map.controls.length){this.map.addControl(new OpenLayers.Control.ArgParser());}},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);if(!this.element){this.div.className=this.displayClass;this.element=document.createElement("a");this.element.style.fontSize="smaller";this.element.innerHTML="Permalink";this.element.href="";this.div.appendChild(this.element);}
this.map.events.register('moveend',this,this.updateLink);return this.div;},updateLink:function(){var center=this.map.getCenter();var zoom="zoom="+this.map.getZoom();var lat="lat="+Math.round(center.lat*100000)/100000;var lon="lon="+Math.round(center.lon*100000)/100000;var layers="layers=";for(var i=0;i<this.map.layers.length;i++){var layer=this.map.layers[i];if(layer.isBaseLayer){layers+=(layer==this.map.baseLayer)?"B":"0";}else{layers+=(layer.getVisibility())?"T":"F";}}
var href=this.base+"?"+lat+"&"+lon+"&"+zoom+"&"+layers;this.element.href=href;},CLASS_NAME:"OpenLayers.Control.Permalink"});OpenLayers.Control.Scale=OpenLayers.Class.create();OpenLayers.Control.Scale.prototype=OpenLayers.Class.inherit(OpenLayers.Control,{element:null,initialize:function(element){OpenLayers.Control.prototype.initialize.apply(this,arguments);this.element=OpenLayers.Util.getElement(element);},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);if(!this.element){this.element=document.createElement("div");this.div.className=this.displayClass;this.element.style.fontSize="smaller";this.div.appendChild(this.element);}
this.map.events.register('moveend',this,this.updateScale);this.updateScale();return this.div;},updateScale:function(){var scale=this.map.getScale();if(!scale)return;if(scale>=9500&&scale<=950000){scale=Math.round(scale/1000)+"K";}else if(scale>=950000){scale=Math.round(scale/1000000)+"M";}else{scale=Math.round(scale);}
this.element.innerHTML="Scale = 1 : "+scale;},CLASS_NAME:"OpenLayers.Control.Scale"});OpenLayers.Control.ZoomToMaxExtent=OpenLayers.Class.create();OpenLayers.Control.ZoomToMaxExtent.prototype=OpenLayers.Class.inherit(OpenLayers.Control,{type:OpenLayers.Control.TYPE_BUTTON,trigger:function(){if(this.map){this.map.zoomToMaxExtent();}},CLASS_NAME:"OpenLayers.Control.ZoomToMaxExtent"});OpenLayers.Event={observers:false,KEY_BACKSPACE:8,KEY_TAB:9,KEY_RETURN:13,KEY_ESC:27,KEY_LEFT:37,KEY_UP:38,KEY_RIGHT:39,KEY_DOWN:40,KEY_DELETE:46,element:function(event){return event.target||event.srcElement;},isLeftClick:function(event){return(((event.which)&&(event.which==1))||((event.button)&&(event.button==1)));},stop:function(event,allowDefault){if(!allowDefault){if(event.preventDefault){event.preventDefault();}else{event.returnValue=false;}}
if(event.stopPropagation){event.stopPropagation();}else{event.cancelBubble=true;}},findElement:function(event,tagName){var element=OpenLayers.Event.element(event);while(element.parentNode&&(!element.tagName||(element.tagName.toUpperCase()!=tagName.toUpperCase())))
element=element.parentNode;return element;},observe:function(elementParam,name,observer,useCapture){var element=OpenLayers.Util.getElement(elementParam);useCapture=useCapture||false;if(name=='keypress'&&(navigator.appVersion.match(/Konqueror|Safari|KHTML/)||element.attachEvent)){name='keydown';}
if(!this.observers){this.observers=new Object();}
if(!element._eventCacheID){var idPrefix="eventCacheID_";if(element.id){idPrefix=element.id+"_"+idPrefix;}
element._eventCacheID=OpenLayers.Util.createUniqueID(idPrefix);}
var cacheID=element._eventCacheID;if(!this.observers[cacheID]){this.observers[cacheID]=new Array();}
this.observers[cacheID].push({'element':element,'name':name,'observer':observer,'useCapture':useCapture});if(element.addEventListener){element.addEventListener(name,observer,useCapture);}else if(element.attachEvent){element.attachEvent('on'+name,observer);}},stopObservingElement:function(elementParam){var element=OpenLayers.Util.getElement(elementParam);var cacheID=element._eventCacheID;this._removeElementObservers(OpenLayers.Event.observers[cacheID]);},_removeElementObservers:function(elementObservers){if(elementObservers){for(var i=elementObservers.length-1;i>=0;i--){var entry=elementObservers[i];var args=new Array(entry.element,entry.name,entry.observer,entry.useCapture);var removed=OpenLayers.Event.stopObserving.apply(this,args);}}},stopObserving:function(elementParam,name,observer,useCapture){useCapture=useCapture||false;var element=OpenLayers.Util.getElement(elementParam);var cacheID=element._eventCacheID;if(name=='keypress'){if(navigator.appVersion.match(/Konqueror|Safari|KHTML/)||element.detachEvent){name='keydown';}}
var foundEntry=false;var elementObservers=OpenLayers.Event.observers[cacheID];if(elementObservers){var i=0;while(!foundEntry&&i<elementObservers.length){var cacheEntry=elementObservers[i];if((cacheEntry.name==name)&&(cacheEntry.observer==observer)&&(cacheEntry.useCapture==useCapture)){elementObservers.splice(i,1);if(elementObservers.length==0){delete OpenLayers.Event.observers[cacheID];}
foundEntry=true;break;}
i++;}}
if(element.removeEventListener){element.removeEventListener(name,observer,useCapture);}else if(element&&element.detachEvent){element.detachEvent('on'+name,observer);}
return foundEntry;},unloadCache:function(){if(OpenLayers.Event.observers){for(var cacheID in OpenLayers.Event.observers){var elementObservers=OpenLayers.Event.observers[cacheID];OpenLayers.Event._removeElementObservers.apply(this,[elementObservers]);}
OpenLayers.Event.observers=false;}},CLASS_NAME:"OpenLayers.Event"};OpenLayers.Event.observe(window,'unload',OpenLayers.Event.unloadCache,false);if(window.Event){OpenLayers.Util.extend(window.Event,OpenLayers.Event);}else{var Event=OpenLayers.Event;}
OpenLayers.Events=OpenLayers.Class.create();OpenLayers.Events.prototype={BROWSER_EVENTS:["mouseover","mouseout","mousedown","mouseup","mousemove","click","dblclick","resize","focus","blur"],listeners:null,object:null,element:null,eventTypes:null,eventHandler:null,fallThrough:null,initialize:function(object,element,eventTypes,fallThrough){this.object=object;this.element=element;this.eventTypes=eventTypes;this.fallThrough=fallThrough;this.listeners=new Object();this.eventHandler=this.handleBrowserEvent.bindAsEventListener(this);if(this.eventTypes!=null){for(var i=0;i<this.eventTypes.length;i++){this.listeners[this.eventTypes[i]]=new Array();}}
if(this.element!=null){this.attachToElement(element);}},destroy:function(){if(this.element){OpenLayers.Event.stopObservingElement(this.element);}
this.element=null;this.listeners=null;this.object=null;this.eventTypes=null;this.fallThrough=null;this.eventHandler=null;},attachToElement:function(element){for(var i=0;i<this.BROWSER_EVENTS.length;i++){var eventType=this.BROWSER_EVENTS[i];if(this.listeners[eventType]==null){this.listeners[eventType]=new Array();}
OpenLayers.Event.observe(element,eventType,this.eventHandler);}
OpenLayers.Event.observe(element,"dragstart",OpenLayers.Event.stop);},register:function(type,obj,func){if(func!=null){if(obj==null){obj=this.object;}
var listeners=this.listeners[type];if(listeners!=null){listeners.push({obj:obj,func:func});}}},registerPriority:function(type,obj,func){if(func!=null){if(obj==null){obj=this.object;}
var listeners=this.listeners[type];if(listeners!=null){listeners.unshift({obj:obj,func:func});}}},unregister:function(type,obj,func){if(obj==null){obj=this.object;}
var listeners=this.listeners[type];if(listeners!=null){for(var i=0;i<listeners.length;i++){if(listeners[i].obj==obj&&listeners[i].func==func){listeners.splice(i,1);break;}}}},remove:function(type){if(this.listeners[type]!=null){this.listeners[type]=new Array();}},triggerEvent:function(type,evt){if(evt==null){evt=new Object();}
evt.object=this.object;evt.element=this.element;var listeners=(this.listeners[type])?this.listeners[type].slice():null;if((listeners!=null)&&(listeners.length>0)){for(var i=0;i<listeners.length;i++){var callback=listeners[i];var continueChain;if(callback.obj!=null){continueChain=callback.func.call(callback.obj,evt);}else{continueChain=callback.func(evt);}
if((continueChain!=null)&&(continueChain==false)){break;}}
if(!this.fallThrough){OpenLayers.Event.stop(evt,true);}}},handleBrowserEvent:function(evt){evt.xy=this.getMousePosition(evt);this.triggerEvent(evt.type,evt)},getMousePosition:function(evt){if(!this.element.offsets){this.element.offsets=OpenLayers.Util.pagePosition(this.element);this.element.offsets[0]+=(document.documentElement.scrollLeft||document.body.scrollLeft);this.element.offsets[1]+=(document.documentElement.scrollTop||document.body.scrollTop);}
return new OpenLayers.Pixel((evt.clientX+(document.documentElement.scrollLeft||document.body.scrollLeft))-this.element.offsets[0],(evt.clientY+(document.documentElement.scrollTop||document.body.scrollTop))-this.element.offsets[1]);},CLASS_NAME:"OpenLayers.Events"};OpenLayers.Format=OpenLayers.Class.create();OpenLayers.Format.prototype={initialize:function(options){OpenLayers.Util.extend(this,options);},read:function(data){alert("Read not implemented.");},write:function(features){alert("Write not implemented.");},CLASS_NAME:"OpenLayers.Format"};OpenLayers.Handler.Box=OpenLayers.Class.create();OpenLayers.Handler.Box.prototype=OpenLayers.Class.inherit(OpenLayers.Handler,{dragHandler:null,initialize:function(control,callbacks,options){OpenLayers.Handler.prototype.initialize.apply(this,arguments);var callbacks={"down":this.startBox,"move":this.moveBox,"out":this.removeBox,"up":this.endBox};this.dragHandler=new OpenLayers.Handler.Drag(this,callbacks,{keyMask:this.keyMask});},setMap:function(map){OpenLayers.Handler.prototype.setMap.apply(this,arguments);if(this.dragHandler){this.dragHandler.setMap(map);}},startBox:function(xy){this.zoomBox=OpenLayers.Util.createDiv('zoomBox',this.dragHandler.start,null,null,"absolute","2px solid red");this.zoomBox.style.backgroundColor="white";this.zoomBox.style.filter="alpha(opacity=50)";this.zoomBox.style.opacity="0.50";this.zoomBox.style.fontSize="1px";this.zoomBox.style.zIndex=this.map.Z_INDEX_BASE["Popup"]-1;this.map.viewPortDiv.appendChild(this.zoomBox);this.map.div.style.cursor="crosshair";},moveBox:function(xy){var deltaX=Math.abs(this.dragHandler.start.x-xy.x);var deltaY=Math.abs(this.dragHandler.start.y-xy.y);this.zoomBox.style.width=Math.max(1,deltaX)+"px";this.zoomBox.style.height=Math.max(1,deltaY)+"px";if(xy.x<this.dragHandler.start.x){this.zoomBox.style.left=xy.x+"px";}
if(xy.y<this.dragHandler.start.y){this.zoomBox.style.top=xy.y+"px";}},endBox:function(end){var result;if(Math.abs(this.dragHandler.start.x-end.x)>5||Math.abs(this.dragHandler.start.y-end.y)>5){var start=this.dragHandler.start;var top=Math.min(start.y,end.y);var bottom=Math.max(start.y,end.y);var left=Math.min(start.x,end.x);var right=Math.max(start.x,end.x);result=new OpenLayers.Bounds(left,bottom,right,top);}else{result=this.dragHandler.start.clone();}
this.removeBox();this.map.div.style.cursor="";this.callback("done",[result]);},removeBox:function(){this.map.viewPortDiv.removeChild(this.zoomBox);this.zoomBox=null;},activate:function(){if(OpenLayers.Handler.prototype.activate.apply(this,arguments)){this.dragHandler.activate();return true;}else{return false;}},deactivate:function(){if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments)){this.dragHandler.deactivate();return true;}else{return false;}},CLASS_NAME:"OpenLayers.Handler.Box"});OpenLayers.Handler.Feature=OpenLayers.Class.create();OpenLayers.Handler.Feature.prototype=OpenLayers.Class.inherit(OpenLayers.Handler,{layerIndex:null,feature:null,initialize:function(control,layer,callbacks,options){OpenLayers.Handler.prototype.initialize.apply(this,[control,callbacks,options]);this.layer=layer;},mousedown:function(evt){var selected=this.select('down',evt);return!selected;},mousemove:function(evt){this.select('move',evt);return true;},mouseup:function(evt){var selected=this.select('up',evt);return!selected;},dblclick:function(evt){var selected=this.select('dblclick',evt);return!selected;},select:function(type,evt){var feature=this.layer.getFeatureFromEvent(evt);if(feature){if(!this.feature){this.callback('over',[feature]);}else if(this.feature!=feature){this.callback('out',[this.feature]);this.callback('over',[feature]);}
this.feature=feature;this.callback(type,[feature]);return true;}else{if(this.feature){this.callback('out',[this.feature]);this.feature=null;}
return false;}},activate:function(){if(OpenLayers.Handler.prototype.activate.apply(this,arguments)){this.layerIndex=this.layer.div.style.zIndex;this.layer.div.style.zIndex=this.map.Z_INDEX_BASE['Popup']-1;return true;}else{return false;}},deactivate:function(){if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments)){this.layer.div.style.zIndex=this.layerIndex;return true;}else{return false;}},CLASS_NAME:"OpenLayers.Handler.Feature"});OpenLayers.Handler.MouseWheel=OpenLayers.Class.create();OpenLayers.Handler.MouseWheel.prototype=OpenLayers.Class.inherit(OpenLayers.Handler,{wheelListener:null,mousePosition:null,initialize:function(control,callbacks,options){OpenLayers.Handler.prototype.initialize.apply(this,arguments);this.wheelListener=this.onWheelEvent.bindAsEventListener(this);},destroy:function(){this.deactivate();this.wheelListener=null;OpenLayers.Handler.prototype.destroy.apply(this,arguments);},onWheelEvent:function(e){if(!this.checkModifiers(e))return;var inMap=false;var elem=OpenLayers.Event.element(e);while(elem!=null){if(this.map&&elem==this.map.div){inMap=true;break;}
elem=elem.parentNode;}
if(inMap){var delta=0;if(!e){e=window.event;}
if(e.wheelDelta){delta=e.wheelDelta/120;if(window.opera){delta=-delta;}}else if(e.detail){delta=-e.detail/3;}
if(delta){e.xy=this.mousePosition;if(delta<0){this.callback("down",[e,delta]);}else{this.callback("up",[e,delta]);}}
OpenLayers.Event.stop(e);}},mousemove:function(evt){this.mousePosition=evt.xy;},activate:function(evt){if(OpenLayers.Handler.prototype.activate.apply(this,arguments)){var wheelListener=this.wheelListener;OpenLayers.Event.observe(window,"DOMMouseScroll",wheelListener);OpenLayers.Event.observe(window,"mousewheel",wheelListener);OpenLayers.Event.observe(document,"mousewheel",wheelListener);return true;}else{return false;}},deactivate:function(evt){if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments)){var wheelListener=this.wheelListener;OpenLayers.Event.stopObserving(window,"DOMMouseScroll",wheelListener);OpenLayers.Event.stopObserving(window,"mousewheel",wheelListener);OpenLayers.Event.stopObserving(document,"mousewheel",wheelListener);return true;}else{return false;}},CLASS_NAME:"OpenLayers.Handler.MouseWheel"});OpenLayers.Popup.Anchored=OpenLayers.Class.create();OpenLayers.Popup.Anchored.prototype=OpenLayers.Class.inherit(OpenLayers.Popup,{relativePosition:null,anchor:null,initialize:function(id,lonlat,size,contentHTML,anchor,closeBox){var newArguments=new Array(id,lonlat,size,contentHTML,closeBox);OpenLayers.Popup.prototype.initialize.apply(this,newArguments);this.anchor=(anchor!=null)?anchor:{size:new OpenLayers.Size(0,0),offset:new OpenLayers.Pixel(0,0)};},draw:function(px){if(px==null){if((this.lonlat!=null)&&(this.map!=null)){px=this.map.getLayerPxFromLonLat(this.lonlat);}}
this.relativePosition=this.calculateRelativePosition(px);return OpenLayers.Popup.prototype.draw.apply(this,arguments);},calculateRelativePosition:function(px){var lonlat=this.map.getLonLatFromLayerPx(px);var extent=this.map.getExtent();var quadrant=extent.determineQuadrant(lonlat);return OpenLayers.Bounds.oppositeQuadrant(quadrant);},moveTo:function(px){var newPx=this.calculateNewPx(px);var newArguments=new Array(newPx);OpenLayers.Popup.prototype.moveTo.apply(this,newArguments);},setSize:function(size){OpenLayers.Popup.prototype.setSize.apply(this,arguments);if((this.lonlat)&&(this.map)){var px=this.map.getLayerPxFromLonLat(this.lonlat);this.moveTo(px);}},calculateNewPx:function(px){var newPx=px.offset(this.anchor.offset);var top=(this.relativePosition.charAt(0)=='t');newPx.y+=(top)?-this.size.h:this.anchor.size.h;var left=(this.relativePosition.charAt(1)=='l');newPx.x+=(left)?-this.size.w:this.anchor.size.w;return newPx;},CLASS_NAME:"OpenLayers.Popup.Anchored"});OpenLayers.Renderer.Elements=OpenLayers.Class.create();OpenLayers.Renderer.Elements.prototype=OpenLayers.Class.inherit(OpenLayers.Renderer,{rendererRoot:null,root:null,xmlns:null,initialize:function(containerID){OpenLayers.Renderer.prototype.initialize.apply(this,arguments);this.rendererRoot=this.createRenderRoot();this.root=this.createRoot();this.rendererRoot.appendChild(this.root);this.container.appendChild(this.rendererRoot);},destroy:function(){this.clear();this.rendererRoot=null;this.root=null;this.xmlns=null;OpenLayers.Renderer.prototype.destroy.apply(this,arguments);},clear:function(){if(this.root){while(this.root.childNodes.length>0){this.root.removeChild(this.root.firstChild);}}},getNodeType:function(geometry){},drawGeometry:function(geometry,style,featureId){if((geometry.CLASS_NAME=="OpenLayers.Geometry.MultiPoint")||(geometry.CLASS_NAME=="OpenLayers.Geometry.MultiLineString")||(geometry.CLASS_NAME=="OpenLayers.Geometry.MultiPolygon")){for(var i=0;i<geometry.components.length;i++){this.drawGeometry(geometry.components[i],style,featureId);}
return;};var nodeType=this.getNodeType(geometry);var node=this.nodeFactory(geometry.id,nodeType,geometry);node._featureId=featureId;node._geometryClass=geometry.CLASS_NAME;node._style=style;this.root.appendChild(node);this.drawGeometryNode(node,geometry);},drawGeometryNode:function(node,geometry,style){style=style||node._style;var options={'isFilled':true,'isStroked':true};switch(geometry.CLASS_NAME){case"OpenLayers.Geometry.Point":this.drawPoint(node,geometry);break;case"OpenLayers.Geometry.LineString":options.isFilled=false;this.drawLineString(node,geometry);break;case"OpenLayers.Geometry.LinearRing":this.drawLinearRing(node,geometry);break;case"OpenLayers.Geometry.Polygon":this.drawPolygon(node,geometry);break;case"OpenLayers.Geometry.Surface":this.drawSurface(node,geometry);break;case"OpenLayers.Geometry.Rectangle":this.drawRectangle(node,geometry);break;default:break;}
node._style=style;node._options=options;this.setStyle(node,style,options,geometry);},drawPoint:function(node,geometry){},drawLineString:function(node,geometry){},drawLinearRing:function(node,geometry){},drawPolygon:function(node,geometry){},drawRectangle:function(node,geometry){},drawCircle:function(node,geometry){},drawCurve:function(node,geometry){},drawSurface:function(node,geometry){},getFeatureIdFromEvent:function(evt){var node=evt.target||evt.srcElement;return node._featureId;},eraseGeometry:function(geometry){if((geometry.CLASS_NAME=="OpenLayers.Geometry.MultiPoint")||(geometry.CLASS_NAME=="OpenLayers.Geometry.MultiLineString")||(geometry.CLASS_NAME=="OpenLayers.Geometry.MultiPolygon")){for(var i=0;i<geometry.components.length;i++){this.eraseGeometry(geometry.components[i]);}}else{var element=$(geometry.id);if(element&&element.parentNode){if(element.geometry){element.geometry.destroy();element.geometry=null;}
element.parentNode.removeChild(element);}}},nodeFactory:function(id,type,geometry){var node=$(id);if(node){if(!this.nodeTypeCompare(node,type)){node.parentNode.removeChild(node);node=this.nodeFactory(id,type,geometry);}}else{node=this.createNode(type,id);}
return node;},CLASS_NAME:"OpenLayers.Renderer.Elements"});OpenLayers.Tile=OpenLayers.Class.create();OpenLayers.Tile.prototype={id:null,layer:null,url:null,bounds:null,size:null,position:null,drawn:false,initialize:function(layer,position,bounds,url,size){this.layer=layer;this.position=position;this.bounds=bounds;this.url=url;this.size=size;this.id=OpenLayers.Util.createUniqueID("Tile_");},destroy:function(){this.layer=null;this.bounds=null;this.size=null;this.position=null;},draw:function(){this.clear();return((this.layer.displayOutsideMaxExtent||(this.layer.maxExtent&&this.bounds.intersectsBounds(this.layer.maxExtent,false)))&&!(this.layer.buffer==0&&!this.bounds.intersectsBounds(this.layer.map.getExtent(),false)));},moveTo:function(bounds,position,redraw){if(redraw==null){redraw=true;}
this.clear();this.bounds=bounds.clone();this.position=position.clone();if(redraw){this.draw();}},clear:function(){this.drawn=false;},getBoundsFromBaseLayer:function(position){var topLeft=this.layer.map.getLonLatFromLayerPx(position);var bottomRightPx=position.clone();bottomRightPx.x+=this.size.w;bottomRightPx.y+=this.size.h;var bottomRight=this.layer.map.getLonLatFromLayerPx(bottomRightPx);if(topLeft.lon>bottomRight.lon){if(topLeft.lon<0){topLeft.lon=-180-(topLeft.lon+180);}else{bottomRight.lon=180+bottomRight.lon+180;}}
bounds=new OpenLayers.Bounds(topLeft.lon,bottomRight.lat,bottomRight.lon,topLeft.lat);return bounds;},CLASS_NAME:"OpenLayers.Tile"};OpenLayers.Control.MouseToolbar=OpenLayers.Class.create();OpenLayers.Control.MouseToolbar.X=6;OpenLayers.Control.MouseToolbar.Y=300;OpenLayers.Control.MouseToolbar.prototype=OpenLayers.Class.inherit(OpenLayers.Control.MouseDefaults,{mode:null,buttons:null,direction:"vertical",buttonClicked:null,initialize:function(position,direction){OpenLayers.Control.prototype.initialize.apply(this,arguments);this.position=new OpenLayers.Pixel(OpenLayers.Control.MouseToolbar.X,OpenLayers.Control.MouseToolbar.Y);if(position){this.position=position;}
if(direction){this.direction=direction;}
this.measureDivs=[];},destroy:function(){for(var btnId in this.buttons){var btn=this.buttons[btnId];btn.map=null;btn.events.destroy();}
OpenLayers.Control.MouseDefaults.prototype.destroy.apply(this,arguments);},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);OpenLayers.Control.MouseDefaults.prototype.draw.apply(this,arguments);this.buttons=new Object();var sz=new OpenLayers.Size(28,28);var centered=new OpenLayers.Pixel(OpenLayers.Control.MouseToolbar.X,0);this._addButton("zoombox","drag-rectangle-off.png","drag-rectangle-on.png",centered,sz,"Shift->Drag to zoom to area");centered=centered.add((this.direction=="vertical"?0:sz.w),(this.direction=="vertical"?sz.h:0));this._addButton("pan","panning-hand-off.png","panning-hand-on.png",centered,sz,"Drag the map to pan.");centered=centered.add((this.direction=="vertical"?0:sz.w),(this.direction=="vertical"?sz.h:0));this.switchModeTo("pan");return this.div;},_addButton:function(id,img,activeImg,xy,sz,title){var imgLocation=OpenLayers.Util.getImagesLocation()+img;var activeImgLocation=OpenLayers.Util.getImagesLocation()+activeImg;var btn=OpenLayers.Util.createAlphaImageDiv("OpenLayers_Control_MouseToolbar_"+id,xy,sz,imgLocation,"absolute");this.div.appendChild(btn);btn.imgLocation=imgLocation;btn.activeImgLocation=activeImgLocation;btn.events=new OpenLayers.Events(this,btn,null,true);btn.events.register("mousedown",this,this.buttonDown);btn.events.register("mouseup",this,this.buttonUp);btn.events.register("dblclick",this,OpenLayers.Event.stop);btn.action=id;btn.title=title;btn.alt=title;btn.map=this.map;this.buttons[id]=btn;return btn;},buttonDown:function(evt){if(!OpenLayers.Event.isLeftClick(evt))return;this.buttonClicked=evt.element.action;OpenLayers.Event.stop(evt);},buttonUp:function(evt){if(!OpenLayers.Event.isLeftClick(evt))return;if(this.buttonClicked!=null){if(this.buttonClicked==evt.element.action){this.switchModeTo(evt.element.action);}
OpenLayers.Event.stop(evt);this.buttonClicked=null;}},defaultDblClick:function(evt){this.switchModeTo("pan");this.performedDrag=false;var newCenter=this.map.getLonLatFromViewPortPx(evt.xy);this.map.setCenter(newCenter,this.map.zoom+1);OpenLayers.Event.stop(evt);return false;},defaultMouseDown:function(evt){if(!OpenLayers.Event.isLeftClick(evt))return;this.mouseDragStart=evt.xy.clone();this.performedDrag=false;this.startViaKeyboard=false;if(evt.shiftKey&&this.mode!="zoombox"){this.switchModeTo("zoombox");this.startViaKeyboard=true;}else if(evt.altKey&&this.mode!="measure"){this.switchModeTo("measure");}else if(!this.mode){this.switchModeTo("pan");}
switch(this.mode){case"zoombox":this.map.div.style.cursor="crosshair";this.zoomBox=OpenLayers.Util.createDiv('zoomBox',this.mouseDragStart,null,null,"absolute","2px solid red");this.zoomBox.style.backgroundColor="white";this.zoomBox.style.filter="alpha(opacity=50)";this.zoomBox.style.opacity="0.50";this.zoomBox.style.fontSize="1px";this.zoomBox.style.zIndex=this.map.Z_INDEX_BASE["Popup"]-1;this.map.viewPortDiv.appendChild(this.zoomBox);this.performedDrag=true;break;case"measure":var distance="";if(this.measureStart){measureEnd=this.map.getLonLatFromViewPortPx(this.mouseDragStart);distance=OpenLayers.Util.distVincenty(this.measureStart,measureEnd);distance=Math.round(distance*100)/100;distance=distance+"km";this.measureStartBox=this.measureBox;}
this.measureStart=this.map.getLonLatFromViewPortPx(this.mouseDragStart);;this.measureBox=OpenLayers.Util.createDiv(null,this.mouseDragStart.add(-2-parseInt(this.map.layerContainerDiv.style.left),-2-parseInt(this.map.layerContainerDiv.style.top)),null,null,"absolute");this.measureBox.style.width="4px";this.measureBox.style.height="4px";this.measureBox.style.fontSize="1px";this.measureBox.style.backgroundColor="red";this.measureBox.style.zIndex=this.map.Z_INDEX_BASE["Popup"]-1;this.map.layerContainerDiv.appendChild(this.measureBox);if(distance){this.measureBoxDistance=OpenLayers.Util.createDiv(null,this.mouseDragStart.add(-2-parseInt(this.map.layerContainerDiv.style.left),2-parseInt(this.map.layerContainerDiv.style.top)),null,null,"absolute");this.measureBoxDistance.innerHTML=distance;this.measureBoxDistance.style.zIndex=this.map.Z_INDEX_BASE["Popup"]-1;this.map.layerContainerDiv.appendChild(this.measureBoxDistance);this.measureDivs.push(this.measureBoxDistance);}
this.measureBox.style.zIndex=this.map.Z_INDEX_BASE["Popup"]-1;this.map.layerContainerDiv.appendChild(this.measureBox);this.measureDivs.push(this.measureBox);break;default:this.map.div.style.cursor="move";break;}
document.onselectstart=function(){return false;}
OpenLayers.Event.stop(evt);},switchModeTo:function(mode){if(mode!=this.mode){if(this.mode&&this.buttons[this.mode]){OpenLayers.Util.modifyAlphaImageDiv(this.buttons[this.mode],null,null,null,this.buttons[this.mode].imgLocation);}
if(this.mode=="measure"&&mode!="measure"){for(var i=0;i<this.measureDivs.length;i++){if(this.measureDivs[i]){this.map.layerContainerDiv.removeChild(this.measureDivs[i]);}}
this.measureDivs=[];this.measureStart=null;}
this.mode=mode;if(this.buttons[mode]){OpenLayers.Util.modifyAlphaImageDiv(this.buttons[mode],null,null,null,this.buttons[mode].activeImgLocation);}
switch(this.mode){case"zoombox":this.map.div.style.cursor="crosshair";break;default:this.map.div.style.cursor="";break;}}},leaveMode:function(){this.switchModeTo("pan");},defaultMouseMove:function(evt){if(this.mouseDragStart!=null){switch(this.mode){case"zoombox":var deltaX=Math.abs(this.mouseDragStart.x-evt.xy.x);var deltaY=Math.abs(this.mouseDragStart.y-evt.xy.y);this.zoomBox.style.width=Math.max(1,deltaX)+"px";this.zoomBox.style.height=Math.max(1,deltaY)+"px";if(evt.xy.x<this.mouseDragStart.x){this.zoomBox.style.left=evt.xy.x+"px";}
if(evt.xy.y<this.mouseDragStart.y){this.zoomBox.style.top=evt.xy.y+"px";}
break;default:var deltaX=this.mouseDragStart.x-evt.xy.x;var deltaY=this.mouseDragStart.y-evt.xy.y;var size=this.map.getSize();var newXY=new OpenLayers.Pixel(size.w/2+deltaX,size.h/2+deltaY);var newCenter=this.map.getLonLatFromViewPortPx(newXY);this.map.setCenter(newCenter,null,true);this.mouseDragStart=evt.xy.clone();}
this.performedDrag=true;}},defaultMouseUp:function(evt){if(!OpenLayers.Event.isLeftClick(evt))return;switch(this.mode){case"zoombox":this.zoomBoxEnd(evt);if(this.startViaKeyboard)this.leaveMode();break;case"pan":if(this.performedDrag){this.map.setCenter(this.map.center);}}
document.onselectstart=null;this.mouseDragStart=null;this.map.div.style.cursor="default";},defaultMouseOut:function(evt){if(this.mouseDragStart!=null&&OpenLayers.Util.mouseLeft(evt,this.map.div)){if(this.zoomBox){this.removeZoomBox();if(this.startViaKeyboard)this.leaveMode();}
this.mouseDragStart=null;this.map.div.style.cursor="default";}},defaultClick:function(evt){if(this.performedDrag){this.performedDrag=false;return false;}}});OpenLayers.Control.OverviewMap=OpenLayers.Class.create();OpenLayers.Control.OverviewMap.prototype=OpenLayers.Class.inherit(OpenLayers.Control,{id:"OverviewMap",element:null,ovmap:null,size:new OpenLayers.Size(180,90),layers:null,minRatio:8,maxRatio:32,mapOptions:null,initialize:function(options){this.layers=new Array();OpenLayers.Control.prototype.initialize.apply(this,[options]);},destroy:function(){if(!this.mapDiv){return;}
this.mapDiv.removeChild(this.extentRectangle);this.extentRectangle=null;this.rectEvents.destroy();this.rectEvents=null;this.ovmap.destroy();this.ovmap=null;this.element.removeChild(this.mapDiv);this.mapDiv=null;this.mapDivEvents.destroy();this.mapDivEvents=null;this.div.removeChild(this.element);this.element=null;this.elementEvents.destroy();this.elementEvents=null;if(this.maximizeDiv){OpenLayers.Event.stopObservingElement(this.maximizeDiv);this.div.removeChild(this.maximizeDiv);this.maximizeDiv=null;}
if(this.minimizeDiv){OpenLayers.Event.stopObservingElement(this.minimizeDiv);this.div.removeChild(this.minimizeDiv);this.minimizeDiv=null;}
this.map.events.unregister('moveend',this,this.update);this.map.events.unregister("changebaselayer",this,this.baseLayerDraw);OpenLayers.Control.prototype.destroy.apply(this,arguments);},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);if(!(this.layers.length>0)){if(this.map.baseLayer){var layer=this.map.baseLayer.clone();this.layers=[layer];}else{this.map.events.register("changebaselayer",this,this.baseLayerDraw);return this.div;}}
this.element=document.createElement('div');this.element.className=this.displayClass+'Element';this.element.style.display='none';this.mapDiv=document.createElement('div');this.mapDiv.style.width=this.size.w+'px';this.mapDiv.style.height=this.size.h+'px';this.mapDiv.style.position='relative';this.mapDiv.style.overflow='hidden';this.mapDiv.id=OpenLayers.Util.createUniqueID('overviewMap');this.extentRectangle=document.createElement('div');this.extentRectangle.style.position='absolute';this.extentRectangle.style.zIndex=1000;this.extentRectangle.style.overflow='hidden';this.extentRectangle.style.backgroundImage='url('+
OpenLayers.Util.getImagesLocation()+'blank.gif)';this.extentRectangle.className=this.displayClass+'ExtentRectangle';this.mapDiv.appendChild(this.extentRectangle);this.element.appendChild(this.mapDiv);this.div.appendChild(this.element);this.map.events.register('moveend',this,this.update);this.elementEvents=new OpenLayers.Events(this,this.element);this.elementEvents.register('mousedown',this,function(e){OpenLayers.Event.stop(e);});this.elementEvents.register('click',this,function(e){OpenLayers.Event.stop(e);});this.elementEvents.register('dblclick',this,function(e){OpenLayers.Event.stop(e);});this.rectEvents=new OpenLayers.Events(this,this.extentRectangle);this.rectEvents.register('mouseout',this,this.rectMouseOut);this.rectEvents.register('mousedown',this,this.rectMouseDown);this.rectEvents.register('mousemove',this,this.rectMouseMove);this.rectEvents.register('mouseup',this,this.rectMouseUp);this.rectEvents.register('click',this,function(e){OpenLayers.Event.stop(e);});this.rectEvents.register('dblclick',this,this.rectDblClick);this.mapDivEvents=new OpenLayers.Events(this,this.mapDiv);this.mapDivEvents.register('click',this,this.mapDivClick);if(!this.outsideViewport){this.div.className=this.displayClass+'Container';var imgLocation=OpenLayers.Util.getImagesLocation();var img=imgLocation+'layer-switcher-maximize.png';this.maximizeDiv=OpenLayers.Util.createAlphaImageDiv(this.displayClass+'MaximizeButton',null,new OpenLayers.Size(18,18),img,'absolute');this.maximizeDiv.style.display='none';this.maximizeDiv.className=this.displayClass+'MaximizeButton';OpenLayers.Event.observe(this.maximizeDiv,'click',this.maximizeControl.bindAsEventListener(this));OpenLayers.Event.observe(this.maximizeDiv,'dblclick',function(e){OpenLayers.Event.stop(e);});this.div.appendChild(this.maximizeDiv);var img=imgLocation+'layer-switcher-minimize.png';this.minimizeDiv=OpenLayers.Util.createAlphaImageDiv('OpenLayers_Control_minimizeDiv',null,new OpenLayers.Size(18,18),img,'absolute');this.minimizeDiv.style.display='none';this.minimizeDiv.className=this.displayClass+'MinimizeButton';OpenLayers.Event.observe(this.minimizeDiv,'click',this.minimizeControl.bindAsEventListener(this));OpenLayers.Event.observe(this.minimizeDiv,'dblclick',function(e){OpenLayers.Event.stop(e);});this.div.appendChild(this.minimizeDiv);this.minimizeControl();}else{this.element.style.display='';}
if(this.map.getExtent()){this.update();}
return this.div;},baseLayerDraw:function(){this.draw();this.map.events.unregister("changebaselayer",this,this.baseLayerDraw);},rectMouseOut:function(evt){if(this.rectDragStart!=null){if(this.performedRectDrag){this.rectMouseMove(evt);var rectPxBounds=this.getRectPxBounds();if((rectPxBounds.top<=0)||(rectPxBounds.left<=0)||(rectPxBounds.bottom>=this.size.h-this.hComp)||(rectPxBounds.right>=this.size.w-this.wComp)){this.updateMapToRect();}else{return;}}
document.onselectstart=null;this.rectDragStart=null;}},rectMouseDown:function(evt){if(!OpenLayers.Event.isLeftClick(evt))return;this.rectDragStart=evt.xy.clone();this.performedRectDrag=false;OpenLayers.Event.stop(evt);},rectMouseMove:function(evt){if(this.rectDragStart!=null){var deltaX=this.rectDragStart.x-evt.xy.x;var deltaY=this.rectDragStart.y-evt.xy.y;var rectPxBounds=this.getRectPxBounds();var rectTop=rectPxBounds.top;var rectLeft=rectPxBounds.left;var rectHeight=Math.abs(rectPxBounds.getHeight());var rectWidth=rectPxBounds.getWidth();var newTop=Math.max(0,(rectTop-deltaY));newTop=Math.min(newTop,this.ovmap.size.h-this.hComp-rectHeight);var newLeft=Math.max(0,(rectLeft-deltaX));newLeft=Math.min(newLeft,this.ovmap.size.w-this.wComp-rectWidth);this.setRectPxBounds(new OpenLayers.Bounds(newLeft,newTop+rectHeight,newLeft+rectWidth,newTop));this.rectDragStart=evt.xy.clone();this.performedRectDrag=true;OpenLayers.Event.stop(evt);}},rectMouseUp:function(evt){if(!OpenLayers.Event.isLeftClick(evt))return;if(this.performedRectDrag){this.updateMapToRect();OpenLayers.Event.stop(evt);}
document.onselectstart=null;this.rectDragStart=null;},rectDblClick:function(evt){this.performedRectDrag=false;OpenLayers.Event.stop(evt);this.updateOverview();},mapDivClick:function(evt){var pxBounds=this.getRectPxBounds();var pxCenter=pxBounds.getCenterPixel();var deltaX=evt.xy.x-pxCenter.x;var deltaY=evt.xy.y-pxCenter.y;var top=pxBounds.top;var left=pxBounds.left;var height=Math.abs(pxBounds.getHeight());var width=pxBounds.getWidth();var newTop=Math.max(0,(top+deltaY));newTop=Math.min(newTop,this.ovmap.size.h-height);var newLeft=Math.max(0,(left+deltaX));newLeft=Math.min(newLeft,this.ovmap.size.w-width);this.setRectPxBounds(new OpenLayers.Bounds(newLeft,newTop+height,newLeft+width,newTop));this.updateMapToRect();OpenLayers.Event.stop(evt);},maximizeControl:function(e){this.element.style.display='';this.showToggle(false);if(e!=null){OpenLayers.Event.stop(e);}},minimizeControl:function(e){this.element.style.display='none';this.showToggle(true);if(e!=null){OpenLayers.Event.stop(e);}},showToggle:function(minimize){this.maximizeDiv.style.display=minimize?'':'none';this.minimizeDiv.style.display=minimize?'none':'';},update:function(){if(this.ovmap==null){this.createMap();}
if(!this.isSuitableOverview()){this.updateOverview();}
this.updateRectToMap();},isSuitableOverview:function(){var mapExtent=this.map.getExtent();var maxExtent=this.map.maxExtent;var testExtent=new OpenLayers.Bounds(Math.max(mapExtent.left,maxExtent.left),Math.max(mapExtent.bottom,maxExtent.bottom),Math.min(mapExtent.right,maxExtent.right),Math.min(mapExtent.top,maxExtent.top));var resRatio=this.ovmap.getResolution()/this.map.getResolution();return((resRatio>this.minRatio)&&(resRatio<=this.maxRatio)&&(this.ovmap.getExtent().containsBounds(testExtent)));},updateOverview:function(){var mapRes=this.map.getResolution();var targetRes=this.ovmap.getResolution();var resRatio=targetRes/mapRes;if(resRatio>this.maxRatio){targetRes=this.minRatio*mapRes;}else if(resRatio<=this.minRatio){targetRes=this.maxRatio*mapRes;}
this.ovmap.setCenter(this.map.center,this.ovmap.getZoomForResolution(targetRes));this.updateRectToMap();},createMap:function(){var options=OpenLayers.Util.extend({controls:[],maxResolution:'auto'},this.mapOptions);this.ovmap=new OpenLayers.Map(this.mapDiv.id,options);this.ovmap.addLayers(this.layers);this.ovmap.zoomToMaxExtent();this.wComp=parseInt(OpenLayers.Element.getStyle(this.extentRectangle,'border-left-width'))+
parseInt(OpenLayers.Element.getStyle(this.extentRectangle,'border-right-width'));this.wComp=(this.wComp)?this.wComp:2;this.hComp=parseInt(OpenLayers.Element.getStyle(this.extentRectangle,'border-top-width'))+
parseInt(OpenLayers.Element.getStyle(this.extentRectangle,'border-bottom-width'));this.hComp=(this.hComp)?this.hComp:2;},updateRectToMap:function(){if(this.map.units!='degrees'){if(this.ovmap.getProjection()&&(this.map.getProjection()!=this.ovmap.getProjection())){alert('The overview map only works when it is in the same projection as the main map');}}
var pxBounds=this.getRectBoundsFromMapBounds(this.map.getExtent());if(pxBounds){this.setRectPxBounds(pxBounds);}},updateMapToRect:function(){var pxBounds=this.getRectPxBounds();var lonLatBounds=this.getMapBoundsFromRectBounds(pxBounds);this.map.setCenter(lonLatBounds.getCenterLonLat(),this.map.zoom);},getRectPxBounds:function(){var top=parseInt(this.extentRectangle.style.top);var left=parseInt(this.extentRectangle.style.left);var height=parseInt(this.extentRectangle.style.height);var width=parseInt(this.extentRectangle.style.width);return new OpenLayers.Bounds(left,top+height,left+width,top);},setRectPxBounds:function(pxBounds){var top=Math.max(pxBounds.top,0);var left=Math.max(pxBounds.left,0);var bottom=Math.min(pxBounds.top+Math.abs(pxBounds.getHeight()),this.ovmap.size.h-this.hComp);var right=Math.min(pxBounds.left+pxBounds.getWidth(),this.ovmap.size.w-this.wComp);this.extentRectangle.style.top=parseInt(top)+'px';this.extentRectangle.style.left=parseInt(left)+'px';this.extentRectangle.style.height=parseInt(Math.max(bottom-top,0))+'px';this.extentRectangle.style.width=parseInt(Math.max(right-left,0))+'px';},getRectBoundsFromMapBounds:function(lonLatBounds){var leftBottomLonLat=new OpenLayers.LonLat(lonLatBounds.left,lonLatBounds.bottom);var rightTopLonLat=new OpenLayers.LonLat(lonLatBounds.right,lonLatBounds.top);var leftBottomPx=this.getOverviewPxFromLonLat(leftBottomLonLat);var rightTopPx=this.getOverviewPxFromLonLat(rightTopLonLat);var bounds=null;if(leftBottomPx&&rightTopPx){bounds=new OpenLayers.Bounds(leftBottomPx.x,leftBottomPx.y,rightTopPx.x,rightTopPx.y);}
return bounds;},getMapBoundsFromRectBounds:function(pxBounds){var leftBottomPx=new OpenLayers.Pixel(pxBounds.left,pxBounds.bottom);var rightTopPx=new OpenLayers.Pixel(pxBounds.right,pxBounds.top);var leftBottomLonLat=this.getLonLatFromOverviewPx(leftBottomPx);var rightTopLonLat=this.getLonLatFromOverviewPx(rightTopPx);return new OpenLayers.Bounds(leftBottomLonLat.lon,leftBottomLonLat.lat,rightTopLonLat.lon,rightTopLonLat.lat);},getLonLatFromOverviewPx:function(overviewMapPx){var size=this.ovmap.size;var res=this.ovmap.getResolution();var center=this.ovmap.getExtent().getCenterLonLat();var delta_x=overviewMapPx.x-(size.w/2);var delta_y=overviewMapPx.y-(size.h/2);return new OpenLayers.LonLat(center.lon+delta_x*res,center.lat-delta_y*res);},getOverviewPxFromLonLat:function(lonlat){var res=this.ovmap.getResolution();var extent=this.ovmap.getExtent();var px=null;if(extent){px=new OpenLayers.Pixel(Math.round(1/res*(lonlat.lon-extent.left)),Math.round(1/res*(extent.top-lonlat.lat)));}
return px;},CLASS_NAME:'OpenLayers.Control.OverviewMap'});OpenLayers.Control.PanZoomBar=OpenLayers.Class.create();OpenLayers.Control.PanZoomBar.prototype=OpenLayers.Class.inherit(OpenLayers.Control.PanZoom,{zoomStopWidth:18,zoomStopHeight:11,slider:null,sliderEvents:null,zoomBarDiv:null,divEvents:null,initialize:function(){OpenLayers.Control.PanZoom.prototype.initialize.apply(this,arguments);},destroy:function(){this.div.removeChild(this.slider);this.slider=null;this.sliderEvents.destroy();this.sliderEvents=null;this.div.removeChild(this.zoombarDiv);this.zoomBarDiv=null;this.divEvents.destroy();this.divEvents=null;this.map.events.unregister("zoomend",this,this.moveZoomBar);this.map.events.unregister("changebaselayer",this,this.redraw)
OpenLayers.Control.PanZoom.prototype.destroy.apply(this,arguments);},setMap:function(map){OpenLayers.Control.PanZoom.prototype.setMap.apply(this,arguments);this.map.events.register("changebaselayer",this,this.redraw);},redraw:function(){if(this.div!=null){this.div.innerHTML="";}
this.draw();},draw:function(px){OpenLayers.Control.prototype.draw.apply(this,arguments);px=this.position.clone();this.buttons=new Array();var sz=new OpenLayers.Size(18,18);var centered=new OpenLayers.Pixel(px.x+sz.w/2,px.y);this._addButton("panup","north-mini.png",centered,sz);px.y=centered.y+sz.h;this._addButton("panleft","west-mini.png",px,sz);this._addButton("panright","east-mini.png",px.add(sz.w,0),sz);this._addButton("pandown","south-mini.png",centered.add(0,sz.h*2),sz);this._addButton("zoomin","zoom-plus-mini.png",centered.add(0,sz.h*3+5),sz);centered=this._addZoomBar(centered.add(0,sz.h*4+5));this._addButton("zoomout","zoom-minus-mini.png",centered,sz);return this.div;},_addZoomBar:function(centered){var imgLocation=OpenLayers.Util.getImagesLocation();var id="OpenLayers_Control_PanZoomBar_Slider"+this.map.id;var zoomsToEnd=this.map.getNumZoomLevels()-1-this.map.getZoom();var slider=OpenLayers.Util.createAlphaImageDiv(id,centered.add(-1,zoomsToEnd*this.zoomStopHeight),new OpenLayers.Size(20,9),imgLocation+"slider.png","absolute");this.slider=slider;this.sliderEvents=new OpenLayers.Events(this,slider,null,true);this.sliderEvents.register("mousedown",this,this.zoomBarDown);this.sliderEvents.register("mousemove",this,this.zoomBarDrag);this.sliderEvents.register("mouseup",this,this.zoomBarUp);this.sliderEvents.register("dblclick",this,this.doubleClick);this.sliderEvents.register("click",this,this.doubleClick);sz=new OpenLayers.Size();sz.h=this.zoomStopHeight*this.map.getNumZoomLevels();sz.w=this.zoomStopWidth;var div=null
if(OpenLayers.Util.alphaHack()){var id="OpenLayers_Control_PanZoomBar"+this.map.id;div=OpenLayers.Util.createAlphaImageDiv(id,centered,new OpenLayers.Size(sz.w,this.zoomStopHeight),imgLocation+"zoombar.png","absolute",null,"crop");div.style.height=sz.h;}else{div=OpenLayers.Util.createDiv('OpenLayers_Control_PanZoomBar_Zoombar'+this.map.id,centered,sz,imgLocation+"zoombar.png");}
this.zoombarDiv=div;this.divEvents=new OpenLayers.Events(this,div,null,true);this.divEvents.register("mousedown",this,this.divClick);this.divEvents.register("mousemove",this,this.passEventToSlider);this.divEvents.register("dblclick",this,this.doubleClick);this.divEvents.register("click",this,this.doubleClick);this.div.appendChild(div);this.startTop=parseInt(div.style.top);this.div.appendChild(slider);this.map.events.register("zoomend",this,this.moveZoomBar);centered=centered.add(0,this.zoomStopHeight*this.map.getNumZoomLevels());return centered;},passEventToSlider:function(evt){this.sliderEvents.handleBrowserEvent(evt);},divClick:function(evt){if(!OpenLayers.Event.isLeftClick(evt))return;var y=evt.xy.y;var top=OpenLayers.Util.pagePosition(evt.object)[1];var levels=Math.floor((y-top)/this.zoomStopHeight);this.map.zoomTo((this.map.getNumZoomLevels()-1)-levels);OpenLayers.Event.stop(evt);},zoomBarDown:function(evt){if(!OpenLayers.Event.isLeftClick(evt))return;this.map.events.register("mousemove",this,this.passEventToSlider);this.map.events.register("mouseup",this,this.passEventToSlider);this.mouseDragStart=evt.xy.clone();this.zoomStart=evt.xy.clone();this.div.style.cursor="move";this.zoombarDiv.offsets=null;OpenLayers.Event.stop(evt);},zoomBarDrag:function(evt){if(this.mouseDragStart!=null){var deltaY=this.mouseDragStart.y-evt.xy.y
var offsets=OpenLayers.Util.pagePosition(this.zoombarDiv);if((evt.clientY-offsets[1])>0&&(evt.clientY-offsets[1])<parseInt(this.zoombarDiv.style.height)-2){var newTop=parseInt(this.slider.style.top)-deltaY;this.slider.style.top=newTop+"px";}
this.mouseDragStart=evt.xy.clone();OpenLayers.Event.stop(evt);}},zoomBarUp:function(evt){if(!OpenLayers.Event.isLeftClick(evt))return;if(this.zoomStart){this.div.style.cursor="";this.map.events.unregister("mouseup",this,this.passEventToSlider);this.map.events.unregister("mousemove",this,this.passEventToSlider);var deltaY=this.zoomStart.y-evt.xy.y
this.map.zoomTo(this.map.zoom+Math.round(deltaY/this.zoomStopHeight));this.moveZoomBar();this.mouseDragStart=null;OpenLayers.Event.stop(evt);}},moveZoomBar:function(){var newTop=((this.map.getNumZoomLevels()-1)-this.map.getZoom())*this.zoomStopHeight+this.startTop+1;this.slider.style.top=newTop+"px";},CLASS_NAME:"OpenLayers.Control.PanZoomBar"});OpenLayers.Control.ZoomBox=OpenLayers.Class.create();OpenLayers.Control.ZoomBox.prototype=OpenLayers.Class.inherit(OpenLayers.Control,{type:OpenLayers.Control.TYPE_TOOL,draw:function(){this.handler=new OpenLayers.Handler.Box(this,{done:this.zoomBox},{keyMask:this.keyMask});},zoomBox:function(position){if(position instanceof OpenLayers.Bounds){var minXY=this.map.getLonLatFromPixel(new OpenLayers.Pixel(position.left,position.bottom));var maxXY=this.map.getLonLatFromPixel(new OpenLayers.Pixel(position.right,position.top));var bounds=new OpenLayers.Bounds(minXY.lon,minXY.lat,maxXY.lon,maxXY.lat);this.map.zoomToExtent(bounds);}else{this.map.setCenter(this.map.getLonLatFromPixel(position),this.map.getZoom()+1);}},CLASS_NAME:"OpenLayers.Control.ZoomBox"});OpenLayers.Format.GeoRSS=OpenLayers.Class.create();OpenLayers.Format.GeoRSS.prototype=OpenLayers.Class.inherit(OpenLayers.Format,{rssns:"http://backend.userland.com/rss2",featureNS:"http://mapserver.gis.umn.edu/mapserver",georssns:"http://www.georss.org/georss",write:function(features){var featureCollection=document.createElementNS(this.rssns,"rss");for(var i=0;i<features.length;i++){featureCollection.appendChild(this.createFeatureXML(features[i]));}
return featureCollection;},createFeatureXML:function(feature){var geometryNode=this.buildGeometryNode(feature.geometry);var featureNode=document.createElementNS(this.rssns,"item");var titleNode=document.createElementNS(this.rssns,"title");titleNode.appendChild(document.createTextNode(feature.attributes.title?feature.attributes.title:""));var descNode=document.createElementNS(this.rssns,"description");descNode.appendChild(document.createTextNode(feature.attributes.description?feature.attributes.description:""));featureNode.appendChild(titleNode);featureNode.appendChild(descNode);for(var attr in feature.attributes){var attrText=document.createTextNode(feature.attributes[attr]);var nodename=attr;if(attr.search(":")!=-1){nodename=attr.split(":")[1];}
var attrContainer=document.createElementNS(this.featureNS,"feature:"+nodename);attrContainer.appendChild(attrText);featureNode.appendChild(attrContainer);}
featureNode.appendChild(geometryNode);return featureNode;},buildGeometryNode:function(geometry){var gml="";if(geometry.CLASS_NAME=="OpenLayers.Geometry.Polygon"){gml=document.createElementNS(this.georssns,'georss:polygon');gml.appendChild(this.buildCoordinatesNode(geometry.components[0]));}
else if(geometry.CLASS_NAME=="OpenLayers.Geometry.LineString"){gml=document.createElementNS(this.georssns,'georss:line');gml.appendChild(this.buildCoordinatesNode(geometry));}
else if(geometry.CLASS_NAME=="OpenLayers.Geometry.Point"){gml=document.createElementNS(this.georssns,'georss:point');gml.appendChild(this.buildCoordinatesNode(geometry));}else{alert("Couldn't parse "+geometry.CLASS_NAME);}
return gml;},buildCoordinatesNode:function(geometry){var points=null;if(geometry.components){points=geometry.components;}
var path="";if(points){for(var i=0;i<points.length;i++){path+=points[i].lat+" "+points[i].lon+" ";}}else{path+=geometry.lat+" "+geometry.lon+" ";}
return document.createTextNode(path);},CLASS_NAME:"OpenLayers.Format.GeoRSS"});OpenLayers.Format.WKT=OpenLayers.Class.create();OpenLayers.Format.WKT.prototype=OpenLayers.Class.inherit(OpenLayers.Format,{initialize:function(options){this.regExes={'typeStr':/^\s*(\w+)\s*\(\s*(.*)\s*\)\s*$/,'spaces':/\s+/,'parenComma':/\)\s*,\s*\(/,'doubleParenComma':/\)\s*\)\s*,\s*\(\s*\(/,'trimParens':/^\s*\(?(.*?)\)?\s*$/};OpenLayers.Format.prototype.initialize.apply(this,[options]);},read:function(wkt){var geometry,type,str;var matches=this.regExes.typeStr.exec(wkt);if(matches){type=matches[1].toLowerCase();str=matches[2];if(this.parse[type]){geometry=this.parse[type].apply(this,[str]);}}
return geometry;},write:function(geom){var collection,geometry,type,data,isCollection;if(geom.constructor==Array){collection=geom;isCollection=true;}else{collection=[geom];isCollection=false;}
var pieces=[];if(isCollection){pieces.push('GEOMETRYCOLLECTION(');}
for(var i=0;i<collection.length;++i){if(isCollection&&i>0){pieces.push(',');}
geometry=collection[i];type=geometry.CLASS_NAME.split('.')[2].toLowerCase();if(!this.extract[type]){return null;}
data=this.extract[type].apply(this,[geometry]);pieces.push(type.toUpperCase()+'('+data+')');}
if(isCollection){pieces.push(')');}
return pieces.join('');},extract:{'point':function(point){return point.x+' '+point.y;},'multipoint':function(multipoint){var array=[];for(var i=0;i<multipoint.components.length;++i){array.push(this.extract.point.apply(this,[multipoint.components[i]]));}
return array.join(',');},'linestring':function(linestring){var array=[];for(var i=0;i<linestring.components.length;++i){array.push(this.extract.point.apply(this,[linestring.components[i]]));}
return array.join(',');},'multilinestring':function(multilinestring){var array=[];for(var i=0;i<multilinestring.components.length;++i){array.push('('+
this.extract.linestring.apply(this,[multilinestring.components[i]])+')');}
return array.join(',');},'polygon':function(polygon){var array=[];for(var i=0;i<polygon.components.length;++i){array.push('('+
this.extract.linestring.apply(this,[polygon.components[i]])+')');}
return array.join(',');},'multipolygon':function(multipolygon){var array=[];for(var i=0;i<multipolygon.components.length;++i){array.push('('+
this.extract.polygon.apply(this,[multipolygon.components[i]])+')');}
return array.join(',');}},parse:{'point':function(str){var coords=str.trim().split(this.regExes.spaces);return new OpenLayers.Geometry.Point(coords[0],coords[1]);},'multipoint':function(str){var points=str.trim().split(',');var components=[];for(var i=0;i<points.length;++i){components.push(this.parse.point.apply(this,[points[i]]));}
return new OpenLayers.Geometry.MultiPoint(components);},'linestring':function(str){var points=str.trim().split(',');var components=[];for(var i=0;i<points.length;++i){components.push(this.parse.point.apply(this,[points[i]]));}
return new OpenLayers.Geometry.LineString(components);},'multilinestring':function(str){var line;var lines=str.trim().split(this.regExes.parenComma);var components=[];for(var i=0;i<lines.length;++i){line=lines[i].replace(this.regExes.trimParens,'$1');components.push(this.parse.linestring.apply(this,[line]));}
return new OpenLayers.Geometry.MultiLineString(components);},'polygon':function(str){var ring,linestring,linearring;var rings=str.trim().split(this.regExes.parenComma);var components=[];for(var i=0;i<rings.length;++i){ring=rings[i].replace(this.regExes.trimParens,'$1');linestring=this.parse.linestring.apply(this,[ring]);linearring=new OpenLayers.Geometry.LinearRing(linestring.components);components.push(linearring);}
return new OpenLayers.Geometry.Polygon(components);},'multipolygon':function(str){var polygon;var polygons=str.trim().split(this.regExes.doubleParenComma);var components=[];for(var i=0;i<polygons.length;++i){polygon=polygons[i].replace(this.regExes.trimParens,'$1');components.push(this.parse.polygon.apply(this,[polygon]));}
return new OpenLayers.Geometry.MultiPolygon(components);},'geometrycollection':function(str){str=str.replace(/,\s*([A-Za-z])/g,'|$1');var wktArray=str.trim().split('|');var components=[];for(var i=0;i<wktArray.length;++i){components.push(OpenLayers.Format.WKT.prototype.read.apply(this,[wktArray[i]]));}
return components;}},CLASS_NAME:"OpenLayers.Format.WKT"});OpenLayers.Handler.Drag=OpenLayers.Class.create();OpenLayers.Handler.Drag.prototype=OpenLayers.Class.inherit(OpenLayers.Handler,{started:false,dragging:false,start:null,oldOnselectstart:null,initialize:function(control,callbacks,options){OpenLayers.Handler.prototype.initialize.apply(this,arguments);},mousedown:function(evt){if(this.checkModifiers(evt)&&OpenLayers.Event.isLeftClick(evt)){this.started=true;this.dragging=false;this.start=evt.xy.clone();this.map.div.style.cursor="move";this.callback("down",[evt.xy]);OpenLayers.Event.stop(evt);return false;}
return true;},mousemove:function(evt){if(this.started){this.dragging=true;this.callback("move",[evt.xy]);if(!this.oldOnselectstart){this.oldOnselectstart=document.onselectstart;document.onselectstart=function(){return false;}}}
return true;},mouseup:function(evt){if(this.started){this.started=false;this.map.div.style.cursor="";this.callback("up",[evt.xy]);document.onselectstart=this.oldOnselectstart;}
return true;},mouseout:function(evt){if(this.started&&OpenLayers.Util.mouseLeft(evt,this.map.div)){this.started=false;this.dragging=false;this.map.div.style.cursor="";this.callback("out",[]);if(document.onselectstart){document.onselectstart=this.oldOnselectstart;}}
return true;},click:function(evt){if(this.dragging){this.dragging=false;return false;}
this.started=false;return true;},activate:function(){if(OpenLayers.Handler.prototype.activate.apply(this,arguments)){this.dragging=false;return true;}else{return false;}},deactivate:function(){if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments)){this.dragging=false;return true;}else{return false;}},CLASS_NAME:"OpenLayers.Handler.Drag"});OpenLayers.Handler.Keyboard=OpenLayers.Class.create();OpenLayers.Handler.Keyboard.prototype=OpenLayers.Class.inherit(OpenLayers.Handler,{KEY_EVENTS:["keydown","keypress","keyup"],eventListener:null,initialize:function(){OpenLayers.Handler.prototype.initialize.apply(this,arguments);this.eventListener=this.handleKeyEvent.bindAsEventListener(this);},destroy:function(){this.deactivate();this.eventListener=null;OpenLayers.Control.prototype.destroy.apply(this,arguments);},activate:function(){if(OpenLayers.Handler.prototype.activate.apply(this,arguments)){for(var i=0;i<this.KEY_EVENTS.length;i++){OpenLayers.Event.observe(window,this.KEY_EVENTS[i],this.eventListener);}
return true;}else{return false;}},deactivate:function(){if(OpenLayers.Handler.prototype.deactivate.apply(this,arguments)){for(var i=0;i<this.KEY_EVENTS.length;i++){OpenLayers.Event.stopObserving(document,this.KEY_EVENTS[i],this.eventListener);}
return true;}else{return false;}},handleKeyEvent:function(evt){if(this.checkModifiers(evt)){this.callback(evt.type,[evt.charCode||evt.keyCode]);}},CLASS_NAME:"OpenLayers.Handler.Keyboard"});OpenLayers.Map=OpenLayers.Class.create();OpenLayers.Map.TILE_WIDTH=256;OpenLayers.Map.TILE_HEIGHT=256;OpenLayers.Map.prototype={Z_INDEX_BASE:{BaseLayer:100,Overlay:325,Popup:750,Control:1000},EVENT_TYPES:["addlayer","removelayer","changelayer","movestart","move","moveend","zoomend","popupopen","popupclose","addmarker","removemarker","clearmarkers","mouseover","mouseout","mousemove","dragstart","drag","dragend","changebaselayer"],id:null,events:null,unloadDestroy:null,div:null,size:null,viewPortDiv:null,layerContainerOrigin:null,layerContainerDiv:null,layers:null,controls:null,popups:null,baseLayer:null,center:null,zoom:0,viewRequestID:0,tileSize:null,projection:"EPSG:4326",units:'degrees',maxResolution:1.40625,minResolution:null,maxScale:null,minScale:null,maxExtent:null,minExtent:null,numZoomLevels:16,theme:null,fallThrough:false,initialize:function(div,options){this.setOptions(options);this.id=OpenLayers.Util.createUniqueID("OpenLayers.Map_");this.div=div=OpenLayers.Util.getElement(div);var id=div.id+"_OpenLayers_ViewPort";this.viewPortDiv=OpenLayers.Util.createDiv(id,null,null,null,"relative",null,"hidden");this.viewPortDiv.style.width="100%";this.viewPortDiv.style.height="100%";this.viewPortDiv.className="olMapViewport";this.div.appendChild(this.viewPortDiv);id=div.id+"_OpenLayers_Container";this.layerContainerDiv=OpenLayers.Util.createDiv(id);this.layerContainerDiv.style.zIndex=this.Z_INDEX_BASE['Popup']-1;this.viewPortDiv.appendChild(this.layerContainerDiv);this.events=new OpenLayers.Events(this,div,this.EVENT_TYPES,this.fallThrough);this.updateSize();this.events.register("movestart",this,this.updateSize);if(navigator.appName.contains("Microsoft")){this.events.register("resize",this,this.updateSize);}else{OpenLayers.Event.observe(window,'resize',this.updateSize.bindAsEventListener(this));}
if(this.theme){var cssNode=document.createElement('link');cssNode.setAttribute('rel','stylesheet');cssNode.setAttribute('type','text/css');cssNode.setAttribute('href',this.theme);document.getElementsByTagName('head')[0].appendChild(cssNode);}
this.layers=[];if(this.controls==null){if(OpenLayers.Control!=null){this.controls=[new OpenLayers.Control.Navigation(),new OpenLayers.Control.PanZoom(),new OpenLayers.Control.ArgParser()];}else{this.controls=[];}}
for(var i=0;i<this.controls.length;i++){this.addControlToMap(this.controls[i]);}
this.popups=new Array();this.unloadDestroy=this.destroy.bindAsEventListener(this);OpenLayers.Event.observe(window,'unload',this.unloadDestroy);},destroy:function(){if(!this.unloadDestroy){return false;}
OpenLayers.Event.stopObserving(window,'unload',this.unloadDestroy);this.unloadDestroy=null;if(this.layers!=null){for(var i=this.layers.length-1;i>=0;--i){this.layers[i].destroy(false);}
this.layers=null;}
if(this.controls!=null){for(var i=this.controls.length-1;i>=0;--i){this.controls[i].destroy();}
this.controls=null;}
if(this.viewPortDiv){this.div.removeChild(this.viewPortDiv);}
this.viewPortDiv=null;this.events.destroy();this.events=null;},setOptions:function(options){this.tileSize=new OpenLayers.Size(OpenLayers.Map.TILE_WIDTH,OpenLayers.Map.TILE_HEIGHT);this.maxExtent=new OpenLayers.Bounds(-180,-90,180,90);this.theme=OpenLayers._getScriptLocation()+'theme/default/style.css';OpenLayers.Util.extend(this,options);},getTileSize:function(){return this.tileSize;},getLayer:function(id){var foundLayer=null;for(var i=0;i<this.layers.length;i++){var layer=this.layers[i];if(layer.id==id){foundLayer=layer;}}
return foundLayer;},setLayerZIndex:function(layer,zIdx){layer.setZIndex(this.Z_INDEX_BASE[layer.isBaseLayer?'BaseLayer':'Overlay']
+zIdx*5);},addLayer:function(layer){for(var i=0;i<this.layers.length;i++){if(this.layers[i]==layer){return false;}}
layer.div.style.overflow="";this.setLayerZIndex(layer,this.layers.length);if(layer.isFixed){this.viewPortDiv.appendChild(layer.div);}else{this.layerContainerDiv.appendChild(layer.div);}
this.layers.push(layer);layer.setMap(this);if(layer.isBaseLayer){if(this.baseLayer==null){this.setBaseLayer(layer);}else{layer.setVisibility(false);}}else{if(this.getCenter()!=null){layer.moveTo(this.getExtent(),true);}}
this.events.triggerEvent("addlayer");},addLayers:function(layers){for(var i=0;i<layers.length;i++){this.addLayer(layers[i]);}},removeLayer:function(layer,setNewBaseLayer){if(setNewBaseLayer==null){setNewBaseLayer=true;}
if(layer.isFixed){this.viewPortDiv.removeChild(layer.div);}else{this.layerContainerDiv.removeChild(layer.div);}
layer.map=null;OpenLayers.Util.removeItem(this.layers,layer);if(setNewBaseLayer&&(this.baseLayer==layer)){this.baseLayer=null;for(i=0;i<this.layers.length;i++){var iLayer=this.layers[i];if(iLayer.isBaseLayer){this.setBaseLayer(iLayer);break;}}}
this.events.triggerEvent("removelayer");},getNumLayers:function(){return this.layers.length;},getLayerIndex:function(layer){return OpenLayers.Util.indexOf(this.layers,layer);},setLayerIndex:function(layer,idx){var base=this.getLayerIndex(layer);if(idx<0)
idx=0;else if(idx>this.layers.length)
idx=this.layers.length;if(base!=idx){this.layers.splice(base,1);this.layers.splice(idx,0,layer);for(var i=0;i<this.layers.length;i++)
this.setLayerZIndex(this.layers[i],i);this.events.triggerEvent("changelayer");}},raiseLayer:function(layer,delta){var idx=this.getLayerIndex(layer)+delta;this.setLayerIndex(layer,idx);},setBaseLayer:function(newBaseLayer,noEvent){var oldExtent=null;if(this.baseLayer){oldExtent=this.baseLayer.getExtent();}
if(newBaseLayer!=this.baseLayer){if(OpenLayers.Util.indexOf(this.layers,newBaseLayer)!=-1){if(this.baseLayer!=null){this.baseLayer.setVisibility(false,noEvent);}
this.baseLayer=newBaseLayer;this.viewRequestID++;this.baseLayer.setVisibility(true,noEvent);var center=this.getCenter();if(center!=null){if(oldExtent==null){this.setCenter(center,this.getZoom(),false,true);}else{this.setCenter(oldExtent.getCenterLonLat(),this.getZoomForExtent(oldExtent),false,true);}}
if((noEvent==null)||(noEvent==false)){this.events.triggerEvent("changebaselayer");}}}},addControl:function(control,px){this.controls.push(control);this.addControlToMap(control,px);},addControlToMap:function(control,px){control.outsideViewport=(control.div!=null);control.setMap(this);var div=control.draw(px);if(div){if(!control.outsideViewport){div.style.zIndex=this.Z_INDEX_BASE['Control']+
this.controls.length;this.viewPortDiv.appendChild(div);}}},addPopup:function(popup,exclusive){if(exclusive){for(var i=0;i<this.popups.length;i++){this.removePopup(this.popups[i]);}}
popup.map=this;this.popups.push(popup);var popupDiv=popup.draw();if(popupDiv){popupDiv.style.zIndex=this.Z_INDEX_BASE['Popup']+
this.popups.length;this.layerContainerDiv.appendChild(popupDiv);}},removePopup:function(popup){OpenLayers.Util.removeItem(this.popups,popup);if(popup.div){try{this.layerContainerDiv.removeChild(popup.div);}
catch(e){}}
popup.map=null;},getSize:function(){var size=null;if(this.size!=null){size=this.size.clone();}
return size;},updateSize:function(){this.events.element.offsets=null;var newSize=this.getCurrentSize();var oldSize=this.getSize();if(oldSize==null)
this.size=oldSize=newSize;if(!newSize.equals(oldSize)){this.size=newSize;for(var i=0;i<this.layers.length;i++){this.layers[i].onMapResize();}
if(this.baseLayer!=null){var center=new OpenLayers.Pixel(newSize.w/2,newSize.h/2);var centerLL=this.getLonLatFromViewPortPx(center);var zoom=this.getZoom();this.zoom=null;this.setCenter(this.getCenter(),zoom);}}},getCurrentSize:function(){var size=new OpenLayers.Size(this.div.clientWidth,this.div.clientHeight);if(size.w==0&&size.h==0||isNaN(size.w)&&isNaN(size.h)){var dim=OpenLayers.Element.getDimensions(this.div);size.w=dim.width;size.h=dim.height;}
if(size.w==0&&size.h==0||isNaN(size.w)&&isNaN(size.h)){size.w=parseInt(this.div.style.width);size.h=parseInt(this.div.style.height);}
return size;},calculateBounds:function(center,resolution){var extent=null;if(center==null){center=this.getCenter();}
if(resolution==null){resolution=this.getResolution();}
if((center!=null)&&(resolution!=null)){var size=this.getSize();var w_deg=size.w*resolution;var h_deg=size.h*resolution;extent=new OpenLayers.Bounds(center.lon-w_deg/2,center.lat-h_deg/2,center.lon+w_deg/2,center.lat+h_deg/2);}
return extent;},getCenter:function(){return this.center;},getZoom:function(){return this.zoom;},pan:function(dx,dy){var centerPx=this.getViewPortPxFromLonLat(this.getCenter());var newCenterPx=centerPx.add(dx,dy);if(!newCenterPx.equals(centerPx)){var newCenterLonLat=this.getLonLatFromViewPortPx(newCenterPx);this.setCenter(newCenterLonLat);}},setCenter:function(lonlat,zoom,dragging,forceZoomChange){if(!this.center&&!this.isValidLonLat(lonlat)){lonlat=this.maxExtent.getCenterLonLat();}
var zoomChanged=forceZoomChange||((this.isValidZoomLevel(zoom))&&(zoom!=this.getZoom()));var centerChanged=(this.isValidLonLat(lonlat))&&(!lonlat.equals(this.center));if(zoomChanged||centerChanged||!dragging){if(!dragging){this.events.triggerEvent("movestart");}
if(centerChanged){if((!zoomChanged)&&(this.center)){this.centerLayerContainer(lonlat);}
this.center=lonlat.clone();}
if((zoomChanged)||(this.layerContainerOrigin==null)){this.layerContainerOrigin=this.center.clone();this.layerContainerDiv.style.left="0px";this.layerContainerDiv.style.top="0px";}
if(zoomChanged){this.zoom=zoom;for(var i=0;i<this.popups.length;i++){this.popups[i].updatePosition();}
this.viewRequestID++;}
var bounds=this.getExtent();this.baseLayer.moveTo(bounds,zoomChanged,dragging);for(var i=0;i<this.layers.length;i++){var layer=this.layers[i];if(!layer.isBaseLayer){var moveLayer;var inRange=layer.calculateInRange();if(layer.inRange!=inRange){layer.inRange=inRange;moveLayer=true;this.events.triggerEvent("changelayer");}else{moveLayer=(layer.visibility&&layer.inRange);}
if(moveLayer){layer.moveTo(bounds,zoomChanged,dragging);}}}
this.events.triggerEvent("move");if(zoomChanged){this.events.triggerEvent("zoomend");}}
if(!dragging){this.events.triggerEvent("moveend");}},centerLayerContainer:function(lonlat){var originPx=this.getViewPortPxFromLonLat(this.layerContainerOrigin);var newPx=this.getViewPortPxFromLonLat(lonlat);if((originPx!=null)&&(newPx!=null)){this.layerContainerDiv.style.left=(originPx.x-newPx.x)+"px";this.layerContainerDiv.style.top=(originPx.y-newPx.y)+"px";}},isValidZoomLevel:function(zoomLevel){return((zoomLevel!=null)&&(zoomLevel>=0)&&(zoomLevel<this.getNumZoomLevels()));},isValidLonLat:function(lonlat){var valid=false;if(lonlat!=null){var maxExtent=this.getMaxExtent();valid=maxExtent.containsLonLat(lonlat);}
return valid;},getProjection:function(){var projection=null;if(this.baseLayer!=null){projection=this.baseLayer.projection;}
return projection;},getMaxResolution:function(){var maxResolution=null;if(this.baseLayer!=null){maxResolution=this.baseLayer.maxResolution;}
return maxResolution;},getMaxExtent:function(){var maxExtent=null;if(this.baseLayer!=null){maxExtent=this.baseLayer.maxExtent;}
return maxExtent;},getNumZoomLevels:function(){var numZoomLevels=null;if(this.baseLayer!=null){numZoomLevels=this.baseLayer.numZoomLevels;}
return numZoomLevels;},getExtent:function(){var extent=null;if(this.baseLayer!=null){extent=this.baseLayer.getExtent();}
return extent;},getResolution:function(){var resolution=null;if(this.baseLayer!=null){resolution=this.baseLayer.getResolution();}
return resolution;},getScale:function(){var scale=null;if(this.baseLayer!=null){var res=this.getResolution();var units=this.baseLayer.units;scale=OpenLayers.Util.getScaleFromResolution(res,units);}
return scale;},getZoomForExtent:function(bounds){var zoom=null;if(this.baseLayer!=null){zoom=this.baseLayer.getZoomForExtent(bounds);}
return zoom;},getZoomForResolution:function(resolution){var zoom=null;if(this.baseLayer!=null){zoom=this.baseLayer.getZoomForResolution(resolution);}
return zoom;},zoomTo:function(zoom){if(this.isValidZoomLevel(zoom)){this.setCenter(null,zoom);}},zoomIn:function(){this.zoomTo(this.getZoom()+1);},zoomOut:function(){this.zoomTo(this.getZoom()-1);},zoomToExtent:function(bounds){this.setCenter(bounds.getCenterLonLat(),this.getZoomForExtent(bounds));},zoomToMaxExtent:function(){this.zoomToExtent(this.getMaxExtent());},zoomToScale:function(scale){var res=OpenLayers.Util.getResolutionFromScale(scale,this.baseLayer.units);var size=this.getSize();var w_deg=size.w*res;var h_deg=size.h*res;var center=this.getCenter();var extent=new OpenLayers.Bounds(center.lon-w_deg/2,center.lat-h_deg/2,center.lon+w_deg/2,center.lat+h_deg/2);this.zoomToExtent(extent);},getLonLatFromViewPortPx:function(viewPortPx){var lonlat=null;if(this.baseLayer!=null){lonlat=this.baseLayer.getLonLatFromViewPortPx(viewPortPx);}
return lonlat;},getViewPortPxFromLonLat:function(lonlat){var px=null;if(this.baseLayer!=null){px=this.baseLayer.getViewPortPxFromLonLat(lonlat);}
return px;},getLonLatFromPixel:function(px){return this.getLonLatFromViewPortPx(px);},getPixelFromLonLat:function(lonlat){return this.getViewPortPxFromLonLat(lonlat);},getViewPortPxFromLayerPx:function(layerPx){var viewPortPx=null;if(layerPx!=null){var dX=parseInt(this.layerContainerDiv.style.left);var dY=parseInt(this.layerContainerDiv.style.top);viewPortPx=layerPx.add(dX,dY);}
return viewPortPx;},getLayerPxFromViewPortPx:function(viewPortPx){var layerPx=null;if(viewPortPx!=null){var dX=-parseInt(this.layerContainerDiv.style.left);var dY=-parseInt(this.layerContainerDiv.style.top);layerPx=viewPortPx.add(dX,dY);if(isNaN(layerPx.x)||isNaN(layerPx.y)){layerPx=null;}}
return layerPx;},getLonLatFromLayerPx:function(px){px=this.getViewPortPxFromLayerPx(px);return this.getLonLatFromViewPortPx(px);},getLayerPxFromLonLat:function(lonlat){var px=this.getViewPortPxFromLonLat(lonlat);return this.getLayerPxFromViewPortPx(px);},CLASS_NAME:"OpenLayers.Map"};OpenLayers.Marker=OpenLayers.Class.create();OpenLayers.Marker.prototype={icon:null,lonlat:null,events:null,map:null,initialize:function(lonlat,icon){this.lonlat=lonlat;var newIcon=(icon)?icon:OpenLayers.Marker.defaultIcon();if(this.icon==null){this.icon=newIcon;}else{this.icon.url=newIcon.url;this.icon.size=newIcon.size;this.icon.offset=newIcon.offset;this.icon.calculateOffset=newIcon.calculateOffset;}
this.events=new OpenLayers.Events(this,this.icon.imageDiv,null);},destroy:function(){this.map=null;this.events.destroy();this.events=null;if(this.icon!=null){this.icon.destroy();this.icon=null;}},draw:function(px){return this.icon.draw(px);},moveTo:function(px){if((px!=null)&&(this.icon!=null)){this.icon.moveTo(px);}
this.lonlat=this.map.getLonLatFromLayerPx(px);},onScreen:function(){var onScreen=false;if(this.map){var screenBounds=this.map.getExtent();onScreen=screenBounds.containsLonLat(this.lonlat);}
return onScreen;},inflate:function(inflate){if(this.icon){var newSize=new OpenLayers.Size(this.icon.size.w*inflate,this.icon.size.h*inflate);this.icon.setSize(newSize);}},setOpacity:function(opacity){this.icon.setOpacity(opacity);},display:function(display){this.icon.display(display);},CLASS_NAME:"OpenLayers.Marker"};OpenLayers.Marker.defaultIcon=function(){var url=OpenLayers.Util.getImagesLocation()+"marker.png";var size=new OpenLayers.Size(21,25);var calculateOffset=function(size){return new OpenLayers.Pixel(-(size.w/2),-size.h);};return new OpenLayers.Icon(url,size,null,calculateOffset);};OpenLayers.Popup.AnchoredBubble=OpenLayers.Class.create();OpenLayers.Popup.AnchoredBubble.CORNER_SIZE=5;OpenLayers.Popup.AnchoredBubble.prototype=OpenLayers.Class.inherit(OpenLayers.Popup.Anchored,{rounded:false,initialize:function(id,lonlat,size,contentHTML,anchor,closeBox){OpenLayers.Popup.Anchored.prototype.initialize.apply(this,arguments);},draw:function(px){OpenLayers.Popup.Anchored.prototype.draw.apply(this,arguments);this.setContentHTML();this.setRicoCorners(!this.rounded);this.rounded=true;this.setBackgroundColor();this.setOpacity();return this.div;},setSize:function(size){OpenLayers.Popup.Anchored.prototype.setSize.apply(this,arguments);if(this.contentDiv!=null){var contentSize=this.size.clone();contentSize.h-=(2*OpenLayers.Popup.AnchoredBubble.CORNER_SIZE);contentSize.h-=(2*this.padding);this.contentDiv.style.height=contentSize.h+"px";this.contentDiv.style.width=contentSize.w+"px";if(this.map){this.setRicoCorners(!this.rounded);this.rounded=true;}}},setBackgroundColor:function(color){if(color!=undefined){this.backgroundColor=color;}
if(this.div!=null){if(this.contentDiv!=null){this.div.style.background="transparent";OpenLayers.Rico.Corner.changeColor(this.contentDiv,this.backgroundColor);}}},setOpacity:function(opacity){if(opacity!=undefined){this.opacity=opacity;}
if(this.div!=null){if(this.contentDiv!=null){OpenLayers.Rico.Corner.changeOpacity(this.contentDiv,this.opacity);}}},setBorder:function(border){this.border=0;},setRicoCorners:function(firstTime){var corners=this.getCornersToRound(this.relativePosition);var options={corners:corners,color:this.backgroundColor,bgColor:"transparent",blend:false};if(firstTime){OpenLayers.Rico.Corner.round(this.div,options);}else{OpenLayers.Rico.Corner.reRound(this.contentDiv,options);this.setBackgroundColor();this.setOpacity();}},getCornersToRound:function(){var corners=['tl','tr','bl','br'];var corner=OpenLayers.Bounds.oppositeQuadrant(this.relativePosition);OpenLayers.Util.removeItem(corners,corner);return corners.join(" ");},CLASS_NAME:"OpenLayers.Popup.AnchoredBubble"});OpenLayers.Renderer.SVG=OpenLayers.Class.create();OpenLayers.Renderer.SVG.prototype=OpenLayers.Class.inherit(OpenLayers.Renderer.Elements,{xmlns:"http://www.w3.org/2000/svg",maxPixel:15000,localResolution:null,initialize:function(containerID){if(!this.supported()){return;}
OpenLayers.Renderer.Elements.prototype.initialize.apply(this,arguments);},destroy:function(){OpenLayers.Renderer.Elements.prototype.destroy.apply(this,arguments);},supported:function(){var svgFeature="http://www.w3.org/TR/SVG11/feature#SVG";var supported=(document.implementation.hasFeature("org.w3c.svg","1.0")||document.implementation.hasFeature(svgFeature,"1.1"));return supported;},setExtent:function(extent){OpenLayers.Renderer.Elements.prototype.setExtent.apply(this,arguments);var resolution=this.getResolution();if(!this.localResolution||resolution!=this.localResolution){this.left=-extent.left/resolution;this.top=extent.top/resolution;}
var left=0;var top=0;if(this.localResolution&&resolution==this.localResolution){left=(this.left)-(-extent.left/resolution);top=(this.top)-(extent.top/resolution);}
this.localResolution=resolution;var extentString=left+" "+top+" "+
extent.getWidth()/resolution+" "+extent.getHeight()/resolution;this.rendererRoot.setAttributeNS(null,"viewBox",extentString);},setSize:function(size){OpenLayers.Renderer.prototype.setSize.apply(this,arguments);this.rendererRoot.setAttributeNS(null,"width",this.size.w);this.rendererRoot.setAttributeNS(null,"height",this.size.h);},getNodeType:function(geometry){var nodeType=null;switch(geometry.CLASS_NAME){case"OpenLayers.Geometry.Point":nodeType="circle";break;case"OpenLayers.Geometry.Rectangle":nodeType="rect";break;case"OpenLayers.Geometry.LineString":nodeType="polyline";break;case"OpenLayers.Geometry.LinearRing":nodeType="polygon";break;case"OpenLayers.Geometry.Polygon":case"OpenLayers.Geometry.Curve":case"OpenLayers.Geometry.Surface":nodeType="path";break;default:break;}
return nodeType;},setStyle:function(node,style,options){style=style||node._style;options=options||node._options;if(node._geometryClass=="OpenLayers.Geometry.Point"){node.setAttributeNS(null,"r",style.pointRadius);}
if(options.isFilled){node.setAttributeNS(null,"fill",style.fillColor);node.setAttributeNS(null,"fill-opacity",style.fillOpacity);}else{node.setAttributeNS(null,"fill","none");}
if(options.isStroked){node.setAttributeNS(null,"stroke",style.strokeColor);node.setAttributeNS(null,"stroke-opacity",style.strokeOpacity);node.setAttributeNS(null,"stroke-width",style.strokeWidth);}else{node.setAttributeNS(null,"stroke","none");}
if(style.pointerEvents){node.setAttributeNS(null,"pointer-events",style.pointerEvents);}
if(style.cursor){node.setAttributeNS(null,"cursor",style.cursor);}},createNode:function(type,id){var node=document.createElementNS(this.xmlns,type);if(id){node.setAttributeNS(null,"id",id);}
return node;},nodeTypeCompare:function(node,type){return(type==node.nodeName);},createRenderRoot:function(){var id=this.container.id+"_svgRoot";var rendererRoot=this.nodeFactory(id,"svg");return rendererRoot;},createRoot:function(){var id=this.container.id+"_root";var root=this.nodeFactory(id,"g");root.setAttributeNS(null,"transform","scale(1, -1)");return root;},drawPoint:function(node,geometry){this.drawCircle(node,geometry,1);},drawCircle:function(node,geometry,radius){var resolution=this.getResolution();var x=(geometry.x/resolution+this.left);var y=(geometry.y/resolution-this.top);var draw=true;if(x<-this.maxPixel||x>this.maxPixel){draw=false;}
if(y<-this.maxPixel||y>this.maxPixel){draw=false;}
if(draw){node.setAttributeNS(null,"cx",x);node.setAttributeNS(null,"cy",y);node.setAttributeNS(null,"r",radius);}else{node.setAttributeNS(null,"cx","");node.setAttributeNS(null,"cy","");node.setAttributeNS(null,"r",0);}},drawLineString:function(node,geometry){node.setAttributeNS(null,"points",this.getComponentsString(geometry.components));},drawLinearRing:function(node,geometry){node.setAttributeNS(null,"points",this.getComponentsString(geometry.components));},drawPolygon:function(node,geometry){var d="";var draw=true;for(var j=0;j<geometry.components.length;j++){var linearRing=geometry.components[j];d+=" M";for(var i=0;i<linearRing.components.length;i++){var component=this.getShortString(linearRing.components[i])
if(component){d+=" "+component;}else{draw=false;}}}
d+=" z";if(draw){node.setAttributeNS(null,"d",d);node.setAttributeNS(null,"fill-rule","evenodd");}else{node.setAttributeNS(null,"d","");}},drawRectangle:function(node,geometry){var x=(geometry.x/resolution+this.left);var y=(geometry.y/resolution-this.top);var draw=true;if(x<-this.maxPixel||x>this.maxPixel){draw=false;}
if(y<-this.maxPixel||y>this.maxPixel){draw=false;}
if(draw){node.setAttributeNS(null,"x",x);node.setAttributeNS(null,"y",y);node.setAttributeNS(null,"width",geometry.width);node.setAttributeNS(null,"height",geometry.height);}else{node.setAttributeNS(null,"x","");node.setAttributeNS(null,"y","");node.setAttributeNS(null,"width",0);node.setAttributeNS(null,"height",0);}},drawCurve:function(node,geometry){var d=null;var draw=true;for(var i=0;i<geometry.components.length;i++){if((i%3)==0&&(i/3)==0){var component=this.getShortString(geometry.components[i]);if(!component){draw=false;}
d="M "+component;}else if((i%3)==1){var component=this.getShortString(geometry.components[i]);if(!component){draw=false;}
d+=" C "+component;}else{var component=this.getShortString(geometry.components[i]);if(!component){draw=false;}
d+=" "+component;}}
if(draw){node.setAttributeNS(null,"d",d);}else{node.setAttributeNS(null,"d","");}},drawSurface:function(node,geometry){var d=null;var draw=true;for(var i=0;i<geometry.components.length;i++){if((i%3)==0&&(i/3)==0){var component=this.getShortString(geometry.components[i]);if(!component){draw=false;}
d="M "+component;}else if((i%3)==1){var component=this.getShortString(geometry.components[i]);if(!component){draw=false;}
d+=" C "+component;}else{var component=this.getShortString(geometry.components[i]);if(!component){draw=false;}
d+=" "+component;}}
d+=" Z";if(draw){node.setAttributeNS(null,"d",d);}else{node.setAttributeNS(null,"d","");}},getComponentsString:function(components){var strings=[];for(var i=0;i<components.length;i++){var component=this.getShortString(components[i]);if(!component){return false;}
strings.push(component);}
return strings.join(",");},getShortString:function(point){var resolution=this.getResolution();var x=(point.x/resolution+this.left);var y=(point.y/resolution-this.top);if(x<-this.maxPixel||x>this.maxPixel){return false;}
if(y<-this.maxPixel||y>this.maxPixel){return false;}
var string=x+","+y;return string;},CLASS_NAME:"OpenLayers.Renderer.SVG"});OpenLayers.Renderer.VML=OpenLayers.Class.create();OpenLayers.Renderer.VML.prototype=OpenLayers.Class.inherit(OpenLayers.Renderer.Elements,{xmlns:"urn:schemas-microsoft-com:vml",initialize:function(containerID){if(!this.supported()){return;}
document.namespaces.add("v","urn:schemas-microsoft-com:vml");var style=document.createStyleSheet();style.addRule('v\\:*',"behavior: url(#default#VML); "+"position: relative; display: inline-block;");OpenLayers.Renderer.Elements.prototype.initialize.apply(this,arguments);},destroy:function(){OpenLayers.Renderer.Elements.prototype.destroy.apply(this,arguments);},supported:function(){var supported=document.namespaces;return supported;},setExtent:function(extent){OpenLayers.Renderer.Elements.prototype.setExtent.apply(this,arguments);var resolution=this.getResolution();var org=extent.left/resolution+" "+
extent.top/resolution;this.root.setAttribute("coordorigin",org);var size=extent.getWidth()/resolution+" "+
-extent.getHeight()/resolution;this.root.setAttribute("coordsize",size);},setSize:function(size){OpenLayers.Renderer.prototype.setSize.apply(this,arguments);this.rendererRoot.style.width=this.size.w;this.rendererRoot.style.height=this.size.h;this.root.style.width="100%";this.root.style.height="100%";},getNodeType:function(geometry){var nodeType=null;switch(geometry.CLASS_NAME){case"OpenLayers.Geometry.Point":nodeType="v:oval";break;case"OpenLayers.Geometry.Rectangle":nodeType="v:rect";break;case"OpenLayers.Geometry.LineString":case"OpenLayers.Geometry.LinearRing":case"OpenLayers.Geometry.Polygon":case"OpenLayers.Geometry.Curve":case"OpenLayers.Geometry.Surface":nodeType="v:shape";break;default:break;}
return nodeType;},setStyle:function(node,style,options,geometry){style=style||node._style;options=options||node._options;if(node._geometryClass=="OpenLayers.Geometry.Point"){this.drawCircle(node,geometry,style.pointRadius);}
var fillColor=(options.isFilled)?style.fillColor:"none";node.setAttribute("fillcolor",fillColor);var fills=node.getElementsByTagName("fill");var fill=(fills.length==0)?null:fills[0];if(!options.isFilled){if(fill){node.removeChild(fill);}}else{if(!fill){fill=this.createNode('v:fill',node.id+"_fill");node.appendChild(fill);}
fill.setAttribute("opacity",style.fillOpacity);}
var strokeColor=(options.isStroked)?style.strokeColor:"none";node.setAttribute("strokecolor",strokeColor);node.setAttribute("strokeweight",style.strokeWidth);var strokes=node.getElementsByTagName("stroke");var stroke=(strokes.length==0)?null:strokes[0];if(!options.isStroked){if(stroke){node.removeChild(stroke);}}else{if(!stroke){stroke=this.createNode('v:stroke',node.id+"_stroke");node.appendChild(stroke);}
stroke.setAttribute("opacity",style.strokeOpacity);}
if(style.cursor){node.style.cursor=style.cursor;}},setNodeDimension:function(node,geometry){var bbox=geometry.getBounds();var resolution=this.getResolution();var scaledBox=new OpenLayers.Bounds((bbox.left/resolution).toFixed(),(bbox.bottom/resolution).toFixed(),(bbox.right/resolution).toFixed(),(bbox.top/resolution).toFixed());node.style.left=scaledBox.left;node.style.top=scaledBox.top;node.style.width=scaledBox.getWidth();node.style.height=scaledBox.getHeight();node.coordorigin=scaledBox.left+" "+scaledBox.top;node.coordsize=scaledBox.getWidth()+" "+scaledBox.getHeight();},createNode:function(type,id){var node=document.createElement(type);if(id){node.setAttribute('id',id);}
return node;},nodeTypeCompare:function(node,type){var subType=type;var splitIndex=subType.indexOf(":");if(splitIndex!=-1){subType=subType.substr(splitIndex+1);}
var nodeName=node.nodeName;splitIndex=nodeName.indexOf(":");if(splitIndex!=-1){nodeName=nodeName.substr(splitIndex+1);}
return(subType==nodeName);},createRenderRoot:function(){var id=this.container.id+"_vmlRoot";var rendererRoot=this.nodeFactory(id,"div");return rendererRoot;},createRoot:function(){var id=this.container.id+"_root";var root=this.nodeFactory(id,"v:group");return root;},drawPoint:function(node,geometry){this.drawCircle(node,geometry,1);},drawCircle:function(node,geometry,radius){var resolution=this.getResolution();node.style.left=(geometry.x/resolution).toFixed()-radius;node.style.top=(geometry.y/resolution).toFixed()-radius;var diameter=radius*2;node.style.width=diameter;node.style.height=diameter;},drawLineString:function(node,geometry){this.drawLine(node,geometry,false);},drawLinearRing:function(node,geometry){this.drawLine(node,geometry,true);},drawLine:function(node,geometry,closeLine){this.setNodeDimension(node,geometry);var resolution=this.getResolution();var path="m";for(var i=0;i<geometry.components.length;i++){var x=(geometry.components[i].x/resolution);var y=(geometry.components[i].y/resolution);path+=" "+x.toFixed()+","+y.toFixed()+" l ";}
if(closeLine){path+=" x";}
path+=" e";node.path=path;},drawPolygon:function(node,geometry){this.setNodeDimension(node,geometry);var resolution=this.getResolution();var path="";for(var j=0;j<geometry.components.length;j++){var linearRing=geometry.components[j];path+="m";for(var i=0;i<linearRing.components.length;i++){var x=linearRing.components[i].x/resolution;var y=linearRing.components[i].y/resolution;path+=" "+x.toFixed()+","+y.toFixed();if(i==0){path+=" l";}}
path+=" x ";}
path+="e";node.path=path;},drawRectangle:function(node,geometry){var resolution=this.getResolution();node.style.left=geometry.x/resolution;node.style.top=geometry.y/resolution;node.style.width=geometry.width/resolution;node.style.height=geometry.height/resolution;},drawCurve:function(node,geometry){this.setNodeDimension(node,geometry);var resolution=this.getResolution();var path="";for(var i=0;i<geometry.components.length;i++){var x=geometry.components[i].x/resolution;var y=geometry.components[i].y/resolution;if((i%3)==0&&(i/3)==0){path+="m"}else if((i%3)==1){path+=" c"}
path+=" "+x+","+y;}
path+=" x e";node.path=path;},drawSurface:function(node,geometry){this.setNodeDimension(node,geometry);var resolution=this.getResolution();var path="";for(var i=0;i<geometry.components.length;i++){var x=geometry.components[i].x/resolution;var y=geometry.components[i].y/resolution;if((i%3)==0&&(i/3)==0){path+="m";}else if((i%3)==1){path+=" c";}
path+=" "+x+","+y;}
path+=" x e";node.path=path;},CLASS_NAME:"OpenLayers.Renderer.VML"});OpenLayers.Tile.Image=OpenLayers.Class.create();OpenLayers.Tile.Image.prototype=OpenLayers.Class.inherit(OpenLayers.Tile,{url:null,imgDiv:null,frame:null,initialize:function(layer,position,bounds,url,size){OpenLayers.Tile.prototype.initialize.apply(this,arguments);this.url=url;this.frame=document.createElement('div');this.frame.style.overflow='hidden';this.frame.style.position='absolute';},destroy:function(){if(this.imgDiv!=null){OpenLayers.Event.stopObservingElement(this.imgDiv.id);if(this.imgDiv.parentNode==this.frame){this.frame.removeChild(this.imgDiv);this.imgDiv.map=null;}}
this.imgDiv=null;if((this.frame!=null)&&(this.frame.parentNode==this.layer.div)){this.layer.div.removeChild(this.frame);}
this.frame=null;OpenLayers.Tile.prototype.destroy.apply(this,arguments);},draw:function(){if(this.layer!=this.layer.map.baseLayer&&this.layer.reproject){this.bounds=this.getBoundsFromBaseLayer(this.position);}
if(!OpenLayers.Tile.prototype.draw.apply(this,arguments)){return false;}
if(this.imgDiv==null){this.initImgDiv();}
this.imgDiv.viewRequestID=this.layer.map.viewRequestID;this.url=this.layer.getURL(this.bounds);OpenLayers.Util.modifyDOMElement(this.frame,null,this.position,this.size);if(this.layer.alpha){OpenLayers.Util.modifyAlphaImageDiv(this.imgDiv,null,null,this.layer.imageSize,this.url);}else{this.imgDiv.src=this.url;OpenLayers.Util.modifyDOMElement(this.imgDiv,null,null,this.layer.imageSize);}
this.drawn=true;return true;},clear:function(){OpenLayers.Tile.prototype.clear.apply(this,arguments);if(this.imgDiv){this.imgDiv.style.display="none";}},moveTo:function(bounds,position,redraw){if(this.layer!=this.layer.map.baseLayer&&this.layer.reproject){bounds=this.getBoundsFromBaseLayer(position);}
this.url=this.layer.getURL(bounds);OpenLayers.Tile.prototype.moveTo.apply(this,arguments);},initImgDiv:function(){if(this.layer.alpha){this.imgDiv=OpenLayers.Util.createAlphaImageDiv(null,this.layer.imageOffset,this.layer.imageSize,null,"relative",null,null,null,true);}else{this.imgDiv=OpenLayers.Util.createImage(null,this.layer.imageOffset,this.layer.imageSize,null,"relative",null,null,true);}
this.imgDiv.className='olTileImage';this.frame.appendChild(this.imgDiv);this.layer.div.appendChild(this.frame);if(this.layer.opacity!=null){OpenLayers.Util.modifyDOMElement(this.imgDiv,null,null,null,null,null,null,this.layer.opacity);}
this.imgDiv.map=this.layer.map;},checkImgURL:function(){if(this.layer){var loaded=this.layer.alpha?this.imgDiv.firstChild.src:this.imgDiv.src;if(!OpenLayers.Util.isEquivalentUrl(loaded,this.url)){this.imgDiv.style.display="none";}}},CLASS_NAME:"OpenLayers.Tile.Image"});OpenLayers.Tile.WFS=OpenLayers.Class.create();OpenLayers.Tile.WFS.prototype=OpenLayers.Class.inherit(OpenLayers.Tile,{features:null,url:null,initialize:function(layer,position,bounds,url,size){OpenLayers.Tile.prototype.initialize.apply(this,arguments);this.url=url;this.features=new Array();},destroy:function(){OpenLayers.Tile.prototype.destroy.apply(this,arguments);this.destroyAllFeatures();this.features=null;this.url=null;},clear:function(){OpenLayers.Tile.prototype.clear.apply(this,arguments);this.destroyAllFeatures();},draw:function(){if(OpenLayers.Tile.prototype.draw.apply(this,arguments)){this.loadFeaturesForRegion(this.requestSuccess);}},loadFeaturesForRegion:function(success,failure){OpenLayers.loadURL(this.url,null,this,success);},requestSuccess:function(request){var doc=request.responseXML;if(!doc||request.fileType!="XML"){doc=OpenLayers.parseXMLString(request.responseText);}
if(this.layer.vectorMode){var gml=new OpenLayers.Format.GML({extractAttributes:this.layer.options.extractAttributes});this.layer.addFeatures(gml.read(doc));}else{var resultFeatures=OpenLayers.Ajax.getElementsByTagNameNS(doc,"http://www.opengis.net/gml","gml","featureMember");this.addResults(resultFeatures);}},addResults:function(results){for(var i=0;i<results.length;i++){var feature=new this.layer.featureClass(this.layer,results[i]);this.features.push(feature);}},destroyAllFeatures:function(){while(this.features.length>0){var feature=this.features.shift();feature.destroy();}},CLASS_NAME:"OpenLayers.Tile.WFS"});OpenLayers.Control.DragPan=OpenLayers.Class.create();OpenLayers.Control.DragPan.prototype=OpenLayers.Class.inherit(OpenLayers.Control,{type:OpenLayers.Control.TYPE_TOOL,draw:function(){this.handler=new OpenLayers.Handler.Drag(this,{"move":this.panMap,"up":this.panMapDone});},panMap:function(xy){var deltaX=this.handler.start.x-xy.x;var deltaY=this.handler.start.y-xy.y;var size=this.map.getSize();var newXY=new OpenLayers.Pixel(size.w/2+deltaX,size.h/2+deltaY);var newCenter=this.map.getLonLatFromViewPortPx(newXY);this.map.setCenter(newCenter,null,true);this.handler.start=xy;},panMapDone:function(xy){var deltaX=this.handler.start.x-xy.x;var deltaY=this.handler.start.y-xy.y;var size=this.map.getSize();var newXY=new OpenLayers.Pixel(size.w/2+deltaX,size.h/2+deltaY);var newCenter=this.map.getLonLatFromViewPortPx(newXY);this.map.setCenter(newCenter,null,false);this.handler.start=xy;},CLASS_NAME:"OpenLayers.Control.DragPan"});OpenLayers.Control.KeyboardDefaults=OpenLayers.Class.create();OpenLayers.Control.KeyboardDefaults.prototype=OpenLayers.Class.inherit(OpenLayers.Control,{slideFactor:75,initialize:function(){OpenLayers.Control.prototype.initialize.apply(this,arguments);},destroy:function(){if(this.handler){this.handler.destroy();}
this.handler=null;OpenLayers.Control.prototype.destroy.apply(this,arguments);},draw:function(){this.handler=new OpenLayers.Handler.Keyboard(this,{"keypress":this.defaultKeyPress});this.activate();},defaultKeyPress:function(code){switch(code){case OpenLayers.Event.KEY_LEFT:this.map.pan(-this.slideFactor,0);break;case OpenLayers.Event.KEY_RIGHT:this.map.pan(this.slideFactor,0);break;case OpenLayers.Event.KEY_UP:this.map.pan(0,-this.slideFactor);break;case OpenLayers.Event.KEY_DOWN:this.map.pan(0,this.slideFactor);break;case 33:var size=this.map.getSize();this.map.pan(0,-0.75*size.h);break;case 34:var size=this.map.getSize();this.map.pan(0,0.75*size.h);break;case 35:var size=this.map.getSize();this.map.pan(0.75*size.w,0);break;case 36:var size=this.map.getSize();this.map.pan(-0.75*size.w,0);break;case 43:this.map.zoomIn();break;case 45:this.map.zoomOut();break;case 107:this.map.zoomIn();break;case 109:this.map.zoomOut();break;}},CLASS_NAME:"OpenLayers.Control.KeyboardDefaults"});OpenLayers.Feature=OpenLayers.Class.create();OpenLayers.Feature.prototype={events:null,layer:null,id:null,lonlat:null,data:null,marker:null,popup:null,initialize:function(layer,lonlat,data){this.layer=layer;this.lonlat=lonlat;this.data=(data!=null)?data:new Object();this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_");},destroy:function(){if((this.layer!=null)&&(this.layer.map!=null)){if(this.popup!=null){this.layer.map.removePopup(this.popup);}}
if(this.events){this.events.destroy();}
this.events=null;this.layer=null;this.id=null;this.lonlat=null;this.data=null;if(this.marker!=null){this.destroyMarker(this.marker);this.marker=null;}
if(this.popup!=null){this.destroyPopup(this.popup);this.popup=null;}},onScreen:function(){var onScreen=false;if((this.layer!=null)&&(this.layer.map!=null)){var screenBounds=this.layer.map.getExtent();onScreen=screenBounds.containsLonLat(this.lonlat);}
return onScreen;},createMarker:function(){var marker=null;if(this.lonlat!=null){this.marker=new OpenLayers.Marker(this.lonlat,this.data.icon);}
return this.marker;},destroyMarker:function(){this.marker.destroy();},createPopup:function(){if(this.lonlat!=null){var id=this.id+"_popup";var anchor=(this.marker)?this.marker.icon:null;this.popup=new OpenLayers.Popup.AnchoredBubble(id,this.lonlat,this.data.popupSize,this.data.popupContentHTML,anchor);}
return this.popup;},destroyPopup:function(){this.popup.destroy()},CLASS_NAME:"OpenLayers.Feature"};OpenLayers.Geometry=OpenLayers.Class.create();OpenLayers.Geometry.prototype={id:null,parent:null,bounds:null,initialize:function(){this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_");},destroy:function(){this.id=null;this.bounds=null;},setBounds:function(bounds){if(bounds){this.bounds=bounds.clone();}},clearBounds:function(){this.bounds=null;if(this.parent){this.parent.clearBounds();}},extendBounds:function(newBounds){var bounds=this.getBounds();if(!bounds){this.setBounds(newBounds);}else{this.bounds.extend(newBounds);}},getBounds:function(){if(this.bounds==null){this.calculateBounds();}
return this.bounds;},calculateBounds:function(){},atPoint:function(lonlat,toleranceLon,toleranceLat){var atPoint=false;var bounds=this.getBounds();if((bounds!=null)&&(lonlat!=null)){var dX=(toleranceLon!=null)?toleranceLon:0;var dY=(toleranceLat!=null)?toleranceLat:0;var toleranceBounds=new OpenLayers.Bounds(this.bounds.left-dX,this.bounds.bottom-dY,this.bounds.right+dX,this.bounds.top+dY);atPoint=toleranceBounds.containsLonLat(lonlat);}
return atPoint;},getLength:function(){return 0.0;},getArea:function(){return 0.0;},toString:function(){return OpenLayers.Format.WKT.prototype.write(this);},CLASS_NAME:"OpenLayers.Geometry"};OpenLayers.Layer=OpenLayers.Class.create();OpenLayers.Layer.prototype={id:null,name:null,div:null,EVENT_TYPES:["loadstart","loadend","loadcancel"],events:null,map:null,isBaseLayer:false,alpha:false,displayInLayerSwitcher:true,visibility:true,inRange:false,imageSize:null,imageOffset:null,options:null,gutter:0,projection:null,units:null,scales:null,resolutions:null,maxExtent:null,minExtent:null,maxResolution:null,minResolution:null,numZoomLevels:null,minScale:null,maxScale:null,displayOutsideMaxExtent:false,initialize:function(name,options){this.addOptions(options);this.name=name;if(this.id==null){this.id=OpenLayers.Util.createUniqueID(this.CLASS_NAME+"_");this.div=OpenLayers.Util.createDiv();this.div.style.width="100%";this.div.style.height="100%";this.div.id=this.id;this.events=new OpenLayers.Events(this,this.div,this.EVENT_TYPES);}},destroy:function(setNewBaseLayer){if(setNewBaseLayer==null){setNewBaseLayer=true;}
if(this.map!=null){this.map.removeLayer(this,setNewBaseLayer);}
this.map=null;this.name=null;this.div=null;this.options=null;if(this.events){this.events.destroy();}
this.events=null;},clone:function(obj){if(obj==null){obj=new OpenLayers.Layer(this.name,this.options);}
OpenLayers.Util.applyDefaults(obj,this);obj.map=null;return obj;},setName:function(newName){if(newName!=this.name){this.name=newName;if(this.map!=null){this.map.events.triggerEvent("changelayer");}}},addOptions:function(newOptions){if(this.options==null){this.options=new Object();}
OpenLayers.Util.extend(this.options,newOptions);OpenLayers.Util.extend(this,newOptions);},onMapResize:function(){},moveTo:function(bounds,zoomChanged,dragging){var display=this.visibility;if(!this.isBaseLayer){display=display&&this.inRange;}
this.display(display);},setMap:function(map){if(this.map==null){this.map=map;this.maxExtent=this.maxExtent||this.map.maxExtent;this.projection=this.projection||this.map.projection;this.units=this.units||this.map.units;this.initResolutions();if(!this.isBaseLayer){this.inRange=this.calculateInRange();var show=((this.visibility)&&(this.inRange));this.div.style.display=show?"":"none";}
this.setTileSize();}},setTileSize:function(size){var tileSize=(size)?size:((this.tileSize)?this.tileSize:this.map.getTileSize());this.tileSize=tileSize;if(this.gutter){this.imageOffset=new OpenLayers.Pixel(-this.gutter,-this.gutter);this.imageSize=new OpenLayers.Size(tileSize.w+(2*this.gutter),tileSize.h+(2*this.gutter));}else{this.imageSize=tileSize;this.imageOffset=new OpenLayers.Pixel(0,0);}},getVisibility:function(){return this.visibility;},setVisibility:function(visibility,noEvent){if(visibility!=this.visibility){this.visibility=visibility;this.display(visibility);if(visibility&&this.map!=null){var extent=this.map.getExtent();if(extent!=null){this.moveTo(extent,true);}}
if((this.map!=null)&&((noEvent==null)||(noEvent==false))){this.map.events.triggerEvent("changelayer");}}},display:function(display){if(display!=(this.div.style.display!="none")){this.div.style.display=(display)?"block":"none";}},calculateInRange:function(){var inRange=false;if(this.map){var resolution=this.map.getResolution();inRange=((resolution>=this.minResolution)&&(resolution<=this.maxResolution));}
return inRange;},setIsBaseLayer:function(isBaseLayer){if(isBaseLayer!=this.isBaseLayer){this.isBaseLayer=isBaseLayer;if(this.map!=null){this.map.events.triggerEvent("changelayer");}}},initResolutions:function(){var props=new Array('projection','units','scales','resolutions','maxScale','minScale','maxResolution','minResolution','minExtent','maxExtent','numZoomLevels','maxZoomLevel');var confProps=new Object();for(var i=0;i<props.length;i++){var property=props[i];confProps[property]=this.options[property]||this.map[property];}
if((!confProps.numZoomLevels)&&(confProps.maxZoomLevel)){confProps.numZoomLevels=confProps.maxZoomLevel+1;}
if((confProps.scales!=null)||(confProps.resolutions!=null)){if(confProps.scales!=null){confProps.resolutions=new Array();for(var i=0;i<confProps.scales.length;i++){var scale=confProps.scales[i];confProps.resolutions[i]=OpenLayers.Util.getResolutionFromScale(scale,confProps.units);}}
confProps.numZoomLevels=confProps.resolutions.length;}else{confProps.resolutions=new Array();if(confProps.minScale){confProps.maxResolution=OpenLayers.Util.getResolutionFromScale(confProps.minScale,confProps.units);}else if(confProps.maxResolution=="auto"){var viewSize=this.map.getSize();var wRes=confProps.maxExtent.getWidth()/viewSize.w;var hRes=confProps.maxExtent.getHeight()/viewSize.h;confProps.maxResolution=Math.max(wRes,hRes);}
if(confProps.maxScale!=null){confProps.minResolution=OpenLayers.Util.getResolutionFromScale(confProps.maxScale);}else if((confProps.minResolution=="auto")&&(confProps.minExtent!=null)){var viewSize=this.map.getSize();var wRes=confProps.minExtent.getWidth()/viewSize.w;var hRes=confProps.minExtent.getHeight()/viewSize.h;confProps.minResolution=Math.max(wRes,hRes);}
if(confProps.minResolution!=null){var ratio=confProps.maxResolution/confProps.minResolution;confProps.numZoomLevels=Math.floor(Math.log(ratio)/Math.log(2))+1;}
for(var i=0;i<confProps.numZoomLevels;i++){var res=confProps.maxResolution/Math.pow(2,i)
confProps.resolutions.push(res);}}
confProps.resolutions.sort(function(a,b){return(b-a);});this.resolutions=confProps.resolutions;this.maxResolution=confProps.resolutions[0];var lastIndex=confProps.resolutions.length-1;this.minResolution=confProps.resolutions[lastIndex];this.scales=new Array();for(var i=0;i<confProps.resolutions.length;i++){this.scales[i]=OpenLayers.Util.getScaleFromResolution(confProps.resolutions[i],confProps.units);}
this.minScale=this.scales[0];this.maxScale=this.scales[this.scales.length-1];this.numZoomLevels=confProps.numZoomLevels;},getResolution:function(){var zoom=this.map.getZoom();return this.resolutions[zoom];},getExtent:function(){return this.map.calculateBounds();},getZoomForExtent:function(extent){var viewSize=this.map.getSize();var idealResolution=Math.max(extent.getWidth()/viewSize.w,extent.getHeight()/viewSize.h);return this.getZoomForResolution(idealResolution);},getZoomForResolution:function(resolution){for(var i=1;i<this.resolutions.length;i++){if(this.resolutions[i]<resolution){break;}}
return(i-1);},getLonLatFromViewPortPx:function(viewPortPx){var lonlat=null;if(viewPortPx!=null){var size=this.map.getSize();var center=this.map.getCenter();var res=this.map.getResolution();var delta_x=viewPortPx.x-(size.w/2);var delta_y=viewPortPx.y-(size.h/2);lonlat=new OpenLayers.LonLat(center.lon+delta_x*res,center.lat-delta_y*res);}
return lonlat;},getViewPortPxFromLonLat:function(lonlat){var px=null;if(lonlat!=null){var resolution=this.map.getResolution();var extent=this.map.getExtent();px=new OpenLayers.Pixel(Math.round(1/resolution*(lonlat.lon-extent.left)),Math.round(1/resolution*(extent.top-lonlat.lat)));}
return px;},adjustBoundsByGutter:function(bounds){var mapGutter=this.gutter*this.map.getResolution();bounds=new OpenLayers.Bounds(bounds.left-mapGutter,bounds.bottom-mapGutter,bounds.right+mapGutter,bounds.top+mapGutter);return bounds;},setOpacity:function(opacity){if(opacity!=this.opacity){this.opacity=opacity;for(var i=0;i<this.div.childNodes.length;++i){var element=this.div.childNodes[i].firstChild;OpenLayers.Util.modifyDOMElement(element,null,null,null,null,null,null,opacity);}}},setZIndex:function(zIdx){this.div.style.zIndex=zIdx;},CLASS_NAME:"OpenLayers.Layer"};OpenLayers.Marker.Box=OpenLayers.Class.create();OpenLayers.Marker.Box.prototype=OpenLayers.Class.inherit(OpenLayers.Marker,{bounds:null,div:null,initialize:function(bounds,borderColor,borderWidth){this.bounds=bounds;this.div=OpenLayers.Util.createDiv();this.div.style.overflow='hidden';this.events=new OpenLayers.Events(this,this.div,null);this.setBorder(borderColor,borderWidth);},destroy:function(){this.bounds=null;this.div=null;OpenLayers.Marker.prototype.destroy.apply(this,arguments);},setBorder:function(color,width){if(!color){color="red";}
if(!width){width=2;}
this.div.style.border=width+"px solid "+color;},draw:function(px,sz){OpenLayers.Util.modifyDOMElement(this.div,null,px,sz);return this.div;},onScreen:function(){var onScreen=false;if(this.map){var screenBounds=this.map.getExtent();onScreen=screenBounds.containsBounds(this.bounds,true,true);}
return onScreen;},display:function(display){this.div.style.display=(display)?"":"none";},CLASS_NAME:"OpenLayers.Marker.Box"});OpenLayers.Control.Navigation=OpenLayers.Class.create();OpenLayers.Control.Navigation.prototype=OpenLayers.Class.inherit(OpenLayers.Control,{dragPan:null,zoomBox:null,wheelHandler:null,activate:function(){this.dragPan.activate();this.wheelHandler.activate();this.zoomBox.activate();return OpenLayers.Control.prototype.activate.apply(this,arguments);},deactivate:function(){this.zoomBox.deactivate();this.dragPan.deactivate();this.wheelHandler.deactivate();return OpenLayers.Control.prototype.deactivate.apply(this,arguments);},draw:function(){this.map.events.register("dblclick",this,this.defaultDblClick);this.dragPan=new OpenLayers.Control.DragPan({map:this.map});this.zoomBox=new OpenLayers.Control.ZoomBox({map:this.map,keyMask:OpenLayers.Handler.MOD_SHIFT});this.dragPan.draw();this.zoomBox.draw();this.wheelHandler=new OpenLayers.Handler.MouseWheel(this,{"up":this.wheelUp,"down":this.wheelDown});this.activate();},defaultDblClick:function(evt){var newCenter=this.map.getLonLatFromViewPortPx(evt.xy);this.map.setCenter(newCenter,this.map.zoom+1);OpenLayers.Event.stop(evt);return false;},wheelChange:function(evt,deltaZ){var newZoom=this.map.getZoom()+deltaZ;if(!this.map.isValidZoomLevel(newZoom))return;var size=this.map.getSize();var deltaX=size.w/2-evt.xy.x;var deltaY=evt.xy.y-size.h/2;var newRes=this.map.baseLayer.resolutions[newZoom];var zoomPoint=this.map.getLonLatFromPixel(evt.xy);var newCenter=new OpenLayers.LonLat(zoomPoint.lon+deltaX*newRes,zoomPoint.lat+deltaY*newRes);this.map.setCenter(newCenter,newZoom);},wheelUp:function(evt){this.wheelChange(evt,1);},wheelDown:function(evt){this.wheelChange(evt,-1);},CLASS_NAME:"OpenLayers.Control.Navigation"});OpenLayers.State={UNKNOWN:'Unknown',INSERT:'Insert',UPDATE:'Update',DELETE:'Delete'}
OpenLayers.Feature.Vector=OpenLayers.Class.create();OpenLayers.Feature.Vector.prototype=OpenLayers.Class.inherit(OpenLayers.Feature,{fid:null,geometry:null,attributes:null,state:null,style:null,initialize:function(geometry,data,style){OpenLayers.Feature.prototype.initialize.apply(this,[null,null,data]);this.lonlat=null;this.geometry=geometry;this.state=null;this.attributes=new Object();if(data){this.attributes=OpenLayers.Util.extend(this.attributes,data);}
this.style=style?style:null;},destroy:function(){if(this.layer){this.layer.removeFeatures(this);this.layer=null;}
this.geometry=null;OpenLayers.Feature.prototype.destroy.apply(this,arguments);},clone:function(obj){if(obj==null){obj=new OpenLayers.Feature(null,this.geometry.clone(),this.data);}
OpenLayers.Util.applyDefaults(obj,this);return obj;},onScreen:function(){return null;},createMarker:function(){return null;},destroyMarker:function(){},createPopup:function(){return null;},atPoint:function(lonlat,toleranceLon,toleranceLat){var atPoint=false;if(this.geometry){atPoint=this.geometry.atPoint(lonlat,toleranceLon,toleranceLat);}
return atPoint;},destroyPopup:function(){},toState:function(state){if(state==OpenLayers.State.UPDATE){switch(this.state){case OpenLayers.State.UNKNOWN:case OpenLayers.State.DELETE:this.state=state;break;case OpenLayers.State.UPDATE:case OpenLayers.State.INSERT:break;}}else if(state==OpenLayers.State.INSERT){switch(this.state){case OpenLayers.State.UNKNOWN:break;default:this.state=state;break;}}else if(state==OpenLayers.State.DELETE){switch(this.state){case OpenLayers.State.INSERT:break;case OpenLayers.State.DELETE:break;case OpenLayers.State.UNKNOWN:case OpenLayers.State.UPDATE:this.state=state;break;}}else if(state==OpenLayers.State.UNKNOWN){this.state=state;}},CLASS_NAME:"OpenLayers.Feature.Vector"});OpenLayers.Feature.Vector.style={'default':{fillColor:"#ee9900",fillOpacity:0.4,hoverFillColor:"white",hoverFillOpacity:0.8,strokeColor:"#ee9900",strokeOpacity:1,strokeWidth:1,hoverStrokeColor:"red",hoverStrokeOpacity:1,hoverStrokeWidth:0.2,pointRadius:6,hoverPointRadius:1,hoverPointUnit:"%",pointerEvents:"visiblePainted"},'select':{fillColor:"blue",fillOpacity:0.4,hoverFillColor:"white",hoverFillOpacity:0.8,strokeColor:"blue",strokeOpacity:1,strokeWidth:2,hoverStrokeColor:"red",hoverStrokeOpacity:1,hoverStrokeWidth:0.2,pointRadius:6,hoverPointRadius:1,hoverPointUnit:"%",pointerEvents:"visiblePainted",cursor:"pointer"},'temporary':{fillColor:"yellow",fillOpacity:0.2,hoverFillColor:"white",hoverFillOpacity:0.8,strokeColor:"yellow",strokeOpacity:1,strokeWidth:4,hoverStrokeColor:"red",hoverStrokeOpacity:1,hoverStrokeWidth:0.2,pointRadius:6,hoverPointRadius:1,hoverPointUnit:"%",pointerEvents:"visiblePainted"}};OpenLayers.Feature.WFS=OpenLayers.Class.create();OpenLayers.Feature.WFS.prototype=OpenLayers.Class.inherit(OpenLayers.Feature,{initialize:function(layer,xmlNode){var newArguments=arguments;var data=this.processXMLNode(xmlNode);newArguments=new Array(layer,data.lonlat,data)
OpenLayers.Feature.prototype.initialize.apply(this,newArguments);this.createMarker();this.layer.addMarker(this.marker);},destroy:function(){if(this.marker!=null){this.layer.removeMarker(this.marker);}
OpenLayers.Feature.prototype.destroy.apply(this,arguments);},processXMLNode:function(xmlNode){var point=OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,"http://www.opengis.net/gml","gml","Point");var text=OpenLayers.Util.getXmlNodeValue(OpenLayers.Ajax.getElementsByTagNameNS(point[0],"http://www.opengis.net/gml","gml","coordinates")[0]);var floats=text.split(",");return{lonlat:new OpenLayers.LonLat(parseFloat(floats[0]),parseFloat(floats[1])),id:null};},CLASS_NAME:"OpenLayers.Feature.WFS"});OpenLayers.Geometry.Collection=OpenLayers.Class.create();OpenLayers.Geometry.Collection.prototype=OpenLayers.Class.inherit(OpenLayers.Geometry,{components:null,componentTypes:null,initialize:function(components){OpenLayers.Geometry.prototype.initialize.apply(this,arguments);this.components=new Array();if(components!=null){this.addComponents(components);}},destroy:function(){this.components.length=0;this.components=null;},clone:function(){var geometry=eval("new "+this.CLASS_NAME+"()");for(var i=0;i<this.components.length;i++){geometry.addComponent(this.components[i].clone());}
OpenLayers.Util.applyDefaults(geometry,this);return geometry;},getComponentsString:function(){var strings=[];for(var i=0;i<this.components.length;i++){strings.push(this.components[i].toShortString());}
return strings.join(",");},calculateBounds:function(){this.bounds=null;if(!this.components||(this.components.length>0)){this.setBounds(this.components[0].getBounds());for(var i=1;i<this.components.length;i++){this.extendBounds(this.components[i].getBounds());}}},addComponents:function(components){if(!(components instanceof Array)){components=[components];}
for(var i=0;i<components.length;i++){this.addComponent(components[i]);}},addComponent:function(component,index){var added=false;if(component){if(this.componentTypes==null||(OpenLayers.Util.indexOf(this.componentTypes,component.CLASS_NAME)>-1)){if(index!=null&&(index<this.components.length)){var components1=this.components.slice(0,index);var components2=this.components.slice(index,this.components.length);components1.push(component);this.components=components1.concat(components2);}else{this.components.push(component);}
component.parent=this;this.clearBounds();added=true;}}
return added;},removeComponents:function(components){if(!(components instanceof Array)){components=[components];}
for(var i=0;i<components.length;i++){this.removeComponent(components[i]);}},removeComponent:function(component){OpenLayers.Util.removeItem(this.components,component);this.clearBounds();},getLength:function(){var length=0.0;for(var i=0;i<this.components.length;i++){length+=this.components[i].getLength();}
return length;},getArea:function(){var area=0.0;for(var i=0;i<this.components.length;i++){area+=this.components[i].getArea();}
return area;},move:function(x,y){for(var i=0;i<this.components.length;i++){this.components[i].move(x,y);}},equals:function(geometry){var equivalent=true;if(!geometry.CLASS_NAME||(this.CLASS_NAME!=geometry.CLASS_NAME)){equivalent=false;}else if(!(geometry.components instanceof Array)||(geometry.components.length!=this.components.length)){equivalent=false;}else{for(var i=0;i<this.components.length;++i){if(!this.components[i].equals(geometry.components[i])){equivalent=false;break;}}}
return equivalent;},CLASS_NAME:"OpenLayers.Geometry.Collection"});OpenLayers.Geometry.Point=OpenLayers.Class.create();OpenLayers.Geometry.Point.prototype=OpenLayers.Class.inherit(OpenLayers.Geometry,{x:null,y:null,initialize:function(x,y){OpenLayers.Geometry.prototype.initialize.apply(this,arguments);this.x=parseFloat(x);this.y=parseFloat(y);},clone:function(obj){if(obj==null){obj=new OpenLayers.Geometry.Point(this.x,this.y);}
OpenLayers.Util.applyDefaults(obj,this);return obj;},calculateBounds:function(){this.bounds=new OpenLayers.Bounds(this.x,this.y,this.x,this.y);},distanceTo:function(point){var distance=0.0;if((this.x!=null)&&(this.y!=null)&&(point!=null)&&(point.x!=null)&&(point.y!=null)){var dx2=Math.pow(this.x-point.x,2);var dy2=Math.pow(this.y-point.y,2);distance=Math.sqrt(dx2+dy2);}
return distance;},equals:function(geom){var equals=false;if(geom!=null){equals=((this.x==geom.x&&this.y==geom.y)||(isNaN(this.x)&&isNaN(this.y)&&isNaN(geom.x)&&isNaN(geom.y)));}
return equals;},toShortString:function(){return(this.x+", "+this.y);},move:function(x,y){this.x=this.x+x;this.y=this.y+y;},CLASS_NAME:"OpenLayers.Geometry.Point"});OpenLayers.Geometry.Rectangle=OpenLayers.Class.create();OpenLayers.Geometry.Rectangle.prototype=OpenLayers.Class.inherit(OpenLayers.Geometry,{x:null,y:null,width:null,height:null,initialize:function(x,y,width,height){OpenLayers.Geometry.prototype.initialize.apply(this,arguments);this.x=x;this.y=y;this.width=width;this.height=height;},calculateBounds:function(){this.bounds=new OpenLayers.Bounds(this.x,this.y,this.x+this.width,this.y+this.height);},getLength:function(){var length=(2*this.width)+(2*this.height);return length;},getArea:function(){var area=this.width*this.height;return area;},CLASS_NAME:"OpenLayers.Geometry.Rectangle"});OpenLayers.Geometry.Surface=OpenLayers.Class.create();OpenLayers.Geometry.Surface.prototype=OpenLayers.Class.inherit(OpenLayers.Geometry,{initialize:function(){OpenLayers.Geometry.prototype.initialize.apply(this,arguments);},CLASS_NAME:"OpenLayers.Geometry.Surface"});OpenLayers.Layer.Canvas=OpenLayers.Class.create();OpenLayers.Layer.Canvas.prototype=OpenLayers.Class.inherit(OpenLayers.Layer,{isBaseLayer:false,isFixed:true,canvas:null,lines:new Array(),initialize:function(name,options){OpenLayers.Layer.prototype.initialize.apply(this,arguments);},destroy:function(){canvas=null;OpenLayers.Layer.prototype.destroy.apply(this,arguments);},moveTo:function(bounds,zoomChanged,dragging){OpenLayers.Layer.prototype.moveTo.apply(this,arguments);this.redraw();},setStrokeColor:function(color){var ctx=this.canvas.getContext("2d");ctx.strokeStyle=color;},setStrokeWidth:function(width){var ctx=this.canvas.getContext("2d");ctx.lineWidth=width;},setAlpha:function(alpha){var ctx=this.canvas.getContext("2d");ctx.globalAlpha=alpha;},clearCanvas:function(){if(this.canvas!=null){this.canvas.getContext("2d").clearRect(0,0,this.map.getSize().w,this.map.getSize().h);}},drawLine:function(start,end){var ctx=this.canvas.getContext("2d");this.addLine(start,end);this.lines.push(new Array(start,end,ctx.strokeStyle,ctx.lineWidth,ctx.globalAlpha));},addLine:function(start,end){var ctx=this.canvas.getContext("2d");var startpx=this.map.getPixelFromLonLat(start);var endpx=this.map.getPixelFromLonLat(end);ctx.beginPath();ctx.moveTo(startpx.x,startpx.y);ctx.lineTo(endpx.x,endpx.y);ctx.closePath();ctx.stroke();},redraw:function(){if(!this.canvas){this.canvas=document.createElement("CANVAS");this.canvas.setAttribute("width",this.map.getSize().w);this.canvas.setAttribute("height",this.map.getSize().h);this.div.appendChild(this.canvas);}else{this.clearCanvas();}
for(var i=0;i<this.lines.length;i++){this.setStrokeColor(this.lines[i][2]);this.setStrokeWidth(this.lines[i][3]);this.setAlpha(this.lines[i][4]);this.addLine(this.lines[i][0],this.lines[i][1]);}},CLASS_NAME:"OpenLayers.Layer.Canvas"});OpenLayers.Layer.EventPane=OpenLayers.Class.create();OpenLayers.Layer.EventPane.prototype=OpenLayers.Class.inherit(OpenLayers.Layer,{isBaseLayer:true,isFixed:true,pane:null,mapObject:null,initialize:function(name,options){OpenLayers.Layer.prototype.initialize.apply(this,arguments);if(this.pane==null){this.pane=OpenLayers.Util.createDiv(this.div.id+"_EventPane");}},destroy:function(){this.mapObject=null;OpenLayers.Layer.prototype.destroy.apply(this,arguments);},setMap:function(map){OpenLayers.Layer.prototype.setMap.apply(this,arguments);this.pane.style.zIndex=parseInt(this.div.style.zIndex)+1;this.pane.style.display=this.div.style.display;this.pane.style.width="100%";this.pane.style.height="100%";if(/MSIE/.test(navigator.userAgent)){this.pane.style.background="url("+OpenLayers.Util.getImagesLocation()+"blank.gif)";}
if(this.isFixed){this.map.viewPortDiv.appendChild(this.pane);}else{this.map.layerContainerDiv.appendChild(this.pane);}
this.loadMapObject();if(this.mapObject==null){this.loadWarningMessage();}},loadWarningMessage:function(){this.div.style.backgroundColor="darkblue";var viewSize=this.map.getSize();msgW=Math.min(viewSize.w,300);msgH=Math.min(viewSize.h,200);var size=new OpenLayers.Size(msgW,msgH);var centerPx=new OpenLayers.Pixel(viewSize.w/2,viewSize.h/2);var topLeft=centerPx.add(-size.w/2,-size.h/2);var div=OpenLayers.Util.createDiv(this.name+"_warning",topLeft,size,null,null,null,"auto");div.style.padding="7px";div.style.backgroundColor="yellow";div.innerHTML=this.getWarningHTML();this.div.appendChild(div);},display:function(display){OpenLayers.Layer.prototype.display.apply(this,arguments);this.pane.style.display=this.div.style.display;},setZIndex:function(zIndex){OpenLayers.Layer.prototype.setZIndex.apply(this,arguments);this.pane.style.zIndex=parseInt(this.div.style.zIndex)+1;},moveTo:function(bounds,zoomChanged,dragging){OpenLayers.Layer.prototype.moveTo.apply(this,arguments);if(this.mapObject!=null){var newCenter=this.map.getCenter();var newZoom=this.map.getZoom();if(newCenter!=null){var moOldCenter=this.getMapObjectCenter();var oldCenter=this.getOLLonLatFromMapObjectLonLat(moOldCenter);var moOldZoom=this.getMapObjectZoom();var oldZoom=this.getOLZoomFromMapObjectZoom(moOldZoom);if(!(newCenter.equals(oldCenter))||!(newZoom==oldZoom)){var center=this.getMapObjectLonLatFromOLLonLat(newCenter);var zoom=this.getMapObjectZoomFromOLZoom(newZoom);this.setMapObjectCenter(center,zoom);}}}},getLonLatFromViewPortPx:function(viewPortPx){var lonlat=null;if((this.mapObject!=null)&&(this.getMapObjectCenter()!=null)){var moPixel=this.getMapObjectPixelFromOLPixel(viewPortPx);var moLonLat=this.getMapObjectLonLatFromMapObjectPixel(moPixel)
lonlat=this.getOLLonLatFromMapObjectLonLat(moLonLat);}
return lonlat;},getViewPortPxFromLonLat:function(lonlat){var viewPortPx=null;if((this.mapObject!=null)&&(this.getMapObjectCenter()!=null)){var moLonLat=this.getMapObjectLonLatFromOLLonLat(lonlat);var moPixel=this.getMapObjectPixelFromMapObjectLonLat(moLonLat)
viewPortPx=this.getOLPixelFromMapObjectPixel(moPixel);}
return viewPortPx;},getOLLonLatFromMapObjectLonLat:function(moLonLat){var olLonLat=null;if(moLonLat!=null){var lon=this.getLongitudeFromMapObjectLonLat(moLonLat);var lat=this.getLatitudeFromMapObjectLonLat(moLonLat);olLonLat=new OpenLayers.LonLat(lon,lat);}
return olLonLat;},getMapObjectLonLatFromOLLonLat:function(olLonLat){var moLatLng=null;if(olLonLat!=null){moLatLng=this.getMapObjectLonLatFromLonLat(olLonLat.lon,olLonLat.lat);}
return moLatLng;},getOLPixelFromMapObjectPixel:function(moPixel){var olPixel=null;if(moPixel!=null){var x=this.getXFromMapObjectPixel(moPixel);var y=this.getYFromMapObjectPixel(moPixel);olPixel=new OpenLayers.Pixel(x,y);}
return olPixel;},getMapObjectPixelFromOLPixel:function(olPixel){var moPixel=null;if(olPixel!=null){moPixel=this.getMapObjectPixelFromXY(olPixel.x,olPixel.y);}
return moPixel;},CLASS_NAME:"OpenLayers.Layer.EventPane"});OpenLayers.Layer.FixedZoomLevels=OpenLayers.Class.create();OpenLayers.Layer.FixedZoomLevels.prototype={initialize:function(){},initResolutions:function(){var props=new Array('minZoomLevel','maxZoomLevel','numZoomLevels');for(var i=0;i<props.length;i++){var property=props[i];this[property]=(this.options[property]!=null)?this.options[property]:this.map[property];}
if((this.minZoomLevel==null)||(this.minZoomLevel<this.MIN_ZOOM_LEVEL)){this.minZoomLevel=this.MIN_ZOOM_LEVEL;}
var limitZoomLevels=this.MAX_ZOOM_LEVEL-this.minZoomLevel+1;if(this.numZoomLevels!=null){this.numZoomLevels=Math.min(this.numZoomLevels,limitZoomLevels);}else{if(this.maxZoomLevel!=null){var zoomDiff=this.maxZoomLevel-this.minZoomLevel+1;this.numZoomLevels=Math.min(zoomDiff,limitZoomLevels);}else{this.numZoomLevels=limitZoomLevels;}}
this.maxZoomLevel=this.minZoomLevel+this.numZoomLevels-1;if(this.RESOLUTIONS!=null){var resolutionsIndex=0;this.resolutions=[];for(var i=this.minZoomLevel;i<this.numZoomLevels;i++){this.resolutions[resolutionsIndex++]=this.RESOLUTIONS[i];}}},getResolution:function(){if(this.resolutions!=null){return OpenLayers.Layer.prototype.getResolution.apply(this,arguments);}else{var resolution=null;var viewSize=this.map.getSize();var extent=this.getExtent();if((viewSize!=null)&&(extent!=null)){resolution=Math.max(extent.getWidth()/viewSize.w,extent.getHeight()/viewSize.h);}
return resolution;}},getExtent:function(){var extent=null;var size=this.map.getSize();var tlPx=new OpenLayers.Pixel(0,0);var tlLL=this.getLonLatFromViewPortPx(tlPx);var brPx=new OpenLayers.Pixel(size.w,size.h);var brLL=this.getLonLatFromViewPortPx(brPx);if((tlLL!=null)&&(brLL!=null)){extent=new OpenLayers.Bounds(tlLL.lon,brLL.lat,brLL.lon,tlLL.lat);}
return extent;},getZoomForResolution:function(resolution){if(this.resolutions!=null){return OpenLayers.Layer.prototype.getZoomForResolution.apply(this,arguments);}else{var extent=OpenLayers.Layer.prototype.getExtent.apply(this,[resolution]);return this.getZoomForExtent(extent);}},getOLZoomFromMapObjectZoom:function(moZoom){var zoom=null;if(moZoom!=null){zoom=moZoom-this.minZoomLevel;}
return zoom;},getMapObjectZoomFromOLZoom:function(olZoom){var zoom=null;if(olZoom!=null){zoom=olZoom+this.minZoomLevel;}
return zoom;},CLASS_NAME:"FixedZoomLevels.js"};OpenLayers.Layer.HTTPRequest=OpenLayers.Class.create();OpenLayers.Layer.HTTPRequest.prototype=OpenLayers.Class.inherit(OpenLayers.Layer,{URL_HASH_FACTOR:(Math.sqrt(5)-1)/2,url:null,params:null,reproject:false,initialize:function(name,url,params,options){var newArguments=arguments;newArguments=[name,options];OpenLayers.Layer.prototype.initialize.apply(this,newArguments);this.url=url;this.params=OpenLayers.Util.extend(new Object(),params);},destroy:function(){this.url=null;this.params=null;OpenLayers.Layer.prototype.destroy.apply(this,arguments);},clone:function(obj){if(obj==null){obj=new OpenLayers.Layer.HTTPRequest(this.name,this.url,this.params,this.options);}
obj=OpenLayers.Layer.prototype.clone.apply(this,[obj]);return obj;},setUrl:function(newUrl){this.url=newUrl;},mergeNewParams:function(newParams){this.params=OpenLayers.Util.extend(this.params,newParams);},selectUrl:function(paramString,urls){var product=1;for(var i=0;i<paramString.length;i++){product*=paramString.charCodeAt(i)*this.URL_HASH_FACTOR;product-=Math.floor(product);}
return urls[Math.floor(product*urls.length)];},getFullRequestString:function(newParams,altUrl){var url=altUrl||this.url;var allParams=OpenLayers.Util.extend(new Object(),this.params);allParams=OpenLayers.Util.extend(allParams,newParams);var paramsString=OpenLayers.Util.getParameterString(allParams);if(url instanceof Array){url=this.selectUrl(paramsString,url);}
var urlParams=OpenLayers.Util.upperCaseObject(OpenLayers.Util.getArgs(url));for(var key in allParams){if(key.toUpperCase()in urlParams){delete allParams[key];}}
paramsString=OpenLayers.Util.getParameterString(allParams);var requestString=url;if(paramsString!=""){var lastServerChar=url.charAt(url.length-1);if((lastServerChar=="&")||(lastServerChar=="?")){requestString+=paramsString;}else{if(url.indexOf('?')==-1){requestString+='?'+paramsString;}else{requestString+='&'+paramsString;}}}
return requestString;},CLASS_NAME:"OpenLayers.Layer.HTTPRequest"});OpenLayers.Layer.Image=OpenLayers.Class.create();OpenLayers.Layer.Image.prototype=OpenLayers.Class.inherit(OpenLayers.Layer,{isBaseLayer:true,url:null,extent:null,size:null,tile:null,aspectRatio:null,initialize:function(name,url,extent,size,options){this.url=url;this.extent=extent;this.size=size;OpenLayers.Layer.prototype.initialize.apply(this,[name,options]);this.aspectRatio=(this.extent.getHeight()/this.size.h)/(this.extent.getWidth()/this.size.w);},destroy:function(){this.tile.destroy();this.tile=null;OpenLayers.Layer.prototype.destroy.apply(this,arguments);},clone:function(obj){if(obj==null){obj=new OpenLayers.Layer.Image(this.name,this.url,this.extent,this.size,this.options);}
obj=OpenLayers.Layer.prototype.clone.apply(this,[obj]);return obj;},setMap:function(map){if(this.options.maxResolution==null){this.options.maxResolution=this.aspectRatio*this.extent.getWidth()/this.size.w;}
OpenLayers.Layer.prototype.setMap.apply(this,arguments);},moveTo:function(bounds,zoomChanged,dragging){OpenLayers.Layer.prototype.moveTo.apply(this,arguments);var firstRendering=(this.tile==null);if(zoomChanged||firstRendering){this.setTileSize();var ul=new OpenLayers.LonLat(this.extent.left,this.extent.top);var ulPx=this.map.getLayerPxFromLonLat(ul);if(firstRendering){this.tile=new OpenLayers.Tile.Image(this,ulPx,this.extent,this.url,this.tileSize);}else{this.tile.size=this.tileSize.clone();this.tile.position=ulPx.clone();}
this.tile.draw();}},setTileSize:function(){var tileWidth=this.extent.getWidth()/this.map.getResolution();var tileHeight=this.extent.getHeight()/this.map.getResolution();this.tileSize=new OpenLayers.Size(tileWidth,tileHeight);this.imageSize=this.tileSize;this.imageOffset=new OpenLayers.Pixel(0,0);},setUrl:function(newUrl){this.url=newUrl;this.draw();},getURL:function(bounds){return this.url;},CLASS_NAME:"OpenLayers.Layer.Image"});OpenLayers.Layer.Markers=OpenLayers.Class.create();OpenLayers.Layer.Markers.prototype=OpenLayers.Class.inherit(OpenLayers.Layer,{isBaseLayer:false,markers:null,drawn:false,initialize:function(name,options){OpenLayers.Layer.prototype.initialize.apply(this,arguments);this.markers=new Array();},destroy:function(){this.clearMarkers();markers=null;OpenLayers.Layer.prototype.destroy.apply(this,arguments);},moveTo:function(bounds,zoomChanged,dragging){OpenLayers.Layer.prototype.moveTo.apply(this,arguments);if(zoomChanged||!this.drawn){this.redraw();this.drawn=true;}},addMarker:function(marker){this.markers.push(marker);if(this.map&&this.map.getExtent()){marker.map=this.map;this.drawMarker(marker);}},removeMarker:function(marker){OpenLayers.Util.removeItem(this.markers,marker);if((marker.icon!=null)&&(marker.icon.imageDiv!=null)&&(marker.icon.imageDiv.parentNode==this.div)){this.div.removeChild(marker.icon.imageDiv);}},clearMarkers:function(){if(this.markers!=null){while(this.markers.length>0){this.removeMarker(this.markers[0]);}}},redraw:function(){for(i=0;i<this.markers.length;i++){this.drawMarker(this.markers[i]);}},drawMarker:function(marker){var px=this.map.getLayerPxFromLonLat(marker.lonlat);if(px==null){marker.display(false);}else{var markerImg=marker.draw(px);if(!marker.drawn){this.div.appendChild(markerImg);marker.drawn=true;}}},CLASS_NAME:"OpenLayers.Layer.Markers"});OpenLayers.Control.DrawFeature=OpenLayers.Class.create();OpenLayers.Control.DrawFeature.prototype=OpenLayers.Class.inherit(OpenLayers.Control,{layer:null,callbacks:null,featureAdded:function(){},handlerOptions:null,initialize:function(layer,handler,options){OpenLayers.Control.prototype.initialize.apply(this,[options]);this.callbacks=OpenLayers.Util.extend({done:this.drawFeature},this.callbacks);this.layer=layer;this.handler=new handler(this,this.callbacks,this.handlerOptions);},drawFeature:function(geometry){var feature=new OpenLayers.Feature.Vector(geometry);this.layer.addFeatures([feature]);this.featureAdded(feature);},CLASS_NAME:"OpenLayers.Control.DrawFeature"});OpenLayers.Control.NavToolbar=OpenLayers.Class.create();OpenLayers.Control.NavToolbar.prototype=OpenLayers.Class.inherit(OpenLayers.Control.Panel,{initialize:function(options){OpenLayers.Control.Panel.prototype.initialize.apply(this,arguments);this.addControls([new OpenLayers.Control.Navigation(),new OpenLayers.Control.ZoomBox()]);},draw:function(){var div=OpenLayers.Control.Panel.prototype.draw.apply(this,arguments);this.activateControl(this.controls[0]);return div;},CLASS_NAME:"OpenLayers.Control.NavToolbar"});OpenLayers.Control.SelectFeature=OpenLayers.Class.create();OpenLayers.Control.SelectFeature.prototype=OpenLayers.Class.inherit(OpenLayers.Control,{multiple:false,hover:false,onSelect:function(){},onUnselect:function(){},layer:null,callbacks:null,selectStyle:OpenLayers.Feature.Vector.style['select'],handler:null,initialize:function(layer,options){OpenLayers.Control.prototype.initialize.apply(this,[options]);this.callbacks=OpenLayers.Util.extend({down:this.downFeature,over:this.overFeature,out:this.outFeature},this.callbacks);this.layer=layer;this.handler=new OpenLayers.Handler.Feature(this,layer,this.callbacks);},downFeature:function(feature){if(this.hover){return;}
if(this.multiple){if(OpenLayers.Util.indexOf(this.layer.selectedFeatures,feature)>-1){this.unselect(feature);}else{this.select(feature);}}else{if(OpenLayers.Util.indexOf(this.layer.selectedFeatures,feature)>-1){this.unselect(feature);}else{if(this.layer.selectedFeatures){for(var i=0;i<this.layer.selectedFeatures.length;i++){this.unselect(this.layer.selectedFeatures[i]);}}
this.select(feature);}}},overFeature:function(feature){if(!this.hover){return;}
if(!(OpenLayers.Util.indexOf(this.layer.selectedFeatures,feature)>-1)){this.select(feature);}},outFeature:function(feature){if(!this.hover){return;}
this.unselect(feature);},select:function(feature){if(feature.originalStyle==null){feature.originalStyle=feature.style;}
this.layer.selectedFeatures.push(feature);this.layer.drawFeature(feature,this.selectStyle);this.onSelect(feature);},unselect:function(feature){if(feature.originalStyle==null){feature.originalStyle=feature.style;}
this.layer.drawFeature(feature,feature.originalStyle);OpenLayers.Util.removeItem(this.layer.selectedFeatures,feature);this.onUnselect(feature);},setMap:function(map){this.handler.setMap(map);OpenLayers.Control.prototype.setMap.apply(this,arguments);},CLASS_NAME:"OpenLayers.Control.SelectFeature"});OpenLayers.Format.GML=OpenLayers.Class.create();OpenLayers.Format.GML.prototype=OpenLayers.Class.inherit(OpenLayers.Format,{featureNS:"http://mapserver.gis.umn.edu/mapserver",featureName:"featureMember",layerName:"features",geometryName:"geometry",collectionName:"FeatureCollection",gmlns:"http://www.opengis.net/gml",extractAttributes:true,read:function(data){if(typeof data=="string"){data=OpenLayers.parseXMLString(data);}
var featureNodes=OpenLayers.Ajax.getElementsByTagNameNS(data,this.gmlns,"gml",this.featureName);if(featureNodes.length==0){return[];}
var dim;var coordNodes=OpenLayers.Ajax.getElementsByTagNameNS(featureNodes[0],this.gmlns,"gml","posList");if(coordNodes.length==0){coordNodes=OpenLayers.Ajax.getElementsByTagNameNS(featureNodes[0],this.gmlns,"gml","pos");}
if(coordNodes.length>0){dim=coordNodes[0].getAttribute("srsDimension");}
this.dim=(dim=="3"||dim==3)?3:2;var features=[];for(var i=0;i<featureNodes.length;i++){var feature=this.parseFeature(featureNodes[i]);if(feature){features.push(feature);}}
return features;},parseFeature:function(xmlNode){var geom;var p;var feature=new OpenLayers.Feature.Vector();if(OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,this.gmlns,"gml","MultiPolygon").length!=0){var multipolygon=OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,this.gmlns,"gml","MultiPolygon")[0];feature.fid=multipolygon.parentNode.parentNode.getAttribute('fid');geom=new OpenLayers.Geometry.MultiPolygon();var polygons=OpenLayers.Ajax.getElementsByTagNameNS(multipolygon,this.gmlns,"gml","Polygon");for(var i=0;i<polygons.length;i++){polygon=this.parsePolygonNode(polygons[i],geom);geom.addComponents(polygon);}}
else if(OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,this.gmlns,"gml","MultiLineString").length!=0){var multilinestring=OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,this.gmlns,"gml","MultiLineString")[0];feature.fid=multilinestring.parentNode.parentNode.getAttribute('fid');geom=new OpenLayers.Geometry.MultiLineString();var lineStrings=OpenLayers.Ajax.getElementsByTagNameNS(multilinestring,this.gmlns,"gml","LineString");for(var i=0;i<lineStrings.length;i++){p=this.parseCoords(lineStrings[i]);if(p.points){var lineString=new OpenLayers.Geometry.LineString(p.points);geom.addComponents(lineString);}}}
else if(OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,this.gmlns,"gml","MultiPoint").length!=0){var multiPoint=OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,this.gmlns,"gml","MultiPoint")[0];feature.fid=multiPoint.parentNode.parentNode.getAttribute('fid');geom=new OpenLayers.Geometry.MultiPoint();var points=OpenLayers.Ajax.getElementsByTagNameNS(multiPoint,this.gmlns,"gml","Point");for(var i=0;i<points.length;i++){p=this.parseCoords(points[i]);geom.addComponents(p.points[0]);}}
else if(OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,this.gmlns,"gml","Polygon").length!=0){var polygon=OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,this.gmlns,"gml","Polygon")[0];feature.fid=polygon.parentNode.parentNode.getAttribute('fid');geom=this.parsePolygonNode(polygon);}
else if(OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,this.gmlns,"gml","LineString").length!=0){var lineString=OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,this.gmlns,"gml","LineString")[0];feature.fid=lineString.parentNode.parentNode.getAttribute('fid');p=this.parseCoords(lineString);if(p.points){geom=new OpenLayers.Geometry.LineString(p.points);}}
else if(OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,this.gmlns,"gml","Point").length!=0){var point=OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,this.gmlns,"gml","Point")[0];feature.fid=point.parentNode.parentNode.getAttribute('fid');p=this.parseCoords(point);if(p.points){geom=p.points[0];}}
feature.geometry=geom;if(this.extractAttributes){feature.attributes=this.parseAttributes(xmlNode);}
return feature;},parseAttributes:function(xmlNode){var nodes=xmlNode.childNodes;var attributes={};for(var i=0;i<nodes.length;i++){var name=nodes[i].nodeName;var value=OpenLayers.Util.getXmlNodeValue(nodes[i]);if((name.search(":pos")!=-1)||(name.search(":posList")!=-1)||(name.search(":coordinates")!=-1)){continue;}
if((nodes[i].childNodes.length==1&&nodes[i].childNodes[0].nodeName=="#text")||(nodes[i].childNodes.length==0&&nodes[i].nodeName!="#text")){attributes[name]=value;}
OpenLayers.Util.extend(attributes,this.parseAttributes(nodes[i]))}
return attributes;},parsePolygonNode:function(polygonNode){var linearRings=OpenLayers.Ajax.getElementsByTagNameNS(polygonNode,this.gmlns,"gml","LinearRing");var rings=[];var p;var polyBounds;for(var i=0;i<linearRings.length;i++){p=this.parseCoords(linearRings[i]);ring1=new OpenLayers.Geometry.LinearRing(p.points);rings.push(ring1);}
var poly=new OpenLayers.Geometry.Polygon(rings);return poly;},parseCoords:function(xmlNode){var x,y,left,bottom,right,top,bounds;var p=[];if(xmlNode){p.points=[];var coordNodes=OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,this.gmlns,"gml","posList");if(coordNodes.length==0){coordNodes=OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,this.gmlns,"gml","pos");}
if(coordNodes.length==0){coordNodes=OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,this.gmlns,"gml","coordinates");}
var coordString=OpenLayers.Util.getXmlNodeValue(coordNodes[0]);var nums=(coordString)?coordString.split(/[, \n\t]+/):[];while(nums[0]=="")
nums.shift();while(nums[nums.length-1]=="")
nums.pop();for(i=0;i<nums.length;i=i+this.dim){x=parseFloat(nums[i]);y=parseFloat(nums[i+1]);p.points.push(new OpenLayers.Geometry.Point(x,y));}}
return p;},write:function(features){var featureCollection=document.createElementNS("http://www.opengis.net/wfs","wfs:"+this.collectionName);for(var i=0;i<features.length;i++){featureCollection.appendChild(this.createFeatureXML(features[i]));}
return featureCollection;},createFeatureXML:function(feature){var geometryNode=this.buildGeometryNode(feature.geometry);var geomContainer=document.createElementNS(this.featureNS,"feature:"+this.geometryName);geomContainer.appendChild(geometryNode);var featureNode=document.createElementNS(this.gmlns,"gml:"+this.featureName);var featureContainer=document.createElementNS(this.featureNS,"feature:"+this.layerName);featureContainer.appendChild(geomContainer);for(var attr in feature.attributes){var attrText=document.createTextNode(feature.attributes[attr]);var nodename=attr;if(attr.search(":")!=-1){nodename=attr.split(":")[1];}
var attrContainer=document.createElementNS(this.featureNS,"feature:"+nodename);attrContainer.appendChild(attrText);featureContainer.appendChild(attrContainer);}
featureNode.appendChild(featureContainer);return featureNode;},buildGeometryNode:function(geometry){var gml="";if(geometry.CLASS_NAME=="OpenLayers.Geometry.MultiPolygon"||geometry.CLASS_NAME=="OpenLayers.Geometry.Polygon"){gml=document.createElementNS(this.gmlns,'gml:MultiPolygon');var polygonMember=document.createElementNS(this.gmlns,'gml:polygonMember');var polygon=document.createElementNS(this.gmlns,'gml:Polygon');var outerRing=document.createElementNS(this.gmlns,'gml:outerBoundaryIs');var linearRing=document.createElementNS(this.gmlns,'gml:LinearRing');linearRing.appendChild(this.buildCoordinatesNode(geometry.components[0]));outerRing.appendChild(linearRing);polygon.appendChild(outerRing);polygonMember.appendChild(polygon);gml.appendChild(polygonMember);}
else if(geometry.CLASS_NAME=="OpenLayers.Geometry.MultiLineString"||geometry.CLASS_NAME=="OpenLayers.Geometry.LineString"){gml=document.createElementNS(this.gmlns,'gml:MultiLineString');var lineStringMember=document.createElementNS(this.gmlns,'gml:lineStringMember');var lineString=document.createElementNS(this.gmlns,'gml:LineString');lineString.appendChild(this.buildCoordinatesNode(geometry));lineStringMember.appendChild(lineString);gml.appendChild(lineStringMember);}
else if(geometry.CLASS_NAME=="OpenLayers.Geometry.Point"||geometry.CLASS_NAME=="OpenLayers.Geometry.MultiPoint"){gml=document.createElementNS(this.gmlns,'gml:MultiPoint');var parts="";if(geometry.CLASS_NAME=="OpenLayers.Geometry.MultiPoint"){parts=geometry.components;}else{parts=[geometry];}
for(var i=0;i<parts.length;i++){var pointMember=document.createElementNS(this.gmlns,'gml:pointMember');var point=document.createElementNS(this.gmlns,'gml:Point');point.appendChild(this.buildCoordinatesNode(parts[i]));pointMember.appendChild(point);gml.appendChild(pointMember);}}
return gml;},buildCoordinatesNode:function(geometry){var coordinatesNode=document.createElementNS(this.gmlns,"gml:coordinates");coordinatesNode.setAttribute("decimal",".");coordinatesNode.setAttribute("cs",",");coordinatesNode.setAttribute("ts"," ");var points=null;if(geometry.components){points=geometry.components;}
var path="";if(points){for(var i=0;i<points.length;i++){path+=points[i].x+","+points[i].y+" ";}}else{path+=geometry.x+","+geometry.y+" ";}
var txtNode=document.createTextNode(path);coordinatesNode.appendChild(txtNode);return coordinatesNode;},CLASS_NAME:"OpenLayers.Format.GML"});OpenLayers.Format.KML=OpenLayers.Class.create();OpenLayers.Format.KML.prototype=OpenLayers.Class.inherit(OpenLayers.Format,{featureNS:"http://mapserver.gis.umn.edu/mapserver",collectionName:"FeatureCollection",kmlns:"http://earth.google.com/kml/2.0",read:function(data){if(typeof data=="string"){data=OpenLayers.parseXMLString(data);}
var featureNodes=OpenLayers.Ajax.getElementsByTagNameNS(data,this.kmlns,"","Placemark");var features=[];for(var i=0;i<featureNodes.length;i++){var feature=this.parseFeature(featureNodes[i]);if(feature){features.push(feature);}}
return features;},parseFeature:function(xmlNode){var geom;var p;var feature=new OpenLayers.Feature.Vector();if(OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,this.kmlns,"","Point").length!=0){var point=OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,this.kmlns,"","Point")[0];p=this.parseCoords(point);if(p.points){geom=p.points[0];geom.extendBounds(p.bounds);}}else if(OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,this.kmlns,"","LineString").length!=0){var linestring=OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,this.kmlns,"","LineString")[0];p=this.parseCoords(linestring);if(p.points){geom=new OpenLayers.Geometry.LineString(p.points);geom.extendBounds(p.bounds);}}
feature.geometry=geom;feature.attributes=this.parseAttributes(xmlNode);return feature;},parseAttributes:function(xmlNode){var nodes=xmlNode.childNodes;var attributes={};for(var i=0;i<nodes.length;i++){var name=nodes[i].nodeName;var value=OpenLayers.Util.getXmlNodeValue(nodes[i]);if((name.search(":pos")!=-1)||(name.search(":posList")!=-1)||(name.search(":coordinates")!=-1)){continue;}
if((nodes[i].childNodes.length==1&&nodes[i].childNodes[0].nodeName=="#text")||(nodes[i].childNodes.length==0&&nodes[i].nodeName!="#text")){attributes[name]=value;}
OpenLayers.Util.extend(attributes,this.parseAttributes(nodes[i]))}
return attributes;},parseCoords:function(xmlNode){var p=[];p.points=[];var coordNodes=OpenLayers.Ajax.getElementsByTagNameNS(xmlNode,this.kmlns,"","coordinates")[0];var coordString=OpenLayers.Util.getXmlNodeValue(coordNodes);var firstCoord=coordString.split(" ");while(firstCoord[0]=="")
firstCoord.shift();var dim=firstCoord[0].split(",").length;var nums=(coordString)?coordString.split(/[, \n\t]+/):[];while(nums[0]=="")
nums.shift();while(nums[nums.length-1]=="")
nums.pop();for(i=0;i<nums.length;i=i+dim){x=parseFloat(nums[i]);y=parseFloat(nums[i+1]);p.points.push(new OpenLayers.Geometry.Point(x,y));if(!p.bounds){p.bounds=new OpenLayers.Bounds(x,y,x,y);}else{p.bounds.extend(x,y);}}
return p;},CLASS_NAME:"OpenLayers.Format.KML"});OpenLayers.Geometry.MultiLineString=OpenLayers.Class.create();OpenLayers.Geometry.MultiLineString.prototype=OpenLayers.Class.inherit(OpenLayers.Geometry.Collection,{componentTypes:["OpenLayers.Geometry.LineString"],initialize:function(components){OpenLayers.Geometry.Collection.prototype.initialize.apply(this,arguments);},CLASS_NAME:"OpenLayers.Geometry.MultiLineString"});OpenLayers.Geometry.MultiPoint=OpenLayers.Class.create();OpenLayers.Geometry.MultiPoint.prototype=OpenLayers.Class.inherit(OpenLayers.Geometry.Collection,{componentTypes:["OpenLayers.Geometry.Point"],initialize:function(components){OpenLayers.Geometry.Collection.prototype.initialize.apply(this,arguments);},addPoint:function(point,index){this.addComponent(point,index);},removePoint:function(point){this.removeComponent(point);},CLASS_NAME:"OpenLayers.Geometry.MultiPoint"});OpenLayers.Geometry.MultiPolygon=OpenLayers.Class.create();OpenLayers.Geometry.MultiPolygon.prototype=OpenLayers.Class.inherit(OpenLayers.Geometry.Collection,{componentTypes:["OpenLayers.Geometry.Polygon"],initialize:function(components){OpenLayers.Geometry.Collection.prototype.initialize.apply(this,arguments);},CLASS_NAME:"OpenLayers.Geometry.MultiPolygon"});OpenLayers.Geometry.Polygon=OpenLayers.Class.create();OpenLayers.Geometry.Polygon.prototype=OpenLayers.Class.inherit(OpenLayers.Geometry.Collection,{componentTypes:["OpenLayers.Geometry.LinearRing"],initialize:function(components){OpenLayers.Geometry.Collection.prototype.initialize.apply(this,arguments);},getArea:function(){var area=0.0;if(this.components&&(this.components.length>0)){area+=Math.abs(this.components[0].getArea());for(var i=1;i<this.components.length;i++){area-=Math.abs(this.components[i].getArea());}}
return area;},CLASS_NAME:"OpenLayers.Geometry.Polygon"});OpenLayers.Handler.Point=OpenLayers.Class.create();OpenLayers.Handler.Point.prototype=OpenLayers.Class.inherit(OpenLayers.Handler,{point:null,layer:null,drawing:false,mouseDown:false,lastDown:null,lastUp:null,initialize:function(control,callbacks,options){this.style=OpenLayers.Util.extend(OpenLayers.Feature.Vector.style['default'],{});OpenLayers.Handler.prototype.initialize.apply(this,arguments);},activate:function(){if(!OpenLayers.Handler.prototype.activate.apply(this,arguments)){return false;}
var options={displayInLayerSwitcher:false};this.layer=new OpenLayers.Layer.Vector(this.CLASS_NAME,options);this.map.addLayer(this.layer);return true;},createFeature:function(){this.point=new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Point());},deactivate:function(){if(!OpenLayers.Handler.prototype.deactivate.apply(this,arguments)){return false;}
if(this.drawing){this.cancel();}
this.map.removeLayer(this.layer,false);this.layer.destroy();return true;},destroyFeature:function(){this.point.destroy();},finalize:function(){this.layer.renderer.clear();this.callback("done",[this.geometryClone()]);this.destroyFeature();this.drawing=false;this.mouseDown=false;this.lastDown=null;this.lastUp=null;},cancel:function(){this.layer.renderer.clear();this.callback("cancel",[this.geometryClone()]);this.destroyFeature();this.drawing=false;this.mouseDown=false;this.lastDown=null;this.lastUp=null;},dblclick:function(evt){OpenLayers.Event.stop(evt);return false;},drawFeature:function(){this.layer.drawFeature(this.point,this.style);},geometryClone:function(){return this.point.geometry.clone();},mousedown:function(evt){if(!this.checkModifiers(evt)){return true;}
if(this.lastDown&&this.lastDown.equals(evt.xy)){return true;}
if(this.lastDown==null){this.createFeature();}
this.lastDown=evt.xy;this.drawing=true;var lonlat=this.map.getLonLatFromPixel(evt.xy);this.point.geometry.x=lonlat.lon;this.point.geometry.y=lonlat.lat;this.drawFeature();return false;},mousemove:function(evt){if(this.drawing){var lonlat=this.map.getLonLatFromPixel(evt.xy);this.point.geometry.x=lonlat.lon;this.point.geometry.y=lonlat.lat;this.drawFeature();}
return true;},mouseup:function(evt){if(this.drawing){this.finalize();return false;}else{return true;}},CLASS_NAME:"OpenLayers.Handler.Point"});OpenLayers.Layer.Boxes=OpenLayers.Class.create();OpenLayers.Layer.Boxes.prototype=OpenLayers.Class.inherit(OpenLayers.Layer.Markers,{initialize:function(name,options){OpenLayers.Layer.Markers.prototype.initialize.apply(this,arguments);},drawMarker:function(marker){var bounds=marker.bounds;var topleft=this.map.getLayerPxFromLonLat(new OpenLayers.LonLat(bounds.left,bounds.top));var botright=this.map.getLayerPxFromLonLat(new OpenLayers.LonLat(bounds.right,bounds.bottom));if(botright==null||topleft==null){marker.display(false);}else{var sz=new OpenLayers.Size(Math.max(1,botright.x-topleft.x),Math.max(1,botright.y-topleft.y));var markerDiv=marker.draw(topleft,sz);if(!marker.drawn){this.div.appendChild(markerDiv);marker.drawn=true;}}},removeMarker:function(marker){OpenLayers.Util.removeItem(this.markers,marker);if((marker.div!=null)&&(marker.div.parentNode==this.div)){this.div.removeChild(marker.div);}},CLASS_NAME:"OpenLayers.Layer.Boxes"});OpenLayers.Layer.GeoRSS=OpenLayers.Class.create();OpenLayers.Layer.GeoRSS.prototype=OpenLayers.Class.inherit(OpenLayers.Layer.Markers,{location:null,features:null,selectedFeature:null,initialize:function(name,location){OpenLayers.Layer.Markers.prototype.initialize.apply(this,[name]);this.location=location;this.features=new Array();OpenLayers.loadURL(location,null,this,this.parseData);},destroy:function(){this.clearFeatures();this.features=null;OpenLayers.Layer.Markers.prototype.destroy.apply(this,arguments);},parseData:function(ajaxRequest){var doc=ajaxRequest.responseXML;if(!doc||ajaxRequest.fileType!="XML"){doc=OpenLayers.parseXMLString(ajaxRequest.responseText);}
this.name=null;try{this.name=doc.getElementsByTagNameNS('*','title')[0].firstChild.nodeValue;}
catch(e){this.name=doc.getElementsByTagName('title')[0].firstChild.nodeValue;}
var itemlist=null;try{itemlist=doc.getElementsByTagNameNS('*','item');}
catch(e){itemlist=doc.getElementsByTagName('item');}
if(itemlist.length==0){try{itemlist=doc.getElementsByTagNameNS('*','entry');}
catch(e){itemlist=doc.getElementsByTagName('entry');}}
for(var i=0;i<itemlist.length;i++){var data={};var point=OpenLayers.Util.getNodes(itemlist[i],'georss:point');var lat=OpenLayers.Util.getNodes(itemlist[i],'geo:lat');var lon=OpenLayers.Util.getNodes(itemlist[i],'geo:long');if(point.length>0){var location=point[0].firstChild.nodeValue.split(" ");if(location.length!=2){var location=point[0].firstChild.nodeValue.split(",");}}else if(lat.length>0&&lon.length>0){var location=[parseFloat(lat[0].firstChild.nodeValue),parseFloat(lon[0].firstChild.nodeValue)];}else{continue;}
location=new OpenLayers.LonLat(parseFloat(location[1]),parseFloat(location[0]));var title="Untitled";try{title=OpenLayers.Util.getNodes(itemlist[i],"title")[0].firstChild.nodeValue;}
catch(e){title="Untitled";}
var descr_nodes=null;try{descr_nodes=itemlist[i].getElementsByTagNameNS("*","description");}
catch(e){descr_nodes=itemlist[i].getElementsByTagName("description");}
if(descr_nodes.length==0){try{descr_nodes=itemlist[i].getElementsByTagNameNS("*","summary");}
catch(e){descr_nodes=itemlist[i].getElementsByTagName("summary");}}
var description="No description.";try{description=descr_nodes[0].firstChild.nodeValue;}
catch(e){description="No description.";}
try{var link=OpenLayers.Util.getNodes(itemlist[i],"link")[0].firstChild.nodeValue;}
catch(e){try{var link=OpenLayers.Util.getNodes(itemlist[i],"link")[0].getAttribute("href");}
catch(e){}}
data.icon=OpenLayers.Marker.defaultIcon();data.popupSize=new OpenLayers.Size(250,120);if((title!=null)&&(description!=null)){contentHTML='<div class="olLayerGeoRSSClose">[x]</div>';contentHTML+='<div class="olLayerGeoRSSTitle">';if(link)contentHTML+='<a class="link" href="'+link+'" target="_blank">';contentHTML+=title;if(link)contentHTML+='</a>';contentHTML+='</div>';contentHTML+='<div style="" class="olLayerGeoRSSDescription">';contentHTML+=description;contentHTML+='</div>';data['popupContentHTML']=contentHTML;}
var feature=new OpenLayers.Feature(this,location,data);this.features.push(feature);var marker=feature.createMarker();marker.events.register('click',feature,this.markerClick);this.addMarker(marker);}},markerClick:function(evt){sameMarkerClicked=(this==this.layer.selectedFeature);this.layer.selectedFeature=(!sameMarkerClicked)?this:null;for(var i=0;i<this.layer.map.popups.length;i++){this.layer.map.removePopup(this.layer.map.popups[i]);}
if(!sameMarkerClicked){var popup=this.createPopup();OpenLayers.Event.observe(popup.div,"click",function(){for(var i=0;i<this.layer.map.popups.length;i++){this.layer.map.removePopup(this.layer.map.popups[i]);}}.bindAsEventListener(this));this.layer.map.addPopup(popup);}
OpenLayers.Event.stop(evt);},clearFeatures:function(){if(this.features!=null){while(this.features.length>0){var feature=this.features[0];OpenLayers.Util.removeItem(this.features,feature);feature.destroy();}}},CLASS_NAME:"OpenLayers.Layer.GeoRSS"});OpenLayers.Layer.Google=OpenLayers.Class.create();OpenLayers.Layer.Google.prototype=OpenLayers.Class.inherit(OpenLayers.Layer.EventPane,OpenLayers.Layer.FixedZoomLevels,{MIN_ZOOM_LEVEL:0,MAX_ZOOM_LEVEL:19,RESOLUTIONS:[1.40625,0.703125,0.3515625,0.17578125,0.087890625,0.0439453125,0.02197265625,0.010986328125,0.0054931640625,0.00274658203125,0.001373291015625,0.0006866455078125,0.00034332275390625,0.000171661376953125,0.0000858306884765625,0.00004291534423828125,.00002145767211914062,.00001072883605957031,.00000536441802978515,.00000268220901489257],type:null,initialize:function(name,options){OpenLayers.Layer.EventPane.prototype.initialize.apply(this,arguments);OpenLayers.Layer.FixedZoomLevels.prototype.initialize.apply(this,arguments);this.addContainerPxFunction();},loadMapObject:function(){try{this.mapObject=new GMap2(this.div);var poweredBy=this.div.lastChild;this.div.removeChild(poweredBy);this.pane.appendChild(poweredBy);poweredBy.className="olLayerGooglePoweredBy gmnoprint";poweredBy.style.left="";poweredBy.style.bottom="";var termsOfUse=this.div.lastChild;this.div.removeChild(termsOfUse);this.pane.appendChild(termsOfUse);termsOfUse.className="olLayerGoogleCopyright";termsOfUse.style.right="";termsOfUse.style.bottom="";}catch(e){}},setMap:function(map){OpenLayers.Layer.EventPane.prototype.setMap.apply(this,arguments);if(this.type!=null){this.map.events.register("moveend",this,this.setMapType);}},setMapType:function(){if(this.mapObject.getCenter()!=null){this.mapObject.setMapType(this.type);this.map.events.unregister("moveend",this,this.setMapType);}},onMapResize:function(){this.mapObject.checkResize();},getOLBoundsFromMapObjectBounds:function(moBounds){var olBounds=null;if(moBounds!=null){var sw=moBounds.getSouthWest();var ne=moBounds.getNorthEast();olBounds=new OpenLayers.Bounds(sw.lng(),sw.lat(),ne.lng(),ne.lat());}
return olBounds;},getMapObjectBoundsFromOLBounds:function(olBounds){var moBounds=null;if(olBounds!=null){var sw=new GLatLng(olBounds.bottom,olBounds.left);var ne=new GLatLng(olBounds.top,olBounds.right);moBounds=new GLatLngBounds(sw,ne);}
return moBounds;},addContainerPxFunction:function(){if(typeof GMap2!="undefined"&&!GMap2.fromLatLngToContainerPixel){GMap2.prototype.fromLatLngToContainerPixel=function(gLatLng){var gPoint=this.fromLatLngToDivPixel(gLatLng);var div=this.b.firstChild.firstChild;gPoint.x+=div.offsetLeft;gPoint.y+=div.offsetTop;return gPoint;};}},getWarningHTML:function(){var html="";html+="The Google Layer was unable to load correctly.<br>";html+="<br>";html+="To get rid of this message, select a new BaseLayer "
html+="in the layer switcher in the upper-right corner.<br>";html+="<br>";html+="Most likely, this is because the Google Maps library";html+=" script was either not included, or does not contain the";html+=" correct API key for your site.<br>";html+="<br>";html+="Developers: For help getting this working correctly, ";html+="<a href='http://trac.openlayers.org/wiki/Google' "
html+="target='_blank'>";html+="click here";html+="</a>";return html;},setMapObjectCenter:function(center,zoom){this.mapObject.setCenter(center,zoom);},getMapObjectCenter:function(){return this.mapObject.getCenter();},getMapObjectZoom:function(){return this.mapObject.getZoom();},getMapObjectLonLatFromMapObjectPixel:function(moPixel){return this.mapObject.fromContainerPixelToLatLng(moPixel);},getMapObjectPixelFromMapObjectLonLat:function(moLonLat){return this.mapObject.fromLatLngToContainerPixel(moLonLat);},getMapObjectZoomFromMapObjectBounds:function(moBounds){return this.mapObject.getBoundsZoomLevel(moBounds);},getLongitudeFromMapObjectLonLat:function(moLonLat){return moLonLat.lng();},getLatitudeFromMapObjectLonLat:function(moLonLat){return moLonLat.lat();},getMapObjectLonLatFromLonLat:function(lon,lat){return new GLatLng(lat,lon);},getXFromMapObjectPixel:function(moPixel){return moPixel.x;},getYFromMapObjectPixel:function(moPixel){return moPixel.y;},getMapObjectPixelFromXY:function(x,y){return new GPoint(x,y);},CLASS_NAME:"OpenLayers.Layer.Google"});OpenLayers.Layer.Grid=OpenLayers.Class.create();OpenLayers.Layer.Grid.prototype=OpenLayers.Class.inherit(OpenLayers.Layer.HTTPRequest,{tileSize:null,grid:null,buffer:2,initialize:function(name,url,params,options){OpenLayers.Layer.HTTPRequest.prototype.initialize.apply(this,arguments);this.grid=new Array();},destroy:function(){this.clearGrid();this.grid=null;this.tileSize=null;OpenLayers.Layer.HTTPRequest.prototype.destroy.apply(this,arguments);},clearGrid:function(){if(this.grid){for(var iRow=0;iRow<this.grid.length;iRow++){var row=this.grid[iRow];for(var iCol=0;iCol<row.length;iCol++){row[iCol].destroy();}}
this.grid=[];}},clone:function(obj){if(obj==null){obj=new OpenLayers.Layer.Grid(this.name,this.url,this.params,this.options);}
obj=OpenLayers.Layer.HTTPRequest.prototype.clone.apply(this,[obj]);if(this.tileSize!=null){obj.tileSize=this.tileSize.clone();}
obj.grid=new Array();return obj;},setMap:function(map){OpenLayers.Layer.HTTPRequest.prototype.setMap.apply(this,arguments);if(this.tileSize==null){this.tileSize=this.map.getTileSize();}},moveTo:function(bounds,zoomChanged,dragging){OpenLayers.Layer.HTTPRequest.prototype.moveTo.apply(this,arguments);if(bounds==null){bounds=this.map.getExtent();}
if(bounds!=null){if(!this.grid.length||zoomChanged||!this.getGridBounds().containsBounds(bounds,true)){this._initTiles();}else{var buffer=(this.buffer)?this.buffer*1.5:1;while(true){var tlLayer=this.grid[0][0].position;var tlViewPort=this.map.getViewPortPxFromLayerPx(tlLayer);if(tlViewPort.x>-this.tileSize.w*(buffer-1)){this.shiftColumn(true);}else if(tlViewPort.x<-this.tileSize.w*buffer){this.shiftColumn(false);}else if(tlViewPort.y>-this.tileSize.h*(buffer-1)){this.shiftRow(true);}else if(tlViewPort.y<-this.tileSize.h*buffer){this.shiftRow(false);}else{break;}};if(this.buffer==0){for(var r=0,rl=this.grid.length;r<rl;r++){var row=this.grid[r];for(var c=0,cl=row.length;c<cl;c++){var tile=row[c];if(!tile.drawn&&tile.bounds.intersectsBounds(bounds,false)){tile.draw();}}}}}}},getGridBounds:function(){var bottom=this.grid.length-1;var bottomLeftTile=this.grid[bottom][0];var right=this.grid[0].length-1;var topRightTile=this.grid[0][right];return new OpenLayers.Bounds(bottomLeftTile.bounds.left,bottomLeftTile.bounds.bottom,topRightTile.bounds.right,topRightTile.bounds.top);},_initTiles:function(){var viewSize=this.map.getSize();var minRows=Math.ceil(viewSize.h/this.tileSize.h)+1;var minCols=Math.ceil(viewSize.w/this.tileSize.w)+1;var bounds=this.map.getExtent();var extent=this.map.getMaxExtent();var resolution=this.map.getResolution();var tilelon=resolution*this.tileSize.w;var tilelat=resolution*this.tileSize.h;var offsetlon=bounds.left-extent.left;var tilecol=Math.floor(offsetlon/tilelon)-this.buffer;var tilecolremain=offsetlon/tilelon-tilecol;var tileoffsetx=-tilecolremain*this.tileSize.w;var tileoffsetlon=extent.left+tilecol*tilelon;var offsetlat=bounds.top-(extent.bottom+tilelat);var tilerow=Math.ceil(offsetlat/tilelat)+this.buffer;var tilerowremain=tilerow-offsetlat/tilelat;var tileoffsety=-tilerowremain*this.tileSize.h;var tileoffsetlat=extent.bottom+tilerow*tilelat;tileoffsetx=Math.round(tileoffsetx);tileoffsety=Math.round(tileoffsety);this.origin=new OpenLayers.Pixel(tileoffsetx,tileoffsety);var startX=tileoffsetx;var startLon=tileoffsetlon;var rowidx=0;do{var row=this.grid[rowidx++];if(!row){row=new Array();this.grid.push(row);}
tileoffsetlon=startLon;tileoffsetx=startX;var colidx=0;do{var tileBounds=new OpenLayers.Bounds(tileoffsetlon,tileoffsetlat,tileoffsetlon+tilelon,tileoffsetlat+tilelat);var x=tileoffsetx;x-=parseInt(this.map.layerContainerDiv.style.left);var y=tileoffsety;y-=parseInt(this.map.layerContainerDiv.style.top);var px=new OpenLayers.Pixel(x,y);var tile=row[colidx++];if(!tile){tile=this.addTile(tileBounds,px);row.push(tile);}else{tile.moveTo(tileBounds,px,false);}
tileoffsetlon+=tilelon;tileoffsetx+=this.tileSize.w;}while((tileoffsetlon<=bounds.right+tilelon*this.buffer)||colidx<minCols)
tileoffsetlat-=tilelat;tileoffsety+=this.tileSize.h;}while((tileoffsetlat>=bounds.bottom-tilelat*this.buffer)||rowidx<minRows)
while(this.grid.length>rowidx){var row=this.grid.pop();for(var i=0,l=row.length;i<l;i++){row[i].destroy();}}
while(this.grid[0].length>colidx){for(var i=0,l=this.grid.length;i<l;i++){var row=this.grid[i];var tile=row.pop();tile.destroy();}}
this.spiralTileLoad();},spiralTileLoad:function(){var tileQueue=new Array();var directions=["right","down","left","up"];var iRow=0;var iCell=-1;var direction=OpenLayers.Util.indexOf(directions,"right");var directionsTried=0;while(directionsTried<directions.length){var testRow=iRow;var testCell=iCell;switch(directions[direction]){case"right":testCell++;break;case"down":testRow++;break;case"left":testCell--;break;case"up":testRow--;break;}
var tile=null;if((testRow<this.grid.length)&&(testRow>=0)&&(testCell<this.grid[0].length)&&(testCell>=0)){tile=this.grid[testRow][testCell];}
if((tile!=null)&&(!tile.queued)){tileQueue.unshift(tile);tile.queued=true;directionsTried=0;iRow=testRow;iCell=testCell;}else{direction=(direction+1)%4;directionsTried++;}}
for(var i=0;i<tileQueue.length;i++){var tile=tileQueue[i]
tile.draw();tile.queued=false;}},addTile:function(bounds,position){},mergeNewParams:function(newArguments){OpenLayers.Layer.HTTPRequest.prototype.mergeNewParams.apply(this,[newArguments]);if(this.map!=null){this._initTiles();}},shiftRow:function(prepend){var modelRowIndex=(prepend)?0:(this.grid.length-1);var modelRow=this.grid[modelRowIndex];var resolution=this.map.getResolution();var deltaY=(prepend)?-this.tileSize.h:this.tileSize.h;var deltaLat=resolution*-deltaY;var row=(prepend)?this.grid.pop():this.grid.shift();for(var i=0;i<modelRow.length;i++){var modelTile=modelRow[i];var bounds=modelTile.bounds.clone();var position=modelTile.position.clone();bounds.bottom=bounds.bottom+deltaLat;bounds.top=bounds.top+deltaLat;position.y=position.y+deltaY;row[i].moveTo(bounds,position);}
if(prepend){this.grid.unshift(row);}else{this.grid.push(row);}},shiftColumn:function(prepend){var deltaX=(prepend)?-this.tileSize.w:this.tileSize.w;var resolution=this.map.getResolution();var deltaLon=resolution*deltaX;for(var i=0;i<this.grid.length;i++){var row=this.grid[i];var modelTileIndex=(prepend)?0:(row.length-1);var modelTile=row[modelTileIndex];var bounds=modelTile.bounds.clone();var position=modelTile.position.clone();bounds.left=bounds.left+deltaLon;bounds.right=bounds.right+deltaLon;position.x=position.x+deltaX;var tile=prepend?this.grid[i].pop():this.grid[i].shift()
tile.moveTo(bounds,position);if(prepend){this.grid[i].unshift(tile);}else{this.grid[i].push(tile);}}},CLASS_NAME:"OpenLayers.Layer.Grid"});OpenLayers.Layer.MultiMap=OpenLayers.Class.create();OpenLayers.Layer.MultiMap.prototype=OpenLayers.Class.inherit(OpenLayers.Layer.EventPane,OpenLayers.Layer.FixedZoomLevels,{MIN_ZOOM_LEVEL:1,MAX_ZOOM_LEVEL:17,RESOLUTIONS:[9,1.40625,0.703125,0.3515625,0.17578125,0.087890625,0.0439453125,0.02197265625,0.010986328125,0.0054931640625,0.00274658203125,0.001373291015625,0.0006866455078125,0.00034332275390625,0.000171661376953125,0.0000858306884765625,0.00004291534423828125],type:null,initialize:function(name,options){OpenLayers.Layer.EventPane.prototype.initialize.apply(this,arguments);OpenLayers.Layer.FixedZoomLevels.prototype.initialize.apply(this,arguments);},loadMapObject:function(){try{this.mapObject=new MultimapViewer(this.div);}catch(e){}},getWarningHTML:function(){var html="";html+="The MM Layer was unable to load correctly.<br>";html+="<br>";html+="To get rid of this message, select a new BaseLayer "
html+="in the layer switcher in the upper-right corner.<br>";html+="<br>";html+="Most likely, this is because the MM library";html+=" script was either not correctly included.<br>";html+="<br>";html+="Demmlopers: For help getting this working correctly, ";html+="<a href='http://trac.openlayers.org/wiki/MultiMap' "
html+="target='_blank'>";html+="click here";html+="</a>";return html;},setMapObjectCenter:function(center,zoom){this.mapObject.goToPosition(center,zoom);},getMapObjectCenter:function(){return this.mapObject.getCurrentPosition();},getMapObjectZoom:function(){return this.mapObject.getZoomFactor();},getMapObjectLonLatFromMapObjectPixel:function(moPixel){moPixel.x=moPixel.x-(this.map.getSize().w/2);moPixel.y=moPixel.y-(this.map.getSize().h/2);return this.mapObject.getMapPositionAt(moPixel);},getMapObjectPixelFromMapObjectLonLat:function(moLonLat){return this.mapObject.geoPosToContainerPixels(moLonLat);},getLongitudeFromMapObjectLonLat:function(moLonLat){return moLonLat.lon;},getLatitudeFromMapObjectLonLat:function(moLonLat){return moLonLat.lat;},getMapObjectLonLatFromLonLat:function(lon,lat){return new MMLatLon(lat,lon);},getXFromMapObjectPixel:function(moPixel){return moPixel.x;},getYFromMapObjectPixel:function(moPixel){return moPixel.y;},getMapObjectPixelFromXY:function(x,y){return new MMPoint(x,y);},CLASS_NAME:"OpenLayers.Layer.MultiMap"});OpenLayers.Layer.Text=OpenLayers.Class.create();OpenLayers.Layer.Text.prototype=OpenLayers.Class.inherit(OpenLayers.Layer.Markers,{location:null,features:null,selectedFeature:null,initialize:function(name,options){OpenLayers.Layer.Markers.prototype.initialize.apply(this,arguments);this.features=new Array();if(this.location!=null){OpenLayers.loadURL(this.location,null,this,this.parseData);}},destroy:function(){this.clearFeatures();this.features=null;OpenLayers.Layer.Markers.prototype.destroy.apply(this,arguments);},parseData:function(ajaxRequest){var text=ajaxRequest.responseText;var lines=text.split('\n');var columns;for(var lcv=0;lcv<(lines.length-1);lcv++){var currLine=lines[lcv].replace(/^\s*/,'').replace(/\s*$/,'');if(currLine.charAt(0)!='#'){if(!columns){columns=currLine.split('\t');}else{var vals=currLine.split('\t');var location=new OpenLayers.LonLat(0,0);var title;var url;var icon,iconSize,iconOffset;var set=false;for(var valIndex=0;valIndex<vals.length;valIndex++){if(vals[valIndex]){if(columns[valIndex]=='point'){var coords=vals[valIndex].split(',');location.lat=parseFloat(coords[0]);location.lon=parseFloat(coords[1]);set=true;}else if(columns[valIndex]=='lat'){location.lat=parseFloat(vals[valIndex]);set=true;}else if(columns[valIndex]=='lon'){location.lon=parseFloat(vals[valIndex]);set=true;}else if(columns[valIndex]=='title')
title=vals[valIndex];else if(columns[valIndex]=='image'||columns[valIndex]=='icon')
url=vals[valIndex];else if(columns[valIndex]=='iconSize'){var size=vals[valIndex].split(',');iconSize=new OpenLayers.Size(parseFloat(size[0]),parseFloat(size[1]));}else if(columns[valIndex]=='iconOffset'){var offset=vals[valIndex].split(',');iconOffset=new OpenLayers.Pixel(parseFloat(offset[0]),parseFloat(offset[1]));}else if(columns[valIndex]=='title'){title=vals[valIndex];}else if(columns[valIndex]=='description'){description=vals[valIndex];}}}
if(set){var data=new Object();if(url!=null){data.icon=new OpenLayers.Icon(url,iconSize,iconOffset);}else{data.icon=OpenLayers.Marker.defaultIcon();if(iconSize!=null){data.icon.setSize(iconSize);}}
if((title!=null)&&(description!=null)){data['popupContentHTML']='<h2>'+title+'</h2><p>'+description+'</p>';}
var feature=new OpenLayers.Feature(this,location,data);this.features.push(feature);var marker=feature.createMarker();if((title!=null)&&(description!=null)){marker.events.register('click',feature,this.markerClick);}
this.addMarker(marker);}}}}},markerClick:function(evt){sameMarkerClicked=(this==this.layer.selectedFeature);this.layer.selectedFeature=(!sameMarkerClicked)?this:null;for(var i=0;i<this.layer.map.popups.length;i++){this.layer.map.removePopup(this.layer.map.popups[i]);}
if(!sameMarkerClicked){this.layer.map.addPopup(this.createPopup());}
OpenLayers.Event.stop(evt);},clearFeatures:function(){if(this.features!=null){while(this.features.length>0){var feature=this.features[0];OpenLayers.Util.removeItem(this.features,feature);feature.destroy();}}},CLASS_NAME:"OpenLayers.Layer.Text"});OpenLayers.Layer.Vector=OpenLayers.Class.create();OpenLayers.Layer.Vector.prototype=OpenLayers.Class.inherit(OpenLayers.Layer,{isBaseLayer:false,isFixed:false,isVector:true,features:null,selectedFeatures:null,reportError:true,style:null,renderers:['SVG','VML'],renderer:null,geometryType:null,drawn:false,initialize:function(name,options){var defaultStyle=OpenLayers.Feature.Vector.style['default'];this.style=OpenLayers.Util.extend({},defaultStyle);OpenLayers.Layer.prototype.initialize.apply(this,arguments);if(!this.renderer||!this.renderer.supported()){this.assignRenderer();}
if(!this.renderer||!this.renderer.supported()){this.renderer=null;this.displayError();}
this.features=new Array();this.selectedFeatures=new Array();},destroy:function(){OpenLayers.Layer.prototype.destroy.apply(this,arguments);this.features=null;this.selectedFeatures=null;if(this.renderer){this.renderer.destroy();}
this.renderer=null;this.geometryType=null;this.drawn=null;},assignRenderer:function(){for(var i=0;i<this.renderers.length;i++){var rendererClass=OpenLayers.Renderer[this.renderers[i]];if(rendererClass&&rendererClass.prototype.supported()){this.renderer=new rendererClass(this.div);break;}}},displayError:function(){if(this.reportError){var message="Your browser does not support vector rendering. "+"Currently supported renderers are:\n";message+=this.renderers.join("\n");alert(message);}},setMap:function(map){OpenLayers.Layer.prototype.setMap.apply(this,arguments);if(!this.renderer){this.map.removeLayer(this);}else{this.renderer.map=this.map;this.renderer.setSize(this.map.getSize());}},onMapResize:function(){OpenLayers.Layer.prototype.onMapResize.apply(this,arguments);this.renderer.setSize(this.map.getSize());},moveTo:function(bounds,zoomChanged,dragging){OpenLayers.Layer.prototype.moveTo.apply(this,arguments);if(!dragging){this.div.style.left=-parseInt(this.map.layerContainerDiv.style.left)+"px";this.div.style.top=-parseInt(this.map.layerContainerDiv.style.top)+"px";var extent=this.map.getExtent();this.renderer.setExtent(extent);}
if(!this.drawn||zoomChanged){this.drawn=true;for(var i=0;i<this.features.length;i++){var feature=this.features[i];this.drawFeature(feature);}}},addFeatures:function(features){if(!(features instanceof Array)){features=[features];}
for(var i=0;i<features.length;i++){var feature=features[i];if(this.geometryType&&!(feature.geometry instanceof this.geometryType)){var throwStr="addFeatures : component should be an "+
this.geometryType.prototype.CLASS_NAME;throw throwStr;}
this.features.push(feature);feature.layer=this;if(!feature.style){feature.style=OpenLayers.Util.extend({},this.style);}
this.preFeatureInsert(feature);if(this.drawn){this.drawFeature(feature);}
this.onFeatureInsert(feature);}},removeFeatures:function(features){if(!(features instanceof Array)){features=[features];}
for(var i=features.length-1;i>=0;i--){var feature=features[i];this.features=OpenLayers.Util.removeItem(this.features,feature);this.renderer.eraseGeometry(feature.geometry);if(OpenLayers.Util.indexOf(this.selectedFeatures,feature)!=-1){OpenLayers.Util.removeItem(this.selectedFeatures,feature);}}},destroyFeatures:function(){this.selectedFeatures=new Array();for(var i=this.features.length-1;i>=0;i--){this.features[i].destroy();}},drawFeature:function(feature,style){if(style==null){if(feature.style){style=feature.style;}else{style=this.style;}}
this.renderer.drawFeature(feature,style);},eraseFeatures:function(features){this.renderer.eraseFeatures(features);},getFeatureFromEvent:function(evt){var featureId=this.renderer.getFeatureIdFromEvent(evt);return this.getFeatureById(featureId);},getFeatureById:function(featureId){var feature=null;for(var i=0;i<this.features.length;++i){if(this.features[i].id==featureId){feature=this.features[i];break;}}
return feature;},onFeatureInsert:function(feature){},preFeatureInsert:function(feature){},CLASS_NAME:"OpenLayers.Layer.Vector"});OpenLayers.Layer.VirtualEarth=OpenLayers.Class.create();OpenLayers.Layer.VirtualEarth.prototype=OpenLayers.Class.inherit(OpenLayers.Layer.EventPane,OpenLayers.Layer.FixedZoomLevels,{MIN_ZOOM_LEVEL:1,MAX_ZOOM_LEVEL:17,RESOLUTIONS:[1.40625,0.703125,0.3515625,0.17578125,0.087890625,0.0439453125,0.02197265625,0.010986328125,0.0054931640625,0.00274658203125,0.001373291015625,0.0006866455078125,0.00034332275390625,0.000171661376953125,0.0000858306884765625,0.00004291534423828125],type:null,initialize:function(name,options){OpenLayers.Layer.EventPane.prototype.initialize.apply(this,arguments);OpenLayers.Layer.FixedZoomLevels.prototype.initialize.apply(this,arguments);},loadMapObject:function(){var veDiv=OpenLayers.Util.createDiv(this.name);var sz=this.map.getSize();veDiv.style.width=sz.w;veDiv.style.height=sz.h;this.div.appendChild(veDiv);try{this.mapObject=new VEMap(this.name);}catch(e){}
if(this.mapObject!=null){try{this.mapObject.LoadMap(null,null,this.type);}catch(e){}
this.mapObject.HideDashboard();}},getWarningHTML:function(){var html="";html+="The VE Layer was unable to load correctly.<br>";html+="<br>";html+="To get rid of this message, select a new BaseLayer "
html+="in the layer switcher in the upper-right corner.<br>";html+="<br>";html+="Most likely, this is because the VE library";html+=" script was either not correctly included.<br>";html+="<br>";html+="Developers: For help getting this working correctly, ";html+="<a href='http://trac.openlayers.org/wiki/VirtualEarth' "
html+="target='_blank'>";html+="click here";html+="</a>";return html;},setMapObjectCenter:function(center,zoom){this.mapObject.SetCenterAndZoom(center,zoom);},getMapObjectCenter:function(){return this.mapObject.GetCenter();},getMapObjectZoom:function(){return this.mapObject.GetZoomLevel();},getMapObjectLonLatFromMapObjectPixel:function(moPixel){return this.mapObject.PixelToLatLong(moPixel.x,moPixel.y);},getMapObjectPixelFromMapObjectLonLat:function(moLonLat){return this.mapObject.LatLongToPixel(moLonLat);},getLongitudeFromMapObjectLonLat:function(moLonLat){return moLonLat.Longitude;},getLatitudeFromMapObjectLonLat:function(moLonLat){return moLonLat.Latitude;},getMapObjectLonLatFromLonLat:function(lon,lat){return new VELatLong(lat,lon);},getXFromMapObjectPixel:function(moPixel){return moPixel.x;},getYFromMapObjectPixel:function(moPixel){return moPixel.y;},getMapObjectPixelFromXY:function(x,y){return new Msn.VE.Pixel(x,y);},CLASS_NAME:"OpenLayers.Layer.VirtualEarth"});OpenLayers.Layer.Yahoo=OpenLayers.Class.create();OpenLayers.Layer.Yahoo.prototype=OpenLayers.Class.inherit(OpenLayers.Layer.EventPane,OpenLayers.Layer.FixedZoomLevels,{MIN_ZOOM_LEVEL:0,MAX_ZOOM_LEVEL:15,RESOLUTIONS:[1.40625,0.703125,0.3515625,0.17578125,0.087890625,0.0439453125,0.02197265625,0.010986328125,0.0054931640625,0.00274658203125,0.001373291015625,0.0006866455078125,0.00034332275390625,0.000171661376953125,0.0000858306884765625,0.00004291534423828125],type:null,initialize:function(name,options){OpenLayers.Layer.EventPane.prototype.initialize.apply(this,arguments);OpenLayers.Layer.FixedZoomLevels.prototype.initialize.apply(this,arguments);},loadMapObject:function(){try{this.mapObject=new YMap(this.div,this.type);}catch(e){}},setMap:function(map){OpenLayers.Layer.EventPane.prototype.setMap.apply(this,arguments);this.map.events.register("moveend",this,this.fixYahooEventPane);},fixYahooEventPane:function(){var yahooEventPane=OpenLayers.Util.getElement("ygddfdiv");if(yahooEventPane!=null){if(yahooEventPane.parentNode!=null)
yahooEventPane.parentNode.removeChild(yahooEventPane);this.map.events.unregister("moveend",this,this.fixYahooEventPane);}},getWarningHTML:function(){var html="";html+="The Yahoo Layer was unable to load correctly.<br>";html+="<br>";html+="To get rid of this message, select a new BaseLayer "
html+="in the layer switcher in the upper-right corner.<br>";html+="<br>";html+="Most likely, this is because the Yahoo library";html+=" script was either not correctly included.<br>";html+="<br>";html+="Developers: For help getting this working correctly, ";html+="<a href='http://trac.openlayers.org/wiki/Yahoo' "
html+="target='_blank'>";html+="click here";html+="</a>";return html;},getOLZoomFromMapObjectZoom:function(moZoom){var zoom=null;if(moZoom!=null){zoom=OpenLayers.Layer.FixedZoomLevels.prototype.getOLZoomFromMapObjectZoom.apply(this,[moZoom]);zoom=18-zoom;}
return zoom;},getMapObjectZoomFromOLZoom:function(olZoom){var zoom=null;if(olZoom!=null){zoom=OpenLayers.Layer.FixedZoomLevels.prototype.getMapObjectZoomFromOLZoom.apply(this,[olZoom]);zoom=18-zoom;}
return zoom;},setMapObjectCenter:function(center,zoom){this.mapObject.drawZoomAndCenter(center,zoom);},getMapObjectCenter:function(){return this.mapObject.getCenterLatLon();},getMapObjectZoom:function(){return this.mapObject.getZoomLevel();},getMapObjectLonLatFromMapObjectPixel:function(moPixel){return this.mapObject.convertXYLatLon(moPixel);},getMapObjectPixelFromMapObjectLonLat:function(moLonLat){return this.mapObject.convertLatLonXY(moLonLat);},getLongitudeFromMapObjectLonLat:function(moLonLat){return moLonLat.Lon;},getLatitudeFromMapObjectLonLat:function(moLonLat){return moLonLat.Lat;},getMapObjectLonLatFromLonLat:function(lon,lat){return new YGeoPoint(lat,lon);},getXFromMapObjectPixel:function(moPixel){return moPixel.x;},getYFromMapObjectPixel:function(moPixel){return moPixel.y;},getMapObjectPixelFromXY:function(x,y){return new YCoordPoint(x,y);},CLASS_NAME:"OpenLayers.Layer.Yahoo"});OpenLayers.Control.EditingToolbar=OpenLayers.Class.create();OpenLayers.Control.EditingToolbar.prototype=OpenLayers.Class.inherit(OpenLayers.Control.Panel,{initialize:function(layer,options){OpenLayers.Control.Panel.prototype.initialize.apply(this,[options]);this.addControls([new OpenLayers.Control.Navigation()]);var controls=[new OpenLayers.Control.DrawFeature(layer,OpenLayers.Handler.Point,{'displayClass':'olControlDrawFeaturePoint'}),new OpenLayers.Control.DrawFeature(layer,OpenLayers.Handler.Path,{'displayClass':'olControlDrawFeaturePath'}),new OpenLayers.Control.DrawFeature(layer,OpenLayers.Handler.Polygon,{'displayClass':'olControlDrawFeaturePolygon'})];for(var i=0;i<controls.length;i++){controls[i].featureAdded=function(feature){feature.state=OpenLayers.State.INSERT;}}
this.addControls(controls);},draw:function(){var div=OpenLayers.Control.Panel.prototype.draw.apply(this,arguments);this.activateControl(this.controls[0]);return div;},CLASS_NAME:"OpenLayers.Control.EditingToolbar"});OpenLayers.Format.WFS=OpenLayers.Class.create();OpenLayers.Format.WFS.prototype=OpenLayers.Class.inherit(OpenLayers.Format.GML,{layer:null,wfsns:"http://www.opengis.net/wfs",initialize:function(options,layer){OpenLayers.Format.GML.prototype.initialize.apply(this,[options]);this.layer=layer;if(this.layer.featureNS){this.featureNS=this.layer.featureNS;}
if(this.layer.options.geometry_column){this.geometryName=this.layer.options.geometry_column;}
if(this.layer.options.typename){this.featureName=this.layer.options.typename;}},write:function(features){var transaction=document.createElementNS('http://www.opengis.net/wfs','wfs:Transaction');for(var i=0;i<features.length;i++){switch(features[i].state){case OpenLayers.State.INSERT:transaction.appendChild(this.insert(features[i]));break;case OpenLayers.State.UPDATE:transaction.appendChild(this.update(features[i]));break;case OpenLayers.State.DELETE:transaction.appendChild(this.remove(features[i]));break;}}
return transaction;},createFeatureXML:function(feature){var geometryNode=this.buildGeometryNode(feature.geometry);var geomContainer=document.createElementNS(this.featureNS,"feature:"+this.geometryName);geomContainer.appendChild(geometryNode);var featureContainer=document.createElementNS(this.featureNS,"feature:"+this.featureName);featureContainer.appendChild(geomContainer);for(var attr in feature.attributes){var attrText=document.createTextNode(feature.attributes[attr]);var nodename=attr;if(attr.search(":")!=-1){nodename=attr.split(":")[1];}
var attrContainer=document.createElementNS(this.featureNS,"feature:"+nodename);attrContainer.appendChild(attrText);featureContainer.appendChild(attrContainer);}
return featureContainer;},insert:function(feature){var insertNode=document.createElementNS(this.wfsns,'wfs:Insert');insertNode.appendChild(this.createFeatureXML(feature));return insertNode;},update:function(feature){if(!feature.fid){alert("Can't update a feature for which there is no FID.");}
var updateNode=document.createElementNS(this.wfsns,'wfs:Update');updateNode.setAttribute("typeName",this.layerName);var propertyNode=document.createElementNS(this.wfsns,'wfs:Property');var nameNode=document.createElementNS('http://www.opengis.net/wfs','wfs:Name');var txtNode=document.createTextNode(this.geometryName);nameNode.appendChild(txtNode);propertyNode.appendChild(nameNode);var valueNode=document.createElementNS('http://www.opengis.net/wfs','wfs:Value');valueNode.appendChild(this.buildGeometryNode(feature.geometry));propertyNode.appendChild(valueNode);updateNode.appendChild(propertyNode);var filterNode=document.createElementNS('http://www.opengis.net/ogc','ogc:Filter');var filterIdNode=document.createElementNS('http://www.opengis.net/ogc','ogc:FeatureId');filterIdNode.setAttribute("fid",feature.fid);filterNode.appendChild(filterIdNode);updateNode.appendChild(filterNode);return updateNode;},remove:function(feature){if(!feature.attributes.fid){alert("Can't update a feature for which there is no FID.");return false;}
var deleteNode=document.createElementNS(this.featureNS,'wfs:Delete');deleteNode.setAttribute("typeName",this.layerName);var filterNode=document.createElementNS('http://www.opengis.net/ogc','ogc:Filter');var filterIdNode=document.createElementNS('http://www.opengis.net/ogc','ogc:FeatureId');filterIdNode.setAttribute("fid",feature.attributes.fid);filterNode.appendChild(filterIdNode);deleteNode.appendChild(filterNode);return deleteNode;},destroy:function(){this.layer=null;},CLASS_NAME:"OpenLayers.Format.WFS"});OpenLayers.Geometry.Curve=OpenLayers.Class.create();OpenLayers.Geometry.Curve.prototype=OpenLayers.Class.inherit(OpenLayers.Geometry.MultiPoint,{componentTypes:["OpenLayers.Geometry.Point"],initialize:function(points){OpenLayers.Geometry.MultiPoint.prototype.initialize.apply(this,arguments);},getLength:function(){var length=0.0;if(this.components&&(this.components.length>1)){for(var i=1;i<this.components.length;i++){length+=this.components[i-1].distanceTo(this.components[i]);}}
return length;},CLASS_NAME:"OpenLayers.Geometry.Curve"});OpenLayers.Layer.GML=OpenLayers.Class.create();OpenLayers.Layer.GML.prototype=OpenLayers.Class.inherit(OpenLayers.Layer.Vector,{loaded:false,format:null,initialize:function(name,url,options){var newArguments=new Array()
newArguments.push(name,options);OpenLayers.Layer.Vector.prototype.initialize.apply(this,newArguments);this.url=url;},setVisibility:function(visibility,noEvent){OpenLayers.Layer.Vector.prototype.setVisibility.apply(this,arguments);if(this.visibility&&!this.loaded){this.loadGML();}},moveTo:function(bounds,zoomChanged,minor){OpenLayers.Layer.Vector.prototype.moveTo.apply(this,arguments);if(this.visibility&&!this.loaded){this.loadGML();}},loadGML:function(){if(!this.loaded){var results=OpenLayers.loadURL(this.url,null,this,this.requestSuccess,this.requestFailure);this.loaded=true;}},requestSuccess:function(request){var doc=request.responseXML;if(!doc||request.fileType!="XML"){doc=request.responseText;}
var gml=this.format?new this.format():new OpenLayers.Format.GML();this.addFeatures(gml.read(doc));},requestFailure:function(request){alert("Error in loading GML file "+this.url);},CLASS_NAME:"OpenLayers.Layer.GML"});OpenLayers.Layer.KaMap=OpenLayers.Class.create();OpenLayers.Layer.KaMap.prototype=OpenLayers.Class.inherit(OpenLayers.Layer.Grid,{isBaseLayer:true,units:null,resolution:OpenLayers.DOTS_PER_INCH,DEFAULT_PARAMS:{i:'jpeg',map:''},initialize:function(name,url,params,options){var newArguments=new Array();newArguments.push(name,url,params,options);OpenLayers.Layer.Grid.prototype.initialize.apply(this,newArguments);this.params=(params?params:{});if(params){OpenLayers.Util.applyDefaults(this.params,this.DEFAULT_PARAMS);}},getURL:function(bounds){var mapRes=this.map.getResolution();var scale=Math.round((this.map.getScale()*10000))/10000;var pX=Math.round(bounds.left/mapRes);var pY=-Math.round(bounds.top/mapRes);return this.getFullRequestString({t:pY,l:pX,s:scale});},addTile:function(bounds,position){var url=this.getURL(bounds);return new OpenLayers.Tile.Image(this,position,bounds,url,this.tileSize);},_initTiles:function(){var viewSize=this.map.getSize();var bounds=this.map.getExtent();var extent=this.map.getMaxExtent();var resolution=this.map.getResolution();var tilelon=resolution*this.tileSize.w;var tilelat=resolution*this.tileSize.h;var offsetlon=bounds.left;var tilecol=Math.floor(offsetlon/tilelon);var tilecolremain=offsetlon/tilelon-tilecol;var tileoffsetx=-tilecolremain*this.tileSize.w;var tileoffsetlon=tilecol*tilelon;var offsetlat=bounds.top;var tilerow=Math.ceil(offsetlat/tilelat);var tilerowremain=tilerow-offsetlat/tilelat;var tileoffsety=-(tilerowremain+1)*this.tileSize.h;var tileoffsetlat=tilerow*tilelat;tileoffsetx=Math.round(tileoffsetx);tileoffsety=Math.round(tileoffsety);this.origin=new OpenLayers.Pixel(tileoffsetx,tileoffsety);var startX=tileoffsetx;var startLon=tileoffsetlon;var rowidx=0;do{var row;row=this.grid[rowidx++];if(!row){row=new Array();this.grid.push(row);}
tileoffsetlon=startLon;tileoffsetx=startX;var colidx=0;do{var tileBounds=new OpenLayers.Bounds(tileoffsetlon,tileoffsetlat,tileoffsetlon+tilelon,tileoffsetlat+tilelat);var x=tileoffsetx;x-=parseInt(this.map.layerContainerDiv.style.left);var y=tileoffsety;y-=parseInt(this.map.layerContainerDiv.style.top);var px=new OpenLayers.Pixel(x,y);var tile;tile=row[colidx++];if(!tile){tile=this.addTile(tileBounds,px);row.push(tile);}else{tile.moveTo(tileBounds,px,false);}
tileoffsetlon+=tilelon;tileoffsetx+=this.tileSize.w;}while(tileoffsetlon<=bounds.right+tilelon*this.buffer)
tileoffsetlat-=tilelat;tileoffsety+=this.tileSize.h;}while(tileoffsetlat>=bounds.bottom-tilelat*this.buffer)
this.spiralTileLoad();},clone:function(obj){if(obj==null){obj=new OpenLayers.Layer.KaMap(this.name,this.url,this.params,this.options);}
obj=OpenLayers.Layer.Grid.prototype.clone.apply(this,[obj]);if(this.tileSize!=null){obj.tileSize=this.tileSize.clone();}
obj.grid=new Array();return obj;},CLASS_NAME:"OpenLayers.Layer.KaMap"});OpenLayers.Layer.MapServer=OpenLayers.Class.create();OpenLayers.Layer.MapServer.prototype=OpenLayers.Class.inherit(OpenLayers.Layer.Grid,{DEFAULT_PARAMS:{mode:"map",map_imagetype:"png"},initialize:function(name,url,params,options){var newArguments=new Array();newArguments.push(name,url,params,options);OpenLayers.Layer.Grid.prototype.initialize.apply(this,newArguments);if(arguments.length>0){OpenLayers.Util.applyDefaults(this.params,this.DEFAULT_PARAMS);}
if(options==null||options.isBaseLayer==null){this.isBaseLayer=((this.params.transparent!="true")&&(this.params.transparent!=true));}},clone:function(obj){if(obj==null){obj=new OpenLayers.Layer.MapServer(this.name,this.url,this.params,this.options);}
obj=OpenLayers.Layer.Grid.prototype.clone.apply(this,[obj]);return obj;},addTile:function(bounds,position){var url=this.getURL(bounds);return new OpenLayers.Tile.Image(this,position,bounds,url,this.tileSize);},getURL:function(bounds){if(this.gutter){bounds=this.adjustBoundsByGutter(bounds);}
var extent=[bounds.left,bounds.bottom,bounds.right,bounds.top];var url=this.getFullRequestString({mapext:extent,imgext:extent,map_size:[this.imageSize.w,this.imageSize.h],imgx:this.imageSize.w/2,imgy:this.imageSize.h/2,imgxy:[this.imageSize.w,this.imageSize.h]});return url;},getFullRequestString:function(newParams,altUrl){var url=(altUrl==null)?this.url:altUrl;if(typeof url=="object"){url=url[Math.floor(Math.random()*url.length)];}
var requestString=url;var allParams=OpenLayers.Util.extend(new Object(),this.params);allParams=OpenLayers.Util.extend(allParams,newParams);var urlParams=OpenLayers.Util.upperCaseObject(OpenLayers.Util.getArgs(url));for(var key in allParams){if(key.toUpperCase()in urlParams){delete allParams[key];}}
var paramsString=OpenLayers.Util.getParameterString(allParams);paramsString=paramsString.replace(/,/g,"+");if(paramsString!=""){var lastServerChar=url.charAt(url.length-1);if((lastServerChar=="&")||(lastServerChar=="?")){requestString+=paramsString;}else{if(url.indexOf('?')==-1){requestString+='?'+paramsString;}else{requestString+='&'+paramsString;}}}
return requestString;},CLASS_NAME:"OpenLayers.Layer.MapServer"});OpenLayers.Layer.TMS=OpenLayers.Class.create();OpenLayers.Layer.TMS.prototype=OpenLayers.Class.inherit(OpenLayers.Layer.Grid,{reproject:false,isBaseLayer:true,tileOrigin:null,initialize:function(name,url,options){var newArguments=new Array();newArguments.push(name,url,{},options);OpenLayers.Layer.Grid.prototype.initialize.apply(this,newArguments);},destroy:function(){OpenLayers.Layer.Grid.prototype.destroy.apply(this,arguments);},clone:function(obj){if(obj==null){obj=new OpenLayers.Layer.TMS(this.name,this.url,this.options);}
obj=OpenLayers.Layer.Grid.prototype.clone.apply(this,[obj]);return obj;},getURL:function(bounds){var res=this.map.getResolution();var x=(bounds.left-this.tileOrigin.lon)/(res*this.tileSize.w);var y=(bounds.bottom-this.tileOrigin.lat)/(res*this.tileSize.h);var z=this.map.getZoom();var path="1.0.0"+"/"+this.layername+"/"+z+"/"+x+"/"+y+"."+this.type;var url=this.url;if(url instanceof Array){url=this.selectUrl(path,url);}
return url+path;},addTile:function(bounds,position){var url=this.getURL(bounds);return new OpenLayers.Tile.Image(this,position,bounds,url,this.tileSize);},setMap:function(map){OpenLayers.Layer.Grid.prototype.setMap.apply(this,arguments);if(!this.tileOrigin){this.tileOrigin=new OpenLayers.LonLat(this.map.maxExtent.left,this.map.maxExtent.bottom);}},CLASS_NAME:"OpenLayers.Layer.TMS"});OpenLayers.Layer.WFS=OpenLayers.Class.create();OpenLayers.Layer.WFS.prototype=OpenLayers.Class.inherit(OpenLayers.Layer.Vector,OpenLayers.Layer.Markers,{isBaseLayer:false,ratio:2,DEFAULT_PARAMS:{service:"WFS",version:"1.0.0",request:"GetFeature"},featureClass:null,vectorMode:true,initialize:function(name,url,params,options){if(options==undefined){options={};}
if(options.featureClass||!OpenLayers.Layer.Vector||!OpenLayers.Feature.Vector){this.vectorMode=false;}
OpenLayers.Util.extend(options,{'reportError':false});var newArguments=new Array()
newArguments.push(name,options);OpenLayers.Layer.Vector.prototype.initialize.apply(this,newArguments);if(!this.renderer||!this.vectorMode){this.vectorMode=false;if(!options.featureClass){options.featureClass=OpenLayers.Feature.WFS;}
OpenLayers.Layer.Markers.prototype.initialize.apply(this,newArguments);}
if(this.params&&this.params.typename&&!this.options.typename){this.options.typename=this.params.typename;}
if(!this.options.geometry_column){this.options.geometry_column="the_geom";}
this.params=params;OpenLayers.Util.applyDefaults(this.params,OpenLayers.Util.upperCaseObject(this.DEFAULT_PARAMS));this.url=url;},destroy:function(){if(this.vectorMode){OpenLayers.Layer.Vector.prototype.destroy.apply(this,arguments);}else{OpenLayers.Layer.Markers.prototype.destroy.apply(this,arguments);}},setMap:function(map){if(this.vectorMode){OpenLayers.Layer.Vector.prototype.setMap.apply(this,arguments);}else{OpenLayers.Layer.Markers.prototype.setMap.apply(this,arguments);}},moveTo:function(bounds,zoomChanged,dragging){if(this.vectorMode){OpenLayers.Layer.Vector.prototype.moveTo.apply(this,arguments);}else{OpenLayers.Layer.Markers.prototype.moveTo.apply(this,arguments);}
if(dragging){return false;}
if(zoomChanged){if(this.vectorMode){this.renderer.clear();}}
if(this.options.minZoomLevel&&this.map.getZoom()<this.options.minZoomLevel){return null;};if(bounds==null){bounds=this.map.getExtent();}
var firstRendering=(this.tile==null);var outOfBounds=(!firstRendering&&!this.tile.bounds.containsBounds(bounds));if(zoomChanged||firstRendering||(!dragging&&outOfBounds)){var center=bounds.getCenterLonLat();var tileWidth=bounds.getWidth()*this.ratio;var tileHeight=bounds.getHeight()*this.ratio;var tileBounds=new OpenLayers.Bounds(center.lon-(tileWidth/2),center.lat-(tileHeight/2),center.lon+(tileWidth/2),center.lat+(tileHeight/2));var tileSize=this.map.getSize();tileSize.w=tileSize.w*this.ratio;tileSize.h=tileSize.h*this.ratio;var ul=new OpenLayers.LonLat(tileBounds.left,tileBounds.top);var pos=this.map.getLayerPxFromLonLat(ul);var url=this.getFullRequestString();var params={BBOX:tileBounds.toBBOX()};url+="&"+OpenLayers.Util.getParameterString(params);if(!this.tile){this.tile=new OpenLayers.Tile.WFS(this,pos,tileBounds,url,tileSize);this.tile.draw();}else{if(this.vectorMode){this.destroyFeatures();this.renderer.clear();}else{this.clearMarkers();}
this.tile.destroy();this.tile=null;this.tile=new OpenLayers.Tile.WFS(this,pos,tileBounds,url,tileSize);this.tile.draw();}}},onMapResize:function(){if(this.vectorMode){OpenLayers.Layer.Vector.prototype.onMapResize.apply(this,arguments);}else{OpenLayers.Layer.Markers.prototype.onMapResize.apply(this,arguments);}},clone:function(obj){if(obj==null){obj=new OpenLayers.Layer.WFS(this.name,this.url,this.params,this.options);}
if(this.vectorMode){obj=OpenLayers.Layer.Vector.prototype.clone.apply(this,[obj]);}else{obj=OpenLayers.Layer.Markers.prototype.clone.apply(this,[obj]);}
return obj;},getFullRequestString:function(newParams){var projection=this.map.getProjection();this.params.SRS=(projection=="none")?null:projection;return OpenLayers.Layer.Grid.prototype.getFullRequestString.apply(this,arguments);},commit:function(){if(!this.writer){this.writer=new OpenLayers.Format.WFS({},this);}
var data=this.writer.write(this.features);var url=this.url;if(OpenLayers.ProxyHost&&this.url.startsWith("http")){url=OpenLayers.ProxyHost+escape(this.url);}
var success=this.commitSuccess.bind(this);var failure=this.commitFailure.bind(this)
data=OpenLayers.Ajax.serializeXMLToString(data);new OpenLayers.Ajax.Request(url,{method:'post',postBody:data,onComplete:success,onFailure:failure});},commitSuccess:function(request){var response=request.responseText;if(response.indexOf('SUCCESS')!=-1){this.commitReport('WFS Transaction: SUCCESS',response);for(var i=0;i<this.features.length;i++){i.state=null;}}else if(response.indexOf('FAILED')!=-1||response.indexOf('Exception')!=-1){this.commitReport('WFS Transaction: FAILED',response);}},commitFailure:function(request){},commitReport:function(string,response){alert(string);},refresh:function(){if(this.tile){if(this.vectorMode){this.renderer.clear();OpenLayers.Util.clearArray(this.features);}else{this.clearMarkers();OpenLayers.Util.clearArray(this.markers);}
this.tile.draw();}},CLASS_NAME:"OpenLayers.Layer.WFS"});OpenLayers.Layer.WMS=OpenLayers.Class.create();OpenLayers.Layer.WMS.prototype=OpenLayers.Class.inherit(OpenLayers.Layer.Grid,{DEFAULT_PARAMS:{service:"WMS",version:"1.1.1",request:"GetMap",styles:"",exceptions:"application/vnd.ogc.se_inimage",format:"image/jpeg"},reproject:true,initialize:function(name,url,params,options){var newArguments=new Array();params=OpenLayers.Util.upperCaseObject(params);newArguments.push(name,url,params,options);OpenLayers.Layer.Grid.prototype.initialize.apply(this,newArguments);OpenLayers.Util.applyDefaults(this.params,OpenLayers.Util.upperCaseObject(this.DEFAULT_PARAMS));if(options==null||options.isBaseLayer==null){this.isBaseLayer=((this.params.TRANSPARENT!="true")&&(this.params.TRANSPARENT!=true));}},destroy:function(){OpenLayers.Layer.Grid.prototype.destroy.apply(this,arguments);},clone:function(obj){if(obj==null){obj=new OpenLayers.Layer.WMS(this.name,this.url,this.params,this.options);}
obj=OpenLayers.Layer.Grid.prototype.clone.apply(this,[obj]);return obj;},getURL:function(bounds){if(this.gutter){bounds=this.adjustBoundsByGutter(bounds);}
return this.getFullRequestString({BBOX:bounds.toBBOX(),WIDTH:this.imageSize.w,HEIGHT:this.imageSize.h});},addTile:function(bounds,position){var url=this.getURL(bounds);return new OpenLayers.Tile.Image(this,position,bounds,url,this.tileSize);},mergeNewParams:function(newParams){var upperParams=OpenLayers.Util.upperCaseObject(newParams);var newArguments=[upperParams];OpenLayers.Layer.Grid.prototype.mergeNewParams.apply(this,newArguments);},getFullRequestString:function(newParams){var projection=this.map.getProjection();this.params.SRS=(projection=="none")?null:projection;return OpenLayers.Layer.Grid.prototype.getFullRequestString.apply(this,arguments);},CLASS_NAME:"OpenLayers.Layer.WMS"});OpenLayers.Layer.WorldWind=OpenLayers.Class.create();OpenLayers.Layer.WorldWind.prototype=OpenLayers.Class.inherit(OpenLayers.Layer.Grid,{DEFAULT_PARAMS:{},isBaseLayer:true,lzd:null,zoomLevels:null,initialize:function(name,url,lzd,zoomLevels,params,options){this.lzd=lzd;this.zoomLevels=zoomLevels;var newArguments=new Array();newArguments.push(name,url,params,options);OpenLayers.Layer.Grid.prototype.initialize.apply(this,newArguments);this.params=(params?params:{});if(params){OpenLayers.Util.applyDefaults(this.params,this.DEFAULT_PARAMS);}},addTile:function(bounds,position){if(this.map.getResolution()<=(this.lzd/512)&&this.getZoom()<=this.zoomLevels){var url=this.getURL(bounds);return new OpenLayers.Tile.Image(this,position,bounds,url,this.tileSize);}else{return new OpenLayers.Tile.Image(this,position,bounds,OpenLayers.Util.getImagesLocation()+"blank.gif",this.tileSize);}},getZoom:function(){var zoom=this.map.getZoom();var extent=this.map.getMaxExtent();zoom=zoom-Math.log(this.maxResolution/(this.lzd/512))/Math.log(2);return zoom;},getURL:function(bounds){var zoom=this.getZoom();var extent=this.map.getMaxExtent();var deg=this.lzd/Math.pow(2,this.getZoom());var x=Math.floor((bounds.left-extent.left)/deg);var y=Math.floor((bounds.bottom-extent.bottom)/deg);if(this.map.getResolution()<=(this.lzd/512)&&this.getZoom()<=this.zoomLevels){return this.getFullRequestString({L:zoom,X:x,Y:y});}else{return OpenLayers.Util.getImagesLocation()+"blank.gif";}},CLASS_NAME:"OpenLayers.Layer.WorldWind"});OpenLayers.Geometry.LineString=OpenLayers.Class.create();OpenLayers.Geometry.LineString.prototype=OpenLayers.Class.inherit(OpenLayers.Geometry.Curve,{initialize:function(points){OpenLayers.Geometry.Curve.prototype.initialize.apply(this,arguments);},removeComponent:function(point){if(this.components&&(this.components.length>2)){OpenLayers.Geometry.Collection.prototype.removeComponent.apply(this,arguments);}},CLASS_NAME:"OpenLayers.Geometry.LineString"});OpenLayers.Layer.MapServer.Untiled=OpenLayers.Class.create();OpenLayers.Layer.MapServer.Untiled.prototype=OpenLayers.Class.inherit(OpenLayers.Layer.HTTPRequest,{default_params:{mode:"map",map_imagetype:"png"},reproject:true,ratio:1,tile:null,doneLoading:false,initialize:function(name,url,params,options){var newArguments=[];newArguments.push(name,url,params,options);OpenLayers.Layer.HTTPRequest.prototype.initialize.apply(this,newArguments);OpenLayers.Util.applyDefaults(this.params,this.default_params);if((options==null)||(options.isBaseLayer==null)){this.isBaseLayer=((this.params.transparent!="true")&&(this.params.transparent!=true));}},destroy:function(){if(this.tile){this.tile.destroy();this.tile=null;}
OpenLayers.Layer.HTTPRequest.prototype.destroy.apply(this,arguments);},clone:function(obj){if(obj==null){obj=new OpenLayers.Layer.MapServer.Untiled(this.name,this.url,this.params,this.options);}
obj=OpenLayers.Layer.HTTPRequest.prototype.clone.apply(this,[obj]);return obj;},setMap:function(map){OpenLayers.Layer.HTTPRequest.prototype.setMap.apply(this,arguments);},setTileSize:function(){var tileSize=this.map.getSize();tileSize.w=tileSize.w*this.ratio;tileSize.h=tileSize.h*this.ratio;this.tileSize=tileSize;this.imageSize=tileSize;this.imageOffset=new OpenLayers.Pixel(0,0);},moveTo:function(bounds,zoomChanged,dragging){if(!this.doneLoading){this.events.triggerEvent("loadcancel");this.doneLoading=true;}
OpenLayers.Layer.HTTPRequest.prototype.moveTo.apply(this,arguments);if(bounds==null){bounds=this.map.getExtent();}
var firstRendering=(this.tile==null);var outOfBounds=(!firstRendering&&!this.tile.bounds.containsBounds(bounds));if(zoomChanged||firstRendering||(!dragging&&outOfBounds)){if(this.tile){this.tile.clear();}
var center=bounds.getCenterLonLat();var tileWidth=bounds.getWidth()*this.ratio;var tileHeight=bounds.getHeight()*this.ratio;var tileBounds=new OpenLayers.Bounds(center.lon-(tileWidth/2),center.lat-(tileHeight/2),center.lon+(tileWidth/2),center.lat+(tileHeight/2));this.setTileSize();var url=this.getURL(tileBounds);var ul=new OpenLayers.LonLat(tileBounds.left,tileBounds.top);var pos=this.map.getLayerPxFromLonLat(ul);if(this.tile&&!this.tile.size.equals(this.tileSize)){this.tile.destroy();this.tile=null;}
this.events.triggerEvent("loadstart");this.doneLoading=false;if(!this.tile){this.tile=new OpenLayers.Tile.Image(this,pos,tileBounds,url,this.tileSize);this.tile.draw();var onload=function(){this.doneLoading=true;this.events.triggerEvent("loadend");}
OpenLayers.Event.observe(this.tile.imgDiv,'load',onload.bindAsEventListener(this));}else{this.tile.moveTo(tileBounds,pos);}}},getURL:function(bounds){var url=this.getFullRequestString({mapext:bounds.toBBOX().replace(/,/g," "),imgext:bounds.toBBOX().replace(/,/g," "),map_size:this.tileSize.w+" "+this.tileSize.h,imgx:this.tileSize.w/2,imgy:this.tileSize.h/2,imgxy:this.tileSize.w+" "+this.tileSize.h});return url;},setUrl:function(newUrl){OpenLayers.Layer.HTTPRequest.prototype.setUrl.apply(this,arguments);this.moveTo();},mergeNewParams:function(newParams){OpenLayers.Layer.HTTPRequest.prototype.mergeNewParams.apply(this,[newParams]);this.moveTo(null,true);},getFullRequestString:function(newParams){var projection=this.map.getProjection();this.params.srs=(projection=="none")?null:projection;return OpenLayers.Layer.Grid.prototype.getFullRequestString.apply(this,arguments);},CLASS_NAME:"OpenLayers.Layer.MapServer.Untiled"});OpenLayers.Layer.WMS.Untiled=OpenLayers.Class.create();OpenLayers.Layer.WMS.Untiled.prototype=OpenLayers.Class.inherit(OpenLayers.Layer.HTTPRequest,{DEFAULT_PARAMS:{service:"WMS",version:"1.1.1",request:"GetMap",styles:"",exceptions:"application/vnd.ogc.se_inimage",format:"image/jpeg"},reproject:true,ratio:2,tile:null,doneLoading:false,initialize:function(name,url,params,options){var newArguments=new Array();params=OpenLayers.Util.upperCaseObject(params);newArguments.push(name,url,params,options);OpenLayers.Layer.HTTPRequest.prototype.initialize.apply(this,newArguments);OpenLayers.Util.applyDefaults(this.params,OpenLayers.Util.upperCaseObject(this.DEFAULT_PARAMS));if((options==null)||(options.isBaseLayer==null)){this.isBaseLayer=((this.params.TRANSPARENT!="true")&&(this.params.TRANSPARENT!=true));}},destroy:function(){if(this.tile){this.tile.destroy();this.tile=null;}
OpenLayers.Layer.HTTPRequest.prototype.destroy.apply(this,arguments);},clone:function(obj){if(obj==null){obj=new OpenLayers.Layer.WMS.Untiled(this.name,this.url,this.params,this.options);}
obj=OpenLayers.Layer.HTTPRequest.prototype.clone.apply(this,[obj]);return obj;},setMap:function(map){OpenLayers.Layer.HTTPRequest.prototype.setMap.apply(this,arguments);},setTileSize:function(){var tileSize=this.map.getSize();tileSize.w=tileSize.w*this.ratio;tileSize.h=tileSize.h*this.ratio;this.tileSize=tileSize;this.imageSize=tileSize;this.imageOffset=new OpenLayers.Pixel(0,0);},moveTo:function(bounds,zoomChanged,dragging){if(!this.doneLoading){this.events.triggerEvent("loadcancel");this.doneLoading=true;}
OpenLayers.Layer.HTTPRequest.prototype.moveTo.apply(this,arguments);if(bounds==null){bounds=this.map.getExtent();}
var firstRendering=(this.tile==null);var outOfBounds=(!firstRendering&&!this.tile.bounds.containsBounds(bounds));if(zoomChanged||firstRendering||(!dragging&&outOfBounds)){if(this.tile){this.tile.clear();}
var center=bounds.getCenterLonLat();var tileWidth=bounds.getWidth()*this.ratio;var tileHeight=bounds.getHeight()*this.ratio;var tileBounds=new OpenLayers.Bounds(center.lon-(tileWidth/2),center.lat-(tileHeight/2),center.lon+(tileWidth/2),center.lat+(tileHeight/2));this.setTileSize();var url=this.getURL(tileBounds);var ul=new OpenLayers.LonLat(tileBounds.left,tileBounds.top);var pos=this.map.getLayerPxFromLonLat(ul);if(this.tile&&!this.tile.size.equals(this.tileSize)){this.tile.destroy();this.tile=null;}
this.events.triggerEvent("loadstart");this.doneLoading=false;if(!this.tile){this.tile=new OpenLayers.Tile.Image(this,pos,tileBounds,url,this.tileSize);this.tile.draw();var onload=function(){this.doneLoading=true;this.events.triggerEvent("loadend");}
OpenLayers.Event.observe(this.tile.imgDiv,'load',onload.bindAsEventListener(this));}else{this.tile.moveTo(tileBounds,pos);}}},getURL:function(bounds){return this.getFullRequestString({'BBOX':bounds.toBBOX(),'WIDTH':this.tileSize.w,'HEIGHT':this.tileSize.h});},setUrl:function(newUrl){OpenLayers.Layer.HTTPRequest.prototype.setUrl.apply(this,arguments);this.moveTo();},mergeNewParams:function(newParams){var upperParams=OpenLayers.Util.upperCaseObject(newParams);var newArguments=[upperParams];OpenLayers.Layer.HTTPRequest.prototype.mergeNewParams.apply(this,newArguments);this.moveTo(null,true);},getFullRequestString:function(newParams){var projection=this.map.getProjection();this.params.SRS=(projection=="none")?null:projection;return OpenLayers.Layer.Grid.prototype.getFullRequestString.apply(this,arguments);},CLASS_NAME:"OpenLayers.Layer.WMS.Untiled"});OpenLayers.Geometry.LinearRing=OpenLayers.Class.create();OpenLayers.Geometry.LinearRing.prototype=OpenLayers.Class.inherit(OpenLayers.Geometry.LineString,{componentTypes:["OpenLayers.Geometry.Point"],initialize:function(points){OpenLayers.Geometry.LineString.prototype.initialize.apply(this,arguments);},addComponent:function(point,index){var added=false;var lastPoint=this.components[this.components.length-1];OpenLayers.Geometry.Collection.prototype.removeComponent.apply(this,[lastPoint]);if(index!=null||!point.equals(lastPoint)){added=OpenLayers.Geometry.Collection.prototype.addComponent.apply(this,arguments);}
var firstPoint=this.components[0];OpenLayers.Geometry.Collection.prototype.addComponent.apply(this,[firstPoint.clone()]);return added;},removeComponent:function(point){if(this.components.length>4){var lastPoint=this.components[this.components.length-1];OpenLayers.Geometry.Collection.prototype.removeComponent.apply(this,[lastPoint]);OpenLayers.Geometry.Collection.prototype.removeComponent.apply(this,arguments);var firstPoint=this.components[0];OpenLayers.Geometry.Collection.prototype.addComponent.apply(this,[firstPoint.clone()]);}},getArea:function(){var area=0.0;if(this.components&&(this.components.length>2)){var sum=0.0;for(var i=0;i<this.components.length-1;i++){var b=this.components[i];var c=this.components[i+1];sum+=(b.x+c.x)*(c.y-b.y);}
area=-sum/2.0;}
return area;},CLASS_NAME:"OpenLayers.Geometry.LinearRing"});OpenLayers.Handler.Path=OpenLayers.Class.create();OpenLayers.Handler.Path.prototype=OpenLayers.Class.inherit(OpenLayers.Handler.Point,{line:null,freehand:false,freehandToggle:'shiftKey',initialize:function(control,callbacks,options){OpenLayers.Handler.Point.prototype.initialize.apply(this,arguments);},createFeature:function(){this.line=new OpenLayers.Feature.Vector(new OpenLayers.Geometry.LineString());this.point=new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Point());},destroyFeature:function(){this.line.destroy();this.point.destroy();},addPoint:function(){this.line.geometry.addComponent(this.point.geometry.clone(),this.line.geometry.components.length);this.callback("point",[this.point.geometry]);},freehandMode:function(evt){return(this.freehandToggle&&evt[this.freehandToggle])?!this.freehand:this.freehand;},modifyFeature:function(){var index=this.line.geometry.components.length-1;this.line.geometry.components[index].x=this.point.geometry.x;this.line.geometry.components[index].y=this.point.geometry.y;},drawFeature:function(){this.layer.drawFeature(this.line,this.style);this.layer.drawFeature(this.point,this.style);},geometryClone:function(){return this.line.geometry.clone();},mousedown:function(evt){if(this.lastDown&&this.lastDown.equals(evt.xy)){return false;}
if(this.lastDown==null){this.createFeature();}
this.mouseDown=true;this.lastDown=evt.xy;var lonlat=this.control.map.getLonLatFromPixel(evt.xy);this.point.geometry.x=lonlat.lon;this.point.geometry.y=lonlat.lat;if((this.lastUp==null)||!this.lastUp.equals(evt.xy)){this.addPoint();}
this.drawFeature();this.drawing=true;return false;},mousemove:function(evt){if(this.drawing){var lonlat=this.map.getLonLatFromPixel(evt.xy);this.point.geometry.x=lonlat.lon;this.point.geometry.y=lonlat.lat;if(this.mouseDown&&this.freehandMode(evt)){this.addPoint();}else{this.modifyFeature();}
this.drawFeature();}
return true;},mouseup:function(evt){this.mouseDown=false;if(this.drawing){if(this.freehandMode(evt)){this.finalize();}else{if(this.lastUp==null){this.addPoint();}
this.lastUp=evt.xy;}
return false;}
return true;},dblclick:function(evt){if(!this.freehandMode(evt)){var index=this.line.geometry.components.length-1;this.line.geometry.removeComponent(this.line.geometry.components[index]);this.finalize();}
return false;},CLASS_NAME:"OpenLayers.Handler.Path"});OpenLayers.Handler.Polygon=OpenLayers.Class.create();OpenLayers.Handler.Polygon.prototype=OpenLayers.Class.inherit(OpenLayers.Handler.Path,{polygon:null,initialize:function(control,callbacks,options){OpenLayers.Handler.Path.prototype.initialize.apply(this,arguments);},createFeature:function(){this.polygon=new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Polygon());this.line=new OpenLayers.Feature.Vector(new OpenLayers.Geometry.LinearRing());this.polygon.geometry.addComponent(this.line.geometry);this.point=new OpenLayers.Feature.Vector(new OpenLayers.Geometry.Point());},destroyFeature:function(){this.polygon.destroy();this.point.destroy();},modifyFeature:function(){var index=this.line.geometry.components.length-2;this.line.geometry.components[index].x=this.point.geometry.x;this.line.geometry.components[index].y=this.point.geometry.y;},drawFeature:function(){this.layer.drawFeature(this.polygon,this.style);this.layer.drawFeature(this.point,this.style);},geometryClone:function(){return this.polygon.geometry.clone();},dblclick:function(evt){if(!this.freehandMode(evt)){var index=this.line.geometry.components.length-2;this.line.geometry.removeComponent(this.line.geometry.components[index]);this.finalize();}
return false;},CLASS_NAME:"OpenLayers.Handler.Polygon"});
