using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;
using System.Xml;

namespace GMDL
{
    public partial class YumCruncher : Form
    {
        public YumCruncher()
        {
            InitializeComponent();
        }

        private void SetMain_Click(object sender, EventArgs e)
        {
            string dir = System.IO.Directory.GetCurrentDirectory();

            OpenFileDialog file = new OpenFileDialog();
            file.Filter = "YUM File - MapCruncher (*.yum)|*.yum";
            file.ShowDialog();

            System.IO.Directory.SetCurrentDirectory(dir);

            if (file.FileName != "")
            {
                FileMain.Text = file.FileName;
            }
        }

        private void SetSecond_Click(object sender, EventArgs e)
        {
            string dir = System.IO.Directory.GetCurrentDirectory();

            OpenFileDialog file = new OpenFileDialog();
            file.Filter = "YUM File - MapCruncher (*.yum)|*.yum";
            file.ShowDialog();

            System.IO.Directory.SetCurrentDirectory(dir);

            if (file.FileName != "")
            {
                FileSecond.Text = file.FileName;
            }
        }

        private void CombineFiles_Click(object sender, EventArgs e)
        {
            if (FileMain.Text != "" && FileSecond.Text != "")
            {
                string file_out = FileMain.Text + "_" + new FileInfo(FileSecond.Text).Name;

                if (new FileInfo(file_out).Exists)
                {
                    MessageBox.Show("Output file already exists");
                }
                else
                {
                    XmlDocument in1 = new XmlDocument();
                    in1.Load(FileMain.Text);

                    XmlDocument in2 = new XmlDocument();
                    in2.Load(FileSecond.Text);

                    int max_id = 0;
                    foreach (XmlNode res in in1.GetElementsByTagName("SourceMap"))
                    {
                        if (max_id < Int32.Parse(res.Attributes["id"].Value))
                        {
                            max_id = Int32.Parse(res.Attributes["id"].Value);
                        }
                    }

                    foreach (XmlNode res in in2.GetElementsByTagName("SourceMap"))
                    {
                        res.Attributes["id"].Value = (max_id + Int32.Parse(res.Attributes["id"].Value)).ToString();
                    }

                    bool added = false; // will add to the first layer
                    foreach (XmlNode res in in1.GetElementsByTagName("Layer"))
                    {
                        if (added == false)
                        {
                            foreach (XmlNode res2 in in2.GetElementsByTagName("SourceMap"))
                            {
                                res.AppendChild(in1.ImportNode(res2.Clone(), true));
                            }
                        }
                        added = true;
                    }

                    in1.Save(file_out);

                    MessageBox.Show("Saved combined YUM to: " + file_out + "\n\ncopy the source files if they are in a different directory");
                }
            }
        }

        private void LayerViewToMapPos_Click(object sender, EventArgs e)
        {
            if (FileMain.Text != "")
            {
                string file_out = FileMain.Text + "_view.yum";

                if (new FileInfo(file_out).Exists)
                {
                    MessageBox.Show("Output file already exists");
                }
                else
                {
                    XmlDocument in1 = new XmlDocument();
                    in1.Load(FileMain.Text);
                    string zoom = "";
                    string lat = "";
                    string lon = "";
                    bool searching = true; // first layer
                    foreach (XmlNode res in in1.GetElementsByTagName("LayerView"))
                    {
                        if (searching)
                        {
                            zoom = res.ChildNodes[0].ChildNodes[0].Attributes["zoom"].Value;
                            lat = res.ChildNodes[0].ChildNodes[0].ChildNodes[0].Attributes["lat"].Value;
                            lon = res.ChildNodes[0].ChildNodes[0].ChildNodes[0].Attributes["lon"].Value;
                        }
                        searching = false;
                    }

                    if (zoom != "" && lat != "" && lon != "")
                    {
                        int done = 0;

                        foreach (XmlNode res in in1.GetElementsByTagName("ReferenceMapPosition"))
                        {
                            if (res.ChildNodes[0].ChildNodes[0].Attributes["zoom"].Value == "1"
                                && res.ChildNodes[0].ChildNodes[0].ChildNodes[0].Attributes["lat"].Value == "0"
                                && res.ChildNodes[0].ChildNodes[0].ChildNodes[0].Attributes["lon"].Value == "0")
                            {
                                res.ChildNodes[0].ChildNodes[0].Attributes["zoom"].Value = zoom;
                                res.ChildNodes[0].ChildNodes[0].ChildNodes[0].Attributes["lat"].Value = lat;
                                res.ChildNodes[0].ChildNodes[0].ChildNodes[0].Attributes["lon"].Value = lon;

                                done++;
                            }
                        }

                        in1.Save(file_out);

                        MessageBox.Show("Saved YUM to: " + file_out + "\n\nwith " + done.ToString() + " changes");
                    }
                    else
                    {
                        MessageBox.Show("No LayerView MapPosition it seems");
                    }
                }
            }
        }

        private void SetCoords_Click(object sender, EventArgs e)
        {
            string dir = System.IO.Directory.GetCurrentDirectory();

            OpenFileDialog file = new OpenFileDialog();
            file.Filter = "txt (csv) File - coords (*.txt)|*.txt";
            file.ShowDialog();

            System.IO.Directory.SetCurrentDirectory(dir);

            if (file.FileName != "")
            {
                FileCoords.Text = file.FileName;
            }
        }

        private void SetTLBLBRcoords_Click(object sender, EventArgs e)
        {
            if (FileMain.Text != "" && FileCoords.Text != "")
            {
                string file_out = FileMain.Text + "_coords.yum";

                if (new FileInfo(file_out).Exists)
                {
                    MessageBox.Show("Output file already exists");
                }
                else
                {
                    DataTable coords = new DataTable();
                    coords.Columns.Add("name", typeof(String));
                    coords.Columns.Add("pin", typeof(String));
                    coords.Columns.Add("lat", typeof(Decimal));
                    coords.Columns.Add("lon", typeof(Decimal));

                    StreamReader sr = new StreamReader(FileCoords.Text);
                    while (sr.EndOfStream == false)
                    {
                        string line = sr.ReadLine().Trim();
                        if (line != "")
                        {
                            line = line + ",";
                            DataRow coord = coords.NewRow();
                            int start = 0;
                            int end = line.IndexOf(",", line.IndexOf(".png"));
                            string name = line.Substring(start, end - start);
                            name = name.Substring(0, name.LastIndexOf("."));
                            coord["name"] = name;
                            start = end + 1;
                            end = line.IndexOf(",", start);
                            coord["pin"] = line.Substring(start, end - start);
                            start = end + 1;
                            end = line.IndexOf(",", start);
                            coord["lat"] = Decimal.Parse(line.Substring(start, end - start));
                            start = end + 1;
                            end = line.IndexOf(",", start);
                            coord["lon"] = Decimal.Parse(line.Substring(start, end - start));
                            coords.Rows.Add(coord);
                        }
                    }
                    sr.Close();

                    int done = 0;

                    XmlDocument in1 = new XmlDocument();
                    in1.Load(FileMain.Text);

                    //<SourceMap DisplayName="08-36-033-1" Expanded="False" id="56">
                    //<RegistrationDefinition WarpQuality="Automatic">
                    //<PositionAssociation pinId="0" associationName="TL">
                    //<GlobalPosition>
                    //<LatLonZoom zoom="1">
                    //<LatLon lat="0" lon="0" />

                    foreach (XmlNode ll in in1.GetElementsByTagName("LatLon"))
                    {
                        if (ll.ParentNode.ParentNode.Name == "GlobalPosition")
                        {
                            string pin_name = ll.ParentNode.ParentNode.ParentNode.Attributes["associationName"].Value;
                            if (pin_name.StartsWith("Pin") == false)
                            {
                                string pic_name = ll.ParentNode.ParentNode.ParentNode.ParentNode.ParentNode.Attributes["DisplayName"].Value;

                                foreach (DataRow coord in coords.Select("name = '" + pic_name + "' AND pin = '" + pin_name + "'"))
                                {
                                    ll.Attributes["lat"].Value = coord["lat"].ToString();
                                    ll.Attributes["lon"].Value = coord["lon"].ToString();

                                    done++;
                                }
                            }
                        }
                    }

                    in1.Save(file_out);

                    MessageBox.Show("Saved YUM to: " + file_out + "\n\n  with " + done.ToString() + " coords (" + (done / 3).ToString() + " files if 3/file)\nout of " + coords.Rows.Count.ToString() + " possible (" + (coords.Rows.Count/3).ToString() + " files if 3/file)");
                }
            }
        }

        private void SetCornerCoordsViaTL_Click(object sender, EventArgs e)
        {
            if (SpanW.Text == "" || SpanH.Text == "")
            {
                MessageBox.Show("Enter spans");
            }
            else
            {
                decimal spanW = Decimal.Parse(SpanW.Text) / 60;
                decimal spanH = Decimal.Parse(SpanH.Text) / 60;

                if (FileMain.Text != "" && FileCoords.Text != "")
                {
                    string file_out = FileMain.Text + "_coords.yum";

                    if (new FileInfo(file_out).Exists)
                    {
                        MessageBox.Show("Output file already exists");
                    }
                    else
                    {
                        DataTable coords = new DataTable();
                        coords.Columns.Add("name", typeof(String));
                        coords.Columns.Add("pin", typeof(String));
                        coords.Columns.Add("lat", typeof(Decimal));
                        coords.Columns.Add("lon", typeof(Decimal));

                        StreamReader sr = new StreamReader(FileCoords.Text);
                        while (sr.EndOfStream == false)
                        {
                            string line = sr.ReadLine().Trim();
                            if (line != "")
                            {
                                line = line + ",";
                                DataRow coord = coords.NewRow();
                                int start = 0;
                                int end = line.IndexOf(",", line.IndexOf(".png"));
                                string name = line.Substring(start, end - start);
                                name = name.Substring(0, name.LastIndexOf("."));
                                coord["name"] = name;
                                start = end + 1;
                                end = line.IndexOf(",", start);
                                coord["pin"] = line.Substring(start, end - start);
                                start = end + 1;
                                end = line.IndexOf(",", start);
                                coord["lat"] = Decimal.Parse(line.Substring(start, end - start));
                                start = end + 1;
                                end = line.IndexOf(",", start);
                                coord["lon"] = Decimal.Parse(line.Substring(start, end - start));
                                coords.Rows.Add(coord);
                            }
                        }
                        sr.Close();

                        int done = 0;

                        XmlDocument in1 = new XmlDocument();
                        in1.Load(FileMain.Text);

                        //<SourceMap DisplayName="08-36-033-1" Expanded="False" id="56">
                        //<RegistrationDefinition WarpQuality="Automatic">
                        //<PositionAssociation pinId="0" associationName="TL">
                        //<GlobalPosition>
                        //<LatLonZoom zoom="1">
                        //<LatLon lat="0" lon="0" />

                        foreach (XmlNode ll in in1.GetElementsByTagName("LatLon"))
                        {
                            if (ll.ParentNode.ParentNode.Name == "GlobalPosition")
                            {
                                string pin_name = ll.ParentNode.ParentNode.ParentNode.Attributes["associationName"].Value;
                                string pic_name = ll.ParentNode.ParentNode.ParentNode.ParentNode.ParentNode.Attributes["DisplayName"].Value;

                                foreach (DataRow coord in coords.Select("name = '" + pic_name + "' AND pin = 'TL'"))
                                {
                                    done++;

                                    if (pin_name == "TL")
                                    {
                                        ll.Attributes["lat"].Value = coord["lat"].ToString();
                                        ll.Attributes["lon"].Value = coord["lon"].ToString();
                                    }
                                    else if (pin_name == "TC")
                                    {
                                        ll.Attributes["lat"].Value = coord["lat"].ToString();
                                        ll.Attributes["lon"].Value = ((decimal)coord["lon"] + spanW / 2).ToString();
                                    }
                                    else if (pin_name == "TR")
                                    {
                                        ll.Attributes["lat"].Value = coord["lat"].ToString();
                                        ll.Attributes["lon"].Value = ((decimal)coord["lon"] + spanW).ToString();
                                    }
                                    else if (pin_name == "ML")
                                    {
                                        ll.Attributes["lat"].Value = ((decimal)coord["lat"] - spanH / 2).ToString();
                                        ll.Attributes["lon"].Value = coord["lon"].ToString();
                                    }
                                    else if (pin_name == "MC")
                                    {
                                        ll.Attributes["lat"].Value = ((decimal)coord["lat"] - spanH / 2).ToString();
                                        ll.Attributes["lon"].Value = ((decimal)coord["lon"] + spanW / 2).ToString();
                                    }
                                    else if (pin_name == "MR")
                                    {
                                        ll.Attributes["lat"].Value = ((decimal)coord["lat"] - spanH / 2).ToString();
                                        ll.Attributes["lon"].Value = ((decimal)coord["lon"] + spanW).ToString();
                                    }
                                    else if (pin_name == "BL")
                                    {
                                        ll.Attributes["lat"].Value = ((decimal)coord["lat"] - spanH).ToString();
                                        ll.Attributes["lon"].Value = coord["lon"].ToString();
                                    }
                                    else if (pin_name == "BC")
                                    {
                                        ll.Attributes["lat"].Value = ((decimal)coord["lat"] - spanH).ToString();
                                        ll.Attributes["lon"].Value = ((decimal)coord["lon"] + spanW / 2).ToString();
                                    }
                                    else if (pin_name == "BR")
                                    {
                                        ll.Attributes["lat"].Value = ((decimal)coord["lat"] - spanH).ToString();
                                        ll.Attributes["lon"].Value = ((decimal)coord["lon"] + spanW).ToString();
                                    }
                                    else
                                    {
                                        done--;
                                    }
                                }
                            }
                        }

                        in1.Save(file_out);

                        MessageBox.Show("Saved YUM to: " + file_out + "\n\n  with " 
                            + done.ToString() + " coords (" + (done / 9).ToString() + " files if 9 pins)\nout of " 
                            + (coords.Select("pin = 'TL'").Length * 9).ToString() + " possible (" + coords.Select("pin = 'TL'").Length.ToString() + " files if 9 pins)");
                    }
                }
            }
        }

        private void SetDir_Click(object sender, EventArgs e)
        {
            string dir = System.IO.Directory.GetCurrentDirectory();

            FolderBrowserDialog file = new FolderBrowserDialog();
            file.ShowDialog();

            System.IO.Directory.SetCurrentDirectory(dir);

            if (file.SelectedPath != "")
            {
                Dir.Text = file.SelectedPath;
            }
        }

        private void DirToYUM_Click(object sender, EventArgs e)
        {
            if (Dir.Text != "")
            {
                if (new FileInfo(Dir.Text + "\\dir.yum").Exists)
                {
                    MessageBox.Show("dir.yum already there");
                }
                else
                {
                    DataTable files = new DataTable();
                    files.Columns.Add("file", typeof(String));

                    foreach (FileInfo file in new DirectoryInfo(Dir.Text).GetFiles("*.png"))
                    {
                        DataRow row = files.NewRow();
                        row["file"] = file.Name;
                        files.Rows.Add(row);
                    }

                    StreamWriter yum = new StreamWriter(Dir.Text + "\\dir.yum");

                    yum.WriteLine("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>");
                    yum.WriteLine("<MapGrinderMashupFile Version=\"1.7\">");
                    yum.WriteLine("  <RenderOptions>");
                    yum.WriteLine("    <PublishSourceData Value=\"False\" />");
                    yum.WriteLine("    <PermitComposition Value=\"False\" />");
                    yum.WriteLine("    <Output Folder=\"" + "MC_rendered" + "\" />");
                    yum.WriteLine("  </RenderOptions>");
                    yum.WriteLine("  <LayerList>");
                    yum.WriteLine("    <Layer DisplayName=\"New Layer\" Expanded=\"True\" id=\"0\">");

                    int SourceMapID = 1;

                    int count = 0;

                    foreach (DataRow file in files.Select("", "file"))
                    {
                        count++;

                        DirProg.Text = count.ToString() + " of " + files.Rows.Count.ToString();
                        Application.DoEvents();

                        string displayN = file["file"].ToString();
                        displayN = displayN.Substring(0, displayN.LastIndexOf("."));

                        yum.WriteLine("      <SourceMap DisplayName=\"" + displayN + "\" Expanded=\"False\" id=\"" + SourceMapID.ToString() + "\">");
                        yum.WriteLine("        <Document>");
                        yum.WriteLine("          <FileDocument Filename=\"" + file["file"].ToString() + "\" PageNumber=\"0\" />");
                        yum.WriteLine("        </Document>");
                        yum.WriteLine("        <SourceMapInfo>");
                        yum.WriteLine("          <MapFileURL url=\"\" />");
                        yum.WriteLine("          <MapHomePage url=\"\" />");
                        yum.WriteLine("          <MapDescription />");
                        yum.WriteLine("        </SourceMapInfo>");
                        if (DirZoom.Text != "")
                        {
                            yum.WriteLine("        <SourceMapRenderOptions MaxZoom=\"" + DirZoom.Text + "\" />"); // will auto calc?
                        }
                        yum.WriteLine("        <TransparencyOptions Enabled=\"True\" Inverted=\"False\" />");
                        yum.WriteLine("        <SourceMapView locked=\"False\">");
                        yum.WriteLine("          <SourceMapPosition>");
                        yum.WriteLine("            <LatLonZoom zoom=\"5\">");
                        yum.WriteLine("              <LatLon lat=\"0.5\" lon=\"0.5\" />");
                        yum.WriteLine("            </LatLonZoom>");
                        yum.WriteLine("          </SourceMapPosition>");
                        yum.WriteLine("          <ReferenceMapPosition>");
                        yum.WriteLine("            <MapPosition>");
                        yum.WriteLine("              <LatLonZoom zoom=\"" + "1" + "\">");
                        yum.WriteLine("                <LatLon lat=\"" + "0" + "\" lon=\"" + "0" + "\" />");
                        yum.WriteLine("              </LatLonZoom>");
                        yum.WriteLine("            </MapPosition>");
                        yum.WriteLine("          </ReferenceMapPosition>");
                        yum.WriteLine("        </SourceMapView>");
                        yum.WriteLine("        <RegistrationDefinition WarpQuality=\"Automatic\">");

                        FileStream image_file = new FileStream(Dir.Text + "\\" + file["file"].ToString(), FileMode.Open);
                        Bitmap file_image = new Bitmap(image_file);
                        image_file.Close();

                        int h = file_image.Height;
                        int w = file_image.Width;

                        int max = h;
                        if (w > max)
                            max = w;

                        int offset;
                        bool got_corner;

                        offset = 0;
                        got_corner = false;
                        int TLx = 0;
                        int TLy = 0;
                        while (got_corner == false)
                        {
                            TLy = offset;
                            TLx = 0;
                            while (TLy >= 0 && got_corner == false)
                            {
                                Color this_pixel = file_image.GetPixel(TLx, TLy);
                                if (this_pixel.A != 0)
                                    got_corner = true;
                                if (got_corner == false)
                                {
                                    TLy--;
                                    TLx++;
                                }
                            }
                            offset++;
                        }

                        offset = 0;
                        got_corner = false;
                        int TRx = 0;
                        int TRy = 0;
                        while (got_corner == false)
                        {
                            TRy = offset;
                            TRx = 0;
                            while (TRy >= 0 && got_corner == false)
                            {
                                Color this_pixel = file_image.GetPixel(w - 1 - TRx, TRy);
                                if (this_pixel.A != 0)
                                    got_corner = true;
                                if (got_corner == false)
                                {
                                    TRy--;
                                    TRx++;
                                }
                            }
                            offset++;
                        }

                        offset = 0;
                        got_corner = false;
                        int BRx = 0;
                        int BRy = 0;
                        while (got_corner == false)
                        {
                            BRy = offset;
                            BRx = 0;
                            while (BRy >= 0 && got_corner == false)
                            {
                                Color this_pixel = file_image.GetPixel(w - 1 - BRx, h - 1 - BRy);
                                if (this_pixel.A != 0)
                                    got_corner = true;
                                if (got_corner == false)
                                {
                                    BRy--;
                                    BRx++;
                                }
                            }
                            offset++;
                        }

                        offset = 0;
                        got_corner = false;
                        int BLx = 0;
                        int BLy = 0;
                        while (got_corner == false)
                        {
                            BLy = offset;
                            BLx = 0;
                            while (BLy >= 0 && got_corner == false)
                            {
                                Color this_pixel = file_image.GetPixel(BLx, h - 1 - BLy);
                                if (this_pixel.A != 0)
                                    got_corner = true;
                                if (got_corner == false)
                                {
                                    BLy--;
                                    BLx++;
                                }
                            }
                            offset++;
                        }

                        file_image.Dispose();

                        decimal TL_y = (decimal)h - (decimal)TLy;
                        decimal TL_x = (decimal)TLx;
                        
                        decimal TR_y = (decimal)h - (decimal)TRy;
                        decimal TR_x = (decimal)w - (decimal)TRx;

                        decimal BR_y = (decimal)BRy;
                        decimal BR_x = (decimal)w - (decimal)BRx;
                        
                        decimal BL_y = (decimal)BLy;
                        decimal BL_x = (decimal)BLx;

                        WritePin(yum, 0, "TL", max, TL_y, TL_x);
                        WritePin(yum, 1, "TC", max, (TL_y + TR_y) / 2, (TL_x + TR_x) / 2);
                        WritePin(yum, 2, "TR", max, TR_y, TR_x);

                        WritePin(yum, 3, "ML", max, (TL_y + BL_y) / 2, (TL_x + BL_x) / 2);
                        WritePin(yum, 4, "MC", max, (TL_y + TR_y + BL_y + BR_y) / 4, (TL_x + TR_x + BL_x + BR_x) / 4);
                        WritePin(yum, 5, "MR", max, (TR_y + BR_y) / 2, (TR_x + BR_x) / 2);

                        WritePin(yum, 6, "BL", max, BL_y, BL_x);
                        WritePin(yum, 7, "BC", max, (BL_y + BR_y) / 2, (BL_x + BR_x) / 2);
                        WritePin(yum, 8, "BR", max, BR_y, BR_x);

                        yum.WriteLine("        </RegistrationDefinition>");
                        yum.WriteLine("        <RenderRegion>");
                        yum.WriteLine("          <LatLon lat=\"" + ((decimal)h / (decimal)max).ToString() + "\" lon=\"0\" />");
                        yum.WriteLine("          <LatLon lat=\"" + "0" + "\" lon=\"0\" />");
                        yum.WriteLine("          <LatLon lat=\"" + "0" + "\" lon=\"" + ((decimal)w / (decimal)max).ToString() + "\" />");
                        yum.WriteLine("          <LatLon lat=\"" + ((decimal)h / (decimal)max).ToString() + "\" lon=\"" + ((decimal)w / (decimal)max).ToString() + "\" />");
                        yum.WriteLine("        </RenderRegion>");
                        yum.WriteLine("        <LegendList />");
                        yum.WriteLine("      </SourceMap>");

                        SourceMapID++;
                    }

                    /*yum.WriteLine("      <LayerView>");
                    yum.WriteLine("        <MapPosition>");
                    yum.WriteLine("          <LatLonZoom zoom=\"" + (16 - zoom).ToString() + "\">");
                    yum.WriteLine("            <LatLon lat=\"" + ((maxlat + minlat) / 2).ToString().Replace(",", ".") + "\" lon=\"" + ((maxlon + minlon) / 2).ToString().Replace(",", ".") + "\" />");
                    yum.WriteLine("          </LatLonZoom>");
                    yum.WriteLine("        </MapPosition>");
                    yum.WriteLine("      </LayerView>");*/
                    yum.WriteLine("    </Layer>");
                    yum.WriteLine("  </LayerList>");
                    yum.WriteLine("</MapGrinderMashupFile>");
                    yum.Close();

                    MessageBox.Show("Done " + (SourceMapID - 1).ToString() + " files");
                }
            }
        }

        private void WritePin(StreamWriter yum, int pinId, string pinName, int max, decimal y, decimal x)
        {
            yum.WriteLine("          <PositionAssociation pinId=\"" + pinId.ToString() + "\" associationName=\"" + pinName + "\">");
            yum.WriteLine("            <SourcePosition>");
            yum.WriteLine("              <LatLonZoom zoom=\"5\">"); // need to set, will def? (what if lock = true?)
            string laty = (y / (decimal)max).ToString();
            string lonx = (x / (decimal)max).ToString();
            yum.WriteLine("                <LatLon lat=\"" + laty + "\" lon=\"" + lonx + "\" />");
            yum.WriteLine("              </LatLonZoom>");
            yum.WriteLine("            </SourcePosition>");
            yum.WriteLine("            <GlobalPosition>");
            yum.WriteLine("              <LatLonZoom zoom=\"" + "1" + "\">");
            yum.WriteLine("                <LatLon lat=\"" + "0" + "\" lon=\"" + "0" + "\" />");
            yum.WriteLine("              </LatLonZoom>");
            yum.WriteLine("            </GlobalPosition>");
            yum.WriteLine("          </PositionAssociation>");
        }

        private void Span50K_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            SpanW.Text = "15";
            SpanH.Text = "10";
        }

        private void Span100K_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            SpanW.Text = "30";
            SpanH.Text = "20";
        }

        private void Span200K_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            SpanW.Text = "60";
            SpanH.Text = "40";
        }
    }
}