using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;

namespace GMDL
{
    public partial class YUM_Assembler : Form
    {
        public YUM_Assembler()
        {
            InitializeComponent();
        }
        string blank = "{ BLANK }";
        private void AddBlank_Click(object sender, EventArgs e)
        {
            if (ItemList.SelectedItems.Count == 0)
            {
                ItemList.Items.Add(blank);
            }
            else
            {
                int pos = ItemList.Items.Count - ItemList.SelectedItems[0].Index;
                ItemList.Items.Add(blank);
                ItemList.Items[ItemList.Items.Count - 1].Selected = true;
                while (pos > 0)
                {
                    MoveListViewItem(ref ItemList, true);
                    pos--;
                }
            }
        }

        // From the intertubes, modified
        private void MoveListViewItem(ref ListView lv, bool moveUp)
        {
            string cache;
            int cacheI;
            int selIdx;

            selIdx = lv.SelectedItems[0].Index;
            if (moveUp)
            {
                // ignore moveup of row(0)
                if (selIdx == 0)
                    return;

                // move the subitems for the previous row
                // to cache to make room for the selected row
                for (int i = 0; i < lv.Items[selIdx].SubItems.Count; i++)
                {
                    cache = lv.Items[selIdx - 1].SubItems[i].Text;
                    lv.Items[selIdx - 1].SubItems[i].Text = lv.Items[selIdx].SubItems[i].Text;
                    lv.Items[selIdx].SubItems[i].Text = cache;
                }
                cacheI = lv.Items[selIdx - 1].ImageIndex;
                lv.Items[selIdx - 1].ImageIndex = lv.Items[selIdx].ImageIndex;
                lv.Items[selIdx].ImageIndex = cacheI;

                lv.Items[selIdx - 1].Selected = true;
                lv.Refresh();
                lv.Focus();
            }
            else
            {
                // ignore movedown of last item
                if (selIdx == lv.Items.Count - 1)
                    return;
                // move the subitems for the next row
                // to cache so we can move the selected row down
                for (int i = 0; i < lv.Items[selIdx].SubItems.Count; i++)
                {
                    cache = lv.Items[selIdx + 1].SubItems[i].Text;
                    lv.Items[selIdx + 1].SubItems[i].Text = lv.Items[selIdx].SubItems[i].Text;
                    lv.Items[selIdx].SubItems[i].Text = cache;
                }
                cacheI = lv.Items[selIdx + 1].ImageIndex;
                lv.Items[selIdx + 1].ImageIndex = lv.Items[selIdx].ImageIndex;
                lv.Items[selIdx].ImageIndex = cacheI;

                lv.Items[selIdx + 1].Selected = true;
                lv.Refresh();
                lv.Focus();
            }
        }

        private void ItemWidth_Click(object sender, EventArgs e)
        {
            ItemList.Width = 20 + Int32.Parse(ItemWidthNum.Text) * Int32.Parse(TileSize.Text);
            this.Width = ItemList.Width + 20;
            if (this.Width < 620)
                this.Width = 620;
            if (ItemList.Items.Count > 0)
            {
                ItemList.RedrawItems(0, ItemList.Items.Count-1, false);
            }
        }

        private void AddDir_Click(object sender, EventArgs e)
        {
            if (Dir.Text != "")
            {
                ItemList.Items.Clear();

                if (new FileInfo(Dir.Text + "\\dir.layout").Exists)
                {
                    StreamReader sr = new StreamReader(Dir.Text + "\\dir.layout");
                    while (sr.EndOfStream == false)
                    {
                        string line = sr.ReadLine();
                        if (line.StartsWith("#"))
                        {
                            string ct = line.Substring(1, line.IndexOf("#", 1) - 1);
                            string val = line.Substring(line.LastIndexOf("#") + 1, line.Length - 1 - line.LastIndexOf("#"));
                            foreach (Control cont in YumBox.Controls)
                            {
                                if (cont.Name == ct)
                                    ((TextBox)cont).Text = val;
                            }
                            foreach (Control cont in FormatBox.Controls)
                            {
                                if (cont.Name == ct)
                                    ((TextBox)cont).Text = val;
                            }
                        }
                        else if (line != "")
                        {
                            ItemList.Items.Add(line);
                        }
                    }
                    sr.Close();
                }
                else if (new FileInfo(Dir.Text + "\\dir.csv").Exists)
                {
                    int max_w = 1;
                    StreamReader sr2 = new StreamReader(Dir.Text + "\\dir.csv");
                    while (sr2.EndOfStream == false)
                    {
                        string line = sr2.ReadLine();
                        if (line != "")
                        {
                            while (line.EndsWith(","))
                            {
                                line = line.Substring(0, line.Length - 1);
                            }
                            int start = 0;
                            int line_w = 1;
                            while(line.IndexOf(",", start) != -1)
                            {
                                line_w++;
                                start = line.IndexOf(",", start) + 1;
                            }
                            if (line_w > max_w)
                                max_w = line_w;
                        }
                    }
                    sr2.Close();
                    ItemWidthNum.Text = max_w.ToString();
                    ItemWidth_Click(Type.Missing, EventArgs.Empty);
                    StreamReader sr3 = new StreamReader(Dir.Text + "\\dir.csv");
                    while (sr3.EndOfStream == false)
                    {
                        string line = sr3.ReadLine();
                        if (line != "")
                        {
                            while (line.EndsWith(","))
                            {
                                line = line.Substring(0, line.Length - 1);
                            }
                            line = line + ",";
                            int start = 0;
                            int line_w = 0;
                            while (line.IndexOf(",", start) != -1)
                            {
                                int end = line.IndexOf(",", start);
                                string val = line.Substring(start, end - start);
                                if (val == "" || val.StartsWith("{"))
                                {
                                    ItemList.Items.Add(blank);
                                }
                                else
                                {
                                    ItemList.Items.Add(val);
                                }
                                start = end + 1;
                                line_w++;
                            }
                            while (line_w < max_w)
                            {
                                ItemList.Items.Add(blank);
                                line_w++;
                            }
                        }
                    }
                    sr3.Close();
                }
                else
                {
                    DataTable files = new DataTable();
                    files.Columns.Add("file", typeof(String));

                    foreach (FileInfo file in new DirectoryInfo(Dir.Text).GetFiles())
                    {
                        DataRow row = files.NewRow();
                        row["file"] = file.Name;
                        if (file.Name.ToLower().EndsWith(".png") && LoadPNG.Checked)
                        {
                            files.Rows.Add(row);
                        }
                        else if (file.Name.ToLower().EndsWith(".jpg") && LoadJPG.Checked)
                        {
                            files.Rows.Add(row);
                        }
                        else if (file.Name.ToLower().EndsWith(".jpeg") && LoadJPG.Checked)
                        {
                            files.Rows.Add(row);
                        }
                    }

                    foreach (DataRow file in files.Select("", "file"))
                    {
                        ItemList.Items.Add(file["file"].ToString());
                    }
                }

                if (ShowThumbCB.Checked)
                {
                    ShowThumb_Click(Type.Missing, EventArgs.Empty);
                }
            }
        }

        private void SetDir_Click(object sender, EventArgs e)
        {
            string dir = System.IO.Directory.GetCurrentDirectory();

            FolderBrowserDialog file = new FolderBrowserDialog();
            file.ShowDialog();

            System.IO.Directory.SetCurrentDirectory(dir);

            if (file.SelectedPath != "")
            {
                Dir.Text = file.SelectedPath;
            }
        }

        private void DeleteBlank_Click(object sender, EventArgs e)
        {
            if (ItemList.SelectedItems[0].Text == blank)
            {
                ItemList.Items[ItemList.SelectedItems[0].Index].Remove();
            }
        }

        private void YUM_Assembler_Load(object sender, EventArgs e)
        {
            SetTileSize_Click(Type.Missing, EventArgs.Empty);

            this.Height = 768 - 40;
        }

        private void ItemList_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.Modifiers == Keys.Shift)
            {
                e.Handled = true;
                string key = "," + e.KeyData.ToString().ToLower().Replace(" ", "") + ",";
                if (key.IndexOf(",left,") != -1)
                {
                    MoveListViewItem(ref ItemList, true);
                }
                else if (key.IndexOf(",right,") != -1)
                {
                    MoveListViewItem(ref ItemList, false);
                }
                else if (key.IndexOf(",up,") != -1)
                {
                    int i = Int32.Parse(ItemWidthNum.Text);
                    while (i > 0)
                    {
                        MoveListViewItem(ref ItemList, true);
                        i--;
                    }
                }
                else if (key.IndexOf(",down,") != -1)
                {
                    int i = Int32.Parse(ItemWidthNum.Text);
                    while (i > 0)
                    {
                        MoveListViewItem(ref ItemList, false);
                        i--;
                    }
                }
                else if (key.IndexOf(",space,") != -1)
                {
                    AddBlank_Click(Type.Missing, EventArgs.Empty);
                }
                else if (key.IndexOf(",back,") != -1)
                {
                    DeleteBlank_Click(Type.Missing, EventArgs.Empty);
                }
            }
        }

        private void Span50K_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            SpanW.Text = "15";
            SpanH.Text = "10";
        }

        private void Span100K_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            SpanW.Text = "30";
            SpanH.Text = "20";
        }

        private void Span200K_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            SpanW.Text = "60";
            SpanH.Text = "40";
        }

        private bool ThumbnailCallback()
        {
            return false;
        }

        private void ShowThumb_Click(object sender, EventArgs e)
        {
            SetTileSize_Click(Type.Missing, EventArgs.Empty);

            ThumbProg.Text = "Starting";
            Application.DoEvents();

            int tsize = Int32.Parse(TileSize.Text) - 10;

            PreviewsIL.Images.Clear();
            int ili = 0;

            int i = 0;
            while (i < ItemList.Items.Count)
            {
                if (ItemList.Items[i].Text != blank)
                {
                    FileStream image_file = new FileStream(Dir.Text + "\\" + ItemList.Items[i].Text, FileMode.Open);
                    Image file_image = new Bitmap(image_file).GetThumbnailImage(tsize, tsize, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero);
                    image_file.Close();

                    PreviewsIL.Images.Add(file_image);

                    ItemList.Items[i].ImageIndex = ili;

                    ili++;
                }

                i++;

                ThumbProg.Text = i.ToString() + " of " + ItemList.Items.Count.ToString();
                Application.DoEvents();
            }

            ThumbProg.Text = "Done";
            Application.DoEvents();

            MessageBox.Show("Done");
        }

        private void SetTileSize_Click(object sender, EventArgs e)
        {
            int i = 0;
            while (i < ItemList.Items.Count)
            {
                ItemList.Items[i].ImageIndex = -1;
                i++;
            }
            PreviewsIL.Images.Clear();

            ItemList.TileSize = new Size(Int32.Parse(TileSize.Text), Int32.Parse(TileSize.Text));

            PreviewsIL.ImageSize = new Size(Int32.Parse(TileSize.Text) - 10, Int32.Parse(TileSize.Text) - 10);

            ItemWidth_Click(Type.Missing, EventArgs.Empty);

            if (e != EventArgs.Empty)
            {
                ShowThumb_Click(Type.Missing, EventArgs.Empty);
            }
        }

        private void SaveYUM_Click(object sender, EventArgs e)
        {
            if (TLlatDeg.Text == "" || TLlatMin.Text == "" || TLlonDeg.Text == "" || TLlonMin.Text == "" || SpanW.Text == "" || SpanH.Text == "")
            {
                MessageBox.Show("Coordinates not set");
            }
            else
            {
                LayoutCSV_LinkClicked_Proc(false);

                decimal TLlatH = Decimal.Parse(TLlatDeg.Text) + Decimal.Parse(TLlatMin.Text) / 60;
                decimal TLlonW = Decimal.Parse(TLlonDeg.Text) + Decimal.Parse(TLlonMin.Text) / 60;
                decimal spanW = Decimal.Parse(SpanW.Text) / 60;
                decimal spanH = Decimal.Parse(SpanH.Text) / 60;

                YumProg.Text = "Starting";
                Application.DoEvents();

                string yum_name = Dir.Text + "\\dir.yum";

                StreamWriter yum = new StreamWriter(yum_name, false);

                yum.WriteLine("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>");
                yum.WriteLine("<MapGrinderMashupFile Version=\"1.7\">");
                yum.WriteLine("  <RenderOptions>");
                yum.WriteLine("    <PublishSourceData Value=\"False\" />");
                yum.WriteLine("    <PermitComposition Value=\"False\" />");
                yum.WriteLine("    <Output Folder=\"" + "MC_rendered" + "\" />");
                yum.WriteLine("  </RenderOptions>");
                yum.WriteLine("  <LayerList>");
                yum.WriteLine("    <Layer DisplayName=\"New Layer\" Expanded=\"True\" id=\"0\">");

                int SourceMapID = 1;

                decimal x_offset = 0;
                decimal y_offset = 0;
                int i = 0;
                while (i < ItemList.Items.Count)
                {
                    if (ItemList.Items[i].Text != blank)
                    {
                        #region header
                        string displayN = ItemList.Items[i].Text;
                        displayN = displayN.Substring(0, displayN.LastIndexOf("."));

                        yum.WriteLine("      <SourceMap DisplayName=\"" + displayN + "\" Expanded=\"False\" id=\"" + SourceMapID.ToString() + "\">");
                        yum.WriteLine("        <Document>");
                        yum.WriteLine("          <FileDocument Filename=\"" + ItemList.Items[i].Text + "\" PageNumber=\"0\" />");
                        yum.WriteLine("        </Document>");
                        yum.WriteLine("        <SourceMapInfo>");
                        yum.WriteLine("          <MapFileURL url=\"\" />");
                        yum.WriteLine("          <MapHomePage url=\"\" />");
                        yum.WriteLine("          <MapDescription />");
                        yum.WriteLine("        </SourceMapInfo>");
                        if (DirZoom.Text != "")
                        {
                            yum.WriteLine("        <SourceMapRenderOptions MaxZoom=\"" + DirZoom.Text + "\" />"); // will auto calc?
                        }
                        yum.WriteLine("        <TransparencyOptions Enabled=\"True\" Inverted=\"False\" />");
                        yum.WriteLine("        <SourceMapView locked=\"False\">");
                        yum.WriteLine("          <SourceMapPosition>");
                        yum.WriteLine("            <LatLonZoom zoom=\"5\">");
                        yum.WriteLine("              <LatLon lat=\"0.5\" lon=\"0.5\" />");
                        yum.WriteLine("            </LatLonZoom>");
                        yum.WriteLine("          </SourceMapPosition>");
                        yum.WriteLine("          <ReferenceMapPosition>");
                        yum.WriteLine("            <MapPosition>");
                        yum.WriteLine("              <LatLonZoom zoom=\"" + "1" + "\">");
                        yum.WriteLine("                <LatLon lat=\"" + "0" + "\" lon=\"" + "0" + "\" />");
                        yum.WriteLine("              </LatLonZoom>");
                        yum.WriteLine("            </MapPosition>");
                        yum.WriteLine("          </ReferenceMapPosition>");
                        yum.WriteLine("        </SourceMapView>");
                        yum.WriteLine("        <RegistrationDefinition WarpQuality=\"Automatic\">");
                        #endregion

                        FileStream image_file = new FileStream(Dir.Text + "\\" + ItemList.Items[i].Text, FileMode.Open);
                        Bitmap file_image = new Bitmap(image_file);
                        image_file.Close();

                        int h = file_image.Height;
                        int w = file_image.Width;

                        int max = h;
                        if (w > max)
                            max = w;

                        #region scan

                        int offset;
                        bool got_corner;

                        offset = 0;
                        got_corner = false;
                        int TLx = 0;
                        int TLy = 0;
                        while (got_corner == false)
                        {
                            TLy = offset;
                            TLx = 0;
                            while (TLy >= 0 && got_corner == false)
                            {
                                Color this_pixel = file_image.GetPixel(TLx, TLy);
                                if (this_pixel.A != 0)
                                    got_corner = true;
                                if (got_corner == false)
                                {
                                    TLy--;
                                    TLx++;
                                }
                            }
                            offset++;
                        }

                        offset = 0;
                        got_corner = false;
                        int TRx = 0;
                        int TRy = 0;
                        while (got_corner == false)
                        {
                            TRy = offset;
                            TRx = 0;
                            while (TRy >= 0 && got_corner == false)
                            {
                                Color this_pixel = file_image.GetPixel(w - 1 - TRx, TRy);
                                if (this_pixel.A != 0)
                                    got_corner = true;
                                if (got_corner == false)
                                {
                                    TRy--;
                                    TRx++;
                                }
                            }
                            offset++;
                        }

                        offset = 0;
                        got_corner = false;
                        int BRx = 0;
                        int BRy = 0;
                        while (got_corner == false)
                        {
                            BRy = offset;
                            BRx = 0;
                            while (BRy >= 0 && got_corner == false)
                            {
                                Color this_pixel = file_image.GetPixel(w - 1 - BRx, h - 1 - BRy);
                                if (this_pixel.A != 0)
                                    got_corner = true;
                                if (got_corner == false)
                                {
                                    BRy--;
                                    BRx++;
                                }
                            }
                            offset++;
                        }

                        offset = 0;
                        got_corner = false;
                        int BLx = 0;
                        int BLy = 0;
                        while (got_corner == false)
                        {
                            BLy = offset;
                            BLx = 0;
                            while (BLy >= 0 && got_corner == false)
                            {
                                Color this_pixel = file_image.GetPixel(BLx, h - 1 - BLy);
                                if (this_pixel.A != 0)
                                    got_corner = true;
                                if (got_corner == false)
                                {
                                    BLy--;
                                    BLx++;
                                }
                            }
                            offset++;
                        }

                        // mids

                        got_corner = false;
                        int TCx = (TLx + w - TRx) / 2; // check rounding
                        int TCy = 0;
                        while (got_corner == false)
                        {
                            while (got_corner == false)
                            {
                                Color this_pixel = file_image.GetPixel(TCx, TCy);
                                if (this_pixel.A != 0)
                                    got_corner = true;
                                if (got_corner == false)
                                {
                                    TCy++;
                                }
                            }
                        }

                        got_corner = false;
                        int BCx = (BLx + w - BRx) / 2;
                        int BCy = 0;
                        while (got_corner == false)
                        {
                            while (got_corner == false)
                            {
                                Color this_pixel = file_image.GetPixel(BCx, h - 1 - BCy);
                                if (this_pixel.A != 0)
                                    got_corner = true;
                                if (got_corner == false)
                                {
                                    BCy++;
                                }
                            }
                        }

                        got_corner = false;
                        int MLx = 0;
                        int MLy = (TLy + h - BLy) / 2;
                        while (got_corner == false)
                        {
                            while (got_corner == false)
                            {
                                Color this_pixel = file_image.GetPixel(MLx, MLy);
                                if (this_pixel.A != 0)
                                    got_corner = true;
                                if (got_corner == false)
                                {
                                    MLx++;
                                }
                            }
                        }

                        got_corner = false;
                        int MRx = 0;
                        int MRy = (TRy + h - BRy) / 2;
                        while (got_corner == false)
                        {
                            while (got_corner == false)
                            {
                                Color this_pixel = file_image.GetPixel(w - 1 - MRx, MRy);
                                if (this_pixel.A != 0)
                                    got_corner = true;
                                if (got_corner == false)
                                {
                                    MRx++;
                                }
                            }
                        }

                        #endregion

                        file_image.Dispose();

                        #region pins

                        decimal TL_y = (decimal)h - (decimal)TLy;
                        decimal TL_x = (decimal)TLx;

                        decimal TR_y = (decimal)h - (decimal)TRy;
                        decimal TR_x = (decimal)w - (decimal)TRx;

                        decimal BR_y = (decimal)BRy;
                        decimal BR_x = (decimal)w - (decimal)BRx;

                        decimal BL_y = (decimal)BLy;
                        decimal BL_x = (decimal)BLx;

                        // mids

                        decimal TC_y = (decimal)h - (decimal)TCy;
                        decimal TC_x = (decimal)TCx;

                        decimal BC_y = (decimal)BCy;
                        decimal BC_x = (decimal)BCx;

                        decimal ML_y = (decimal)h - (decimal)MLy;
                        decimal ML_x = (decimal)MLx;

                        decimal MR_y = (decimal)h - (decimal)MRy;
                        decimal MR_x = (decimal)w - (decimal)MRx;

                        WritePin(yum, 0, "TL", max, TL_y, TL_x, TLlatH - spanH * (y_offset + (decimal)0), TLlonW + spanW * (x_offset + (decimal)0));
                        WritePin(yum, 1, "TC", max, TC_y, TC_x, TLlatH - spanH * (y_offset + (decimal)0), TLlonW + spanW * (x_offset + (decimal)0.5));
                        WritePin(yum, 2, "TR", max, TR_y, TR_x, TLlatH - spanH * (y_offset + (decimal)0), TLlonW + spanW * (x_offset + (decimal)1));

                        WritePin(yum, 3, "ML", max, ML_y, ML_x, TLlatH - spanH * (y_offset + (decimal)0.5), TLlonW + spanW * (x_offset + (decimal)0));
                        WritePin(yum, 4, "MC", max, (TC_y + BC_y) / 2, (ML_x + MR_x) / 2, TLlatH - spanH * (y_offset + (decimal)0.5), TLlonW + spanW * (x_offset + (decimal)0.5));
                        WritePin(yum, 5, "MR", max, MR_y, MR_x, TLlatH - spanH * (y_offset + (decimal)0.5), TLlonW + spanW * (x_offset + (decimal)1));

                        WritePin(yum, 6, "BL", max, BL_y, BL_x, TLlatH - spanH * (y_offset + (decimal)1), TLlonW + spanW * (x_offset + (decimal)0));
                        WritePin(yum, 7, "BC", max, BC_y, BC_x, TLlatH - spanH * (y_offset + (decimal)1), TLlonW + spanW * (x_offset + (decimal)0.5));
                        WritePin(yum, 8, "BR", max, BR_y, BR_x, TLlatH - spanH * (y_offset + (decimal)1), TLlonW + spanW * (x_offset + (decimal)1));
                        #endregion

                        #region footer
                        yum.WriteLine("        </RegistrationDefinition>");
                        yum.WriteLine("        <RenderRegion>");
                        yum.WriteLine("          <LatLon lat=\"" + ((decimal)h / (decimal)max).ToString() + "\" lon=\"0\" />");
                        yum.WriteLine("          <LatLon lat=\"" + "0" + "\" lon=\"0\" />");
                        yum.WriteLine("          <LatLon lat=\"" + "0" + "\" lon=\"" + ((decimal)w / (decimal)max).ToString() + "\" />");
                        yum.WriteLine("          <LatLon lat=\"" + ((decimal)h / (decimal)max).ToString() + "\" lon=\"" + ((decimal)w / (decimal)max).ToString() + "\" />");
                        yum.WriteLine("        </RenderRegion>");
                        yum.WriteLine("        <LegendList />");
                        yum.WriteLine("      </SourceMap>");
                        #endregion

                        SourceMapID++;
                    }

                    x_offset++;
                    if (x_offset == Decimal.Parse(ItemWidthNum.Text))
                    {
                        x_offset = 0;
                        y_offset++;
                    }
                    i++;

                    YumProg.Text = i.ToString() + " of " + ItemList.Items.Count.ToString();
                    Application.DoEvents();
                }

                yum.WriteLine("      <LayerView>");
                yum.WriteLine("        <MapPosition>");
                yum.WriteLine("          <LatLonZoom zoom=\"" + "5" + "\">");
                yum.WriteLine("            <LatLon lat=\"" + TLlatH.ToString().Replace(",", ".") + "\" lon=\"" + TLlonW.ToString().Replace(",", ".") + "\" />");
                yum.WriteLine("          </LatLonZoom>");
                yum.WriteLine("        </MapPosition>");
                yum.WriteLine("      </LayerView>");
                yum.WriteLine("    </Layer>");
                yum.WriteLine("  </LayerList>");
                yum.WriteLine("</MapGrinderMashupFile>");
                yum.Close();

                YumProg.Text = "Done";
                Application.DoEvents();

                MessageBox.Show("Done: " + yum_name);
            }
        }

        private void WritePin(StreamWriter yum, int pinId, string pinName, int max, decimal y, decimal x, decimal lat, decimal lon)
        {
            yum.WriteLine("          <PositionAssociation pinId=\"" + pinId.ToString() + "\" associationName=\"" + pinName + "\">");
            yum.WriteLine("            <SourcePosition>");
            yum.WriteLine("              <LatLonZoom zoom=\"5\">"); // need to set, will def? (what if lock = true?)
            string laty = (y / (decimal)max).ToString().Replace(",", ".");
            string lonx = (x / (decimal)max).ToString().Replace(",", ".");
            yum.WriteLine("                <LatLon lat=\"" + laty + "\" lon=\"" + lonx + "\" />");
            yum.WriteLine("              </LatLonZoom>");
            yum.WriteLine("            </SourcePosition>");
            yum.WriteLine("            <GlobalPosition>");
            yum.WriteLine("              <LatLonZoom zoom=\"" + "5" + "\">"); // just because (looks unused)
            yum.WriteLine("                <LatLon lat=\"" + lat.ToString().Replace(",", ".") + "\" lon=\"" + lon.ToString().Replace(",", ".") + "\" />");
            yum.WriteLine("              </LatLonZoom>");
            yum.WriteLine("            </GlobalPosition>");
            yum.WriteLine("          </PositionAssociation>");
        }

        private void YumCruncherBTN_Click(object sender, EventArgs e)
        {
            new YumCruncher().ShowDialog();
        }

        private void LayoutCSV_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            LayoutCSV_LinkClicked_Proc(true);
        }

        private void LayoutCSV_LinkClicked_Proc(bool do_msg)
        {
            StreamWriter sw = new StreamWriter(Dir.Text + "\\dir.layout", false);
            sw.WriteLine("#TLlatDeg#" + TLlatDeg.Text);
            sw.WriteLine("#TLlatMin#" + TLlatMin.Text);
            sw.WriteLine("#TLlonDeg#" + TLlonDeg.Text);
            sw.WriteLine("#TLlonMin#" + TLlonMin.Text);
            sw.WriteLine("#SpanW#" + SpanW.Text);
            sw.WriteLine("#SpanH#" + SpanH.Text);
            sw.WriteLine("#DirZoom#" + DirZoom.Text);
            sw.WriteLine("#TileSize#" + TileSize.Text);
            sw.WriteLine("#ItemWidthNum#" + ItemWidthNum.Text);
            int j = 0;
            while (j < ItemList.Items.Count)
            {
                sw.WriteLine(ItemList.Items[j].Text);
                j++;
            }
            sw.Close();

            StreamWriter sw2 = new StreamWriter(Dir.Text + "\\dir.csv", false);
            int x = 0;
            j = 0;
            while (j < ItemList.Items.Count)
            {
                sw2.Write(ItemList.Items[j].Text + ",");
                x++;
                if (x == Int32.Parse(ItemWidthNum.Text))
                {
                    sw2.Write("\n");
                    x = 0;
                }
                j++;
            }
            sw2.Close();

            if (do_msg)
            {
                MessageBox.Show("Done: " + Dir.Text + "\\dir.layout and dir.csv");
            }
        }
    }
}