using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;
using System.Net;

using System.Diagnostics;

namespace GMDL
{
    public partial class UpdateCheck : Form
    {
        private WebClient wc;

        public UpdateCheck(string this_version, WebClient WC)
        {
            wc = WC;

            bool do_check = true;
            if (new FileInfo("config.txt").Exists)
                if (new StreamReader("config.txt").ReadToEnd().Replace(" ", "").ToUpper().IndexOf("UPDATE=0") != -1)
                    do_check = false;

            if (do_check)
            {
                string updateURL = "";
                string UPDversion = "";
                try
                {
                    string page = wc.DownloadString("http://www.in7ane.com/psp/gmdl.txt");
                    UPDversion = page.Substring(0, page.IndexOf("\n"));
                    string url = page.Substring(page.IndexOf("\n") + 1, page.Length - 1 - page.IndexOf("\n"));

                    if (string.Compare(this_version, UPDversion.Replace("\0", "")) < 0)
                        updateURL = url;
                }
                catch { }

                if (updateURL != "")
                {
                    InitializeComponent();

                    this.Text = this_version;

                    getURL.Text = updateURL;
                    getName.Text = UPDversion;

                    this.ShowDialog();
                    
                }
                else
                {
                    this.Dispose();
                }
            }
            else
            {
                this.Dispose();
            }
        }

        private void GetIt_Click(object sender, EventArgs e)
        {
            Process proc = new Process();
            proc.StartInfo.FileName = getURL.Text;
            proc.Start();

            Application.Exit();
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Process proc = new Process();
            proc.StartInfo.FileName = linkLabel1.Text;
            proc.Start();
        }
    }
}