using System;
using System.Collections.Generic;
using System.Text;

using System.Windows.Forms;

using System.IO;

using System.Data;

namespace GMDL
{
    class ToolTips
    {
        public void GenerateFile(Form form, ToolTip tt)
        {
            StreamWriter sr = new StreamWriter("tooltips.txt", true);
            foreach (Control cont in form.Controls)
            {
                if (cont.Name != "")
                    sr.WriteLine(form.Name + "." + cont.Name + "(" + cont.Text + ")=" + tt.GetToolTip(cont));
                
                GenerateString(cont, form.Name, sr, tt);
            }
            sr.Close();
        }

        private void GenerateString(Control control, string form, StreamWriter sr, ToolTip tt)
        {
            foreach (Control cont in control.Controls)
            {
                if (cont.Name != "")
                    sr.WriteLine(form + "." + cont.Name + "(" + cont.Text + ")=" + tt.GetToolTip(cont));

                GenerateString(cont, form, sr, tt);
            }
        }

        public void LoadFile(Form form, ToolTip tt)
        {
            if (new FileInfo("tooltips.txt").Exists)
            {
                try
                {
                    bool file_ok = true;

                    DataTable trans = new DataTable();
                    trans.Columns.Add("Form", typeof(String));
                    trans.Columns.Add("Control", typeof(String));
                    trans.Columns.Add("New", typeof(String));

                    try
                    {
                        StreamReader sr = new StreamReader("tooltips.txt");

                        while (sr.EndOfStream == false)
                        {
                            string line = sr.ReadLine();
                            DataRow new_row = trans.NewRow();

                            new_row["Form"] = line.Substring(0, line.IndexOf("."));
                            new_row["Control"] = line.Substring(line.IndexOf(".") + 1, line.IndexOf("(") - 1 - line.IndexOf("."));
                            new_row["New"] = line.Substring(line.LastIndexOf(")=") + 2, line.Length - 2 - line.LastIndexOf(")="));

                            if (new_row["New"].ToString() != "")
                                trans.Rows.Add(new_row);
                        }
                    }
                    catch
                    {
                        file_ok = false;
                        MessageBox.Show("Invalid tooltips.txt file");
                    }

                    if (file_ok)
                    {
                        foreach (Control cont in form.Controls)
                        {
                            if (cont.Name != "")
                            {
                                foreach (DataRow Trow in trans.Select("Form = '" + form.Name + "' AND Control = '" + cont.Name + "' AND New <> ''"))
                                {
                                    tt.SetToolTip(cont, Trow["New"].ToString());
                                }
                            }
                            LoadControl(cont, form.Name, trans, tt);
                        }
                    }
                }
                catch
                {
                    MessageBox.Show("Something went wrong while applying the translation");
                }
            }
        }

        private void LoadControl(Control control, string form, DataTable trans, ToolTip tt)
        {
            foreach (Control cont in control.Controls)
            {
                if (cont.Name != "")
                {
                    foreach (DataRow Trow in trans.Select("Form = '" + form + "' AND Control = '" + cont.Name + "' AND New <> ''"))
                    {
                        tt.SetToolTip(cont, Trow["New"].ToString());
                    }
                }
                LoadControl(cont, form, trans, tt);
            }
        }
    }
}
