using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Net;

namespace GMDL
{
    public partial class SetProxy : Form
    {
        WebClient wc;
        public SetProxy(WebClient WC)
        {
            InitializeComponent();

            wc = WC;
        }

        private void Cancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void Set_Click(object sender, EventArgs e)
        {
            // thanks to harpik and dloading
            // -- better NTLM support by dloading --
            try
            {
                WebProxy mp = new WebProxy(Proxy.Text, true);
                NetworkCredential myCred = null;
                if (Domain.Text.CompareTo("") == 0)
                {
                    // If user did not write domain its authentication method don't need it
                    myCred = new NetworkCredential(User.Text, Pass.Text);
                }
                else
                {
                    // If user put domain we need to use it, maybe he authenticate against NT Lan Manager 
                    myCred = new NetworkCredential(User.Text, Pass.Text, Domain.Text);
                }
                mp.Credentials = myCred;
                wc.Proxy = mp; // "wc" is the WebClient object 

                this.Close();
            }
            catch
            {
                MessageBox.Show("That doesn't seem to work, try again");
            }
            
        }
    }
}