using System;
using System.Collections.Generic;
using System.Text;

namespace GMDL
{
    class RT90
    {
        /*
// version 5 2004-11-23
// By Bengt Madeberg, SM6MUY

function sind($x) {
     return sin(pi()*$x/180);
}
function cosd($x) {
     return cos(pi()*$x/180);
}
function atand($x) {
     return 180*atan($x)/pi();
}

function sweref99_to_rt90($x,$y,$z) {
     //Transformation SWEREF99 (x,y,z) to RT90 ($X,$Y,$Z) Helmert formula
     $dX=-414.0978567149;
     $dY=-41.3381489658;
     $dZ=-603.0627177516;
     $wx=-0.8550434314/3600*(pi()/180);
     $wy=2.1413465185/3600*(pi()/180);
     $wz=-7.0227209516/3600*(pi()/180);
     $eps=0.0000000000;
     $R11=cos($wy)*cos($wz);
     $R12=cos($wx)*sin($wz)+sin($wx)*sin($wy)*cos($wz);
     $R13=-cos($wx)*sin($wy)*cos($wz)+sin($wx)*sin($wz);
     $R21=-cos($wy)*sin($wz);
     $R22=cos($wx)*cos($wz)-sin($wx)*sin($wy)*sin($wz);
     $R23=sin($wx)*cos($wz)+cos($wx)*sin($wy)*sin($wz);
     $R31=sin($wy);
     $R32=-sin($wx)*cos($wy);
     $R33=cos($wx)*cos($wy);
     $X=(1+$eps)*($R11*$x+$R12*$y+$R13*$z)+$dX;
     $Y=(1+$eps)*($R21*$x+$R22*$y+$R23*$z)+$dY;
     $Z=(1+$eps)*($R31*$x+$R32*$y+$R33*$z)+$dZ;
     return array($X,$Y,$Z);
}

function rt90_to_sweref99($x,$y,$z) {
     //Transformation RT90  (x,y,z) to SWEREF99  (X,Y,Z) Helmert formula
     $dX=414.1055246174;
     $dY=41.3265500042;
     $dZ=603.0582474221;
     $wx=0.8551163377/3600*(pi()/180);
     $wy=-2.1413174055/3600*(pi()/180);
     $wz=7.0227298286/3600*(pi()/180);
     $eps=0.0000000000;
     $R11=cos($wy)*cos($wz);
     $R12=cos($wx)*sin($wz)+sin($wx)*sin($wy)*cos($wz);
     $R13=-cos($wx)*sin($wy)*cos($wz)+sin($wx)*sin($wz);
     $R21=-cos($wy)*sin($wz);
     $R22=cos($wx)*cos($wz)-sin($wx)*sin($wy)*sin($wz);
     $R23=sin($wx)*cos($wz)+cos($wx)*sin($wy)*sin($wz);
     $R31=sin($wy);
     $R32=-sin($wx)*cos($wy);
     $R33=cos($wx)*cos($wy);
     $X=(1+$eps)*($R11*$x+$R12*$y+$R13*$z)+$dX;
     $Y=(1+$eps)*($R21*$x+$R22*$y+$R23*$z)+$dY;
     $Z=(1+$eps)*($R31*$x+$R32*$y+$R33*$z)+$dZ;
     return array($X,$Y,$Z);
}

function plh_to_xyz($phi,$lam,$h,$rs) {
     // Transformation phi,lamda,h to x,y,z (RT90)
     if ($rs=='RT90') {
         // Bessel 1841
         $a=6377397.155;
         $f=1/299.1528128;
         } else {
         // GRS1980
         $a=6378137;
         $f=1/298.257222101;
         }
     $e2=$f*(2-$f);
     $N=$a/(sqrt(1-$e2*pow(sind($phi),2)));
     $X=($N+$h)*cosd($phi)*cosd($lam);
     $Y=($N+$h)*cosd($phi)*sind($lam);
     $Z=($N*(1-$e2)+$h)*sind($phi);
     return array($X,$Y,$Z);
}

function xyz_to_plh($x,$y,$z,$rs) {
     // Transformation x,y,z to phi,lamda,h (SWEREF99)
     if ($rs=='RT90') {
         // Bessel 1841
         $a=6377397.155;
         $f=1/299.1528128;
         } else {
         // GRS1980
         $a=6378137;
         $f=1/298.257222101;
         }
     $e2=$f*(2-$f);
     $lam=atand($y/$x);
     $p=sqrt($x*$x+$y*$y);
     $the=atan($z/($p*sqrt(1-$e2)));
 
$phi=atand(($z+($a*$e2)/sqrt(1-$e2)*pow(sin($the),3))/($p-$a*$e2*pow(cos($the),3)));
     $N=$a/(sqrt(1-$e2*pow(sind($phi),2)));
     $h=($p/cosd($phi))-$N;
     return array($phi,$lam,$h);
}


function latlon_to_xy($phi, $lambda) {
     // Transformation phi, lamda to x,y (RT90) Krgers Formulas
     // Bessel 1841
     $a = 6377397.155;
     $f = 1/299.1528128;
     $lambda0 = 15.808277777778 * pi() / 180;
     $FN =0;
     $FE =1500000;
     $k0=1.000000000000;

     $e2 = $f * (2 - $f);
     $n =  $f / (2 - $f);
     $aa = $a / (1 + $n) * (1 + 1/4 * pow($n,2) + 1/64 * pow($n,4));

     $beta1 = 1/2 * $n - 2/ 3 * pow($n,2) + 5/16 * pow($n,3) +    41/180 
* pow($n,4);
     $beta2 =           13/48 * pow($n,2) -  3/5 * pow($n,3) +  557/1440 
* pow($n,4);
     $beta3 =                           61/240 * pow($n,3) -   103/140 * 
pow($n,4);
     $beta4 =                                           49561/161280 * 
pow($n,4);

     $A = $e2;
     $B = 1/6 * (5 * pow($e2,2) - pow($e2,3));
     $C =        1/120 * (104 * pow($e2,3) - 45 * pow($e2,4));
     $D =                      1/1260 * (1237 * pow($e2,4));

     $lambda = $lambda * pi() / 180;
     $phi =    $phi *    pi() / 180;

     $phix = $phi - sin($phi) * cos($phi) * ($A +
                         $B * pow(sin($phi),2) +
                         $C * pow(sin($phi),4) +
                         $D * pow(sin($phi),6));
     $dlambda = $lambda - $lambda0;

     $xip = atan2(tan($phix), cos($dlambda));
     $etap = atanh(cos($phix) * sin($dlambda));

     $x = $k0 * $aa * ($xip +
                    $beta1 * sin(2 * $xip) * cosh(2 * $etap) +
                    $beta2 * sin(4 * $xip) * cosh(4 * $etap) +
                    $beta3 * sin(6 * $xip) * cosh(6 * $etap) +
                    $beta4 * sin(8 * $xip) * cosh(8 * $etap)) + $FN;
     $y = $k0 * $aa * ($etap +
                    $beta1 * cos(2 * $xip) * sinh(2 * $etap) +
                    $beta2 * cos(4 * $xip) * sinh(4 * $etap) +
                    $beta3 * cos(6 * $xip) * sinh(6 * $etap) +
                    $beta4 * cos(8 * $xip) * sinh(8 * $etap)) + $FE;
     return array($x, $y);
}

function xy_to_latlon($x, $y) {
     // Transformation x,y to phi, lamda (RT90) Krgers Formulas
     // Bessel 1841
     $a = 6377397.155;
     $f = 1/299.1528128;
     $lambda0 = 15.808277777778 * pi() / 180;
     $FN =0;
     $FE =1500000;
     $k0=1.000000000000;


     $e2 = $f * (2 - $f);
     $n =  $f / (2 - $f);
     $aa = $a / (1 + $n) * (1 + 1/4 * pow($n,2) + 1/64 * pow($n,4));

     $delta1 = 1/2 * $n - 2/3 * pow($n,2) + 37/96 * pow($n,3) -    1/360 
* pow($n,4);
     $delta2 =           1/48 * pow($n,2) +  1/15 * pow($n,3) - 437/1440 
* pow($n,4);
     $delta3 =                           17/480 * pow($n,3) -   37/840 * 
pow($n,4);
     $delta4 =                                           4397/161280 * 
pow($n,4);

     $Ap =          $e2 + pow($e2,2) +      pow($e2,3) +       pow($e2,4);
     $Bp =  -1/6 * (  7 * pow($e2,2) + 17 * pow($e2,3) +  30 * pow($e2,4));
     $Cp =                 1/120 * (224 * pow($e2,3) + 889 * pow($e2,4));
     $Dp =                                -1/1260 * (4279 * pow($e2,4));


     $xi =  ($x - $FN) / ($k0 * $aa);
     $eta = ($y - $FE) / ($k0 * $aa);

     $xip = $xi -
                   $delta1 * sin(2 * $xi) * cosh(2 * $eta) -
                    $delta2 * sin(4 * $xi) * cosh(4 * $eta) -
         $delta3 * sin(6 * $xi) * cosh(6 * $eta) -
         $delta4 * sin(8 * $xi) * cosh(8 * $eta);

     $etap = $eta -
            $delta1 * cos(2 * $xi) * sinh(2 * $eta) -
                 $delta2 * cos(4 * $xi) * sinh(4 * $eta) -
               $delta3 * cos(6 * $xi) * sinh(6 * $eta) -
             $delta4 * cos(8 * $xi) * sinh(8 * $eta);


     $phix = asin(sin($xip) / cosh($etap));
     $dlambda = atan2(sinh($etap), cos($xip));

     $lambda = $lambda0 + $dlambda;

     $phi = $phix + sin($phix) * cos($phix) * ($Ap +
                            $Bp * pow(sin($phix),2) +
                              $Cp * pow(sin($phix),4) +
                                $Dp * pow(sin($phix),6));

     return array($phi / pi() * 180, $lambda / pi() * 180);
}


        */
    }
}
