using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Globalization;

namespace GMDL
{
    public partial class LatLonToTiles : Form
    {
        LatLonXYcalcs LLXY = new LatLonXYcalcs();

        public LatLonToTiles(string zoom)
        {
            InitializeComponent();

            Mzoom.Text = zoom;
        }

        private void Mzoom_TextChanged(object sender, EventArgs e)
        {
            CalculateXY();
        }

        private void poiLat_TextChanged(object sender, EventArgs e)
        {
            if (poiLat.Text != LLXY.MinutesToProper(poiLat.Text))
                poiLat.Text = LLXY.MinutesToProper(poiLat.Text);

            CalculateXY();
        }

        private void poiLon_TextChanged(object sender, EventArgs e)
        {
            if (poiLon.Text != LLXY.MinutesToProper(poiLon.Text))
                poiLon.Text = LLXY.MinutesToProper(poiLon.Text);

            CalculateXY();
        }

        private void CalculateXY()
        {
            try
            {
                decimal lat = Decimal.Parse(poiLat.Text.Trim(), NumberFormatInfo.InvariantInfo);
                decimal lon = Decimal.Parse(poiLon.Text.Trim(), NumberFormatInfo.InvariantInfo);
                decimal zoom = Decimal.Parse(Mzoom.Text.Trim(), NumberFormatInfo.InvariantInfo);

                int[] XY = LLXY.CalculateXY(lat, lon, zoom);

                Mx.Text = XY[0].ToString();
                My.Text = XY[1].ToString();
            }
            catch
            {
                Mx.Text = "";
                My.Text = "";
            }
        }

        private void btnAccept_Click(object sender, EventArgs e)
        {
            Mzoom.Text = Mzoom.Text.Trim();
            this.Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            Mzoom.Text = "";
            Mx.Text = "";
            My.Text = "";
            this.Close();
        }
    }
}