using System;
using System.Collections.Generic;
using System.Text;

using System.IO;

using System.Data;

using System.Drawing;

namespace GMDL
{
    class GPSFS
    {
        public Bitmap GetGPSFStileReverse(string map_dir, int tile_num)
        {
            //int idx_offset = 48 + (tile_num - 1) * 8;
            int file_num;
            int file_offset;
            int file_size;

            Bitmap bm = new Bitmap(1, 1);

            BinaryReader sr = new BinaryReader(new FileStream(map_dir + "/GPSFS", FileMode.Open));
            try
            {
                sr.BaseStream.Position = 40;
                int maxsize = System.Convert.ToInt32(sr.ReadInt64());

                int idx_offset = 48 + (maxsize - tile_num) * 8;

                sr.BaseStream.Position = idx_offset;
                file_num = sr.ReadInt32();
                file_offset = sr.ReadInt32();
                sr.ReadInt32();
                file_size = sr.ReadInt32();

                if (file_num != 0)
                {
                    sr.Close();
                    sr = new BinaryReader(new FileStream(map_dir + "/GPSFS" + file_num.ToString(), FileMode.Open));
                }

                if (file_size < 0)
                    file_size = file_size * -1;
                else if (file_size > 0)
                    file_size = file_size - file_offset;
                else // if (file_size == 0)
                    file_size = System.Convert.ToInt32(sr.BaseStream.Length) - file_offset;
                sr.BaseStream.Position = file_offset;
                bm = new Bitmap(new MemoryStream(sr.ReadBytes(file_size)));
                sr.Close();
            }
            catch
            {
                try
                {
                    sr.Close();
                }
                catch { }
            }

            return bm;
        }

        public Bitmap GetGPSFStile(string map_dir, int tile_num)
        {
            int idx_offset = 48 + (tile_num - 1) * 8;
            int file_num;
            int file_offset;
            int file_size;

            Bitmap bm = new Bitmap(1,1);

            BinaryReader sr = new BinaryReader(new FileStream(map_dir + "/GPSFS", FileMode.Open));
            try
            {
                sr.BaseStream.Position = idx_offset;
                file_num = sr.ReadInt32();
                file_offset = sr.ReadInt32();
                sr.ReadInt32();
                file_size = sr.ReadInt32();

                if (file_num != 0)
                {
                    sr.Close();
                    sr = new BinaryReader(new FileStream(map_dir + "/GPSFS" + file_num.ToString(), FileMode.Open));
                }

                if (file_size < 0)
                    file_size = file_size * -1;
                else if (file_size > 0)
                    file_size = file_size - file_offset;
                else // if (file_size == 0)
                    file_size = System.Convert.ToInt32(sr.BaseStream.Length) - file_offset;
                sr.BaseStream.Position = file_offset;
                bm = new Bitmap(new MemoryStream(sr.ReadBytes(file_size)));
                sr.Close();
            }
            catch
            {
                try
                {
                    sr.Close();
                }
                catch { }
            }

            return bm;
        }

        public bool ExtractGPSFS(string map_dir)
        {
            bool extracted_ok = true;

            DirectoryInfo td = new DirectoryInfo(map_dir);
            if (td.Exists == false)
                extracted_ok = false; // no directory
            else
                if (new FileInfo(map_dir + "/GPSFS").Exists == false)
                    extracted_ok = false; // gpsfs does not exist

            DirectoryInfo de = new DirectoryInfo(map_dir + "/GPSFS_Extracted");
            if (de.Exists)
                extracted_ok = false;

            if (extracted_ok)
            {
                BinaryReader sr = new BinaryReader(new FileStream(map_dir + "/GPSFS", FileMode.Open));
                try
                {
                    de.Create();

                    string gpsfsv = "";
                    Int64 x = -1;
                    Int64 y = -1;
                    Int64 basezoom = 0;
                    Int64 filetype = -1;
                    Int64 maxsize = -1;

                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();

                    x = sr.ReadInt64();
                    y = sr.ReadInt64();
                    basezoom = sr.ReadInt64();
                    filetype = sr.ReadInt64();
                    maxsize = sr.ReadInt64();

                    if (x >= 0 && y >= 0)
                    {
                        StreamWriter srC = new StreamWriter(map_dir + "/GPSFS_Extracted/coords.txt");
                        srC.WriteLine(x.ToString() + " " + y.ToString() + " " + basezoom.ToString());
                        srC.Close();
                    }

                    string ext;
                    if (filetype == 0)
                        ext = "png";
                    else
                        ext = "jpg";

                    // get N + 1 coords

                    DataTable IDX = new DataTable();
                    IDX.Columns.Add("Location", typeof(String));
                    IDX.Columns.Add("IDXfile", typeof(Int32));
                    IDX.Columns.Add("IDXoffset", typeof(Int32));

                    int top_dir = 0;
                    int tiles = 0;
                    while (tiles < maxsize)
                    {
                        top_dir++;
                        tiles = System.Convert.ToInt32(TotalTiles(top_dir));
                    }

                    // table of tiles loc, with length, length++ (in order)
                    int zoom = 1;
                    while (zoom <= top_dir)
                    {
                        new DirectoryInfo(map_dir + "/GPSFS_Extracted/" + zoom.ToString() + "x").Create();
                        int row = 0;
                        while (row < (top_dir * 2) / zoom)
                        {
                            new DirectoryInfo(map_dir + "/GPSFS_Extracted/" + zoom.ToString() + "x/" + row.ToString("000")).Create();
                            int col = 0;
                            while (col < (top_dir * 2) / zoom)
                            {
                                DataRow new_row = IDX.NewRow();
                                new_row["Location"] = map_dir + "/GPSFS_Extracted/" + zoom.ToString() + "x/" + row.ToString("000") + "/" + zoom.ToString() + "x" + row.ToString("000") + col.ToString("000") + "." + ext;
                                new_row["IDXfile"] = sr.ReadInt32();
                                new_row["IDXoffset"] = sr.ReadInt32();
                                IDX.Rows.Add(new_row);

                                col++;
                            }
                            row++;
                        }
                        zoom = zoom * 2; // will round down to 0
                    }

                    DataRow new_rowE = IDX.NewRow();
                    new_rowE["Location"] = "";
                    new_rowE["IDXfile"] = sr.ReadInt32(); // the last one
                    new_rowE["IDXoffset"] = sr.ReadInt32(); // the last one
                    IDX.Rows.Add(new_rowE);

                    int IDXfile = 0;

                    for (int i = 0; i < maxsize; i++)
                    {
                        if ((int)IDX.Rows[i]["IDXoffset"] >= 0)
                        {
                            int length;
                            if ((int)IDX.Rows[i + 1]["IDXoffset"] > 0)
                            {
                                length = (int)IDX.Rows[i + 1]["IDXoffset"] - (int)IDX.Rows[i]["IDXoffset"];
                            }
                            else if ((int)IDX.Rows[i + 1]["IDXoffset"] < 0)
                            {
                                length = (int)IDX.Rows[i + 1]["IDXoffset"] * -1;
                            }
                            else // if ((int)IDX.Rows[i + 1]["IDXoffset"] == 0)
                            {
                                length = System.Convert.ToInt32(sr.BaseStream.Length) - (int)IDX.Rows[i]["IDXoffset"];
                            }

                            if (IDXfile != (int)IDX.Rows[i]["IDXfile"])
                            {
                                IDXfile = (int)IDX.Rows[i]["IDXfile"];
                                sr.Close();
                                sr = new BinaryReader(new FileStream(map_dir + "/GPSFS" + IDXfile.ToString(), FileMode.Open));
                            }

                            File.WriteAllBytes((string)IDX.Rows[i]["Location"], sr.ReadBytes(System.Convert.ToInt32(length)));
                        }
                    }

                    // empty directories
                    foreach (DirectoryInfo dir_x in new DirectoryInfo(map_dir + "/GPSFS_Extracted").GetDirectories())
                    {
                        foreach (DirectoryInfo dir_n in dir_x.GetDirectories())
                        {
                            if (dir_n.GetFiles().Length == 0)
                                dir_n.Delete();
                        }
                    }
                }
                catch
                {
                    de.Delete(true);
                    extracted_ok = false;
                }

                sr.Close();
            }

            return extracted_ok;
        }

        public bool ExtractGPSFStoSiteDir(string map_dir, bool create_files, bool only_specified, bool create_overlay, bool create_overlay_only_bottom, string pre_path, int one_zoom, bool super_overlay)
        {
            //string pre_path = ""; // http://www.in7ane.com/topomaps/
            //bool create_overlay = true;
            //bool create_overlay_only_bottom = true;
            //bool create_files = true;

            GEsuperOverlay so = new GEsuperOverlay();

            string all = " " + one_zoom.ToString();
            if (create_overlay_only_bottom == false)
            {
                all = " all";
            }

            bool extracted_ok = true;

            DirectoryInfo td = new DirectoryInfo(map_dir);
            if (td.Exists == false)
                extracted_ok = false; // no directory
            else
                if (new FileInfo(map_dir + "/GPSFS").Exists == false)
                    extracted_ok = false; // gpsfs does not exist

            DirectoryInfo de = new DirectoryInfo(map_dir + "/tiles");
            if (create_files)
            {
                if (de.Exists)
                {
                    extracted_ok = false;
                }
            }

            if (extracted_ok)
            {
                StreamWriter sw = new StreamWriter(map_dir + "/overlay" + all + ".kml");

                BinaryReader sr = new BinaryReader(new FileStream(map_dir + "/GPSFS", FileMode.Open));

                LatLonXYcalcs LLXY = new LatLonXYcalcs();

                try
                {
                    if (create_files || only_specified)
                    {
                        de.Create();
                    }

                    if (create_overlay)
                    {
                        string map_name = map_dir;
                        if (map_name.EndsWith("\\"))
                            map_name = map_name.Substring(0, map_name.Length - 1);
                        if (map_name.IndexOf("\\") != -1)
                            map_name = map_name.Substring(map_name.LastIndexOf("\\") + 1, map_name.Length - 1 - map_name.LastIndexOf("\\"));
                        if (map_name.StartsWith("_"))
                            map_name = map_name.Substring(1, map_name.Length - 1);

                        sw.WriteLine("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                        sw.WriteLine("<kml xmlns=\"http://earth.google.com/kml/2.1\">");
                        sw.WriteLine("<Folder>");
                        sw.WriteLine("<name>" + map_name + "</name>");
                        sw.WriteLine("<description>" + (pre_path + " tile overlay").Trim() + "</description>");
                    }
                    else
                    {
                        sw.Close();
                        new FileInfo(map_dir + "/overlay" + all + ".kml").Delete();
                    }

                    string gpsfsv = "";
                    Int64 x = -1;
                    Int64 y = -1;
                    Int64 basezoom = 0;
                    Int64 filetype = -1;
                    Int64 maxsize = -1;

                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();

                    x = sr.ReadInt64();
                    y = sr.ReadInt64();
                    basezoom = sr.ReadInt64();
                    filetype = sr.ReadInt64();
                    maxsize = sr.ReadInt64();

                    int x_off = 0;
                    int y_off = 0;

                    if (x >= 0 && y >= 0)
                    {
                        x_off = System.Convert.ToInt32(x);
                        y_off = System.Convert.ToInt32(y);
                    }

                    string ext;
                    if (filetype == 0)
                        ext = "png";
                    else
                        ext = "jpg";

                    string map_type = "iGESO" + ext + map_dir;

                    // get N + 1 coords

                    DataTable IDX = new DataTable();
                    IDX.Columns.Add("Location", typeof(String));
                    IDX.Columns.Add("IDXfile", typeof(Int32));
                    IDX.Columns.Add("IDXoffset", typeof(Int32));
                    IDX.Columns.Add("x", typeof(Int32));
                    IDX.Columns.Add("y", typeof(Int32));
                    IDX.Columns.Add("z", typeof(Int32));
                    IDX.Columns.Add("path", typeof(String));

                    int top_dir = 0;
                    int tiles = 0;
                    while (tiles < maxsize)
                    {
                        top_dir++;
                        tiles = System.Convert.ToInt32(TotalTiles(top_dir));
                    }

                    int zoom_dir = 0;
                    while (Math.Pow(2, zoom_dir) != top_dir)
                    {
                        zoom_dir++;
                    }
                    zoom_dir++;

                    if (x >= 0 && y >= 0)
                    {
                        zoom_dir = 17 - System.Convert.ToInt32(basezoom);
                    }

                    // table of tiles loc, with length, length++ (in order)
                    int zoom = 1;
                    while (zoom <= top_dir)
                    {
                        if (create_files || (only_specified && 17 - zoom_dir == one_zoom))
                        {
                            new DirectoryInfo(map_dir + "/tiles/" + zoom_dir.ToString()).Create();
                        }
                        int row = 0;
                        bool create_dirs = true;
                        while (row < (top_dir * 2) / zoom)
                        {
                            int col = 0;
                            while (col < (top_dir * 2) / zoom)
                            {
                                if (create_files || (only_specified && 17 - zoom_dir == one_zoom))
                                {
                                    if (create_dirs)
                                    {
                                        new DirectoryInfo(map_dir + "/tiles/" + zoom_dir.ToString() + "/" + (x_off + col).ToString()).Create();
                                    }
                                }

                                DataRow new_row = IDX.NewRow();
                                new_row["Location"] = map_dir + "/tiles/" + zoom_dir.ToString() + "/" + (x_off + col).ToString() + "/" + (y_off + row).ToString() + "." + ext;
                                new_row["IDXfile"] = sr.ReadInt32();
                                new_row["IDXoffset"] = sr.ReadInt32();
                                new_row["x"] = x_off + col;
                                new_row["y"] = y_off + row;
                                new_row["z"] = 17 - zoom_dir;
                                new_row["path"] = "tiles/" + zoom_dir.ToString() + "/" + (x_off + col).ToString() + "/" + (y_off + row).ToString() + "." + ext;
                                IDX.Rows.Add(new_row);

                                col++;
                            }
                            create_dirs = false;
                            row++;
                        }
                        zoom_dir--;
                        x_off /= 2;
                        y_off /= 2;
                        zoom = zoom * 2; // will round down to 0
                    }

                    DataRow new_rowE = IDX.NewRow();
                    new_rowE["Location"] = "";
                    new_rowE["IDXfile"] = sr.ReadInt32(); // the last one
                    new_rowE["IDXoffset"] = sr.ReadInt32(); // the last one
                    IDX.Rows.Add(new_rowE);

                    int IDXfile = 0;

                    int last_z = -99;

                    for (int i = 0; i < maxsize; i++)
                    {
                        if ((int)IDX.Rows[i]["IDXoffset"] >= 0)
                        {
                            if (create_files || only_specified)
                            {
                                int length;
                                if ((int)IDX.Rows[i + 1]["IDXoffset"] > 0)
                                {
                                    length = (int)IDX.Rows[i + 1]["IDXoffset"] - (int)IDX.Rows[i]["IDXoffset"];
                                }
                                else if ((int)IDX.Rows[i + 1]["IDXoffset"] < 0)
                                {
                                    length = (int)IDX.Rows[i + 1]["IDXoffset"] * -1;
                                }
                                else // if ((int)IDX.Rows[i + 1]["IDXoffset"] == 0)
                                {
                                    length = System.Convert.ToInt32(sr.BaseStream.Length) - (int)IDX.Rows[i]["IDXoffset"];
                                }

                                if (IDXfile != (int)IDX.Rows[i]["IDXfile"])
                                {
                                    IDXfile = (int)IDX.Rows[i]["IDXfile"];
                                    sr.Close();
                                    sr = new BinaryReader(new FileStream(map_dir + "/GPSFS" + IDXfile.ToString(), FileMode.Open));
                                }

                                if (create_files || (only_specified && (int)IDX.Rows[i]["z"] == one_zoom))
                                {
                                    File.WriteAllBytes((string)IDX.Rows[i]["Location"], sr.ReadBytes(System.Convert.ToInt32(length)));
                                }
                                else
                                {
                                    sr.BaseStream.Position = sr.BaseStream.Position + length;
                                }
                            }
                            if (create_overlay)
                            {
                                if (create_overlay_only_bottom == false || one_zoom == (int)IDX.Rows[i]["z"])
                                {
                                    decimal[] Tcoord = LLXY.getLatLong((int)IDX.Rows[i]["x"], (int)IDX.Rows[i]["y"], (int)IDX.Rows[i]["z"]); // top left
                                    decimal north = Tcoord[1];
                                    decimal west = Tcoord[0];
                                    decimal[] Bcoord = LLXY.getLatLong((int)IDX.Rows[i]["x"] + 1, (int)IDX.Rows[i]["y"] + 1, (int)IDX.Rows[i]["z"]); // bottom right
                                    decimal south = Bcoord[1];
                                    decimal east = Bcoord[0];

                                    if (last_z != (int)IDX.Rows[i]["z"])
                                    {
                                        if (last_z != -99)
                                        {
                                            sw.WriteLine("</Folder>");
                                        }

                                        last_z = (int)IDX.Rows[i]["z"];

                                        sw.WriteLine("<Folder>");
                                        sw.WriteLine("<name>zoom = " + IDX.Rows[i]["z"].ToString() + "</name>");
                                        //sw.WriteLine("<description></description>");
                                    }

                                    sw.WriteLine("<GroundOverlay>");
                                    sw.WriteLine("<name>x = " + IDX.Rows[i]["x"].ToString() + ", y = " + IDX.Rows[i]["y"].ToString() + "</name>");
                                    sw.WriteLine("<description>" + pre_path + (string)IDX.Rows[i]["path"] + "</description>");
                                    sw.WriteLine("<Icon>");
                                    sw.WriteLine("<href>" + pre_path + (string)IDX.Rows[i]["path"] + "</href>");
                                    sw.WriteLine("</Icon>");
                                    sw.WriteLine("<LatLonBox>");
                                    sw.WriteLine("<north>" + north.ToString() + "</north>");
                                    sw.WriteLine("<south>" + south.ToString() + "</south>");
                                    sw.WriteLine("<east>" + east.ToString() + "</east>");
                                    sw.WriteLine("<west>" + west.ToString() + "</west>");
                                    sw.WriteLine("<rotation>0</rotation>");
                                    sw.WriteLine("</LatLonBox>");
                                    sw.WriteLine("</GroundOverlay>");
                                }
                            }
                            if (super_overlay)
                            {
                                bool top_level = false;
                                if ((int)IDX.Rows[i]["z"] == (int)IDX.Rows[IDX.Rows.Count - 2]["z"]) // top 4 (2 because... new_rowE)
                                {
                                    top_level = true;
                                }
                                so.create_tile(map_dir, (int)IDX.Rows[i]["x"], (int)IDX.Rows[i]["y"], (int)IDX.Rows[i]["z"], (int)IDX.Rows[0]["z"], map_type, false, top_level, true, pre_path);
                            }
                        }
                    }

                    // empty directories
                    if (create_files || only_specified)
                    {
                        foreach (DirectoryInfo dir_x in new DirectoryInfo(map_dir + "/tiles").GetDirectories())
                        {
                            foreach (DirectoryInfo dir_n in dir_x.GetDirectories())
                            {
                                if (dir_n.GetFiles().Length == 0)
                                    dir_n.Delete();
                            }
                        }
                    }

                    if (create_overlay)
                    {
                        sw.WriteLine("</Folder>");
                        sw.WriteLine("</Folder>");
                        sw.WriteLine("</kml>");
                        sw.Close();
                    }

                    if (super_overlay)
                    {
                        so.CreateOverlayXMLforSO(map_dir, (int)IDX.Rows[IDX.Rows.Count - 5]["x"], (int)IDX.Rows[IDX.Rows.Count - 5]["y"], (int)IDX.Rows[IDX.Rows.Count - 5]["z"], map_type, true, pre_path);
                    }
                }
                catch
                {
                    sw.Close();
                    new FileInfo(map_dir + "/overlay" + all + ".kml").Delete();

                    if (de.Exists)
                    {
                        de.Delete(true);
                    }
                    extracted_ok = false;
                }

                sr.Close();
            }

            return extracted_ok;
        }

        public bool ExtractOldGPSFS(string map_dir)
        {
            bool extracted_ok = true;

            DirectoryInfo td = new DirectoryInfo(map_dir);
            if (td.Exists == false)
                extracted_ok = false; // no directory
            else
                if (new FileInfo(map_dir + "/GPSFS").Exists == false)
                    extracted_ok = false; // gpsfs does not exist

            DirectoryInfo de = new DirectoryInfo(map_dir + "/GPSFS_Extracted");
            if (de.Exists)
                extracted_ok = false;

            if (extracted_ok)
            {
                BinaryReader sr = new BinaryReader(new FileStream(map_dir + "/GPSFS", FileMode.Open));
                try
                {
                    de.Create();

                    string gpsfsv = "";
                    Int64 x = -1;
                    Int64 y = -1;
                    Int64 basezoom = 0;
                    Int64 filetype = -1;
                    Int64 maxsize = -1;

                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();
                    gpsfsv += sr.ReadChar();

                    x = sr.ReadInt64();
                    y = sr.ReadInt64();
                    basezoom = sr.ReadInt64();
                    filetype = sr.ReadInt64();
                    maxsize = sr.ReadInt64();

                    if (x >= 0 && y >= 0)
                    {
                        StreamWriter srC = new StreamWriter(map_dir + "/GPSFS_Extracted/coords.txt");
                        srC.WriteLine(x.ToString() + " " + y.ToString() + " " + basezoom.ToString());
                        srC.Close();
                    }

                    string ext;
                    if (filetype == 0)
                        ext = "png";
                    else
                        ext = "jpg";

                    // get N + 1 coords

                    DataTable IDX = new DataTable();
                    IDX.Columns.Add("Location", typeof(String));
                    IDX.Columns.Add("Size", typeof(Int64));
                    IDX.Columns.Add("Position", typeof(Int64));
                    IDX.Columns.Add("IDX", typeof(Int64));

                    int top_dir = 0;
                    int tiles = 0;
                    while (tiles < maxsize)
                    {
                        top_dir++;
                        tiles = System.Convert.ToInt32(TotalTiles(top_dir));
                    }

                    // table of tiles loc, with length, length++ (in order)
                    int zoom = 1;
                    while (zoom <= top_dir)
                    {
                        new DirectoryInfo(map_dir + "/GPSFS_Extracted/" + zoom.ToString() + "x").Create();
                        int row = 0;
                        while (row < (top_dir * 2) / zoom)
                        {
                            new DirectoryInfo(map_dir + "/GPSFS_Extracted/" + zoom.ToString() + "x/" + row.ToString("000")).Create();
                            int col = 0;
                            while (col < (top_dir * 2) / zoom)
                            {
                                DataRow new_row = IDX.NewRow();
                                new_row["Location"] = map_dir + "/GPSFS_Extracted/" + zoom.ToString() + "x/" + row.ToString("000") + "/" + zoom.ToString() + "x" + row.ToString("000") + col.ToString("000") + "." + ext;
                                new_row["IDX"] = sr.ReadInt64();
                                IDX.Rows.Add(new_row);

                                col++;
                            }
                            row++;
                        }
                        zoom = zoom * 2; // will round down to 0
                    }

                    DataRow new_rowE = IDX.NewRow();
                    new_rowE["IDX"] = sr.ReadInt64(); // the last one
                    IDX.Rows.Add(new_rowE);

                    for (int i = 0; i < maxsize; i++)
                    {
                        Int64 tt1 = (Int64)IDX.Rows[i]["IDX"];
                        Int64 tt2 = (Int64)IDX.Rows[i + 1]["IDX"];
                        if ((Int64)IDX.Rows[i]["IDX"] > 0)
                        {
                            Int64 length;
                            if ((Int64)IDX.Rows[i + 1]["IDX"] > 0)
                            {
                                length = (Int64)IDX.Rows[i + 1]["IDX"] - (Int64)IDX.Rows[i]["IDX"];
                            }
                            else
                            {
                                length = (Int64)IDX.Rows[i + 1]["IDX"] * -1;
                            }

                            File.WriteAllBytes((string)IDX.Rows[i]["Location"], sr.ReadBytes(System.Convert.ToInt32(length)));
                        }
                    }

                    // empty directories
                    foreach (DirectoryInfo dir_x in new DirectoryInfo(map_dir + "/GPSFS_Extracted").GetDirectories())
                    {
                        foreach (DirectoryInfo dir_n in dir_x.GetDirectories())
                        {
                            if (dir_n.GetFiles().Length == 0)
                                dir_n.Delete();
                        }
                    }
                }
                catch
                {
                    de.Delete(true);
                    extracted_ok = false;
                }

                sr.Close();
            }

            return extracted_ok;
        }

        private int num_files = 5;

        public bool CreateGPSFSfromSite(string map_dir, int Zoom, int X, int Y, int Min_zoom, string Ext)
        {
            // top 4,
            // bottom 2

            // diff dir

            bool encoded_ok = true;

            DirectoryInfo td = new DirectoryInfo(map_dir);
            if (td.Exists == false)
                encoded_ok = false; // no directory
            else
                if (new FileInfo(map_dir + "/GPSFS").Exists)
                    encoded_ok = false; // gpsfs exists

            if (encoded_ok)
            {
                BinaryWriter sw = new BinaryWriter(new FileStream(map_dir + "/GPSFS", FileMode.CreateNew));
                try
                {
                    Int64 x = -1;
                    Int64 y = -1;
                    Int64 basezoom = 0;
                    Int64 filetype = -1;
                    Int64 maxsize = -1;

                    DataTable IDX = new DataTable();

                    x = System.Convert.ToInt64(X * Math.Pow(2, Zoom - Min_zoom));
                    y = System.Convert.ToInt64(Y * Math.Pow(2, Zoom - Min_zoom));
                    basezoom = Min_zoom;

                    // find max/min zoom, int/png

                    int top_dir = System.Convert.ToInt32(Math.Pow(2, Zoom - Min_zoom));

                    string ext = Ext;
                    
                    if (ext == "png")
                        filetype = 0;
                    else
                        filetype = 1;

                    // calc number of tiles
                    maxsize = TotalTiles(top_dir);

                    // write header (GPSFSV01)
                    sw.Write('G');
                    sw.Write('P');
                    sw.Write('S');
                    sw.Write('F');
                    sw.Write('S');
                    sw.Write('V');
                    sw.Write('0');
                    sw.Write('1');
                    sw.Write(x);
                    sw.Write(y);
                    sw.Write(basezoom);
                    sw.Write(filetype);
                    sw.Write(maxsize);

                    IDX.Columns.Add("Location", typeof(String));
                    IDX.Columns.Add("Size", typeof(Int32));
                    IDX.Columns.Add("IDXfile", typeof(Int32));
                    IDX.Columns.Add("IDXoffset", typeof(Int32));

                    Int64 tot_file_size = 0;

                    // table of tiles loc, with length, length++ (in order)
                    int x_off = System.Convert.ToInt32(x);
                    int y_off = System.Convert.ToInt32(y);
                    int z_dir = 17 - Min_zoom;

                    int zoom = 1;
                    while (zoom <= top_dir)
                    {
                        int row = 0;
                        while (row < (top_dir * 2) / zoom)
                        {
                            int col = 0;
                            while (col < (top_dir * 2) / zoom)
                            {
                                DataRow new_row = IDX.NewRow();

                                FileInfo file = new FileInfo(map_dir + "/" + z_dir.ToString() + "/" + (x_off + col).ToString() + "/" + (y_off + row).ToString() + "." + ext);

                                if (file.Exists)
                                {
                                    new_row["Location"] = file.FullName;
                                    new_row["Size"] = file.Length;
                                    tot_file_size += file.Length;
                                }
                                else
                                {
                                    new_row["Location"] = "";
                                    new_row["Size"] = 0;
                                }

                                IDX.Rows.Add(new_row);

                                col++;
                            }
                            row++;
                        }
                        zoom = zoom * 2;

                        x_off /= 2;
                        y_off /= 2;
                        z_dir--;
                    }

                    // pointer to EOF
                    DataRow eof_row = IDX.NewRow();
                    eof_row["Location"] = "";
                    eof_row["Size"] = 8;
                    IDX.Rows.Add(eof_row);

                    int IDXfile = 0;
                    int ind_file_size = System.Convert.ToInt32(tot_file_size / num_files);
                    int IDXposition = 48 + (System.Convert.ToInt32(maxsize) + 1) * 8; // the info offset

                    int last_size = 0;
                    foreach (DataRow new_row in IDX.Rows)
                    {
                        if (IDXposition > ind_file_size && IDXfile + 1 < num_files)
                        {
                            IDXposition = 0;
                            IDXfile++;
                        }
                        new_row["IDXfile"] = IDXfile;
                        if ((string)new_row["Location"] == "")
                        {
                            if (last_size == 0)
                                new_row["IDXoffset"] = -1;
                            else
                                new_row["IDXoffset"] = -1 * last_size;
                        }
                        else
                        {
                            new_row["IDXoffset"] = IDXposition;
                        }

                        last_size = (int)new_row["Size"];
                        IDXposition += (int)new_row["Size"];
                    }

                    foreach (DataRow new_row in IDX.Rows)
                    {
                        sw.Write((Int32)new_row["IDXfile"]); // includes EOFrow
                        sw.Write((Int32)new_row["IDXoffset"]); // includes EOFrow
                    }

                    IDXfile = 0;

                    foreach (DataRow file in IDX.Rows)
                    {
                        if ((string)file["Location"] != "")
                        {
                            if (IDXfile != (int)file["IDXfile"])
                            {
                                IDXfile = (int)file["IDXfile"];
                                sw.Close();
                                sw = new BinaryWriter(new FileStream(map_dir + "/GPSFS" + IDXfile.ToString(), FileMode.CreateNew));
                            }
                            sw.Write(File.ReadAllBytes((string)file["Location"]));
                        }
                    }

                    // write end (GPSFSEOF)
                    sw.Write('G');
                    sw.Write('P');
                    sw.Write('S');
                    sw.Write('F');
                    sw.Write('S');
                    sw.Write('E');
                    sw.Write('O');
                    sw.Write('F');

                    IDXfile++;
                    while (IDXfile < num_files) // filler files
                    {
                        sw.Close();
                        sw = new BinaryWriter(new FileStream(map_dir + "/GPSFS" + IDXfile.ToString(), FileMode.CreateNew));
                        IDXfile++;
                    }

                    sw.Close();
                }
                catch
                {
                    sw.Close();
                    new FileInfo(map_dir + "/GPSFS").Delete();
                    for (int i = 1; i < num_files; i++)
                    {
                        new FileInfo(map_dir + "/GPSFS" + i.ToString()).Delete();
                    }
                    encoded_ok = false;
                }
            }

            return encoded_ok;
        }

        public bool CreateGPSFS(string map_dir)
        {
            bool encoded_ok = true;

            DirectoryInfo td = new DirectoryInfo(map_dir);
            if (td.Exists == false)
                encoded_ok = false; // no directory
            else
                if (new FileInfo(map_dir + "/GPSFS").Exists)
                    encoded_ok = false; // gpsfs exists
            
            if (encoded_ok)
            {
                BinaryWriter sw = new BinaryWriter(new FileStream(map_dir + "/GPSFS", FileMode.CreateNew));
                try
                {
                    Int64 x = -1;
                    Int64 y = -1;
                    Int64 basezoom = 0;
                    Int64 filetype = -1;
                    Int64 maxsize = -1;

                    DataTable IDX = new DataTable();

                    // read coords (if no set -xy)
                    if (new FileInfo(map_dir + "/coords.txt").Exists)
                    {
                        StreamReader sr = new StreamReader(map_dir + "/coords.txt");
                        string coords = sr.ReadLine();
                        sr.Close();

                        // x y basezoom wTLx.ToString() + " " + wTLy.ToString() + " " + Minzoom.Text
                        x = Int64.Parse(coords.Substring(0, coords.IndexOf(" ")));
                        y = Int64.Parse(coords.Substring(coords.IndexOf(" ") + 1, coords.IndexOf(" ", coords.IndexOf(" ") + 1) - 1 - coords.IndexOf(" ")));
                        basezoom = Int64.Parse(coords.Substring(coords.IndexOf(" ", coords.IndexOf(" ") + 1) + 1, coords.Length - 1 - coords.IndexOf(" ", coords.IndexOf(" ") + 1)));
                    }

                    // find max/min zoom, int/png
                    
                    int top_dir = 0;

                    foreach (DirectoryInfo dir in td.GetDirectories("*x"))
                    {
                        if (Int32.Parse(dir.Name.Replace("x", "")) > top_dir)
                            top_dir = Int32.Parse(dir.Name.Replace("x", ""));
                    }

                    string ext = "png";
                    if (top_dir > 0)
                    {
                        if (new DirectoryInfo(td.FullName + "/" + top_dir.ToString() + "x" + "/000").GetFiles("*.jpg").Length > 0)
                        {
                            ext = "jpg";
                        }
                    }
                    else
                    {
                        int i1 = Int32.Parse("Need an error thrown");
                    }

                    if (ext == "png")
                        filetype = 0;
                    else
                        filetype = 1;
                    
                    // calc number of tiles
                    maxsize = TotalTiles(top_dir);

                    // write header (GPSFSV01)
                    sw.Write('G');
                    sw.Write('P');
                    sw.Write('S');
                    sw.Write('F');
                    sw.Write('S');
                    sw.Write('V');
                    sw.Write('0');
                    sw.Write('1');
                    sw.Write(x);
                    sw.Write(y);
                    sw.Write(basezoom);
                    sw.Write(filetype);
                    sw.Write(maxsize);

                    IDX.Columns.Add("Location", typeof(String));
                    IDX.Columns.Add("Size", typeof(Int32));
                    IDX.Columns.Add("IDXfile", typeof(Int32));
                    IDX.Columns.Add("IDXoffset", typeof(Int32));

                    Int64 tot_file_size = 0;

                    // table of tiles loc, with length, length++ (in order)
                    int zoom = 1;
                    while (zoom <= top_dir)
                    {
                        int row = 0;
                        while (row < (top_dir * 2) / zoom)
                        {
                            int col = 0;
                            while (col < (top_dir * 2) / zoom)
                            {
                                DataRow new_row = IDX.NewRow();
                                
                                FileInfo file = new FileInfo(map_dir + "/" + zoom.ToString() + "x/" + row.ToString("000") + "/" + zoom.ToString() + "x" + row.ToString("000") + col.ToString("000") + "." + ext);

                                if (file.Exists)
                                {
                                    new_row["Location"] = file.FullName;
                                    new_row["Size"] = file.Length;
                                    tot_file_size += file.Length;
                                }
                                else
                                {
                                    new_row["Location"] = "";
                                    new_row["Size"] = 0;
                                }

                                IDX.Rows.Add(new_row);

                                col++;
                            }
                            row++;
                        }
                        zoom = zoom * 2;
                    }

                    // pointer to EOF
                    DataRow eof_row = IDX.NewRow();
                    eof_row["Location"] = "";
                    eof_row["Size"] = 8;
                    IDX.Rows.Add(eof_row);
                    
                    int IDXfile = 0;
                    int ind_file_size = System.Convert.ToInt32(tot_file_size / num_files);
                    int IDXposition = 48 + (System.Convert.ToInt32(maxsize) + 1) * 8; // the info offset

                    int last_size = 0;
                    foreach (DataRow new_row in IDX.Rows)
                    {
                        if (IDXposition > ind_file_size && IDXfile + 1 < num_files)
                        {
                            IDXposition = 0;
                            IDXfile++;
                        }
                        new_row["IDXfile"] = IDXfile;
                        if ((string)new_row["Location"] == "")
                        {
                            if (last_size == 0)
                                new_row["IDXoffset"] = -1;
                            else
                                new_row["IDXoffset"] = -1 * last_size;
                        }
                        else
                        {
                            new_row["IDXoffset"] = IDXposition;
                        }

                        last_size = (int)new_row["Size"];
                        IDXposition += (int)new_row["Size"];
                    }

                    foreach (DataRow new_row in IDX.Rows)
                    {
                        sw.Write((Int32)new_row["IDXfile"]); // includes EOFrow
                        sw.Write((Int32)new_row["IDXoffset"]); // includes EOFrow
                    }

                    IDXfile = 0;

                    foreach (DataRow file in IDX.Rows)
                    {
                        if ((string)file["Location"] != "")
                        {
                            if (IDXfile != (int)file["IDXfile"])
                            {
                                IDXfile = (int)file["IDXfile"];
                                sw.Close();
                                sw = new BinaryWriter(new FileStream(map_dir + "/GPSFS" + IDXfile.ToString(), FileMode.CreateNew));
                            }
                            sw.Write(File.ReadAllBytes((string)file["Location"]));
                        }
                    }

                    // write end (GPSFSEOF)
                    sw.Write('G');
                    sw.Write('P');
                    sw.Write('S');
                    sw.Write('F');
                    sw.Write('S');
                    sw.Write('E');
                    sw.Write('O');
                    sw.Write('F');

                    IDXfile++;
                    while (IDXfile < num_files) // filler files
                    {
                        sw.Close();
                        sw = new BinaryWriter(new FileStream(map_dir + "/GPSFS" + IDXfile.ToString(), FileMode.CreateNew));
                        IDXfile++;
                    }

                    sw.Close();
                }
                catch
                {
                    sw.Close();
                    new FileInfo(map_dir + "/GPSFS").Delete();
                    for (int i = 1; i < num_files; i++)
                    {
                        new FileInfo(map_dir + "/GPSFS" + i.ToString()).Delete();
                    }
                    encoded_ok = false;
                }
            }

            return encoded_ok;
        }

        public bool CreateOldGPSFS(string map_dir)
        {
            bool encoded_ok = true;

            DirectoryInfo td = new DirectoryInfo(map_dir);
            if (td.Exists == false)
                encoded_ok = false; // no directory
            else
                if (new FileInfo(map_dir + "/GPSFS").Exists)
                    encoded_ok = false; // gpsfs exists

            if (encoded_ok)
            {
                BinaryWriter sw = new BinaryWriter(new FileStream(map_dir + "/GPSFS", FileMode.CreateNew));
                try
                {
                    Int64 x = -1;
                    Int64 y = -1;
                    Int64 basezoom = 0;
                    Int64 filetype = -1;
                    Int64 maxsize = -1;

                    DataTable IDX = new DataTable();

                    // read coords (if no set -xy)
                    if (new FileInfo(map_dir + "/coords.txt").Exists)
                    {
                        StreamReader sr = new StreamReader(map_dir + "/coords.txt");
                        string coords = sr.ReadLine();
                        sr.Close();

                        // x y basezoom wTLx.ToString() + " " + wTLy.ToString() + " " + Minzoom.Text
                        x = Int64.Parse(coords.Substring(0, coords.IndexOf(" ")));
                        y = Int64.Parse(coords.Substring(coords.IndexOf(" ") + 1, coords.IndexOf(" ", coords.IndexOf(" ") + 1) - 1 - coords.IndexOf(" ")));
                        basezoom = Int64.Parse(coords.Substring(coords.IndexOf(" ", coords.IndexOf(" ") + 1) + 1, coords.Length - 1 - coords.IndexOf(" ", coords.IndexOf(" ") + 1)));
                    }

                    // find max/min zoom, int/png

                    int top_dir = 0;

                    foreach (DirectoryInfo dir in td.GetDirectories("*x"))
                    {
                        if (Int32.Parse(dir.Name.Replace("x", "")) > top_dir)
                            top_dir = Int32.Parse(dir.Name.Replace("x", ""));
                    }

                    string ext = "png";
                    if (top_dir > 0)
                    {
                        if (new DirectoryInfo(td.FullName + "/" + top_dir.ToString() + "x" + "/000").GetFiles("*.jpg").Length > 0)
                        {
                            ext = "jpg";
                        }
                    }
                    else
                    {
                        int i1 = Int32.Parse("Need an error thrown");
                    }

                    if (ext == "png")
                        filetype = 0;
                    else
                        filetype = 1;

                    // calc number of tiles
                    maxsize = TotalTiles(top_dir);

                    // write header (GPSFSV01)
                    sw.Write('G');
                    sw.Write('P');
                    sw.Write('S');
                    sw.Write('F');
                    sw.Write('S');
                    sw.Write('V');
                    sw.Write('0');
                    sw.Write('1');
                    sw.Write(x);
                    sw.Write(y);
                    sw.Write(basezoom);
                    sw.Write(filetype);
                    sw.Write(maxsize);

                    IDX.Columns.Add("Location", typeof(String));
                    IDX.Columns.Add("Size", typeof(Int64));
                    IDX.Columns.Add("Position", typeof(Int64));
                    IDX.Columns.Add("IDX", typeof(Int64));

                    DataRow last_file = IDX.NewRow(); // never used
                    last_file["Size"] = 0;
                    last_file["Position"] = 48 + (maxsize + 1) * 8; // the info offset

                    // table of tiles loc, with length, length++ (in order)
                    int zoom = 1;
                    while (zoom <= top_dir)
                    {
                        int row = 0;
                        while (row < (top_dir * 2) / zoom)
                        {
                            int col = 0;
                            while (col < (top_dir * 2) / zoom)
                            {
                                DataRow new_row = IDX.NewRow();

                                FileInfo file = new FileInfo(map_dir + "/" + zoom.ToString() + "x/" + row.ToString("000") + "/" + zoom.ToString() + "x" + row.ToString("000") + col.ToString("000") + "." + ext);

                                new_row["Position"] = (Int64)last_file["Position"] + (Int64)last_file["Size"];

                                if (file.Exists)
                                {
                                    new_row["Location"] = file.FullName;
                                    new_row["Size"] = file.Length;
                                    new_row["IDX"] = (Int64)new_row["Position"];
                                }
                                else
                                {
                                    new_row["Location"] = "";
                                    new_row["Size"] = 0;
                                    new_row["IDX"] = (Int64)last_file["Size"] * -1;
                                    if ((Int64)new_row["IDX"] == 0)
                                        new_row["IDX"] = -1;
                                }

                                sw.Write((Int64)new_row["IDX"]);

                                last_file = new_row;
                                IDX.Rows.Add(new_row);

                                col++;
                            }
                            row++;
                        }
                        zoom = zoom * 2;
                    }

                    // pointer to EOF
                    DataRow eof_row = IDX.NewRow();
                    eof_row["Location"] = "";
                    eof_row["Size"] = 8;
                    eof_row["Position"] = (Int64)last_file["Position"] + (Int64)last_file["Size"];
                    eof_row["IDX"] = (Int64)eof_row["Position"];
                    sw.Write((Int64)eof_row["IDX"]);

                    foreach (DataRow file in IDX.Rows)
                    {
                        if ((string)file["Location"] != "")
                        {
                            sw.Write(File.ReadAllBytes((string)file["Location"]));
                        }
                    }

                    // write end (GPSFSEOF)
                    sw.Write('G');
                    sw.Write('P');
                    sw.Write('S');
                    sw.Write('F');
                    sw.Write('S');
                    sw.Write('E');
                    sw.Write('O');
                    sw.Write('F');

                    sw.Close();
                }
                catch
                {
                    sw.Close();
                    new FileInfo(map_dir + "/GPSFS").Delete();
                    encoded_ok = false;
                }
            }

            return encoded_ok;
        }


        public Int64 TotalTiles(int top_dir)
        {
            Int64 maxsize = 0;

            int zoom = 1;
            int span = 2;

            while (zoom <= top_dir)
            {
                maxsize += span * span;
                zoom *= 2;
                span *= 2;
            }

            return maxsize;
        }

        /*
        #          __________
# 0-7     | GPSFSV1  |
# 	  |----------|
# 8	  |    X     |
# 	  |----------|
# 16      |    Y     |
# 	  |----------|
# 24      | basezoom |
# 	  |----------|
# 28      | filetype |
# 	  |----------|
# 32      | maxsize  |
# 	  |----------|
# 40      |   IDX0   |
# 	  |----------|
# 48      |   IDX1   |
# 	  |__________|
# 	       .
# 	       .
# 	       .
#          __________
# 	  | IDX N    | - points to GPSFSEOF 
# 	  |----------|
#         |   PNG0   |
# 	  |----------|
# ..      |   PNG1   |
# 	  |----------|
# 	       .
# 	       .
# 	       .
#          __________
# 	  | PNG N-1  | - last image
# 	  |----------|
#         | GPSFSEOF |
# 	  |__________|


Field Descriptions:

GPSFSV1:  - version 1 of GPSFS
GPSFSEOF: - end of file check

X: 	- x coordinate of tile
Y: 	- y coordinate of tile

basezoom: - used basezoom
maxsize:  - maximum size

filetype: - 0 .png 
          - 1 .jpg 

IDXi:	- the IDXs pointing to the PNGs
PNGi:	- the PNGs

Notes: 
	Number of IDX entries is always fixed and equals to the max number of tiles for given map size.
	This way any IDXn entry is completely defined as offset from the beginning of the file.
	The IDX section cover the most distant zoom tiles first> Here is the example:

	IDX0->16x000000
	IDX1->16x000001
	IDX2->16x001000
	IDX3->16x001000		<last tile at this level>
	IDX4->8x0000000
	IDX5->8x0000000
		.....
	
	IDX offsets are relative to the beginning of the map file: IDX0 = [00100000] means that the PNG0 starts 100000 bytes from the beginning of the file.
	If a tile is ommitted - the corresponding index has a negative number. The absolute value of this entry should be equal to the file size of previous entry. Example:

	IDX0 00010000		non-empty PNG 1K size
	IDX1 00011000		non-empty PNG 3K size
	IDX2 -0003000		empty file
	IDX3 -0003000		empty file - don't really care what value is as long as it's negative
	IDX4 00014000		non-empty file - size is determined by next index entry	


        */
    }
}
