using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Globalization;

using System.IO;
using System.Net;

using System.Threading;

using System.Xml;

using System.Collections;

using System.Diagnostics;

namespace GMDL
{
    public partial class GMdl : Form
    {
        public GMdl()
        {
            InitializeComponent();
        }

        private WebClient wc = new WebClient();
        private Random ran = new Random();

        public mapURL mu;

        public LatLonXYcalcs LLXY = new LatLonXYcalcs();

        private int[] GetNumbers(string page)
        {
            int min_zoom = 99;
            int min_x = 999999;
            int min_y = 999999;
            int max_x = -1;
            int max_y = -1;

            if (iBAIDUm.Checked)
            {
                // going to use google zoom, and 'redirect' y

                string baidu_img = "http://mappng.baidu.com/maplite/mapbank/baidu/";
                int start = page.IndexOf(baidu_img);
                while (start != -1)
                {
                    start = start + baidu_img.Length;
                    int zoom = 14 - Int32.Parse(page.Substring(start, page.IndexOf("/", start) - start).Replace("W", "-1")); //int Tl = 14 - zoom; // 12 -> 2
                    if (zoom < min_zoom)
                        min_zoom = zoom;
                    start = page.IndexOf(baidu_img, start);
                }

                string baidu_xy = "http://mappng.baidu.com/maplite/mapbank/baidu/" + (14 - min_zoom).ToString().Replace("-1", "W") + "/";
                start = page.IndexOf(baidu_xy);
                while (start != -1)
                {
                    start = start + baidu_xy.Length;

                    // chi80: it's a little different from zoom 9, the level_2 from 10*10 to 50*50.
                    int multiplier = 10;
                    if (14 - min_zoom >= 9)
                        multiplier = 50;

                    int start2 = start;
                    int end = page.IndexOf("_", start);
                    int x = Int32.Parse(page.Substring(start2, end - start2)) * multiplier;
                    start2 = page.IndexOf("/", start2) + 1;
                    end = page.IndexOf("_", start2);
                    x += Int32.Parse(page.Substring(start2, end - start2)); //int Tx = x; // 15 -> -1 <= x is ok
                    if (x < min_x)
                        min_x = x;
                    if (x > max_x)
                        max_x = x;

                    start2 = page.IndexOf("_", start) + 1;
                    end = page.IndexOf("/", start);
                    int y = Int32.Parse(page.Substring(start2, end - start2)) * multiplier;
                    start2 = page.IndexOf("_", end) + 1;
                    end = page.IndexOf(".", start2);
                    y += Int32.Parse(page.Substring(start2, end - start2));
                    y = System.Convert.ToInt32(Math.Pow(2, 14 - min_zoom + 2)) - y - 1; //int Ty = System.Convert.ToInt32(Math.Pow(2, Tl + 2)) - y - 1; // 10 -> 6
                    if (y < min_y)
                        min_y = y;
                    if (y > max_y)
                        max_y = y;

                    start = page.IndexOf(baidu_xy, start);
                }
            }
            else if (iMAP2GOm.Checked)
            {
                // http://map.sogou.com/new/
                // src=\"http://pic1.go2map.com/seamless/0/174/724/0/0/5_0.GIF\"

                string map2go_img = "http://pic1.go2map.com/seamless/0/174/";
                int start = page.IndexOf(map2go_img);
                while (start != -1)
                {
                    start = start + map2go_img.Length;
                    int zoom = Int32.Parse(page.Substring(start, page.IndexOf("/", start) - start)) - 711; // 0 == 17 in url
                    if (zoom < min_zoom)
                        min_zoom = zoom;
                    start = page.IndexOf(map2go_img, start);
                }

                string map2go_xy = "http://pic1.go2map.com/seamless/0/174/" + (711 + min_zoom).ToString() + "/";
                start = page.IndexOf(map2go_xy);
                while (start != -1)
                {
                    start = start + map2go_xy.Length;
                    start = page.IndexOf("/", start) + 1;
                    start = page.IndexOf("/", start) + 1;

                    // order xy correct?

                    int end = page.IndexOf("_", start);
                    int x = Int32.Parse(page.Substring(start, end - start).Replace("M", "-"));
                    if (x < min_x)
                        min_x = x;
                    if (x > max_x)
                        max_x = x;

                    start = end + 1;
                    end = page.IndexOf(".", start);
                    int y = Int32.Parse(page.Substring(start, end - start).Replace("M", "-"));
                    y = System.Convert.ToInt32(Math.Pow(2, 16 - min_zoom)) - y - 1; //int Ty = System.Convert.ToInt32(Math.Pow(2, Tl + 2)) - y - 1; // 10 -> 6
                    if (y < min_y)
                        min_y = y;
                    if (y > max_y)
                        max_y = y;

                    start = page.IndexOf(map2go_xy, start);
                }

            }
            else if (MapType().StartsWith("iR"))
            {
                int start = page.IndexOf("src=\"tiles/");
                while (start != -1)
                {
                    start = page.IndexOf("/", start) + 1;
                    start = page.IndexOf("/", start) + 1;
                    int end = page.IndexOf("/", start) - 3;
                    int zoom = Int32.Parse(page.Substring(start, end - start));
                    zoom = System.Convert.ToInt32(Math.Log(zoom) / Math.Log(2));
                    if (zoom < min_zoom)
                        min_zoom = zoom;
                    start = page.IndexOf("src=\"tiles/", start);
                }
                
                start = page.IndexOf("/" + Math.Pow(2, min_zoom).ToString("00000000") + "000/");
                while (start != -1)
                {
                    start = page.IndexOf("/", start) + 1;
                    start = page.IndexOf("/", start) + 1;
                    start = page.IndexOf("/", start) + 1;
                    
                    int x = Int32.Parse(page.Substring(start, 6));
                    if (x < min_x)
                        min_x = x;
                    if (x > max_x)
                        max_x = x;
                    int y = Int32.Parse(page.Substring(start + 6, 6));
                    if (y < min_y)
                        min_y = y;
                    if (y > max_y)
                        max_y = y;
                    start = page.IndexOf("/" + Math.Pow(2, min_zoom).ToString("00000000") + "000/", start);
                }
            }
            else if (wB.Url.ToString().IndexOf("in7ane.com") != -1)
            {
                int start = page.IndexOf("/tiles/");
                while (start != -1)
                {
                    start = page.IndexOf("/", start) + 1;
                    start = page.IndexOf("/", start) + 1;
                    int end = page.IndexOf("/", start);
                    int zoom = Int32.Parse(page.Substring(start, end - start));
                    zoom = 17 - zoom;
                    if (zoom < min_zoom)
                        min_zoom = zoom;
                    start = page.IndexOf("/tiles/", start);
                }

                start = page.IndexOf("/tiles/" + (17 - min_zoom).ToString() + "/");
                while (start != -1)
                {
                    start = page.IndexOf("/", start) + 1;
                    start = page.IndexOf("/", start) + 1;
                    start = page.IndexOf("/", start) + 1;
                    int end = page.IndexOf("/", start);

                    int x = Int32.Parse(page.Substring(start, end - start));
                    if (x < min_x)
                        min_x = x;
                    if (x > max_x)
                        max_x = x;

                    start = end + 1;
                    end = page.IndexOf(".", start);

                    int y = Int32.Parse(page.Substring(start, end - start));
                    if (y < min_y)
                        min_y = y;
                    if (y > max_y)
                        max_y = y;
                    start = page.IndexOf("/tiles/" + (17 - min_zoom).ToString() + "/", start);
                }

                min_x += 2; // bigger tile cache it seems
                min_y += 2;
            }
            else if (wB.Url.ToString().IndexOf("yahoo.com") != -1)
            {
                int start = page.IndexOf("&x=");
                while (start != -1)
                {
                    start = start + 3;
                    int x = Int32.Parse(page.Substring(start, page.IndexOf("&", start) - start));
                    start = page.IndexOf("&y=", start) + 3;
                    int y = Int32.Parse(page.Substring(start, page.IndexOf("&", start) - start));
                    start = page.IndexOf("&z=", start) + 3;
                    string Sz = page.Substring(start, page.IndexOf("'", start) - start);
                    if (Sz.IndexOf("&") != -1)
                        Sz = Sz.Substring(0, Sz.IndexOf("&"));
                    int z = Int32.Parse(Sz) - 1;

                    y = System.Convert.ToInt32(Math.Pow(2, 16 - z)) - y - 1;

                    if (x < min_x)
                        min_x = x;
                    if (y < min_y)
                        min_y = y;
                    if (z < min_zoom)
                        min_zoom = z;

                    start = page.IndexOf("&x=", start);
                }
                start = page.IndexOf("http://us.maps3.yimg.com/aerial.maps.yimg.com/tile?v=");
                if (start != -1)
                {
                    start = page.IndexOf("=", start) + 1;
                    string v = page.Substring(start, page.IndexOf("&", start) - start);
                    if (iYsatV.Text != v && MessageBox.Show("Sat V is set to " + iYsatV.Text + ", reset to " + v + "?", "", MessageBoxButtons.YesNo) == DialogResult.Yes)
                    {
                        iYsatV.Text = v;
                    }
                }
            }
            else if (wB.Url.ToString().IndexOf("live.com") != -1)
            {
                int start = page.IndexOf("tiles.virtualearth.net/tiles/");
                while (start != -1)
                {
                    start = page.IndexOf("/", start) + 1;
                    start = page.IndexOf("/", start) + 2;
                    int end = page.IndexOf("?", start);

                    string url = page.Substring(start, end - start);
                    if (url.IndexOf(".") != -1)
                        url = url.Substring(0, url.IndexOf("."));

                    min_zoom = 17 - url.Length;

                    int x = 0;
                    int y = 0;

                    // set coords from shortest
                    for (int i = 0; i < url.Length; i++)
                    {
                        x *= 2;
                        y *= 2;
                        if (url.Substring(i, 1) == "1")
                            x++;
                        else if (url.Substring(i, 1) == "2")
                            y++;
                        else if (url.Substring(i, 1) == "3")
                        {
                            x++;
                            y++;
                        }
                    }

                    if (x < min_x)
                        min_x = x;
                    if (y < min_y)
                        min_y = y;

                    start = page.IndexOf("tiles.virtualearth.net/tiles/", start);
                }
            }
            else // google
            {
                int start = page.IndexOf("zoom=");
                while (start != -1)
                {
                    start = start + 5;
                    int zoom = Int32.Parse(page.Substring(start, page.IndexOf("\"", start) - start));
                    if (zoom < min_zoom)
                        min_zoom = zoom;
                    start = page.IndexOf("zoom=", start);
                }

                start = page.IndexOf(";x=");
                while (start != -1)
                {
                    start = start + 3;
                    int x = Int32.Parse(page.Substring(start, page.IndexOf("&", start) - start));
                    if (x < min_x && page.Substring(start, page.IndexOf("\"", start) - start).EndsWith("=" + min_zoom.ToString()))
                        min_x = x;
                    if (x > max_x && page.Substring(start, page.IndexOf("\"", start) - start).EndsWith("=" + min_zoom.ToString()))
                        max_x = x;
                    start = page.IndexOf(";y=", start) + 3;
                    int y = Int32.Parse(page.Substring(start, page.IndexOf("&", start) - start));
                    if (y < min_y && page.Substring(start, page.IndexOf("\"", start) - start).EndsWith("=" + min_zoom.ToString()))
                        min_y = y;
                    if (y > max_y && page.Substring(start, page.IndexOf("\"", start) - start).EndsWith("=" + min_zoom.ToString()))
                        max_y = y;
                    start = page.IndexOf(";x=", start);
                }

                if (MapType() == "iFMnpe")
                {
                    int cen_x = min_x + 1;
                    int cen_y = min_y + 1;

                    cen_x++;
                    cen_y++;

                    decimal[] Bcoord = LLXY.getLatLong(cen_x, cen_y, min_zoom); // center of map if compliant2x2
                    decimal minlat = Bcoord[1];
                    decimal maxlon = Bcoord[0];

                    mu.latC = System.Convert.ToDouble(minlat);
                    mu.lonC = System.Convert.ToDouble(maxlon);
                }
            }

            min_x++;
            min_y++;

            return new int[] { min_zoom, min_x, min_y };
        }

        private void bGN_Click(object sender, EventArgs e)
        {
            Mzoom.Text = "";

            try
            {
                int[] the_numbers = GetNumbers(wB.Document.Body.OuterHtml);

                Mzoom.Text = the_numbers[0].ToString();
                Mx.Text = the_numbers[1].ToString();
                My.Text = the_numbers[2].ToString();

                if (map_name.Text == "")
                {
                    map_name.Text = "_Map of " + Mx.Text + " by " + My.Text + " at " + Mzoom.Text + " to " + Minzoom.Text;
                }
            }
            catch
            {
                MessageBox.Show(msgPreview1.Text);
            }
        }
        
        private string HTMLmapPage(int zoom, int min_x, int min_y, int span_x, int span_y)
        {
            int span = span_x;
            if (span < span_y)
                span = span_y;

            // TN: added a table for vertical centering
            string preview = "<HTML><body><nobr><table width=100% height=100%><tr valign=middle><td align=center>";
            int y_off = 0;
            while (y_off < span)
            {
                int x_off = 0;
                while (x_off < span)
                {
                    preview = preview + "<IMG width = 256 height = 256 SRC=\"" + mu.MapByType(zoom, min_x + x_off, min_y + y_off, MapType()) + "\">";

                    x_off++;
                }
                preview = preview + "<BR>";
                y_off++;
            }
            preview = preview + "</td></tr></table></nobr></body><html>";

            return preview;
        }

        private void bSP_Click(object sender, EventArgs e)
        {
            if (MapType() == "iFMnpe")
            {
                decimal[] Bcoord = LLXY.getLatLong(Int32.Parse(Mx.Text) + 1, Int32.Parse(My.Text) + 1, Int32.Parse(Mzoom.Text)); // center of map if compliant2x2
                decimal minlat = Bcoord[1];
                decimal maxlon = Bcoord[0];

                mu.latC = System.Convert.ToDouble(minlat);
                mu.lonC = System.Convert.ToDouble(maxlon);
            }

            int x_off;
            int y_off;

            tabs.SelectedTab = tP;

            int span = 2;

            wP.DocumentText = HTMLmapPage(Int32.Parse(Mzoom.Text), Int32.Parse(Mx.Text), Int32.Parse(My.Text), 2, 2);

            int zoom_multiple = 1;
            for (int i = Int32.Parse(Mzoom.Text); i > Int32.Parse(Minzoom.Text); i--)
            {
                zoom_multiple *= 2;
            }

            int wTLx = Int32.Parse(Mx.Text) * zoom_multiple;
            int wTLy = Int32.Parse(My.Text) * zoom_multiple;

            x_off = span * zoom_multiple - 1;
            y_off = span * zoom_multiple - 1;

            wTL.DocumentText = "<IMG SRC=\"" + mu.MapByType(Int32.Parse(Minzoom.Text), wTLx, wTLy, MapType()) + "\">";
            wBL.DocumentText = "<IMG SRC=\"" + mu.MapByType(Int32.Parse(Minzoom.Text), wTLx, wTLy + y_off, MapType()) + "\">";
            wTR.DocumentText = "<IMG SRC=\"" + mu.MapByType(Int32.Parse(Minzoom.Text), wTLx + x_off, wTLy, MapType()) + "\">";
            wBR.DocumentText = "<IMG SRC=\"" + mu.MapByType(Int32.Parse(Minzoom.Text), wTLx + x_off, wTLy + y_off, MapType()) + "\">";
        }

        private int TotalFiles(int max_zoom, int min_zoom)
        {
            int span = 2;

            int zoom_multiple = 1;
            for (int i = max_zoom; i > min_zoom; i--)
            {
                zoom_multiple *= 2;
            }

            int total_files = 0;
            for (int dm = 1; dm <= zoom_multiple; dm *= 2)
            {
                total_files += dm * dm * span * span;
            }

            return total_files;
        }

        private void CheckGoogleSat()
        {
            if (mu.CheckGoogleSatOK() == false)
                MessageBox.Show("Google Satellite tile test failed\n\nMay be an idea to change connection");
        }

        private bool tiles_missed = false;
        private int true_done_files = 0;
        private DataTable missing_tiles = new DataTable();
        private int running_threads = 0;

        string percent_done;

        private void bPF_Click(object sender, EventArgs e)
        {
            if (Mzoom.Text == "" || Mx.Text == "" || My.Text == "")
            {
                bGN_Click(Type.Missing, EventArgs.Empty);
            }

            if (MapType() == "iFMnpe")
            {
                decimal[] Bcoord = LLXY.getLatLong(Int32.Parse(Mx.Text) + 1, Int32.Parse(My.Text) + 1, Int32.Parse(Mzoom.Text)); // center of map if compliant2x2
                decimal minlat = Bcoord[1];
                decimal maxlon = Bcoord[0];

                mu.latC = System.Convert.ToDouble(minlat);
                mu.lonC = System.Convert.ToDouble(maxlon);
            }
            
            int BAIDUmin = 14 - Int32.Parse(Mzoom.Text);
            int BAIDUmax = 14 - Int32.Parse(Minzoom.Text);
            /*
             * Bad (*2.5 jumps)
             * 9 to 10
             * 6 to 7
             * 3 to 4
            */
            if (iBAIDUm.Checked && ((BAIDUmin < 9.5 && BAIDUmax > 9.5) || (BAIDUmin < 6.5 && BAIDUmax > 6.5) || (BAIDUmin < 3.5 && BAIDUmax > 3.5))) // right comparison? other jumps?
            {
                MessageBox.Show(msgBaiduJump.Text);
            }
            else
            {
                TriggerMapAbort.Checked = false;
                TriggerMapAbort.Visible = true;
                DirectoryInfo map_dir = new DirectoryInfo(map_name.Text);
                if (map_dir.Exists && map_dir.GetFiles().Length + map_dir.GetDirectories().Length > 0 && RepairDir.Checked == false)
                {
                    MessageBox.Show("Already There\n\nnote: if specifying an existing directory it needs to be empty");
                }
                else
                {
                    bool diff_drive = false;
                    if (map_name.Text.Length >= 2) // C:...
                    {
                        if (map_name.Text.Substring(1, 1) == ":") // C:
                        {
                            if (map_name.Text.Substring(0, 1).ToUpper() != Directory.GetCurrentDirectory().Substring(0, 1).ToUpper()) // C vs D
                            {
                                if (RepairDir.Checked == false)
                                {
                                    diff_drive = true;
                                }
                            }
                        }
                    }
                    string dest_dir = map_name.Text;
                    if (LocalGPSFStemp.Checked && diff_drive)
                    {
                        map_name.Text = ran.Next(100000, 999999).ToString();
                        map_dir = new DirectoryInfo(map_name.Text);
                    }

                    tiles_missed = false;

                    int zoom_multiple = 1;
                    for (int i = Int32.Parse(Mzoom.Text); i > Int32.Parse(Minzoom.Text); i--)
                    {
                        zoom_multiple *= 2;
                    }

                    int span = 2;

                    if (zoom_multiple * span > 1024 && MessageBox.Show("This will result in a map that is probably too big (" + (zoom_multiple * span).ToString() + " where 1024 maximum is suggested), do you wish to abort?", "", MessageBoxButtons.YesNo) == DialogResult.Yes)
                    {
                        //MessageBox.Show("Area selected with minimum zoom is too big (" + (zoom_multiple * span).ToString() + " where 1024 max)");
                    }
                    else
                    {
                        DataTable to_skip = new DataTable();
                        to_skip.Columns.Add("zoom", typeof(Int32));
                        to_skip.Columns.Add("min_x", typeof(Int32));
                        to_skip.Columns.Add("min_y", typeof(Int32));
                        to_skip.Columns.Add("max_x", typeof(Int32));
                        to_skip.Columns.Add("max_y", typeof(Int32));
                        if (Int32.Parse(Mzoom.Text) - Int32.Parse(Minzoom.Text) > 2 && SelectiveDetail.Checked)
                        {
                            SelectDetail4x detail = new SelectDetail4x(Int32.Parse(Mzoom.Text), Int32.Parse(Minzoom.Text), Int32.Parse(Mx.Text), Int32.Parse(My.Text), MapType(), mu, wc);
                            detail.ShowDialog();
                            while (detail.Visible)
                            {
                                Thread.Sleep(500);
                            }
                            to_skip = detail.TilesToIgnore;

                            if (detail.DoCancel)
                                TriggerMapAbort.Checked = true;
                        }
                        int to_skip_count = 0;
                        foreach (DataRow row in to_skip.Select("zoom = -99"))
                        {
                            to_skip_count = (int)row["min_x"];
                        }

                        FilesDone.Text = "";

                        if (map_dir.Exists == false)
                            map_dir.Create();

                        int wTLx = Int32.Parse(Mx.Text) * zoom_multiple;
                        int wTLy = Int32.Parse(My.Text) * zoom_multiple;

                        if (NoCoords.Checked == false && new FileInfo(map_name.Text + "/coords.txt").Exists == false)
                        {
                            StreamWriter sr = new StreamWriter(map_name.Text + "/coords.txt");
                            if (iMAP2GOm.Checked)
                                sr.WriteLine(wTLx.ToString() + " " + (System.Convert.ToInt32(Math.Pow(2, 16 - Int32.Parse(Minzoom.Text))) - wTLy - 1).ToString() + " " + (711 + Int32.Parse(Minzoom.Text)).ToString());
                            else
                                sr.WriteLine(wTLx.ToString() + " " + wTLy.ToString() + " " + Minzoom.Text);
                            sr.Close();
                        }

                        missing_tiles.Rows.Clear();

                        try
                        {
                            int done_files = 1;
                            int total_files = TotalFiles(Int32.Parse(Mzoom.Text), Int32.Parse(Minzoom.Text));
                            true_done_files = 0;

                            running_threads = 0;

                            string map_type = MapType();
                            string ext = mu.ExtByType(map_type);
                            string overlay = tOverlay.Text.Trim();
                            if (overlay != "")
                                ext = ".jpg";
                            if (ReEncToJPG.Checked)
                                ext = ".jpg";

                            int the_zoom = Int32.Parse(Mzoom.Text);
                            int dir_multiple = 1;
                            for (int dir_zoom = zoom_multiple; dir_zoom >= 1; dir_zoom /= 2, the_zoom--, dir_multiple *= 2)
                            {
                                if (to_skip.Select("zoom = " + the_zoom.ToString()
                                    + " AND min_x = -1 AND min_y = -1 AND max_x = -1 AND max_y = -1").Length == 0)
                                {
                                    DirectoryInfo dir_x = new DirectoryInfo(map_name.Text + "/" + dir_zoom.ToString() + "x");
                                    if (dir_x.Exists == false)
                                        dir_x.Create();

                                    int Zx = Int32.Parse(Mx.Text) * dir_multiple;
                                    int Zy = Int32.Parse(My.Text) * dir_multiple;

                                    for (int dir_row = 0; dir_row < span * dir_multiple; dir_row++)
                                    {
                                        DirectoryInfo dir_num = new DirectoryInfo(map_name.Text + "/" + dir_zoom.ToString() + "x" + "/" + dir_row.ToString("000"));
                                        if (dir_num.Exists == false)
                                            dir_num.Create();

                                        for (int fil_col = 0; fil_col < span * dir_multiple; fil_col++)
                                        {
                                            if (TriggerMapAbort.Checked)
                                            {
                                                int i1 = Int32.Parse("Need an error thrown");
                                            }

                                            if (to_skip.Select("zoom = " + the_zoom.ToString()
                                                + " AND min_x <= " + (Zx + fil_col).ToString() + " AND min_y <= " + (Zy + dir_row).ToString() + " AND max_x >= " + (Zx + fil_col).ToString() + " AND max_y >= " + (Zy + dir_row).ToString()).Length == 0)
                                            {
                                                string part_file_name = dir_zoom.ToString() + "x" + dir_row.ToString("000") + fil_col.ToString("000");
                                                string full_file_name = map_name.Text + "/" + dir_zoom.ToString() + "x" + "/" + dir_row.ToString("000") + "/" + part_file_name + ext;

                                                if (DoThread.Checked)
                                                {
                                                    while (running_threads > Int32.Parse(NumThreads.Text))
                                                    {
                                                        Thread.Sleep(1);
                                                    }
                                                    Thread tile_thread = new Thread(new ParameterizedThreadStart(GetThreadTile));
                                                    tile_thread.Start(new Object[] { the_zoom, Zx + fil_col, Zy + dir_row, full_file_name, map_type, overlay });

                                                    RunningThreads.Text = running_threads.ToString();
                                                    Application.DoEvents();
                                                }
                                                else
                                                {
                                                    GetThreadTile(new Object[] { the_zoom, Zx + fil_col, Zy + dir_row, full_file_name, map_type, overlay });
                                                }

                                                percent_done = (100 * done_files / (total_files - to_skip_count)).ToString("0") + "% - ";
                                                if (this.Text.IndexOf("%") == -1)
                                                    this.Text = percent_done + this.Text;
                                                else
                                                    this.Text = percent_done + this.Text.Substring(this.Text.IndexOf("%") + 4, this.Text.Length - 4 - this.Text.IndexOf("%"));
                                                FilesDone.Text = percent_done + done_files.ToString() + " out of " + (total_files - to_skip_count).ToString() + " now at zoom " + dir_zoom.ToString() + "x (got " + true_done_files.ToString() + ")";
                                                Application.DoEvents();
                                                done_files++;
                                            }
                                        }
                                    }
                                }
                            }

                            // wait for threads to finish up
                            while (running_threads > 0)
                            {
                                Thread.Sleep(5);
                            }

                            if (CopyIcons.Checked && new DirectoryInfo("icons").Exists)
                            {
                                foreach (FileInfo icon in new DirectoryInfo("icons").GetFiles("*.png"))
                                {
                                    if (new FileInfo(map_name.Text + "\\" + icon.Name).Exists == false)
                                    {
                                        icon.CopyTo(map_name.Text + "\\" + icon.Name);
                                    }
                                }
                            }

                            if (CopySounds.Checked && new DirectoryInfo("sounds").Exists)
                            {
                                foreach (FileInfo sound in new DirectoryInfo("sounds").GetFiles("*.mp3"))
                                {
                                    if (new FileInfo(map_name.Text + "\\" + sound.Name).Exists == false)
                                    {
                                        sound.CopyTo(map_name.Text + "\\" + sound.Name);
                                    }
                                }
                            }

                            if (missing_tiles.Rows.Count > 0 && PromptToRetryTiles.Checked)
                            {
                                new GMdl_2ndTryDL(missing_tiles.Copy(), mu, wc, ReEncToJPG.Checked).ShowDialog();
                            }

                            if (FillMissingTiles.Checked)
                            {
                                FilesDone.Text = "Filling missing tiles";
                                Application.DoEvents();
                                FillMissingTilesProc(map_name.Text, ext);
                            }

                            // top 2x2
                            try
                            {
                                if (new FileInfo(map_name.Text + "\\" + zoom_multiple.ToString() + "x\\000\\" + zoom_multiple.ToString() + "x000000" + ext).Exists == false)
                                {
                                    new FileInfo("resources\\empty_tile" + ext).CopyTo(map_name.Text + "\\" + zoom_multiple.ToString() + "x\\000\\" + zoom_multiple.ToString() + "x000000" + ext);
                                }
                            }
                            catch { }
                            try
                            {
                                if (new FileInfo(map_name.Text + "\\" + zoom_multiple.ToString() + "x\\000\\" + zoom_multiple.ToString() + "x000001" + ext).Exists == false)
                                {
                                    new FileInfo("resources\\empty_tile" + ext).CopyTo(map_name.Text + "\\" + zoom_multiple.ToString() + "x\\000\\" + zoom_multiple.ToString() + "x000001" + ext);
                                }
                            }
                            catch { }
                            try
                            {
                                if (new FileInfo(map_name.Text + "\\" + zoom_multiple.ToString() + "x\\001\\" + zoom_multiple.ToString() + "x001000" + ext).Exists == false)
                                {
                                    new FileInfo("resources\\empty_tile" + ext).CopyTo(map_name.Text + "\\" + zoom_multiple.ToString() + "x\\001\\" + zoom_multiple.ToString() + "x001000" + ext);
                                }
                            }
                            catch { }
                            try
                            {
                                if (new FileInfo(map_name.Text + "\\" + zoom_multiple.ToString() + "x\\001\\" + zoom_multiple.ToString() + "x001001" + ext).Exists == false)
                                {
                                    new FileInfo("resources\\empty_tile" + ext).CopyTo(map_name.Text + "\\" + zoom_multiple.ToString() + "x\\001\\" + zoom_multiple.ToString() + "x001001" + ext);
                                }
                            }
                            catch { }

                            // top left and bottom right (directories exist)
                            try
                            {
                                if (new FileInfo(map_name.Text + "\\1x\\000\\1x000000" + ext).Exists == false)
                                {
                                    new FileInfo("resources\\empty_tile" + ext).CopyTo(map_name.Text + "\\1x\\000\\1x000000" + ext);
                                }
                            }
                            catch { }
                            try
                            {
                                string bottom_right = (Math.Pow(2, 1 + Int32.Parse(Mzoom.Text) - Int32.Parse(Minzoom.Text)) - 1).ToString("000");
                                if (new FileInfo(map_name.Text + "\\1x\\" + bottom_right + "\\1x" + bottom_right + bottom_right + ext).Exists == false)
                                {
                                    new FileInfo("resources\\empty_tile" + ext).CopyTo(map_name.Text + "\\1x\\" + bottom_right + "\\1x" + bottom_right + bottom_right + ext);
                                }
                            }
                            catch { }


                            // empty directories
                            foreach (DirectoryInfo dir_x in new DirectoryInfo(map_name.Text).GetDirectories())
                            {
                                foreach (DirectoryInfo dir_n in dir_x.GetDirectories())
                                {
                                    if (dir_n.GetFiles().Length == 0)
                                        dir_n.Delete();
                                }
                            }

                            
                        }
                        catch
                        {
                            if (RepairDir.Checked == false)
                            {
                                new DirectoryInfo(map_name.Text).Delete(true); // don't delete if repairing
                            }
                            
                            MessageBox.Show(msgPullError.Text);
                        }
                    }

                    if (new DirectoryInfo(map_name.Text).Exists) // didn't get deleted by an error thrown
                    {
                        if (NoGPSFS.Checked)
                        {
                            FilesDone.Text = "Finishing up, wait";

                            // directories
                            DirectoryInfo temp_dirDI = new DirectoryInfo(map_name.Text);
                            
                            if (diff_drive) // move?
                            {
                                DirectoryInfo dest_dirDI = new DirectoryInfo(dest_dir);
                                if (dest_dirDI.Exists == false)
                                    dest_dirDI.Create();
                                foreach (FileInfo file in temp_dirDI.GetFiles())
                                {
                                    file.MoveTo(dest_dirDI.FullName + "\\" + file.Name);
                                }
                                foreach (DirectoryInfo file_dir in temp_dirDI.GetDirectories())
                                {
                                    CopyDir.Copy(file_dir.FullName, dest_dirDI.FullName + "\\" + file_dir.Name); // because...
                                }
                                temp_dirDI.Delete(true);
                            }

                            map_name.Text = dest_dir;

                            if (AutoGeoData.Checked)
                            {
                                string geo_country = "";
                                if (AutoGeoDataUSA.Checked)
                                    geo_country = "USA";
                                if (AutoGeoDataCanada.Checked)
                                    geo_country = "Canada";
                                new GEOmain(map_name.Text, geo_country).ShowDialog();
                            }

                            if (tiles_missed)
                                MessageBox.Show("Finished downlaoding the map\nbut there were missed tiles, see ERROR_LOG.txt in the map folder");
                            else
                                MessageBox.Show("Finished downlaoding the map");
                        }
                        else
                        {
                            // encode
                            FilesDone.Text = "Creating GPSFS, wait";
                            Application.DoEvents();
                            bool worked = new GPSFS().CreateGPSFS(map_name.Text);

                            if (worked)
                            {
                                // directories
                                DirectoryInfo temp_dirDI = new DirectoryInfo(map_name.Text);
                                new FileInfo(temp_dirDI.FullName + "\\" + "coords.txt").Delete();
                                foreach (DirectoryInfo dir_x in temp_dirDI.GetDirectories())
                                {
                                    dir_x.Delete(true);
                                }
                                if (diff_drive) // move?
                                {
                                    DirectoryInfo dest_dirDI = new DirectoryInfo(dest_dir);
                                    if (dest_dirDI.Exists == false)
                                        dest_dirDI.Create();
                                    foreach (FileInfo file in temp_dirDI.GetFiles())
                                    {
                                        file.MoveTo(dest_dirDI.FullName + "\\" + file.Name);
                                    }
                                    temp_dirDI.Delete();
                                }

                                map_name.Text = dest_dir;

                                if (AutoGeoData.Checked)
                                {
                                    string geo_country = "";
                                    if (AutoGeoDataUSA.Checked)
                                        geo_country = "USA";
                                    if (AutoGeoDataCanada.Checked)
                                        geo_country = "Canada";
                                    new GEOmain(map_name.Text, geo_country).ShowDialog();
                                }
                                string tiles_missed_str = "";
                                if (tiles_missed)
                                    tiles_missed_str = "\nbut there were missed tiles, see ERROR_LOG.txt in the map folder";

                                string done_msg = "Finished downlaoding the map" + tiles_missed_str + "\n\nand\n\nGPSFS created";

                                if (new FileInfo(GPSFS_util_exe).Exists)
                                {
                                    if (MessageBox.Show(done_msg + "\n\nWould you like to run GPSFS_util to try and reduce the map size?", "", MessageBoxButtons.YesNo) == DialogResult.Yes)
                                    {
                                        string full_map_path = new DirectoryInfo(map_name.Text).FullName;

                                        Process proc = new Process();
                                        proc.StartInfo.FileName = GPSFS_util_exe;
                                        proc.StartInfo.Arguments = full_map_path;
                                        proc.Start();
                                    }
                                }
                                else
                                {
                                    MessageBox.Show(done_msg);
                                }
                            }
                            else
                            {
                                MessageBox.Show("Something went wrong, invalid dir, GPSFS already exists, etc.\n\n" + map_name.Text + " + is where it's (temp) at\n\nnever having made it to" + dest_dir + " (if different)");
                            }
                        }
                    }
                }

                TriggerMapAbort.Checked = false;
                TriggerMapAbort.Visible = false;
            }
        }

        string GPSFS_util_exe = "GPSFS_util\\GPSFS_util.exe";

        private void FillMissingTilesProc(string map_dir, string ext)
        {
            DirectoryInfo td = new DirectoryInfo(map_dir);

            int top_dir = 0;

            foreach (DirectoryInfo dir in td.GetDirectories("*x"))
            {
                if (Int32.Parse(dir.Name.Replace("x", "")) > top_dir)
                    top_dir = Int32.Parse(dir.Name.Replace("x", ""));
            }

            int zoom = 1;
            while (zoom <= top_dir)
            {
                int row = 0;
                while (row < (top_dir * 2) / zoom)
                {
                    int col = 0;
                    while (col < (top_dir * 2) / zoom)
                    {
                        FileInfo file = new FileInfo(map_dir + "/" + zoom.ToString() + "x/" + row.ToString("000") + "/" + zoom.ToString() + "x" + row.ToString("000") + col.ToString("000") + ext);

                        if (file.Exists == false)
                        {
                            new FileInfo("resources\\empty_tile" + ext).CopyTo(file.FullName);
                        }

                        col++;
                    }
                    row++;
                }
                zoom = zoom * 2;
            }
        }

        private void GetThreadTile(object Thread_xyz) // static?
        {
            running_threads++;
            Object[] thread_xyz = (Object[])Thread_xyz;
            int thread_z = (int)thread_xyz[0];
            int thread_x = (int)thread_xyz[1];
            int thread_y = (int)thread_xyz[2];
            string full_file_name = (string)thread_xyz[3];
            string map_type = (string)thread_xyz[4];
            string overlay = (string)thread_xyz[5];

            FileInfo file_info = new FileInfo(full_file_name);

            if (file_info.Exists == false)
            {
                if (WarnOnTileFail.Checked)
                {
                    if (ran.Next(1, 10) == 1)
                    {
                        CheckGoogleSat();
                    }
                }

                if (DelayTile.Checked)
                {
                    Thread.Sleep(System.Convert.ToInt32((decimal)1000 * Decimal.Parse(DelayTileSec.Text)));
                }

                if (overlay != "")
                {
                    Bitmap sat = new Bitmap(1, 1);
                    Bitmap trans = new Bitmap(1, 1);

                    try
                    {
                        if (map_type == "iYs")
                        {
                            sat = (Bitmap)new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type)))).GetThumbnailImage(256, 256, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero);
                        }
                        else
                        {
                            sat = new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type))));
                        }
                    }
                    catch
                    {
                        try
                        {
                            if (map_type == "iYs")
                            {
                                sat = (Bitmap)new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type)))).GetThumbnailImage(256, 256, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero);
                            }
                            else
                            {
                                sat = new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type))));
                            }
                        }
                        catch
                        {
                            try
                            {
                                if (WarnOnTileFail.Checked)
                                    CheckGoogleSat();

                                if (map_type == "iYs")
                                {
                                    sat = (Bitmap)new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type)))).GetThumbnailImage(256, 256, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero);
                                }
                                else
                                {
                                    sat = new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type))));
                                }
                            }
                            catch { }
                        }
                    }

                    try
                    {
                        if (overlay == "Yahooo Hybrid")
                        {
                            trans = (Bitmap)new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, overlay)))).GetThumbnailImage(256, 256, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero);
                        }
                        else
                        {
                            trans = new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, overlay))));
                        }
                    }
                    catch
                    {
                        try
                        {
                            if (overlay == "Yahooo Hybrid")
                            {
                                trans = (Bitmap)new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, overlay)))).GetThumbnailImage(256, 256, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero);
                            }
                            else
                            {
                                trans = new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, overlay))));
                            }
                        }
                        catch
                        {
                            try
                            {
                                if (overlay == "Yahooo Hybrid")
                                {
                                    trans = (Bitmap)new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, overlay)))).GetThumbnailImage(256, 256, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero);
                                }
                                else
                                {
                                    trans = new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, overlay))));
                                }
                            }
                            catch { }
                        }
                    }

                    if (sat.Width != 1 && trans.Width != 1)
                    {
                        true_done_files++;

                        Graphics.FromImage(sat).DrawImage(trans, new Rectangle(0, 0, 256, 256), new Rectangle(0, 0, 256, 256), System.Drawing.GraphicsUnit.Pixel);
                        sat.Save(full_file_name, System.Drawing.Imaging.ImageFormat.Jpeg);
                        sat.Dispose();
                        trans.Dispose();
                    }
                    else
                    {
                        if (IgnoreMissingTiles.Checked == false)
                        {
                            if (PromptToRetryTiles.Checked)
                            {
                                DataRow missed_tile = missing_tiles.NewRow();
                                missed_tile["x"] = thread_x;
                                missed_tile["y"] = thread_y;
                                missed_tile["z"] = thread_z;
                                missed_tile["File"] = full_file_name;
                                missed_tile["map_type"] = map_type;
                                missed_tile["overlay"] = overlay;
                                missing_tiles.Rows.Add(missed_tile);
                            }
                            else
                            {
                                int i1 = Int32.Parse("Need an error thrown");
                            }
                        }
                        else
                        {
                            StreamWriter sr2 = new StreamWriter(map_name.Text + "/ERROR_LOG.txt", true);
                            sr2.WriteLine(mu.MapByType(thread_z, thread_x, thread_y, map_type) + " TO " + full_file_name);
                            sr2.Close();
                            tiles_missed = true;
                        }
                    }
                }
                else
                {
                    true_done_files++;
                    try
                    {
                        if (map_type.StartsWith("iMC"))
                        {
                            string file_loc = mu.MapByType(thread_z, thread_x, thread_y, map_type);
                            if (new FileInfo(file_loc).Exists)
                            {
                                if (map_type.StartsWith("iMCjpg"))
                                    new Bitmap(new MemoryStream(File.ReadAllBytes(file_loc))).Save(full_file_name, System.Drawing.Imaging.ImageFormat.Jpeg);
                                else if (map_type.StartsWith("iMCpng"))
                                    new FileInfo(file_loc).CopyTo(full_file_name);
                            }
                            else
                            {
                                true_done_files--;
                            }
                        }
                        else if (map_type.StartsWith("iSI"))
                        {
                            string file_loc = mu.MapByType(thread_z, thread_x, thread_y, map_type);
                            if (new FileInfo(file_loc).Exists)
                                new FileInfo(file_loc).CopyTo(full_file_name);
                            else
                                true_done_files--;
                        }
                        else
                            GetTile(thread_z, thread_x, thread_y, full_file_name, map_type);
                    }
                    catch
                    {
                        try
                        {
                            GetTile(thread_z, thread_x, thread_y, full_file_name, map_type);
                        }
                        catch
                        {
                            try
                            {
                                if (WarnOnTileFail.Checked)
                                    CheckGoogleSat();

                                GetTile(thread_z, thread_x, thread_y, full_file_name, map_type);
                            }
                            catch
                            {
                                true_done_files--;
                                if (IgnoreMissingTiles.Checked == false)
                                {
                                    if (PromptToRetryTiles.Checked)
                                    {
                                        DataRow missed_tile = missing_tiles.NewRow();
                                        missed_tile["x"] = thread_x;
                                        missed_tile["y"] = thread_y;
                                        missed_tile["z"] = thread_z;
                                        missed_tile["File"] = full_file_name;
                                        missed_tile["map_type"] = map_type;
                                        missed_tile["overlay"] = overlay;
                                        missing_tiles.Rows.Add(missed_tile);
                                    }
                                    else
                                    {
                                        int i1 = Int32.Parse("Need an error thrown");
                                    }
                                }
                                else
                                {
                                    StreamWriter sr2 = new StreamWriter(map_name.Text + "/ERROR_LOG.txt", true);
                                    sr2.WriteLine(mu.MapByType(thread_z, thread_x, thread_y, map_type) + " TO " + full_file_name);
                                    sr2.Close();
                                    tiles_missed = true;
                                }
                            }
                        }
                    }
                }
            }
            running_threads--;
        }

        private void GetTile(int thread_z, int thread_x, int thread_y, string full_file_name, string map_type)
        {
            //For re-encoding quality... (qould also need to implement in 2nd try)
            //Info[1] is jpeg apaprently
            //System.Drawing.Imaging.EncoderParameters Params = new System.Drawing.Imaging.EncoderParameters(0);
            //System.Drawing.Imaging.ImageCodecInfo[] Info = System.Drawing.Imaging.ImageCodecInfo.GetImageEncoders();
            
            System.Drawing.Imaging.ImageFormat png = System.Drawing.Imaging.ImageFormat.Png;
            System.Drawing.Imaging.ImageFormat jpg = System.Drawing.Imaging.ImageFormat.Jpeg;
            if (ReEncToJPG.Checked)
            {
                png = jpg;
                //Params = new System.Drawing.Imaging.EncoderParameters(1);
                //Params.Param[0] = new System.Drawing.Imaging.EncoderParameter(System.Drawing.Imaging.Encoder.Quality, 100L);
            }

            if (map_type == "iBAIDUm")
                new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type)))).GetThumbnailImage(256, 256, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero).Save(full_file_name, png);
            else if (map_type == "iMAP2GOm")
                new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type)))).Save(full_file_name, png);
            else if (map_type == "iYs")
                new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type)))).GetThumbnailImage(256, 256, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero).Save(full_file_name, jpg);
            else if (map_type == "iYm")
                new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type)))).GetThumbnailImage(256, 256, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero).Save(full_file_name, png);
            else if (map_type == "iMabc")
                new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type)))).Save(full_file_name, png);
            else if (map_type.StartsWith("iMETRO") || map_type.StartsWith("iUB"))
                new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type)))).Save(full_file_name, png);
            else if (ReEncToJPG.Checked)
                new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type)))).Save(full_file_name, jpg);
            else
                wc.DownloadFile(mu.MapByType(thread_z, thread_x, thread_y, map_type), full_file_name);

            if (iNASA.Checked || iWMS.Checked || iUSGSortho.Checked || iUSGStopo.Checked || iUSGSuortho.Checked)
            {
                FileInfo file_info = new FileInfo(full_file_name);
                try
                {
                    Bitmap testbm = new Bitmap(new MemoryStream(File.ReadAllBytes(file_info.FullName)));
                    testbm.Dispose();
                }
                catch
                {
                    if (WarnOnWMS.Checked)
                    {
                        MessageBox.Show("WMS server is probably busy, wait a while then continue:\n\n" + new StreamReader(file_info.FullName).ReadToEnd());
                    }
                    file_info.Delete();

                    int i1 = Int32.Parse("Need an error thrown");
                }
            }
        }

        private bool ThumbnailCallback()
        {
            return false;
        }

        private void TBload_Click(object sender, EventArgs e)
        {
            p11.Image = null;
            p12.Image = null;
            p13.Image = null;

            p21.Image = null;
            p22.Image = null;
            p23.Image = null;

            p31.Image = null;
            p32.Image = null;
            p33.Image = null;

            DirectoryInfo td = new DirectoryInfo(tdir.Text);

            if (td.Exists)
            {
                int top_dir = 0;
                foreach (DirectoryInfo dir in td.GetDirectories("*x"))
                {
                    //string top_dir_check = dir.Name;
                    //top_dir_check = top_dir_check.Substring(0, top_dir_check.LastIndexOf("x/"));
                    //top_dir_check = top_dir_check.Substring(top_dir_check.LastIndexOf("/") + 1, top_dir_check.Length - 1 - top_dir_check.LastIndexOf("/"));
                    if (Int32.Parse(dir.Name.Replace("x", "")) > top_dir)
                        top_dir = Int32.Parse(dir.Name.Replace("x", ""));
                }

                if (top_dir > 0)
                {
                    string ext = "png";
                    if (new DirectoryInfo(td.FullName + "/" + top_dir.ToString() + "x" + "/000").GetFiles("*.jpg").Length > 0)
                    {
                        ext = "jpg";
                    }

                    try
                    {
                        p11.Image = new Bitmap(new MemoryStream(File.ReadAllBytes(td.FullName + "\\" + top_dir.ToString() + "x" + "\\000\\" + top_dir.ToString() + "x000000." + ext)));
                    }
                    catch { }
                    try
                    {
                        p12.Image = new Bitmap(new MemoryStream(File.ReadAllBytes(td.FullName + "/" + top_dir.ToString() + "x" + "/000/" + top_dir.ToString() + "x000001." + ext)));
                    }
                    catch { }
                    try
                    {
                        p13.Image = new Bitmap(new MemoryStream(File.ReadAllBytes(td.FullName + "/" + top_dir.ToString() + "x" + "/000/" + top_dir.ToString() + "x000002." + ext)));
                    }
                    catch { }

                    try
                    {
                        p21.Image = new Bitmap(new MemoryStream(File.ReadAllBytes(td.FullName + "/" + top_dir.ToString() + "x" + "/001/" + top_dir.ToString() + "x001000." + ext)));
                    }
                    catch { }
                    try
                    {
                        p22.Image = new Bitmap(new MemoryStream(File.ReadAllBytes(td.FullName + "/" + top_dir.ToString() + "x" + "/001/" + top_dir.ToString() + "x001001." + ext)));
                    }
                    catch { }
                    try
                    {
                        p23.Image = new Bitmap(new MemoryStream(File.ReadAllBytes(td.FullName + "/" + top_dir.ToString() + "x" + "/001/" + top_dir.ToString() + "x001002." + ext)));
                    }
                    catch { }

                    try
                    {
                        p31.Image = new Bitmap(new MemoryStream(File.ReadAllBytes(td.FullName + "/" + top_dir.ToString() + "x" + "/002/" + top_dir.ToString() + "x002000." + ext)));
                    }
                    catch { }
                    try
                    {
                        p32.Image = new Bitmap(new MemoryStream(File.ReadAllBytes(td.FullName + "/" + top_dir.ToString() + "x" + "/002/" + top_dir.ToString() + "x002001." + ext)));
                    }
                    catch { }
                    try
                    {
                        p33.Image = new Bitmap(new MemoryStream(File.ReadAllBytes(td.FullName + "/" + top_dir.ToString() + "x" + "/002/" + top_dir.ToString() + "x002002." + ext)));
                    }
                    catch { }

                }
                else // GPSFS secondary
                {
                    try
                    {
                        p11.Image = new GPSFS().GetGPSFStileReverse(td.FullName, 4);
                    }
                    catch { }
                    try
                    {
                        p12.Image = new GPSFS().GetGPSFStileReverse(td.FullName, 3);
                    }
                    catch { }
                    try
                    {
                        p21.Image = new GPSFS().GetGPSFStileReverse(td.FullName, 2);
                    }
                    catch { }
                    try
                    {
                        p22.Image = new GPSFS().GetGPSFStileReverse(td.FullName, 1);
                    }
                    catch { }
                }
            }
        }

        private void UserMode_Click(object sender, EventArgs e)
        {
            if (AdvancedPanel.Visible == false)
            {
                UserMode.Text = bAdvSimp.Text;
                AdvancedPanel.Visible = true;
                //MessageBox.Show(msgAdvanced.Text);
            }
            else
            {
                UserMode.Text = bAdvAdv.Text;
                AdvancedPanel.Visible = false;
            }
        }

        private void EasyMode_Click(object sender, EventArgs e)
        {
            if (map_name.Text == "")
            {
                SetMapDir_Click(Type.Missing, EventArgs.Empty);
            }

            bGN_Click(Type.Missing, EventArgs.Empty);

            if (Mzoom.Text != "")
            {
                bSP_Click(Type.Missing, EventArgs.Empty);
                bPF_Click(Type.Missing, EventArgs.Empty);

                tabs.SelectedTab = tT;

                tdir.Text = map_name.Text;

                TBload_Click(Type.Missing, EventArgs.Empty);
            }
        }

        private void bPR1_Click(object sender, EventArgs e)
        {
            try
            {
                int[] the_numbers = GetNumbers(wB.Document.Body.OuterHtml);
                int total_files = TotalFiles(the_numbers[0], Int32.Parse(Minzoom.Text));
                string page = HTMLmapPage(the_numbers[0], the_numbers[1], the_numbers[2], 2, 2);

                string ext = mu.ExtByType(MapType());
                if (tOverlay.Text.Trim() != "")
                    ext = ".jpg";

                new Prev1x(total_files, page, System.Convert.ToInt32(Math.Pow(2, 1 + the_numbers[0] - Int32.Parse(Minzoom.Text))), ext).ShowDialog();
            }
            catch
            {
                MessageBox.Show(msgPreview1.Text);
            }
        }

        private void bPR2_Click(object sender, EventArgs e)
        {
            try
            {
                int[] the_numbers = GetNumbers(wB.Document.Body.OuterHtml);
                int total_files = TotalFiles(the_numbers[0], Int32.Parse(Minzoom.Text));
                string page = HTMLmapPage(the_numbers[0] - 1, the_numbers[1] * 2, the_numbers[2] * 2, 4, 4);

                string ext = mu.ExtByType(MapType());
                if (tOverlay.Text.Trim() != "")
                    ext = ".jpg";

                new Prev2x(total_files, page, System.Convert.ToInt32(Math.Pow(2, 1 + the_numbers[0] - Int32.Parse(Minzoom.Text))), ext).ShowDialog();
            }
            catch
            {
                MessageBox.Show(msgPreview2.Text);
            }
        }

        private DataTable POI;
        private DataTable DIR;

        private void GMdl_Load(object sender, EventArgs e)
        {
            wc.Headers.Add("User-Agent", "Mozilla/4.0+");

            mu = new mapURL(wc);

            NumThreads.Text = "5";

            new Translation().LoadFile(this);

            new ToolTips().LoadFile(this, toolTip1);

            MoreSourcesTabs_SelectedIndexChanged(Type.Missing, EventArgs.Empty);

            if (this.Width < 1333 || this.Height < 863)
                this.WindowState = FormWindowState.Maximized;

            POI = new DataTable();
            POI.Columns.Add("Name", typeof(String));
            POI.Columns.Add("Icon", typeof(String));
            POI.Columns.Add("Lat", typeof(Decimal));
            POI.Columns.Add("Lon", typeof(Decimal));
            poiGrid.DataSource = POI;

            DIR = new DataTable();
            DIR.Columns.Add("Name", typeof(String));
            DIR.Columns.Add("Lat", typeof(Decimal));
            DIR.Columns.Add("Lon", typeof(Decimal));
            dirGrid.DataSource = DIR;

            dirDist.SelectedIndex = 1;

            // icons and sizes (pictures in the future maybe)
            if (new DirectoryInfo("icons").Exists)
            {
                foreach (FileInfo icon in new DirectoryInfo("icons").GetFiles("*.png"))
                {
                    //poiImage.Items.Add(icon.Name); // + "," + image.Width.ToString() + "," + image.Height.ToString() + ",");
                    //dirImage.Items.Add(icon.Name); // + "," + image.Width.ToString() + "," + image.Height.ToString() + ",");

                    FileStream image_file = new FileStream(icon.FullName, FileMode.Open);
                    Bitmap image = new Bitmap(image_file);
                    image_file.Close();

                    ToolStripMenuItem ti1 = new ToolStripMenuItem();
                    ti1.Text = icon.Name;
                    ti1.Image = image;
                    poiImage.DropDownItems.Add(ti1);

                    ToolStripMenuItem ti2 = new ToolStripMenuItem();
                    ti2.Text = icon.Name;
                    ti2.Image = image;
                    dirImage.DropDownItems.Add(ti2);

                    ToolStripMenuItem ti3 = new ToolStripMenuItem();
                    ti3.Text = icon.Name;
                    ti3.Image = image;
                    dirImage2.DropDownItems.Add(ti3);
                }
            }

            // thanks to harpik and dloading
            string proxy = "";
            string user = "";
            string pass = "";
            string domain = "";
            // get from config.txt
            if (new FileInfo("config.txt").Exists)
            {
                string config = new StreamReader("config.txt").ReadToEnd().Replace(" ", "");
                if (config.IndexOf("PROXY=") != -1)
                {
                    proxy = config.Substring(config.IndexOf("=", config.IndexOf("PROXY=")) + 1, config.IndexOf("#", config.IndexOf("PROXY=")) - 1 - config.IndexOf("=", config.IndexOf("PROXY="))).Trim();
                    user = config.Substring(config.IndexOf("=", config.IndexOf("USER=")) + 1, config.IndexOf("#", config.IndexOf("USER=")) - 1 - config.IndexOf("=", config.IndexOf("USER="))).Trim();
                    pass = config.Substring(config.IndexOf("=", config.IndexOf("PASS=")) + 1, config.IndexOf("#", config.IndexOf("PASS=")) - 1 - config.IndexOf("=", config.IndexOf("PASS="))).Trim();
                    domain = config.Substring(config.IndexOf("=", config.IndexOf("DOMAIN=")) + 1, config.IndexOf("#", config.IndexOf("DOMAIN=")) - 1 - config.IndexOf("=", config.IndexOf("DOMAIN="))).Trim();
                }
            }
            if (proxy != "")
            {
                try
                {
                    WebProxy mp = new WebProxy(proxy, true);
                    NetworkCredential myCred;
                    if (domain.CompareTo("") == 0)
                    {
                        // If user did not write domain its authentication method don't need it
                        myCred = new NetworkCredential(user, pass);
                    }
                    else
                    {
                        // If user put domain we need to use it, maybe he authenticate against NT Lan Manager 
                        myCred = new NetworkCredential(user, pass, domain);
                    }
                    mp.Credentials = myCred;
                    wc.Proxy = mp; // "wc" is the WebClient object 

                    MessageBox.Show("Proxy settings sucessfully loaded from config.txt");
                }
                catch
                {
                    MessageBox.Show("Failed to load proxy settings from config.txt");
                }
            }

            // the update check
            new UpdateCheck(this.Text, wc);

            // the build version
            string build = System.Windows.Forms.Application.ProductVersion;
            build = build.Substring(build.LastIndexOf(".") + 1, build.Length - 1 - build.LastIndexOf("."));
            this.Text = this.Text + " - Build " + build;

            //the TOS compliance
            new TOScompliance(wc);

            bool done = false;
            string page = "";
            int errors = 0;
            while (done == false)
            {
                try
                {
                    page = wc.DownloadString("http://maps.google.com");
                    done = true;
                }
                catch (System.Net.WebException We)
                {
                    System.Net.HttpWebResponse hwr = (System.Net.HttpWebResponse)We.Response;

                    if (hwr == null)
                    {
                        if (errors > 0)
                        {
                            if (MessageBox.Show("No internet connection, for the WebClient object (trying http://maps.google.com), try again?\n\nOr, if the embedded Internet Explorer window does load in the background this is probably a firewall/antivirus/proxy problem - check your setting.", "", MessageBoxButtons.YesNo) == DialogResult.No)
                            {
                                done = true;
                            }
                        }
                    }
                    else if (hwr.StatusCode == System.Net.HttpStatusCode.ProxyAuthenticationRequired)
                    {
                        if (errors > 0)
                        {
                            MessageBox.Show("Wrong or empty proxy info, try again...");
                        }
                        new SetProxy(wc).ShowDialog();
                    }
                    else
                    {
                        if (errors > 0)
                        {
                            MessageBox.Show("Unknown connectivity error (" + hwr.StatusCode.ToString() + "), try again...");
                        }
                    }
                }
                errors++;
            }

            string google_mt = "google.com/mt?n=404&v=";
            int start = page.IndexOf(google_mt);
            while (start != -1)
            {
                start += google_mt.Length;
                string google_ver = page.Substring(start, page.IndexOf("&", start) - start);
                if (google_ver.IndexOf("t") != -1)
                    iTversion.Text = google_ver;
                else
                    iMversion.Text = google_ver;
                start = page.IndexOf(google_mt, start);
            }

            missing_tiles.Columns.Add("x", typeof(Int32));
            missing_tiles.Columns.Add("y", typeof(Int32));
            missing_tiles.Columns.Add("z", typeof(Int32));
            missing_tiles.Columns.Add("File", typeof(String));
            missing_tiles.Columns.Add("map_type", typeof(String));
            missing_tiles.Columns.Add("overlay", typeof(String));

            string google_s = "google.com/kh?n=404&v=";
            start = page.IndexOf(google_s);
            while (start != -1)
            {
                start += google_mt.Length;
                string google_ver = page.Substring(start, page.IndexOf("&", start) - start);
                iSversion.Text = google_ver;
                start = page.IndexOf(google_s, start);
            }

            page = "";
            try
            {
                page = wc.DownloadString("http://ditu.google.cn");
            }
            catch { }

            string google_abc = "mapgoogle.mapabc.com/googlechina/maptile?v=";
            start = page.IndexOf(google_abc);
            while (start != -1)
            {
                start += google_abc.Length;
                string google_abc_ver = page.Substring(start, page.IndexOf("&", start) - start);
                iMabcversion.Text = google_abc_ver;
                start = page.IndexOf(google_abc, start);
            }

            iYsatV.Text = "1.6";
        }

        private void ToGoogle_Click(object sender, EventArgs e)
        {
            wDB.Navigate("http://maps.google.com");
        }

        private void ToMSN_Click(object sender, EventArgs e)
        {
            wDB.Navigate("http://local.live.com");
        }

        private void ToText_Click(object sender, EventArgs e)
        {
            wDBtext.Text = wDB.Document.Body.OuterHtml;
        }

        private void ToWB_Click(object sender, EventArgs e)
        {
            wDB.DocumentText = wDBtext.Text;
        }

        private void poiGetNumbers_Click(object sender, EventArgs e)
        {
            try
            {
                string page = wPOI.Document.Body.OuterHtml;

                int start = page.IndexOf("&amp;ll=");

                start = page.IndexOf("=", start) + 1;
                int end = page.IndexOf(",", start);
                poiLat.Text = page.Substring(start, end - start);

                start = end + 1;
                end = page.IndexOf("&", start);
                poiLon.Text = page.Substring(start, end - start);

                start = page.IndexOf("=", start) + 1;
                end = page.IndexOf(",", start);
                poiLatS.Text = page.Substring(start, end - start);

                start = end + 1;
                end = page.IndexOf("&", start);
                poiLonS.Text = page.Substring(start, end - start);
            }
            catch
            {
                MessageBox.Show(msgGetNumbers.Text);
            }
        }

        private void poiList_Click(object sender, EventArgs e)
        {
            if (poiMap24.Checked)
            {
                if (poiAddNotRepl.Checked == false)
                    POI.Rows.Clear();

                try
                {
                    string page = wPOI.Document.Window.Frames[3].Document.Body.InnerHtml;

                    int start = page.IndexOf("addLocation");
                    while (start != -1)
                    {
                        start = page.IndexOf("\"", start) + 1;
                        int end = page.IndexOf("\"", start);
                        // loc num
                        start = page.IndexOf("\"", end + 1) + 1;
                        end = page.IndexOf("\"", start);
                        decimal lon = Decimal.Parse(page.Substring(start, end - start), NumberFormatInfo.InvariantInfo) / 60;
                        start = page.IndexOf("\"", end + 1) + 1;
                        end = page.IndexOf("\"", start);
                        decimal lat = Decimal.Parse(page.Substring(start, end - start), NumberFormatInfo.InvariantInfo) / 60;
                        start = page.IndexOf("\"", end + 1) + 1;
                        end = page.IndexOf("\"", start);
                        // empty
                        start = page.IndexOf("\"", end + 1) + 1;
                        end = page.IndexOf("\"", start);
                        // some num
                        start = page.IndexOf("\"", end + 1) + 1;
                        end = page.IndexOf("\"", start);
                        // empty
                        start = page.IndexOf("\"", end + 1) + 1;
                        end = page.IndexOf("\"", start) - 1;
                        string name_full = page.Substring(start, end - start);

                        string name_name = name_full;
                        try
                        {
                            name_name = name_full.Substring(0, name_full.IndexOf("|")).Trim(); // first
                        }
                        catch { }
                        string name_address = "";
                        try
                        {
                            name_address = name_full.Substring(name_full.IndexOf("|") + 1, name_full.LastIndexOf("|") - 1 - name_full.IndexOf("|")).Replace("|", "; ").Trim();
                        }
                        catch { }
                        string name_phone = "";
                        try
                        {
                            name_phone = name_full.Substring(name_full.LastIndexOf("|") + 1, name_full.Length - 1 - name_full.LastIndexOf("|")).Trim(); // last
                        }
                        catch { }

                        string name = name_name + "\n" + name_phone + " - " + name_address;

                        DataRow new_row = POI.NewRow();
                        new_row["Lat"] = lat;
                        new_row["Lon"] = lon;
                        new_row["Name"] = name.Replace(",", ";");
                        POI.Rows.Add(new_row);

                        start = page.IndexOf("addLocation", start);
                    }

                    MessageBox.Show("There are " + POI.Rows.Count.ToString() + " POIs");
                }
                catch
                {
                    MessageBox.Show(msgPOIerror.Text);
                }
            }
            else
            {
                if (poiSearch.Text.Trim() == "")
                {
                    MessageBox.Show(msgPOIterm.Text);
                }
                else
                {
                    try
                    {
                        if (poiAddNotRepl.Checked == false)
                            POI.Rows.Clear();

                        int yahoo_results = 0;

                        bool max_tripped = false;

                        decimal lat_step = Decimal.Parse(poiLatS.Text, NumberFormatInfo.InvariantInfo) / Decimal.Parse(poiLatDiv.Text, NumberFormatInfo.InvariantInfo);
                        decimal lon_step = Decimal.Parse(poiLonS.Text, NumberFormatInfo.InvariantInfo) / Decimal.Parse(poiLonDiv.Text, NumberFormatInfo.InvariantInfo);

                        decimal lat1a = Decimal.Parse(poiLat.Text, NumberFormatInfo.InvariantInfo) + (decimal)0.5 * Decimal.Parse(poiLatS.Text, NumberFormatInfo.InvariantInfo);
                        decimal lat2a = Decimal.Parse(poiLat.Text, NumberFormatInfo.InvariantInfo) - (decimal)0.5 * Decimal.Parse(poiLatS.Text, NumberFormatInfo.InvariantInfo);

                        decimal lon1a = Decimal.Parse(poiLon.Text, NumberFormatInfo.InvariantInfo) + (decimal)0.5 * Decimal.Parse(poiLonS.Text, NumberFormatInfo.InvariantInfo);
                        decimal lon2a = Decimal.Parse(poiLon.Text, NumberFormatInfo.InvariantInfo) - (decimal)0.5 * Decimal.Parse(poiLonS.Text, NumberFormatInfo.InvariantInfo);

                        decimal lat1 = lat1a;
                        decimal lat2 = lat1 - lat_step;

                        decimal lon1 = lon1a;
                        decimal lon2 = lon1 - lon_step;

                        while (lat2 >= lat2a)
                        {
                            while (lon2 >= lon2a)
                            {
                                bool yahoo_read = false;

                                bool more_left = true;
                                int poi_num = 0;
                                while (more_left)
                                {
                                    int records = 0;
                                    try
                                    {
                                        if (poiMSN.Checked)
                                        {
                                            string url = "http://local.live.com/search.ashx?a=" + poiSearch.Text.Trim() + "&c=" + lat1.ToString("0.000000").Replace(",", ".") + "&d=" + lon1.ToString("0.000000").Replace(",", ".") + "&e=" + lat2.ToString("0.000000").Replace(",", ".") + "&f=" + lon2.ToString("0.000000").Replace(",", ".") + "&g=" + poi_num.ToString() + "&i=2&t=yp&r=true"; // &r=true not required but makes shorter res
                                            string page = wc.DownloadString(url); // i=2 does nothing but seems to be required, can be any number, r=true ensures no adds(?)

                                            int start = page.IndexOf("new VE_SearchResult(");

                                            while (start != -1)
                                            {
                                                start = page.IndexOf("','", start) + 3;
                                                int end = page.IndexOf("','", start);
                                                string loc_name = page.Substring(start, end - start).Replace(",", ";").Trim();
                                                start = end + 3;
                                                end = page.IndexOf("','", start);
                                                string loc_add = page.Substring(start, end - start).Replace(",", ";").Trim();
                                                start = end + 3;
                                                end = page.IndexOf("',", start);
                                                string loc_pho = page.Substring(start, end - start).Replace(",", ";").Trim();
                                                string name = loc_name + "\n" + loc_pho + " - " + loc_add;
                                                while (name.IndexOf("  ") != -1)
                                                {
                                                    name = name.Replace("  ", " ");
                                                }

                                                start = page.IndexOf("',", end + 1) + 2;
                                                end = page.IndexOf(",", start);
                                                decimal lat = Decimal.Parse(page.Substring(start, end - start), NumberFormatInfo.InvariantInfo);

                                                start = end + 1;
                                                end = page.IndexOf(",", start);
                                                decimal lon = Decimal.Parse(page.Substring(start, end - start), NumberFormatInfo.InvariantInfo);

                                                if (POI.Select("Lat = " + lat.ToString("0.000000").Replace(",", ".") + " AND Lon = " + lon.ToString("0.000000").Replace(",", ".") + " AND Name = '" + name.Replace("'", "''") + "'").Length == 0) // the reported dupes
                                                {
                                                    DataRow new_row = POI.NewRow();
                                                    new_row["Lat"] = lat;
                                                    new_row["Lon"] = lon;
                                                    new_row["Name"] = name;
                                                    POI.Rows.Add(new_row);

                                                    records++;
                                                }

                                                start = page.IndexOf("new VE_SearchResult(", start);
                                            }
                                        }
                                        else if (poiYahoo.Checked)
                                        {
                                            string url = "http://xml1.maps.yahoo.com/lsx.xml?stx=" + poiSearch.Text.Trim() + "&lat=" + ((lat1 + lat2) / 2).ToString("0.000000").Replace(",", ".") + "&lon=" + ((lon1 + lon2) / 2).ToString("0.000000").Replace(",", ".") + "&begin=" + (poi_num + 1).ToString() + "&n=25&radius=" + poiYahooMi.Text;

                                            XmlDocument xmlDoc = new XmlDocument();
                                            xmlDoc.Load(url);

                                            foreach (XmlNode res in xmlDoc.GetElementsByTagName("searchtotal"))
                                            {
                                                if (yahoo_read == false)
                                                {
                                                    yahoo_results += Int32.Parse(res.InnerText);
                                                    yahoo_read = true;

                                                    if (Int32.Parse(res.InnerText) > 950)
                                                        max_tripped = true;
                                                }
                                            }

                                            foreach (XmlNode res in xmlDoc.GetElementsByTagName("listing"))
                                            {
                                                string loc_name = "";
                                                string loc_add = "";
                                                string loc_pho = "";
                                                decimal lat = 0;
                                                decimal lon = 0;
                                                foreach (XmlNode res2 in res.ChildNodes)
                                                {
                                                    if (res2.Name == "title")
                                                        loc_name = res2.InnerText.Replace(",", ";");
                                                    if (res2.Name == "addr")
                                                        loc_add = res2.InnerText.Replace(",", ";");
                                                    if (res2.Name == "phone")
                                                        loc_pho = res2.InnerText.Replace(",", ";");

                                                    if (res2.Name == "lat")
                                                        lat = Decimal.Parse(res2.InnerText, NumberFormatInfo.InvariantInfo);
                                                    if (res2.Name == "lon")
                                                        lon = Decimal.Parse(res2.InnerText, NumberFormatInfo.InvariantInfo);
                                                }
                                                loc_name = loc_name.Replace("<b>", "").Replace("</b>", "").Trim();

                                                foreach (XmlNode res2 in res.ChildNodes)
                                                {
                                                    if (res2.Name == "rating")
                                                        if (res2.InnerText != "")
                                                            loc_add = loc_add + " [Rated " + res2.InnerText.Replace(",", ";") + "/5]";
                                                }

                                                string name = loc_name + "\n" + loc_pho + " - " + loc_add;
                                                while (name.IndexOf("  ") != -1)
                                                {
                                                    name = name.Replace("  ", " ");
                                                }

                                                if (POI.Select("Lat = " + lat.ToString("0.000000").Replace(",", ".") + " AND Lon = " + lon.ToString("0.000000").Replace(",", ".") + " AND Name = '" + name.Replace("'", "''") + "'").Length == 0) // the reported dupes
                                                {
                                                    DataRow new_row = POI.NewRow();
                                                    new_row["Lat"] = lat;
                                                    new_row["Lon"] = lon;
                                                    new_row["Name"] = name;
                                                    POI.Rows.Add(new_row);

                                                    records++;
                                                }
                                            }
                                        }
                                        else if (poiGoogle.Checked)
                                        {
                                            string url = "http://" + poiGoogleURL.Text.Trim() + "/maps?output=kml&sll=" + ((lat1 + lat2) / 2).ToString("0.000000").Replace(",", ".") + "," + ((lon1 + lon2) / 2).ToString("0.000000").Replace(",", ".") + "&sspn=" + lat_step.ToString("0.000000").Replace(",", ".") + "," + lon_step.ToString("0.000000").Replace(",", ".") + "&q=" + poiSearch.Text.Trim() + "&start=" + poi_num.ToString();

                                            XmlDocument xmlDoc = new XmlDocument();
                                            xmlDoc.Load(url);

                                            foreach (XmlNode res in xmlDoc.GetElementsByTagName("Placemark"))
                                            {
                                                string loc_name = "";
                                                string loc_desc = "";
                                                decimal lat = 0;
                                                decimal lon = 0;
                                                foreach (XmlNode res2 in res.ChildNodes)
                                                {
                                                    if (res2.Name == "name")
                                                        loc_name = res2.InnerText.Replace(",", ";");
                                                    if (res2.Name == "description")
                                                        loc_desc = res2.InnerText.Replace(",", ";");

                                                    if (res2.Name == "Point")
                                                    {
                                                        foreach (XmlNode res3 in res2.ChildNodes)
                                                        {
                                                            string coord = "";
                                                            if (res3.Name == "coordinates")
                                                                coord = res3.InnerText.Replace(",", "<") + "<";

                                                            lon = Decimal.Parse(coord.Substring(0, coord.IndexOf("<")), NumberFormatInfo.InvariantInfo);
                                                            lat = Decimal.Parse(coord.Substring(coord.IndexOf("<") + 1, coord.IndexOf("<", coord.IndexOf("<") + 1) - 1 - coord.IndexOf("<")), NumberFormatInfo.InvariantInfo);
                                                        }
                                                    }
                                                }

                                                loc_desc = loc_desc + "<";
                                                loc_desc = loc_desc.Replace("<br/><", "<"); // get phone out?
                                                loc_desc = loc_desc.Replace("<br/>", " - "); // get phone out?
                                                if (loc_desc.IndexOf("<") != -1)
                                                    loc_desc = loc_desc.Substring(0, loc_desc.IndexOf("<")).Trim();

                                                string name = loc_name + "\n" + loc_desc;
                                                while (name.IndexOf("  ") != -1)
                                                {
                                                    name = name.Replace("  ", " ");
                                                }
                                                if (POI.Select("Lat = " + lat.ToString("0.000000").Replace(",", ".") + " AND Lon = " + lon.ToString("0.000000").Replace(",", ".") + " AND Name = '" + name.Replace("'", "''") + "'").Length == 0) // the reported dupes
                                                {
                                                    DataRow new_row = POI.NewRow();
                                                    new_row["Lat"] = lat;
                                                    new_row["Lon"] = lon;
                                                    new_row["Name"] = name;
                                                    POI.Rows.Add(new_row);

                                                    records++;
                                                }
                                            }

                                        }
                                    }
                                    catch { }

                                    if (records == 0)
                                    {
                                        more_left = false;
                                    }

                                    if (poiMSN.Checked)
                                        poi_num += 10;
                                    else if (poiYahoo.Checked)
                                        poi_num += 25;
                                    else // if (poiGoogle.Checked)
                                        poi_num += 10;
                                }

                                if (poiMSN.Checked && poi_num >= 230)
                                    max_tripped = true;
                                if (poiGoogle.Checked && poi_num >= 950)
                                    max_tripped = true;

                                lon1 = lon2;
                                lon2 = lon2 - lon_step;
                            }
                            lon1 = lon1a;
                            lon2 = lon1a - lon_step;

                            lat1 = lat2;
                            lat2 = lat2 - lat_step;
                        }

                        string max_error = "";
                        if (max_tripped)
                            max_error = "\n\nThe number of results for at least one of the cells seems to have hit the maximum,\nyou may want to try larger divisors, and therefore smaller radius for Yahoo";

                        MessageBox.Show("There are " + POI.Rows.Count.ToString() + " POIs" + max_error);
                    }
                    catch
                    {
                        MessageBox.Show(msgPOInum.Text);
                    }
                }
            }

            poiSetIconNull();
        }

        private void poiSave_Click(object sender, EventArgs e)
        {
            if (poiName.Text == "")
            {
                string dir = System.IO.Directory.GetCurrentDirectory();

                SaveFileDialog file = new SaveFileDialog();
                file.ShowDialog();

                System.IO.Directory.SetCurrentDirectory(dir);

                if (file.FileName != "")
                {
                    poiName.Text = file.FileName;
                }
            }

            poiSetIconNull();

            int icons = 0;
            string last_icon = "";
            foreach (DataRow poi in POI.Select("", "Icon"))
            {
                if (last_icon != poi["Icon"].ToString())
                {
                    last_icon = poi["Icon"].ToString();
                    icons++;
                }
            }
            if (icons > 10)
            {
                MessageBox.Show("You can have a maximum of 10 different icons per POI file\nyou have " + icons.ToString() + "\nfix this and try again");
            }
            else
            {
                if (poiName.Text.Trim() == "" && poiSearch.Text.Trim() != "")
                {
                    poiName.Text = "_" + poiSearch.Text.Trim().ToUpper();
                }

                if (poiName.Text.Trim() == "" || POI.Rows.Count == 0)
                {
                    MessageBox.Show(msgPOIsave.Text);
                }
                else
                {
                    if (new FileInfo(poiName.Text.Trim()).Exists)
                    {
                        MessageBox.Show(msgPOIthere.Text);
                    }
                    else
                    {
                        try
                        {
                            // poiSplit400
                            int count = -1;
                            string ext_str = "";
                            if (poiSplit400.Checked && POI.Rows.Count > 400)
                            {
                                ext_str = " 1";
                                count = 400;
                            }
                            int ext = 2;

                            last_icon = "";

                            StreamWriter file = new StreamWriter(poiName.Text.Trim() + ext_str);
                            //file.WriteLine("#");
                            //file.WriteLine("!IMAGE:" + poiImage.Text);
                            //file.WriteLine("#");

                            foreach (DataRow poi in POI.Select("", "Icon"))
                            {
                                if (count == 0)
                                {
                                    // new file
                                    file.Close();
                                    file = new StreamWriter(poiName.Text.Trim() + " " + ext.ToString());
                                    last_icon = "";
                                    count = 400;
                                    ext++;
                                }

                                if (last_icon != poi["Icon"].ToString())
                                {
                                    last_icon = poi["Icon"].ToString();
                                    file.WriteLine("!IMAGE:" + last_icon + ",");
                                }

                                file.WriteLine(((decimal)poi["Lat"]).ToString("0.000000").Replace(",", ".") + "," + ((decimal)poi["Lon"]).ToString("0.000000").Replace(",", ".") + "," + poi["Name"].ToString().Replace(",", ".").Replace("\n", ",") + ",");
                                
                                count--;
                            }

                            file.Close();

                            MessageBox.Show("Saved " + poiName.Text.Trim() + " POI file\n\nPlace it into the corresponding map directory");
                        }
                        catch
                        {
                            new FileInfo(poiName.Text.Trim()).Delete();
                            MessageBox.Show(msgPOInosave.Text);
                        }
                    }
                }
            }
        }

        private void dirList_Click(object sender, EventArgs e)
        {
            if (dirTo.Text.IndexOf("to:") == -1)
            {
                dirListProc(true);
            }
            else
            {
                string from_full = dirFrom.Text;
                string to_full = dirTo.Text;
                bool do_add = dirAddNotRepl.Checked;

                int start = 0;
                int end = to_full.IndexOf("to:");
                while (end != -1)
                {
                    dirTo.Text = to_full.Substring(start, end - start);
                    dirListProc(false);

                    dirAddNotRepl.Checked = true;

                    dirFrom.Text = dirTo.Text;
                    start = end + 3;
                    end = (to_full + "to:").IndexOf("to:", start);
                }

                dirFrom.Text = from_full;
                dirTo.Text = to_full;
                dirAddNotRepl.Checked = do_add;

                MessageBox.Show("There are " + DIR.Rows.Count.ToString() + " POIs");
            }
        }

        private void dirListProc(bool show_messages)
        {
            if ((dirFrom.Text.Trim() == "" || dirTo.Text.Trim() == "") && dirMap24.Checked == false) // google handles no to
            {
                MessageBox.Show(msgDIRfromto.Text);
            }
            else
            {
                DataTable DIRlast = DIR.Copy();

                string url_msg = "";

                try
                {
                    DIR.Rows.Clear();

                    if (dirMSN.Checked)
                    {
                        DataRow last_point = DIR.NewRow();
                        //try
                        //{
                            string url = "";
                            url = "http://local.live.com/directions.ashx?start=" + dirFrom.Text.Trim() + "&end=" + dirTo.Text.Trim() + "&units=" + dirDist.Text.Substring(0, 1);
                            if (dirShortest.Checked)
                                url = url + "&type=s";
                            url_msg = url;
                            string page = wc.DownloadString(url); // i=2 does nothing but seems to be required, can be any number, r=true ensures no adds(?)

                            if (dirFirst.Checked)
                            {
                                if (page.IndexOf("new VE_Location") != -1)
                                {
                                    int posnewVELocation = page.IndexOf("new VE_Location");
                                    int startlatfrom = page.IndexOf("',", posnewVELocation) + 2;
                                    int endlatfrom = page.IndexOf(",", startlatfrom);
                                    Decimal latfrom = Decimal.Parse(page.Substring(startlatfrom, endlatfrom - startlatfrom), NumberFormatInfo.InvariantInfo);

                                    int startlonfrom = page.IndexOf(",", endlatfrom) + 1;
                                    int endlonfrom = page.IndexOf(")", startlonfrom);
                                    Decimal lonfrom = Decimal.Parse(page.Substring(startlonfrom, endlonfrom - startlonfrom), NumberFormatInfo.InvariantInfo);

                                    int posVEDir = page.IndexOf("VE_Directions.Disambiguate", endlonfrom);

                                    posnewVELocation = page.IndexOf("new VE_Location", posVEDir);
                                    int startlatto = page.IndexOf("',", posnewVELocation) + 2;
                                    int endlatto = page.IndexOf(",", startlatto);
                                    Decimal latto = Decimal.Parse(page.Substring(startlatto, endlatto - startlatto), NumberFormatInfo.InvariantInfo);


                                    int startlonto = page.IndexOf(",", endlatto) + 1;
                                    int endlonto = page.IndexOf(")", startlonto);
                                    Decimal lonto = Decimal.Parse(page.Substring(startlonto, endlonto - startlonto), NumberFormatInfo.InvariantInfo);

                                    url = "http://local.live.com/directions.ashx?startlat=" + latfrom.ToString().Replace(",", ".") + "&startlon=" + lonfrom.ToString().Replace(",", ".") + "&endlat=" + latto.ToString().Replace(",", ".") + "&endlon=" + lonto.ToString().Replace(",", ".") + "&units=" + dirDist.Text.Substring(0, 1);
                                    if (dirShortest.Checked)
                                        url = url + "&type=s";

                                    page = wc.DownloadString(url); // i=2 does nothing but seems to be required, can be any number, r=true ensures no adds(?)
                                }
                            }

                            int start = page.IndexOf("new VE_RouteInstruction");
                            int end;

                            string name;
                            decimal lat;
                            decimal lon;

                            while (start != -1)
                            {
                                start = page.IndexOf("('", start) + 2;
                                end = page.IndexOf("',", start);
                                name = page.Substring(start, end - start).Replace(",", ";").Trim();

                                start = end + 2;
                                end = page.IndexOf(",", start);
                                lat = Decimal.Parse(page.Substring(start, end - start), NumberFormatInfo.InvariantInfo);

                                start = end + 1;
                                end = page.IndexOf(",", start);
                                lon = Decimal.Parse(page.Substring(start, end - start), NumberFormatInfo.InvariantInfo);

                                start = end + 1;
                                end = page.IndexOf(")", start);
                                name = page.Substring(start, end - start) + " " + dirDist.Text + "\n" + name; // dist, then info (since now second line is longer)

                                while (name.IndexOf("  ") != -1)
                                {
                                    name = name.Replace("  ", " ");
                                }

                                DataRow new_row = DIR.NewRow();
                                new_row["Lat"] = lat;
                                new_row["Lon"] = lon;
                                new_row["Name"] = name;

                                if (dirInter.Checked)
                                {
                                    if (DIR.Rows.Count > 0)
                                    {
                                        decimal a1 = (decimal)last_point["Lat"];
                                        decimal a2 = (decimal)new_row["Lat"];
                                        decimal o1 = (decimal)last_point["Lon"];
                                        decimal o2 = (decimal)new_row["Lon"];
                                        decimal d = Decimal.Parse(dirInterValue.Text, NumberFormatInfo.InvariantInfo);
                                        decimal Dfull = (decimal)Math.Sqrt(System.Convert.ToDouble((a2 - a1) * (a2 - a1) + (o2 - o1) * (o2 - o1)));
                                        decimal slope = 9999;
                                        try
                                        {
                                            slope = (a2 - a1) / (o2 - o1);
                                        }
                                        catch { }
                                        decimal Drunning = 0;
                                        decimal oC = d / (decimal)Math.Sqrt(System.Convert.ToDouble(slope * slope + 1)); // messes up on negatives
                                        if (o2 - o1 < (decimal)0)
                                        {
                                            oC *= (decimal)-1;
                                        }
                                        decimal aC = slope * oC;
                                        decimal aRunning = 0;
                                        decimal oRunning = 0;
                                        while (Drunning + d * (decimal)1.5 < Dfull)
                                        {
                                            Drunning += d;
                                            aRunning += aC;
                                            oRunning += oC;
                                            DataRow mid_row = DIR.NewRow();
                                            mid_row["Lat"] = a1 + aRunning;
                                            mid_row["Lon"] = o1 + oRunning;
                                            mid_row["Name"] = " ";
                                            if (last_point["Name"].ToString().IndexOf("mi") != -1)
                                            {
                                                string distS = last_point["Name"].ToString();
                                                distS = distS.Substring(0, distS.IndexOf("mi")).Trim();
                                                int b4 = distS.LastIndexOf("\n");
                                                if (b4 < distS.LastIndexOf(" "))
                                                    b4 = distS.LastIndexOf(" ");
                                                if (b4 == -1)
                                                    b4 = 0; // on frst row in the new format
                                                string distsS = distS.Substring(b4, distS.Length - b4);
                                                decimal dist = Decimal.Parse(distsS, NumberFormatInfo.InvariantInfo);
                                                mid_row["Name"] = (dist - dist * Drunning / Dfull).ToString("0.0").Replace(",", ".") + " mi";
                                            }
                                            if (last_point["Name"].ToString().IndexOf("km") != -1)
                                            {
                                                string distS = last_point["Name"].ToString();
                                                distS = distS.Substring(0, distS.IndexOf("km")).Trim();
                                                int b4 = distS.LastIndexOf("\n");
                                                if (b4 < distS.LastIndexOf(" "))
                                                    b4 = distS.LastIndexOf(" ");
                                                if (b4 == -1)
                                                    b4 = 0; // on frst row in the new format
                                                string distsS = distS.Substring(b4, distS.Length - b4);
                                                decimal dist = Decimal.Parse(distsS, NumberFormatInfo.InvariantInfo);
                                                mid_row["Name"] = (dist - dist * Drunning / Dfull).ToString("0.0").Replace(",", ".") + " km";
                                            }
                                            mid_row["Name"] = mid_row["Name"].ToString() + "\nMIDPOINT";
                                            DIR.Rows.Add(mid_row);
                                        }
                                    }
                                }
                                last_point = new_row;
                                DIR.Rows.Add(new_row);

                                start = page.IndexOf("new VE_RouteInstruction", start);
                            }

                            start = page.IndexOf("],'") + 3;
                            end = page.IndexOf("'", start);
                            if (end > page.IndexOf(",", start))
                                end = page.IndexOf(",", start);
                            name = page.Substring(start, end - start).Replace(",", ";").Trim();
                            if (name == "")
                                name = "Destination";

                            start = page.IndexOf("[", start) + 1;
                            end = page.IndexOf(",", start);
                            lat = Decimal.Parse(page.Substring(start, end - start), NumberFormatInfo.InvariantInfo);

                            start = end + 1;
                            end = page.IndexOf("]", start);
                            lon = Decimal.Parse(page.Substring(start, end - start), NumberFormatInfo.InvariantInfo);

                            string tot_dist_time;
                            try
                            {
                                start = page.IndexOf("LatLong");
                                tot_dist_time = page.Substring(0, start);
                                start = tot_dist_time.LastIndexOf("'");
                                tot_dist_time = tot_dist_time.Substring(0, start);
                                tot_dist_time = tot_dist_time.Replace("'mi'", "mi").Replace("'km'", "km").Replace("'q'", "-");
                                tot_dist_time = tot_dist_time.Substring(tot_dist_time.LastIndexOf("',"), tot_dist_time.Length - tot_dist_time.LastIndexOf("',"));
                                tot_dist_time = tot_dist_time.Replace(",", " ").Replace("'", "");
                                while (tot_dist_time.IndexOf("  ") != -1)
                                {
                                    tot_dist_time = tot_dist_time.Replace("  ", " ");
                                }
                                tot_dist_time = tot_dist_time.Trim();
                            }
                            catch
                            {
                                tot_dist_time = "";
                            }

                            DataRow new_rowF = DIR.NewRow();
                            new_rowF["Lat"] = lat;
                            new_rowF["Lon"] = lon;
                            new_rowF["Name"] = tot_dist_time + "\n" + "Arrive at " + name;

                            if (dirInter.Checked) // same code (new_rowF inst new_row, not setting last_point) - midpoints to end
                            {
                                if (DIR.Rows.Count > 0)
                                {
                                    decimal a1 = (decimal)last_point["Lat"];
                                    decimal a2 = (decimal)new_rowF["Lat"];
                                    decimal o1 = (decimal)last_point["Lon"];
                                    decimal o2 = (decimal)new_rowF["Lon"];
                                    decimal d = Decimal.Parse(dirInterValue.Text, NumberFormatInfo.InvariantInfo);
                                    decimal Dfull = (decimal)Math.Sqrt(System.Convert.ToDouble((a2 - a1) * (a2 - a1) + (o2 - o1) * (o2 - o1)));
                                    decimal slope = 9999;
                                    try
                                    {
                                        slope = (a2 - a1) / (o2 - o1);
                                    }
                                    catch { }
                                    decimal Drunning = 0;
                                    decimal oC = d / (decimal)Math.Sqrt(System.Convert.ToDouble(slope * slope + 1)); // messes up on negatives
                                    if (o2 - o1 < (decimal)0)
                                    {
                                        oC *= (decimal)-1;
                                    }
                                    decimal aC = slope * oC;
                                    decimal aRunning = 0;
                                    decimal oRunning = 0;
                                    while (Drunning + d * (decimal)1.5 < Dfull)
                                    {
                                        Drunning += d;
                                        aRunning += aC;
                                        oRunning += oC;
                                        DataRow mid_row = DIR.NewRow();
                                        mid_row["Lat"] = a1 + aRunning;
                                        mid_row["Lon"] = o1 + oRunning;
                                        mid_row["Name"] = " ";
                                        if (last_point["Name"].ToString().IndexOf("mi") != -1)
                                        {
                                            string distS = last_point["Name"].ToString();
                                            distS = distS.Substring(0, distS.IndexOf("mi")).Trim();
                                            int b4 = distS.LastIndexOf("\n");
                                            if (b4 < distS.LastIndexOf(" "))
                                                b4 = distS.LastIndexOf(" ");
                                            if (b4 == -1)
                                                b4 = 0; // on frst row in the new format
                                            string distsS = distS.Substring(b4, distS.Length - b4);
                                            decimal dist = Decimal.Parse(distsS, NumberFormatInfo.InvariantInfo);
                                            mid_row["Name"] = (dist - dist * Drunning / Dfull).ToString("0.0").Replace(",", ".") + " mi";
                                        }
                                        if (last_point["Name"].ToString().IndexOf("km") != -1)
                                        {
                                            string distS = last_point["Name"].ToString();
                                            distS = distS.Substring(0, distS.IndexOf("km")).Trim();
                                            int b4 = distS.LastIndexOf("\n");
                                            if (b4 < distS.LastIndexOf(" "))
                                                b4 = distS.LastIndexOf(" ");
                                            if (b4 == -1)
                                                b4 = 0; // on frst row in the new format
                                            string distsS = distS.Substring(b4, distS.Length - b4);
                                            decimal dist = Decimal.Parse(distsS, NumberFormatInfo.InvariantInfo);
                                            mid_row["Name"] = (dist - dist * Drunning / Dfull).ToString("0.0").Replace(",", ".") + " km";
                                        }
                                        mid_row["Name"] = mid_row["Name"].ToString() + "\nMIDPOINT";
                                        DIR.Rows.Add(mid_row);
                                    }
                                }
                            }
                            //last_point = new_row;
                            DIR.Rows.Add(new_rowF);
                        //}
                        //catch { }
                    }
                    else if (dirGoogle.Checked)
                    {
                        DataRow last_point = DIR.NewRow();

                        string suff = "";
                        if (dirAvoidHi.Checked)
                        {
                            suff = "&dirflg=h";
                        }

                        string url = "http://" + dirGoogleURL.Text.Trim() + "/maps?output=kml&saddr=" + dirFrom.Text.Trim().Replace(" ", "+") + "&daddr=" + dirTo.Text.Trim().Replace(" ", "+") + suff;
                        url_msg = url;
                        XmlDocument xmlDoc = new XmlDocument();
                        xmlDoc.Load(url);

                        foreach (XmlNode res in xmlDoc.GetElementsByTagName("Placemark"))
                        {
                            string loc_name = "";
                            string loc_desc = "";
                            decimal lat = 0;
                            decimal lon = 0;
                            foreach (XmlNode res2 in res.ChildNodes)
                            {
                                if (res2.Name == "name")
                                    loc_name = res2.InnerText.Replace(",", ";");
                                if (res2.Name == "description")
                                    loc_desc = res2.InnerText.Replace(",", ".");

                                if (res2.Name == "Point")
                                {
                                    foreach (XmlNode res3 in res2.ChildNodes)
                                    {
                                        string coord = "";
                                        if (res3.Name == "coordinates")
                                            coord = res3.InnerText.Replace(",", "<") + "<";

                                        lon = Decimal.Parse(coord.Substring(0, coord.IndexOf("<")), NumberFormatInfo.InvariantInfo);
                                        lat = Decimal.Parse(coord.Substring(coord.IndexOf("<") + 1, coord.IndexOf("<", coord.IndexOf("<") + 1) - 1 - coord.IndexOf("<")), NumberFormatInfo.InvariantInfo);
                                    }
                                }
                            }

                            loc_desc = loc_desc.Substring(loc_desc.LastIndexOf(" ") + 1, loc_desc.Length - 1 - loc_desc.LastIndexOf(" ")).Trim();
                            loc_desc = loc_desc.Replace("&#160;", " "); // bold

                            string name = loc_desc + "\n" + loc_name;
                            while (name.IndexOf("  ") != -1)
                            {
                                name = name.Replace("  ", " ");
                            }

                            if (lat != 0 || lon != 0)
                            {
                                DataRow new_row = DIR.NewRow();
                                new_row["Lat"] = lat;
                                new_row["Lon"] = lon;
                                new_row["Name"] = name;
                                last_point = new_row;
                                DIR.Rows.Add(new_row);
                            }
                            else 
                            {
                                // add the route
                                foreach (XmlNode res2 in res.ChildNodes)
                                {
                                    if (res2.Name == "description")
                                    {
                                        string end_desc = res2.InnerText.Replace(",", ".");
                                        end_desc = end_desc.Replace("&#160;", " "); // bold
                                        if (end_desc.IndexOf("<") != -1)
                                            end_desc = end_desc.Substring(0, end_desc.IndexOf("<")).Trim();
                                        if (end_desc.IndexOf(":") != -1)
                                            end_desc = end_desc.Substring(end_desc.IndexOf(":") + 1, end_desc.Length - 1 - end_desc.IndexOf(":")).Trim();
                                        last_point["Name"] = end_desc + last_point["Name"].ToString();
                                    }
                                    if (dirInterPath.Checked)
                                    {
                                        if (res2.Name == "GeometryCollection")
                                        {
                                            DataTable DIRbu = DIR.Copy();
                                            DIR.Rows.Clear();

                                            foreach (XmlNode res3 in res2.ChildNodes)
                                            {
                                                if (res3.Name == "LineString")
                                                {
                                                    foreach (XmlNode res4 in res3.ChildNodes)
                                                    {
                                                        string coord = "";
                                                        if (res4.Name == "coordinates")
                                                            coord = res4.InnerText.Trim();

                                                        // lat,lon,ignore
                                                        int start = 0;
                                                        while (start != -1)
                                                        {
                                                            if (start != 0)
                                                                start++;

                                                            int end = coord.IndexOf(",", start);
                                                            lon = Decimal.Parse(coord.Substring(start, end - start), NumberFormatInfo.InvariantInfo);
                                                            start = end + 1;
                                                            end = coord.IndexOf(",", start);
                                                            lat = Decimal.Parse(coord.Substring(start, end - start), NumberFormatInfo.InvariantInfo);
                                                            start = coord.IndexOf(" ", end);

                                                            DataRow new_row = DIR.NewRow();
                                                            if (DIRbu.Select("Lat = " + lat.ToString("0.000000").Replace(",", ".") + " AND Lon = " + lon.ToString("0.000000").Replace(",", ".")).Length == 0) // the actual points
                                                            {
                                                                new_row["Lat"] = lat;
                                                                new_row["Lon"] = lon;
                                                                new_row["Name"] = "PATH" + "\nMIDPOINT";
                                                            }
                                                            else // a waypoint
                                                            {
                                                                foreach (DataRow actual_point in DIRbu.Select("Lat = " + lat.ToString("0.000000").Replace(",", ".") + " AND Lon = " + lon.ToString("0.000000").Replace(",", ".")))
                                                                {
                                                                    new_row["Lat"] = actual_point["Lat"];
                                                                    new_row["Lon"] = actual_point["Lon"];
                                                                    new_row["Name"] = actual_point["Name"];

                                                                    actual_point.Delete();
                                                                }
                                                            }

                                                            //last_point = new_row;
                                                            DIR.Rows.Add(new_row);
                                                        }
                                                    }
                                                }
                                            }
                                            if (DIRbu.Rows.Count == 1)
                                            {
                                                DataRow new_row = DIR.NewRow();
                                                new_row["Lat"] = DIRbu.Rows[0]["Lat"];
                                                new_row["Lon"] = DIRbu.Rows[0]["Lon"];
                                                new_row["Name"] = DIRbu.Rows[0]["Name"];

                                                //last_point = new_row;
                                                DIR.Rows.Add(new_row);
                                            }
                                            else
                                            {
                                                foreach (DataRow actual_point in DIRbu.Rows)
                                                {
                                                    DIR.Rows.Add(actual_point.ItemArray);
                                                }
                                                if (show_messages)
                                                {
                                                    MessageBox.Show(msgDIRmissing.Text);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }

                        if (dirInterValue.Text.Trim() != "")
                        {
                            if (dirInter.Checked)
                            {
                                DataTable DIRbu = DIR.Copy();
                                DIR.Rows.Clear();

                                foreach (DataRow row in DIRbu.Rows)
                                {
                                    if (DIR.Rows.Count > 0)
                                    {
                                        decimal a1 = (decimal)last_point["Lat"];
                                        decimal a2 = (decimal)row["Lat"];
                                        decimal o1 = (decimal)last_point["Lon"];
                                        decimal o2 = (decimal)row["Lon"];
                                        decimal d = Decimal.Parse(dirInterValue.Text, NumberFormatInfo.InvariantInfo);
                                        decimal Dfull = (decimal)Math.Sqrt(System.Convert.ToDouble((a2 - a1) * (a2 - a1) + (o2 - o1) * (o2 - o1)));
                                        decimal slope = 9999;
                                        try
                                        {
                                            slope = (a2 - a1) / (o2 - o1);
                                        }
                                        catch { }
                                        decimal Drunning = 0;
                                        decimal oC = d / (decimal)Math.Sqrt(System.Convert.ToDouble(slope * slope + 1)); // messes up on negatives
                                        if (o2 - o1 < (decimal)0)
                                        {
                                            oC *= (decimal)-1;
                                        }
                                        decimal aC = slope * oC;
                                        decimal aRunning = 0;
                                        decimal oRunning = 0;
                                        while (Drunning + d * (decimal)1.5 < Dfull)
                                        {
                                            Drunning += d;
                                            aRunning += aC;
                                            oRunning += oC;
                                            DataRow mid_row = DIR.NewRow();
                                            mid_row["Lat"] = a1 + aRunning;
                                            mid_row["Lon"] = o1 + oRunning;
                                            mid_row["Name"] = " " + "\nMIDPOINT";
                                            DIR.Rows.Add(mid_row);
                                        }
                                    }

                                    DIR.Rows.Add(row.ItemArray);
                                    last_point = row;
                                }
                            }

                            // set distances
                            DIR.Columns.Add("Drunning", typeof(Decimal));
                            DIR.Columns.Add("Dtot", typeof(Decimal));
                            DataRow tot_point = DIR.NewRow();
                            bool first_point = true;
                            foreach (DataRow row in DIR.Rows)
                            {
                                row["Drunning"] = 0;

                                if (first_point == false)
                                {
                                    decimal a1 = (decimal)last_point["Lat"];
                                    decimal a2 = (decimal)row["Lat"];
                                    decimal o1 = (decimal)last_point["Lon"];
                                    decimal o2 = (decimal)row["Lon"];
                                    decimal d = Decimal.Parse(dirInterValue.Text, NumberFormatInfo.InvariantInfo);
                                    decimal Dfull = (decimal)Math.Sqrt(System.Convert.ToDouble((a2 - a1) * (a2 - a1) + (o2 - o1) * (o2 - o1)));

                                    if (last_point["Name"].ToString().IndexOf("MIDPOINT") != -1)
                                    {
                                        row["Drunning"] = (decimal)last_point["Drunning"] + Dfull;
                                        tot_point["Dtot"] = (decimal)row["Drunning"];
                                    }
                                    else
                                    {
                                        tot_point = last_point;
                                        row["Drunning"] = Dfull;
                                    }
                                }
                                else
                                {
                                    tot_point = row;
                                }

                                first_point = false;
                                last_point = row;
                            }

                            // point dist * (Dtot - Drunning) / Dtot

                            first_point = true;
                            foreach (DataRow row in DIR.Rows)
                            {
                                if (first_point == false)
                                {
                                    if (row["Name"].ToString().IndexOf("MIDPOINT") != -1)
                                    {
                                        string dist_str = tot_point["Name"].ToString().ToUpper();
                                        if (dist_str.IndexOf(" KM\n") != -1 || dist_str.IndexOf(" MI\n") != -1)
                                        {

                                            decimal dist_val = Decimal.Parse(dist_str.Substring(0, dist_str.IndexOf(" ")), NumberFormatInfo.InvariantInfo);

                                            string dist_ext = "mi";
                                            if (dist_str.IndexOf(" KM\n") != -1)
                                                dist_ext = "km";

                                            row["Name"] = (dist_val * ((decimal)tot_point["Dtot"] - (decimal)row["Drunning"]) / (decimal)tot_point["Dtot"]).ToString("0.0") + " " + dist_ext + "\nMIDPOINT";
                                        }
                                    }
                                    else
                                    {
                                        tot_point = row;
                                    }
                                }
                                else
                                {
                                    tot_point = row;
                                }

                                first_point = false;
                            }

                            if (dirInterRemRed.Checked)
                            {
                                DataTable DIRbu = DIR.Copy();
                                DIR.Rows.Clear();

                                foreach (DataRow row in DIRbu.Rows)
                                {
                                    if (DIR.Rows.Count > 0 && row["Name"].ToString().IndexOf("MIDPOINT") != -1)
                                    {
                                        decimal a1 = (decimal)last_point["Lat"];
                                        decimal a2 = (decimal)row["Lat"];
                                        decimal o1 = (decimal)last_point["Lon"];
                                        decimal o2 = (decimal)row["Lon"];
                                        decimal d = Decimal.Parse(dirInterValue.Text, NumberFormatInfo.InvariantInfo);
                                        decimal Dfull = (decimal)Math.Sqrt(System.Convert.ToDouble((a2 - a1) * (a2 - a1) + (o2 - o1) * (o2 - o1)));

                                        if (Dfull * (decimal)1.5 > d)
                                        {
                                            if ((decimal)row["Drunning"] + d * (decimal)0.5 < (decimal)tot_point["Dtot"]) // not too close to end
                                            {
                                                DIR.Rows.Add(row.ItemArray);
                                                last_point = row;
                                            }
                                        }
                                    }
                                    else
                                    {
                                        DIR.Rows.Add(row.ItemArray);
                                        last_point = row;

                                        tot_point = row;
                                    }
                                }
                            }

                            DIR.Columns.Remove("Drunning");
                            DIR.Columns.Remove("Dtot");
                        }
                    }
                    else if (dirMap24.Checked)
                    {
                        DataRow last_point = DIR.NewRow();

                        string page = wDIR.Document.Window.Frames[3].Document.Body.InnerHtml;

                        int start = page.IndexOf("ctrlShowRouteSeg");
                        start = page.IndexOf("ctrlShowRouteSeg", start + 1);
                        while (start != -1)
                        {
                            start = page.IndexOf("'", start) + 1;
                            int end = page.IndexOf("'", start);
                            decimal lon = Decimal.Parse(page.Substring(start, end - start), NumberFormatInfo.InvariantInfo) / 60;
                            start = page.IndexOf("'", end + 1) + 1;
                            end = page.IndexOf("'", start);
                            decimal lat = Decimal.Parse(page.Substring(start, end - start), NumberFormatInfo.InvariantInfo) / 60;
                            start = page.IndexOf("'", end + 1) + 1;
                            end = page.IndexOf("'", start);
                            // end lon
                            start = page.IndexOf("'", end + 1) + 1;
                            end = page.IndexOf("'", start);
                            // end lat
                            start = page.IndexOf(">", start) + 1;
                            end = page.IndexOf("</DIV", start);
                            string name_full = page.Substring(start, end - start).Replace("<SIGN>", "").Replace("</SIGN>", "").Replace("<B>", "").Replace("</B>", "").Replace(" .", ".").Trim();
                            start = page.IndexOf("</TD>", end) + 5;
                            end = page.IndexOf("</TR>", start);
                            string name_dist = page.Substring(start, end - start).Replace("\r", "").Replace("\n", "").Replace("<TD class=rlr2>", "").Replace("</TD>", "").Replace("<BR>", " - ");
                            if (name_dist == "")
                                name_dist = " ";
                            string name_time = " ";
                            if (name_dist.IndexOf("-") != -1)
                            {
                                name_time = name_dist.Substring(0, name_dist.IndexOf("-")).Trim();
                                name_dist = name_dist.Substring(name_dist.IndexOf("-") + 1, name_dist.Length - 1 - name_dist.IndexOf("-")).Trim();
                            }

                            string name = dirMap24dt.Text.Replace("$D$", name_dist).Replace("$T$", name_time) + "\n" + name_full;

                            DataRow new_row = DIR.NewRow();
                            new_row["Lat"] = lat;
                            new_row["Lon"] = lon;
                            new_row["Name"] = name.Replace(",", ";");

                            if (dirInter.Checked)
                            {
                                if (DIR.Rows.Count > 0)
                                {
                                    decimal a1 = (decimal)last_point["Lat"];
                                    decimal a2 = (decimal)new_row["Lat"];
                                    decimal o1 = (decimal)last_point["Lon"];
                                    decimal o2 = (decimal)new_row["Lon"];
                                    decimal d = Decimal.Parse(dirInterValue.Text, NumberFormatInfo.InvariantInfo);
                                    decimal Dfull = (decimal)Math.Sqrt(System.Convert.ToDouble((a2 - a1) * (a2 - a1) + (o2 - o1) * (o2 - o1)));
                                    decimal slope = 9999;
                                    try
                                    {
                                        slope = (a2 - a1) / (o2 - o1);
                                    }
                                    catch { }
                                    decimal Drunning = 0;
                                    decimal oC = d / (decimal)Math.Sqrt(System.Convert.ToDouble(slope * slope + 1)); // messes up on negatives
                                    if (o2 - o1 < (decimal)0)
                                    {
                                        oC *= (decimal)-1;
                                    }
                                    decimal aC = slope * oC;
                                    decimal aRunning = 0;
                                    decimal oRunning = 0;

                                    while (Drunning + d * (decimal)1.5 < Dfull)
                                    {
                                        Drunning += d;
                                        aRunning += aC;
                                        oRunning += oC;
                                        DataRow mid_row = DIR.NewRow();
                                        mid_row["Lat"] = a1 + aRunning;
                                        mid_row["Lon"] = o1 + oRunning;

                                        // name_dist - keep a record of running
                                        mid_row["Name"] = " ";
                                        /*if (last_point["Name"].ToString().IndexOf("mi") != -1)
                                        {
                                            string distS = last_point["Name"].ToString();
                                            distS = distS.Substring(0, distS.IndexOf("mi")).Trim();
                                            int b4 = distS.LastIndexOf("\n");
                                            if (b4 < distS.LastIndexOf(" "))
                                                b4 = distS.LastIndexOf(" ");
                                            if (b4 == -1)
                                                b4 = 0; // on frst row in the new format
                                            string distsS = distS.Substring(b4, distS.Length - b4);
                                            decimal dist = Decimal.Parse(distsS, NumberFormatInfo.InvariantInfo);
                                            mid_row["Name"] = (dist - dist * Drunning / Dfull).ToString("0.0").Replace(",", ".") + " mi";
                                        }
                                        if (last_point["Name"].ToString().IndexOf("km") != -1)
                                        {
                                            string distS = last_point["Name"].ToString();
                                            distS = distS.Substring(0, distS.IndexOf("km")).Trim();
                                            int b4 = distS.LastIndexOf("\n");
                                            if (b4 < distS.LastIndexOf(" "))
                                                b4 = distS.LastIndexOf(" ");
                                            if (b4 == -1)
                                                b4 = 0; // on frst row in the new format
                                            string distsS = distS.Substring(b4, distS.Length - b4);
                                            decimal dist = Decimal.Parse(distsS, NumberFormatInfo.InvariantInfo);
                                            mid_row["Name"] = (dist - dist * Drunning / Dfull).ToString("0.0").Replace(",", ".") + " km";
                                        }*/
                                        mid_row["Name"] = mid_row["Name"].ToString() + "\nMIDPOINT";
                                        DIR.Rows.Add(mid_row);
                                    }
                                }
                            }

                            if (dirMap24DupeLL.Checked == false || DIR.Select("Lat = " + new_row["Lat"].ToString().Replace(",", ".") + " AND Lon = " + new_row["Lon"].ToString().Replace(",", ".")).Length == 0)
                            {
                                last_point = new_row;
                                DIR.Rows.Add(new_row);
                            }

                            start = page.IndexOf("ctrlShowRouteSeg", start);
                            if (start != -1)
                                start = page.IndexOf("ctrlShowRouteSeg", start + 1);
                        }
                    }

                    if (dirListUpcoming.Checked)
                    {
                        string direction = "";
                        for (int i = DIR.Rows.Count - 1; i >= 0; i--)
                        {
                            if (DIR.Rows[i]["Name"].ToString().IndexOf("MIDPOINT") == -1)
                            {
                                direction = DIR.Rows[i]["Name"].ToString();
                                direction = " " + direction.Substring(direction.IndexOf("\n") + 1, direction.Length - 1 - direction.IndexOf("\n"));
                            }
                            else
                            {
                                DIR.Rows[i]["Name"] = DIR.Rows[i]["Name"].ToString().Replace("\n", direction + "\n");
                            }
                        }
                    }

                    if (dirAddNotRepl.Checked)
                    {
                        DataTable DIRtemp = DIR.Copy();
                        DIR.Rows.Clear();

                        foreach (DataRow row in DIRlast.Rows)
                        {
                            DIR.Rows.Add(row.ItemArray);
                        }

                        foreach (DataRow row in DIRtemp.Rows)
                        {
                            DIR.Rows.Add(row.ItemArray);
                        }
                    }

                    if (show_messages)
                    {
                        MessageBox.Show("There are " + DIR.Rows.Count.ToString() + " POIs");
                    }
                }
                catch (Exception e)
                {
                    // restore last
                    DIR.Rows.Clear();
                    foreach (DataRow row in DIRlast.Rows)
                    {
                        DIR.Rows.Add(row.ItemArray);
                    }

                    MessageBox.Show(msgDIRerror.Text + "\n" + " you may want to try this as the address format: 123 Street Name, Town, State, Post/Zip Code, Country" + "\n\n" + url_msg + "\n\n" + e.Message + "\n\n" + e.StackTrace);
                }
            }
        }

        private void SetdirName()
        {
            if (dirName.Text.Trim() == "" && dirFrom.Text.Trim() != "" && dirTo.Text.Trim() != "")
            {
                string from = dirFrom.Text.Trim();
                if (from.IndexOf(",") != -1)
                {
                    from = from.Substring(0, from.IndexOf(",")).Trim();
                }
                string to = dirTo.Text.Trim();
                if (to.IndexOf(",") != -1)
                {
                    to = to.Substring(0, to.IndexOf(",")).Trim();
                }
                dirName.Text = "_" + from.ToUpper() + " TO " + to.ToUpper();
            }
        }

        private void dirSave_Click(object sender, EventArgs e)
        {
            if (dirName.Text == "")
            {
                string dir = System.IO.Directory.GetCurrentDirectory();

                SaveFileDialog file = new SaveFileDialog();
                file.ShowDialog();

                System.IO.Directory.SetCurrentDirectory(dir);

                if (file.FileName != "")
                {
                    dirName.Text = file.FileName;
                }
            }

            SetdirName();

            if (dirName.Text.Trim() == "" || DIR.Rows.Count == 0)
            {
                MessageBox.Show(msgDIRnosave.Text);
            }
            else
            {
                if (new FileInfo(dirName.Text.Trim()).Exists)
                {
                    MessageBox.Show(msgDIRexists.Text);
                }
                else
                {
                    try
                    {
                        if (dirLegacy.Checked)
                        {
                            if (dirSplit400.Checked && DIR.Rows.Count > 400)
                            {
                                int ext = 1;
                                int count = 400;
                                DataTable table = DIR.Clone();
                                foreach (DataRow row in DIR.Rows)
                                {
                                    if (count == 0)
                                    {
                                        DIRtoFile(table, dirName.Text.Trim() + " " + ext.ToString());
                                        table.Rows.Clear();
                                        count = 400;
                                        ext++;
                                    }
                                    table.Rows.Add(row.ItemArray);
                                    count--;
                                }
                            }
                            else
                            {
                                DIRtoFile(DIR, dirName.Text.Trim());
                            }
                        }
                        else
                        {
                            int numberD = 0;

                            DataTable sounds = new DataTable();
                            sounds.Columns.Add("number", typeof(Int32));
                            sounds.Columns.Add("words", typeof(String));
                            if (DIRsounds.Checked)
                            {
                                if (new FileInfo("sounds.txt").Exists)
                                {
                                    StreamReader sr = new StreamReader("sounds.txt");
                                    if (sr.EndOfStream == false)
                                    {
                                        string lineD = sr.ReadLine();
                                        numberD = Int32.Parse(lineD.Substring(0, lineD.IndexOf(",")));
                                    }
                                    while (sr.EndOfStream == false)
                                    {
                                        string line = sr.ReadLine();
                                        DataRow new_row = sounds.NewRow();
                                        new_row["number"] = Int32.Parse(line.Substring(0, line.IndexOf(",")));
                                        new_row["words"] = line.Substring(line.IndexOf(",") + 1, line.Length - 1 - line.IndexOf(",")).Trim();
                                        sounds.Rows.Add(new_row);
                                    }
                                    sr.Close();
                                }
                            }

                            StreamWriter file;
                            if (DIRutf8.Checked)
                            {
                                Encoding dir_enc = Encoding.Default;
                                if (DIRencoding.Text == "ASCII")
                                    dir_enc = Encoding.ASCII;
                                else if (DIRencoding.Text == "BigEndianUnicode")
                                    dir_enc = Encoding.BigEndianUnicode;
                                else if (DIRencoding.Text == "Default")
                                    dir_enc = Encoding.Default;
                                else if (DIRencoding.Text == "Unicode")
                                    dir_enc = Encoding.Unicode;
                                else if (DIRencoding.Text == "UTF32")
                                    dir_enc = Encoding.UTF32;
                                else if (DIRencoding.Text == "UTF7")
                                    dir_enc = Encoding.UTF7;
                                else if (DIRencoding.Text == "UTF8")
                                    dir_enc = Encoding.UTF8;
                                else
                                    MessageBox.Show("Unrecognized encoding (edit the source), using Encoding.Default");
                                file = new StreamWriter(dirName.Text.Trim(), false, dir_enc);
                            }
                            else
                            {
                                file = new StreamWriter(dirName.Text.Trim());
                            }

                            file.WriteLine("#");
                            file.WriteLine("!IMAGE:" + dirImage.Text + ",");
                            file.WriteLine("!WAYPOINT");
                            file.WriteLine("#");

                            string last_poi = "";

                            foreach (DataRow poi in DIR.Rows)
                            {
                                if (dirImage.Text != dirImage2.Text)
                                {
                                    if (last_poi != "")
                                    {
                                        if (last_poi.IndexOf("MIDPOINT") != -1 && poi["Name"].ToString().IndexOf("MIDPOINT") == -1) // switching from MIDPOINT
                                        {
                                            file.WriteLine("!IMAGE:" + dirImage.Text + ",");
                                        }
                                        if (last_poi.IndexOf("MIDPOINT") == -1 && poi["Name"].ToString().IndexOf("MIDPOINT") != -1) // switching to MIDPOINT
                                        {
                                            file.WriteLine("!IMAGE:" + dirImage2.Text + ",");
                                        }
                                    }

                                    last_poi = poi["Name"].ToString();
                                }
                                string sound = "";
                                if (DIRsounds.Checked)
                                {
                                    sound = "0,";
                                    if (poi["Name"].ToString().IndexOf("MIDPOINT") == -1)
                                    {
                                        foreach (DataRow row in sounds.Rows)
                                        {
                                            if (poi["Name"].ToString().ToLower().IndexOf(row["words"].ToString().ToLower()) != -1)
                                            {
                                                sound = row["number"].ToString() + ",";
                                            }
                                        }
                                        if (sound == "0,")
                                        {
                                            sound = numberD.ToString() + ",";
                                        }
                                    }
                                }
                                string poi_name = poi["Name"].ToString().Replace(",", ".").Replace("\n", ",");
                                if (DIRupper.Checked)
                                    poi_name = poi_name.ToUpper();
                                file.WriteLine(((decimal)poi["Lat"]).ToString("0.000000").Replace(",", ".") + "," + ((decimal)poi["Lon"]).ToString("0.000000").Replace(",", ".") + "," + poi_name + "," + sound);
                            }

                            file.Close();
                        }
                        
                        MessageBox.Show("Saved " + dirName.Text.Trim() + " DIR file\n\nPlace it into the corresponding map directory");
                    }
                    catch
                    {
                        new FileInfo(dirName.Text.Trim()).Delete();
                        MessageBox.Show(msgDIRsaveerror.Text);
                    }
                }
            }
        }

        private void DIRtoFile(DataTable table, string file_name)
        {
            StreamWriter file = new StreamWriter(file_name);

            bool first = true;
            bool first_mid = true;

            foreach (DataRow poi in table.Rows)
            {
                if (poi["Name"].ToString().IndexOf("MIDPOINT") == -1)
                {
                    first_mid = false;
                    if (first)
                    {
                        file.WriteLine("#");
                        file.WriteLine("!IMAGE:" + dirImage.Text + ",");
                        file.WriteLine("!WAYPOINT");
                        file.WriteLine("#");
                        first = false;
                    }
                    file.WriteLine(((decimal)poi["Lat"]).ToString("0.000000").Replace(",", ".") + "," + ((decimal)poi["Lon"]).ToString("0.000000").Replace(",", ".") + "," + poi["Name"].ToString().Replace(",", ".").Replace("\n", ",") + ",");
                }
            }

            first = true;

            foreach (DataRow poi in table.Rows)
            {
                if (poi["Name"].ToString().IndexOf("MIDPOINT") != -1)
                {
                    if (first)
                    {
                        if (first_mid) // doesn't matter to reset
                        {
                            file.WriteLine("#");
                            file.WriteLine("!IMAGE:" + dirImage2.Text + ",");
                            file.WriteLine("!WAYPOINT");
                            file.WriteLine("#");
                        }
                        else
                        {
                            file.WriteLine("!IMAGE:" + dirImage2.Text + ",");
                        }
                        first = false;
                    }
                    file.WriteLine(((decimal)poi["Lat"]).ToString("0.000000").Replace(",", ".") + "," + ((decimal)poi["Lon"]).ToString("0.000000").Replace(",", ".") + "," + poi["Name"].ToString().Replace(",", ".").Replace("\n", ",") + ",");
                }
            }

            file.Close();
        }

        private void dirGetValues_Click(object sender, EventArgs e)
        {
            if (dirMSN.Checked)
            {
                try
                {
                    string page = wDIR.Document.Body.OuterHtml;

                    int start = page.IndexOf("ClearSetStartValues");
                    start = page.IndexOf(">", start) + 1;
                    int end = page.IndexOf("<", start);
                    dirFrom.Text = page.Substring(start, end - start).Trim();

                    start = page.IndexOf("ClearSetEndValues");
                    start = page.IndexOf(">", start) + 1;
                    end = page.IndexOf("<", start);
                    dirTo.Text = page.Substring(start, end - start).Trim();

                    if (page.IndexOf("routeType_shortest") < page.IndexOf("CHECKED"))
                        dirShortest.Checked = true;
                    else
                        dirQuickest.Checked = true;

                    if (page.IndexOf("km)") != -1)
                        dirDist.Text = "km";
                    else
                        dirDist.Text = "mi";
                }
                catch
                {
                    MessageBox.Show(msgDIRvalerror.Text);
                }
            }
            else if (dirGoogle.Checked)
            {
                try
                {
                    string page = wDIR.Document.Body.OuterHtml;

                    int start = page.IndexOf("name=saddr");
                    start = page.Substring(0, start).LastIndexOf("value=") + 6;
                    int end = page.IndexOf("name=", start);
                    dirFrom.Text = page.Substring(start, end - start).Replace("\"", " ").Trim();

                    start = page.IndexOf("name=daddr");
                    start = page.Substring(0, start).LastIndexOf("value=") + 6;
                    end = page.IndexOf("name=", start);
                    dirTo.Text = page.Substring(start, end - start).Replace("\"", " ").Trim(); ;

                    if (page.IndexOf("&amp;dirflg=h") != -1)
                    {
                        dirAvoidHi.Checked = true;
                    }
                    else
                    {
                        dirAvoidHi.Checked = false;
                    }
                }
                catch
                {
                    MessageBox.Show(msgDIRvalerror.Text);
                }
            }
            else if (dirMap24.Checked)
            {
                MessageBox.Show(msgDIRvalerror24.Text);
            }
        }

        private void dirInterValueOpt_TextChanged(object sender, EventArgs e)
        {
            dirInterValue.Text = dirInterValueOpt.Text.Substring(dirInterValueOpt.Text.IndexOf("[") + 1, dirInterValueOpt.Text.IndexOf("]") - dirInterValueOpt.Text.IndexOf("[") - 1);

            dirInter.Checked = true;

            DIR.Rows.Clear();

            /*if (dirName.Text == "" || dirName.Text.IndexOf("[") != -1)
            {
                dirName.Text = "";
                SetdirName();
                dirName.Text = dirName.Text + dirInterValueOpt.Text.Replace("Zoom ", "; Z");
            }*/
        }

        private string MapType()
        {
            foreach (Control cn in SelectedMap.Controls)
            {
                try
                {
                    if (((RadioButton)cn).Checked)
                    {
                        if (cn.Name == "iMC")
                        {
                            if (MCtoJPG.Checked)
                                return cn.Name + "jpg" + SetMC.Text;
                            else
                                return cn.Name + "png" + SetMC.Text;
                        }
                        else if (cn.Name == "iSI")
                        {
                            return cn.Name + SetSI.Text;
                        }
                        else if (cn.Name == "iNASA")
                        {
                            return cn.Name + NASAlayer.Text;
                        }
                        else if (cn.Name == "iWMS")
                        {
                            return cn.Name + "$$$" + WMSformat.Text + "$$$" + WMSserver.Text + "$$$" + WMSversion.Text + "$$$" + WMSlayer.Text + "$$$";
                        }
                        else if (cn.Name.StartsWith("iCUSTOM"))
                        {
                            return cn.Name + "$$$" + CUSTOMurl.Text;
                        }
                        else
                        {
                            return cn.Name;
                        }
                    }
                }
                catch { } // for non checkboxes
            }

            return "";
        }

        private void dDetail_Click(object sender, EventArgs e)
        {
            new SelectDetail4x(Int32.Parse(Mzoom.Text), Int32.Parse(Minzoom.Text), Int32.Parse(Mx.Text), Int32.Parse(My.Text), MapType(), mu, wc).ShowDialog();
        }

        private void NumbersFromLatLon_Click(object sender, EventArgs e)
        {
            LatLonToTiles latlon = new LatLonToTiles(Mzoom.Text);
            latlon.ShowDialog();
            while (latlon.Visible)
            {
                Thread.Sleep(500);
            }
            if (latlon.Mzoom.Text != "")
            {
                Mzoom.Text = latlon.Mzoom.Text;
                Mx.Text = latlon.Mx.Text;
                My.Text = latlon.My.Text;

                if (map_name.Text == "")
                {
                    map_name.Text = "_Map of " + Mx.Text + " by " + My.Text + " at " + Mzoom.Text + " to " + Minzoom.Text;
                }
            }
        }

        private void poiKML_Click(object sender, EventArgs e)
        {
            if (poiAddNotRepl.Checked == false)
            {
                POI.Rows.Clear();
                poiName.Text = "";
            }

            string dir = System.IO.Directory.GetCurrentDirectory();

            OpenFileDialog file = new OpenFileDialog();
            file.Filter = "KML File - Google (*.kml)|*.kml";
            file.ShowDialog();

            System.IO.Directory.SetCurrentDirectory(dir);

            if (file.FileName != "")
            {
                try
                {
                    string file_name = new FileInfo(file.FileName).Name;
                    file_name = file_name.Substring(0, file_name.LastIndexOf(".")).Trim();
                    if (poiName.Text == "")
                        poiName.Text = "_" + file_name;

                    XmlDocument xmlDoc = new XmlDocument();
                    xmlDoc.Load(file.FileName);

                    foreach (XmlNode res in xmlDoc.GetElementsByTagName("Placemark"))
                    {
                        string loc_name = "";
                        string loc_desc = "";
                        decimal lat = 0;
                        decimal lon = 0;
                        foreach (XmlNode res2 in res.ChildNodes)
                        {
                            if (res2.Name == "name")
                                loc_name = res2.InnerText.Replace(",", ";");
                            if (res2.Name == "description")
                                loc_desc = res2.InnerText.Replace(",", ";");

                            if (res2.Name == "Point")
                            {
                                foreach (XmlNode res3 in res2.ChildNodes)
                                {
                                    string coord = "";
                                    if (res3.Name == "coordinates")
                                        coord = res3.InnerText.Replace(",", "<") + "<";

                                    lon = Decimal.Parse(coord.Substring(0, coord.IndexOf("<")), NumberFormatInfo.InvariantInfo);
                                    lat = Decimal.Parse(coord.Substring(coord.IndexOf("<") + 1, coord.IndexOf("<", coord.IndexOf("<") + 1) - 1 - coord.IndexOf("<")), NumberFormatInfo.InvariantInfo);
                                }
                            }
                        }

                        loc_desc = loc_desc + "<";
                        loc_desc = loc_desc.Replace("<br/><", "<"); // get phone out?
                        loc_desc = loc_desc.Replace("<br/>", " - "); // get phone out?
                        if (loc_desc.IndexOf("<") != -1)
                            loc_desc = loc_desc.Substring(0, loc_desc.IndexOf("<")).Trim();

                        string name = loc_name + "\n" + loc_desc;
                        while (name.IndexOf("  ") != -1)
                        {
                            name = name.Replace("  ", " ");
                        }

                        DataRow new_row = POI.NewRow();
                        new_row["Lat"] = lat;
                        new_row["Lon"] = lon;
                        new_row["Name"] = name;
                        POI.Rows.Add(new_row);
                    }

                    MessageBox.Show("There are " + POI.Rows.Count.ToString() + " POIs");
                }
                catch
                {
                    MessageBox.Show(msgPOIfileerror.Text);
                }
            }

            poiSetIconNull();
        }

        private void poiCSV_Click(object sender, EventArgs e)
        {
            if (poiAddNotRepl.Checked == false)
            {
                POI.Rows.Clear();
                poiName.Text = "";
            }

            string dir = System.IO.Directory.GetCurrentDirectory();

            OpenFileDialog file = new OpenFileDialog();
            file.Filter = "CSV File - Navman, Garmin, generic (*.csv)|*.csv";
            file.ShowDialog();

            System.IO.Directory.SetCurrentDirectory(dir);

            if (file.FileName != "")
            {
                try
                {
                    string file_name = new FileInfo(file.FileName).Name;
                    file_name = file_name.Substring(0, file_name.LastIndexOf(".")).Trim();
                    if (poiName.Text == "")
                        poiName.Text = "_" + file_name;

                    StreamReader csv_file = new StreamReader(file.FileName);
                    while (csv_file.EndOfStream == false)
                    {
                        try
                        {
                            string line = csv_file.ReadLine() + ",,"; // 2nd col and end if not there
                            string loc_name = "";
                            string loc_desc = "";
                            decimal lat = 0;
                            decimal lon = 0;

                            int start = 0;
                            int end = line.IndexOf(",");

                            lon = Decimal.Parse(line.Substring(start, end - start), NumberFormatInfo.InvariantInfo);
                            start = end + 1;
                            end = line.IndexOf(",", start);
                            lat = Decimal.Parse(line.Substring(start, end - start), NumberFormatInfo.InvariantInfo);
                            start = end + 1;
                            end = line.IndexOf(",", start);
                            loc_name = line.Substring(start, end - start).Trim();
                            start = end + 1;
                            end = line.IndexOf(",", start);
                            loc_desc = line.Substring(start, end - start).Trim();

                            if (loc_desc == "" && poiNewline.Checked && poiNewlineText.Text != "")
                            {
                                // divide up name
                                if (loc_name.IndexOf(poiNewlineText.Text) != -1)
                                {
                                    int startNL;
                                    if (poiNewlineFirst.Checked)
                                        startNL = loc_name.IndexOf(poiNewlineText.Text);
                                    else
                                        startNL = loc_name.LastIndexOf(poiNewlineText.Text);

                                    loc_desc = loc_name.Substring(startNL + poiNewlineText.Text.Length, loc_name.Length - startNL - poiNewlineText.Text.Length);
                                    loc_name = loc_name.Substring(0, startNL);
                                }
                            }

                            string name = loc_name + "\n" + loc_desc;

                            name = name.Replace(",", ";").Replace("\"", "");
                            while (name.IndexOf("  ") != -1)
                            {
                                name = name.Replace("  ", " ");
                            }

                            DataRow new_row = POI.NewRow();
                            new_row["Lat"] = lat;
                            new_row["Lon"] = lon;
                            new_row["Name"] = name;
                            POI.Rows.Add(new_row);
                        }
                        catch{}
                    }

                    csv_file.Close();

                    MessageBox.Show("There are " + POI.Rows.Count.ToString() + " POIs");
                }
                catch
                {
                    MessageBox.Show(msgPOIfileerror.Text);
                }
            }

            poiSetIconNull();
        }

        private void POI_mt_Click(object sender, EventArgs e)
        {
            if (poiAddNotRepl.Checked == false)
            {
                POI.Rows.Clear();
                poiName.Text = "";
            }

            string dir = System.IO.Directory.GetCurrentDirectory();

            OpenFileDialog file = new OpenFileDialog();
            file.Filter = "_POI File - Map This! (_*)|_*";
            file.ShowDialog();

            System.IO.Directory.SetCurrentDirectory(dir);

            if (file.FileName != "")
            {
                try
                {
                    string file_name = new FileInfo(file.FileName).Name;
                    if (poiName.Text == "")
                        poiName.Text = file_name;

                    string icon = "";

                    StreamReader poi_file = new StreamReader(file.FileName);
                    while (poi_file.EndOfStream == false)
                    {
                        try
                        {
                            string line = poi_file.ReadLine() + ",,"; // 2nd col and end if not there
                            if (line.StartsWith("!IMAGE:"))
                            {
                                icon = line.Replace(",", "").Replace("!IMAGE:", "");
                            }
                            else
                            {
                                string loc_name = "";
                                string loc_desc = "";
                                decimal lat = 0;
                                decimal lon = 0;

                                int start = 0;
                                int end = line.IndexOf(",");

                                lat = Decimal.Parse(line.Substring(start, end - start), NumberFormatInfo.InvariantInfo);
                                start = end + 1;
                                end = line.IndexOf(",", start);
                                lon = Decimal.Parse(line.Substring(start, end - start), NumberFormatInfo.InvariantInfo);
                                start = end + 1;
                                end = line.IndexOf(",", start);
                                loc_name = line.Substring(start, end - start).Trim();
                                start = end + 1;
                                end = line.IndexOf(",", start);
                                loc_desc = line.Substring(start, end - start).Trim();

                                string name = loc_name + "\n" + loc_desc;

                                DataRow new_row = POI.NewRow();
                                new_row["Lat"] = lat;
                                new_row["Lon"] = lon;
                                new_row["Name"] = name;
                                new_row["Icon"] = icon;
                                POI.Rows.Add(new_row);
                            }
                        }
                        catch { }
                    }

                    poi_file.Close();

                    MessageBox.Show("There are " + POI.Rows.Count.ToString() + " POIs");
                }
                catch
                {
                    MessageBox.Show(msgPOIfileerror.Text);
                }
            }

            //poiSetIconNull();
        }

        private void DIR_mt_Click(object sender, EventArgs e)
        {
            if (dirAddNotRepl.Checked == false)
            {
                DIR.Rows.Clear();
                dirName.Text = "";
            }

            string dir = System.IO.Directory.GetCurrentDirectory();

            OpenFileDialog file = new OpenFileDialog();
            file.Filter = "_DIR File - Map This! (_*)|_*";
            file.ShowDialog();

            System.IO.Directory.SetCurrentDirectory(dir);

            if (file.FileName != "")
            {
                try
                {
                    string file_name = new FileInfo(file.FileName).Name;
                    if (dirName.Text == "")
                        dirName.Text = file_name;

                    //string icon = "";

                    StreamReader dir_file = new StreamReader(file.FileName);
                    while (dir_file.EndOfStream == false)
                    {
                        try
                        {
                            string line = dir_file.ReadLine() + ",,"; // 2nd col and end if not there
                            if (line.StartsWith("!IMAGE:") || line.StartsWith("#"))
                            {
                                //icon = line.Replace(",", "").Replace("!IMAGE:", "");
                            }
                            else
                            {
                                string loc_name = "";
                                string loc_desc = "";
                                decimal lat = 0;
                                decimal lon = 0;

                                int start = 0;
                                int end = line.IndexOf(",");

                                lat = Decimal.Parse(line.Substring(start, end - start), NumberFormatInfo.InvariantInfo);
                                start = end + 1;
                                end = line.IndexOf(",", start);
                                lon = Decimal.Parse(line.Substring(start, end - start), NumberFormatInfo.InvariantInfo);
                                start = end + 1;
                                end = line.IndexOf(",", start);
                                loc_name = line.Substring(start, end - start).Trim();
                                start = end + 1;
                                end = line.IndexOf(",", start);
                                loc_desc = line.Substring(start, end - start).Trim();

                                string name = loc_name + "\n" + loc_desc;

                                DataRow new_row = DIR.NewRow();
                                new_row["Lat"] = lat;
                                new_row["Lon"] = lon;
                                new_row["Name"] = name;
                                //new_row["Icon"] = icon;
                                DIR.Rows.Add(new_row);
                            }
                        }
                        catch { }
                    }

                    dir_file.Close();

                    MessageBox.Show("There are " + DIR.Rows.Count.ToString() + " POIs");
                }
                catch
                {
                    MessageBox.Show(msgPOIfileerror.Text);
                }
            }

            //poiSetIconNull();
        }

        private void dirGoogle_CheckedChanged(object sender, EventArgs e)
        {
            dirSourceChanged();
        }

        private void dirSourceChanged()
        {
            dirInterValueOpt.Enabled = true;
            dirInterValue.Enabled = true;
            dirFirst.Enabled = true;

            dirQorS.Enabled = true;
            dirDist.Enabled = true;

            dirFrom.Enabled = true;
            dirTo.Enabled = true;
            dirGetValues.Enabled = true;

            dirMap24dt.Enabled = false;

            dirInterRemRed.Enabled = false;
            dirInterPath.Enabled = false;

            dirMap24DupeLL.Enabled = false;

            dirAvoidHi.Enabled = false;

            dirInter.Enabled = true;

            if (dirMSN.Checked)
            {
                wDIR.Navigate("http://local.live.com");
            }
            else if (dirGoogle.Checked)
            {
                wDIR.Navigate("http://" + dirGoogleURL.Text);

                dirFirst.Enabled = false;

                dirQorS.Enabled = false;
                dirDist.Enabled = false;

                dirInterRemRed.Enabled = true;
                dirInterPath.Enabled = true;

                dirInter.Checked = false;
                dirInter.Enabled = false;
            }
            else if (dirMap24.Checked)
            {
                wDIR.Navigate("http://www." + dirMap24URL.Text);

                dirFirst.Enabled = false;

                dirQorS.Enabled = false;
                dirDist.Enabled = false;

                dirFrom.Enabled = false;
                dirTo.Enabled = false;
                dirGetValues.Enabled = false;

                dirMap24dt.Enabled = true;

                dirMap24DupeLL.Enabled = true;
            }            
        }

        private void dirGoogleURL_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (dirGoogle.Checked)
                wDIR.Navigate("http://" + dirGoogleURL.Text);
        }

        private void poiOV2_Click(object sender, EventArgs e)
        {
            if (poiAddNotRepl.Checked == false)
            {
                POI.Rows.Clear();
                poiName.Text = "";
            }

            string dir = System.IO.Directory.GetCurrentDirectory();

            OpenFileDialog file = new OpenFileDialog();
            file.Filter = "OV2 File - TomTom (*.ov2)|*.ov2";
            file.ShowDialog();

            System.IO.Directory.SetCurrentDirectory(dir);

            if (file.FileName != "")
            {
                try
                {
                    string file_name = new FileInfo(file.FileName).Name;
                    file_name = file_name.Substring(0, file_name.LastIndexOf(".")).Trim();
                    if (poiName.Text == "")
                        poiName.Text = "_" + file_name;

                    #region somewhat borrowed code, somewhat translated with c-sharpener for vb
                    // variables
                    byte[] btHexFile = null;
                    int c = 0; // compteur
                    string loc_name = "";
                    int iLength = 0;
                    int poi_type;

                    btHexFile = System.IO.File.ReadAllBytes(file.FileName);

                    while (c < btHexFile.Length)
                    {
                        poi_type = Convert.ToInt32(btHexFile[c]);
                        while (poi_type != 2 && poi_type != 3) // simple or extended (ignores extended part, untested) record
                        {
                            if (poi_type == 1) // skipper record
                                c += 21;
                            poi_type = Convert.ToInt32(btHexFile[c]);
                        }

                        decimal lat = 0;
                        decimal lon = 0;

                        // rcupration de la longeur du POI
                        iLength = BitConverter.ToInt32(btHexFile, c + 1); // longeur 1 octet; position 2ime octets de chaque POI

                        // ------------------------------
                        // recuperation de la description (X octets; octet de dbut 14ime; octet de fin: iLenght (longeur totale de chaque POI)
                        // ------------------------------
                        loc_name = "";
                        int i = (c + 13);
                        while (i < c + iLength && Convert.ToInt32(btHexFile[i]) != 0)
                        {
                            loc_name += Convert.ToChar(Convert.ToInt32(btHexFile[i]));
                            i++;
                        }

                        // ------------------------------
                        // rcuperation de la longitude (4 octets; position du 6ime au 9ime octets dans chaque POI)
                        // ------------------------------
                        int lon_i = BitConverter.ToInt32(btHexFile, c + 5);
                        lon = System.Convert.ToDecimal(lon_i) / 100000;

                        // ------------------------------
                        // recuperation de la latitude (idem pour la latitude sur 4 octets; du 10ime au 13ime)
                        // ------------------------------
                        int lat_i = BitConverter.ToInt32(btHexFile, c + 9);
                        lat = System.Convert.ToDecimal(lat_i) / 100000;

                        // compteurs
                        c += iLength; // du pointeur dans le fichier

                        string loc_desc = "";
                        if (poiNewline.Checked && poiNewlineText.Text != "")
                        {
                            // divide up name
                            if (loc_name.IndexOf(poiNewlineText.Text) != -1)
                            {
                                int startNL;
                                if (poiNewlineFirst.Checked)
                                    startNL = loc_name.IndexOf(poiNewlineText.Text);
                                else
                                    startNL = loc_name.LastIndexOf(poiNewlineText.Text);

                                loc_desc = loc_name.Substring(startNL + poiNewlineText.Text.Length, loc_name.Length - startNL - poiNewlineText.Text.Length);
                                loc_name = loc_name.Substring(0, startNL);
                            }
                        }

                        string name = loc_name + "\n" + loc_desc;

                        name = name.Replace(",", ";").Replace("\"", "");
                        while (name.IndexOf("  ") != -1)
                        {
                            name = name.Replace("  ", " ");
                        }

                        DataRow new_row = POI.NewRow();
                        new_row["Lat"] = lat;
                        new_row["Lon"] = lon;
                        new_row["Name"] = name;
                        POI.Rows.Add(new_row);
                    }
                    #endregion
                    
                    MessageBox.Show("There are " + POI.Rows.Count.ToString() + " POIs");
                }
                catch
                {
                    MessageBox.Show(msgPOIfileerror.Text);
                }
            }

            poiSetIconNull();
        }

        private void poiSetIconSel_Click(object sender, EventArgs e)
        {
            foreach (DataGridViewCell cell in poiGrid.SelectedCells)
            {
                cell.OwningRow.Cells["Icon"].Value = poiImage.Text;
            }
        }

        private void poiSetIconNull()
        {
            foreach (DataRow row in POI.Select("Icon IS null"))
            {
                row["Icon"] = poiImage.Text;
            }
        }

        private void popCustomMap_Click(object sender, EventArgs e)
        {
            new CustomMap(mu, wc).Show();
        }

        private void IgnoreMissingTiles_CheckedChanged(object sender, EventArgs e)
        {
            if (IgnoreMissingTiles.Checked)
            {
                PromptToRetryTiles.Checked = false;
                PromptToRetryTiles.Enabled = false;
            }
            /*else
            {
                if (iT.Checked == false && iASKt.Checked == false)
                {
                    PromptToRetryTiles.Enabled = true;
                }
            }*/
        }

        private void ToMap24_Click(object sender, EventArgs e)
        {
            wDB.Navigate("http://www.map24.com");
        }

        private void ToTextFrameN_Click(object sender, EventArgs e)
        {
            try
            {
                wDBtext.Text = wDB.Document.Window.Frames[Int32.Parse(FrameN.Text)].Document.Body.InnerHtml;
            }
            catch
            {
                wDBtext.Text = "No such frame";
            }
        }

        private void dirMap24URL_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (dirMap24.Checked)
                wDIR.Navigate("http://www." + dirMap24URL.Text);
        }

        private void dirMSN_CheckedChanged(object sender, EventArgs e)
        {
            dirSourceChanged();
        }

        private void dirMap24_CheckedChanged(object sender, EventArgs e)
        {
            dirSourceChanged();
        }

        private void poiMSN_CheckedChanged(object sender, EventArgs e)
        {
            poiSourceChanged();
        }

        private void poiGoogle_CheckedChanged(object sender, EventArgs e)
        {
            poiSourceChanged();
        }

        private void poiYahoo_CheckedChanged(object sender, EventArgs e)
        {
            poiSourceChanged();
        }

        private void poiMap24_CheckedChanged(object sender, EventArgs e)
        {
            poiSourceChanged();
        }

        private void poiSourceChanged()
        {
            poiNumberPanel.Enabled = true;
            poiYahooMi.Enabled = false;

            if (poiMap24.Checked)
            {
                wPOI.Navigate("http://www." + poiMap24URL.Text);

                poiNumberPanel.Enabled = false;
            }
            else
            {
                if (wPOI.Url.ToString().StartsWith("http://maps.google.com") == false)
                    wPOI.Navigate("http://maps.google.com");

                if (poiYahoo.Checked)
                {
                    poiYahooMi.Enabled = true;
                }
            }
        }

        private void poiMap24URL_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (poiMap24.Checked)
                wPOI.Navigate("http://www." + poiMap24URL.Text);
        }

        private void ManualWebLink_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Process proc = new Process();
            proc.StartInfo.FileName = ManualWebLink.Text;
            proc.Start();
        }

        private void poiReplace_Click(object sender, EventArgs e)
        {
            if ((poiReplaceB.Text + poiReplaceA.Text).IndexOf(",") != -1)
            {
                MessageBox.Show(msgPOIchars.Text);
            }
            else
            {
                foreach (DataRow row in POI.Rows)
                {
                    row["Name"] = row["Name"].ToString().Replace(poiReplaceA.Text, poiReplaceB.Text);
                }
            }
        }

        private void dirReplace_Click(object sender, EventArgs e)
        {
            if ((dirReplaceB.Text + dirReplaceA.Text).IndexOf(",") != -1)
            {
                MessageBox.Show(msgPOIchars.Text);
            }
            else
            {
                foreach (DataRow row in DIR.Rows)
                {
                    row["Name"] = row["Name"].ToString().Replace(dirReplaceA.Text, dirReplaceB.Text);
                }
            }
        }

        private void poiReplaceGerman_Click(object sender, EventArgs e)
        {
            //   with oe  with ae  with ue and  with ss
            poiReplaceA.Text = "";
            poiReplaceB.Text = "oe";
            poiReplace_Click(Type.Missing, EventArgs.Empty);
            poiReplaceA.Text = "";
            poiReplaceB.Text = "ae";
            poiReplace_Click(Type.Missing, EventArgs.Empty);
            poiReplaceA.Text = "";
            poiReplaceB.Text = "ue";
            poiReplace_Click(Type.Missing, EventArgs.Empty);
            poiReplaceA.Text = "";
            poiReplaceB.Text = "ss";
            poiReplace_Click(Type.Missing, EventArgs.Empty);
        }

        private void dirReplaceGerman_Click(object sender, EventArgs e)
        {
            //   with oe  with ae  with ue and  with ss
            dirReplaceA.Text = "";
            dirReplaceB.Text = "oe";
            dirReplace_Click(Type.Missing, EventArgs.Empty);
            dirReplaceA.Text = "";
            dirReplaceB.Text = "ae";
            dirReplace_Click(Type.Missing, EventArgs.Empty);
            dirReplaceA.Text = "";
            dirReplaceB.Text = "ue";
            dirReplace_Click(Type.Missing, EventArgs.Empty);
            dirReplaceA.Text = "";
            dirReplaceB.Text = "ss";
            dirReplace_Click(Type.Missing, EventArgs.Empty);
        }

        private void SetMapDir_Click(object sender, EventArgs e)
        {
            string dir = System.IO.Directory.GetCurrentDirectory();

            FolderBrowserDialog file = new FolderBrowserDialog();
            file.ShowDialog();

            System.IO.Directory.SetCurrentDirectory(dir);

            if (file.SelectedPath != "")
            {
                map_name.Text = file.SelectedPath;
            }
        }

        private void GenerateTranslation_Click(object sender, EventArgs e)
        {
            if (new FileInfo("translation.txt").Exists || new FileInfo("tooltips.txt").Exists)
            {
                MessageBox.Show(msgTransEx.Text);
            }
            else
            {
                new Translation().GenerateFile(this);
                new ToolTips().GenerateFile(this, toolTip1);
                MessageBox.Show(msgTransGen.Text);
            }
        }

        private void ToGPSFS_Click(object sender, EventArgs e)
        {
            bool worked = new GPSFS().CreateGPSFS(map_name.Text);

            if (worked)
                MessageBox.Show(msgGPFcreated.Text);
            else
                MessageBox.Show(msgGPFerror.Text);
        }

        private void FromGPSFS_Click(object sender, EventArgs e)
        {
            bool worked = new GPSFS().ExtractGPSFS(map_name.Text);

            if (worked)
                MessageBox.Show(msgGPFextracted.Text);
            else
                MessageBox.Show(msgGPFexerror.Text);
        }

        private void poiImage_DropDownItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {
            Bitmap image = new Bitmap(e.ClickedItem.Image);

            poiImage.Text = e.ClickedItem.Text;
            poiImage.Image = image;
        }

        private void dirImage_DropDownItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {
            Bitmap image = new Bitmap(e.ClickedItem.Image);

            dirImage.Text = e.ClickedItem.Text;
            dirImage.Image = image;
        }

        private void dirImage2_DropDownItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {
            Bitmap image = new Bitmap(e.ClickedItem.Image);

            dirImage2.Text = e.ClickedItem.Text;
            dirImage2.Image = image;
        }

        private void iMversion_TextChanged(object sender, EventArgs e)
        {
            mu.iMversion = iMversion.Text;
        }

        private void iTversion_TextChanged(object sender, EventArgs e)
        {
            mu.iTversion = iTversion.Text;
        }

        private void iSversion_TextChanged(object sender, EventArgs e)
        {
            mu.iSversion = iSversion.Text;
        }

        private void iYsatV_TextChanged(object sender, EventArgs e)
        {
            mu.iYsatV = iYsatV.Text;
        }

        private void iS_CheckedChanged(object sender, EventArgs e)
        {
            SatChanged();
        }

        private void SatChanged()
        {
            if (iS.Checked) // if (iT.Checked || iS.Checked)
            {
                WarnOnTileFail.Enabled = true;
                WarnOnTileFail.Checked = true;
            }
            else
            {
                WarnOnTileFail.Enabled = false;
                WarnOnTileFail.Checked = false;
            }
        }

        private void GoogleMapsString_Click(object sender, EventArgs e)
        {
            wDBtext.Text = wc.DownloadString("http://maps.google.com");
        }

        private void RepairDir_CheckedChanged(object sender, EventArgs e)
        {
            if (RepairDir.Checked)
            {
                LocalGPSFStemp.Enabled = false;
                LocalGPSFStemp.Checked = false;

                MessageBox.Show("You need to have the individual files, and specify the zoom,x,y,minzoom\n\nSo extract GPSFS first and use the contents of GPSFS_Extracted");
            }
            else
            {
                LocalGPSFStemp.Enabled = true;
                LocalGPSFStemp.Checked = true;
            }
        }

        private void DoThread_CheckedChanged(object sender, EventArgs e)
        {
            if (DoThread.Checked)
            {
                MessageBox.Show("Threading is experimental, and only seems to benefit slower sites/connections (satellite)" 
                    + "\n\nmake sure check prompt to retry or ignore missing, else you will likely crash" 
                    + "\n\ntiles will fail more frequently with this setup");
            }
        }

        private void RefreshWeb_Click(object sender, EventArgs e)
        {
            wB.Refresh();
        }

        private void SetProxy_Click(object sender, EventArgs e)
        {
            new SetProxy(wc).ShowDialog();
        }

        private void DelayTileSec_TextChanged(object sender, EventArgs e)
        {
            try
            {
                decimal test = Decimal.Parse(DelayTileSec.Text);
            }
            catch
            {
                DelayTileSec.Text = "2.5";
            }
        }

        private void itCM_CheckedChanged(object sender, EventArgs e)
        {
            if (itCM.Checked)
            {
                UserMode.Text = bAdvSimp.Text;
                AdvancedPanel.Visible = true;

                //if (map_name.Text == "")
                    map_name.Text = "_CHANG MAI";

                Mzoom.Text = "6";
                Mx.Text = "1586";
                My.Text = "914";

                MessageBox.Show("Click Pull Tiles not Download The Map");
            }
        }

        private void itP_CheckedChanged(object sender, EventArgs e)
        {
            if (itP.Checked)
            {
                UserMode.Text = bAdvSimp.Text;
                AdvancedPanel.Visible = true;

                //if (map_name.Text == "")
                    map_name.Text = "_PHUKET";

                Mzoom.Text = "7";
                Mx.Text = "791";
                My.Text = "488";

                MessageBox.Show("Click Pull Tiles not Download The Map");
            }
        }

        private void itB_CheckedChanged(object sender, EventArgs e)
        {
            Minzoom.Text = "0";

            if (itB.Checked)
            {
                Minzoom.Text = "1";

                UserMode.Text = bAdvSimp.Text;
                AdvancedPanel.Visible = true;

                //if (map_name.Text == "")
                    map_name.Text = "_BANGKOK";

                Mzoom.Text = "8";
                Mx.Text = "398";
                My.Text = "235";

                MessageBox.Show("Click Pull Tiles not Download The Map");
            }
        }

        private void GeoData_Click(object sender, EventArgs e)
        {
            new GEOmain("", "").ShowDialog();
        }

        private void iMabcversion_TextChanged(object sender, EventArgs e)
        {
            mu.iMabcversion = iMabcversion.Text;
        }

        private void iMabc_CheckedChanged(object sender, EventArgs e)
        {
            if (iMabc.Checked)
            {
                wB.Navigate("http://ditu.google.cn");
            }
            else
            {
                MSNasNAV();
            }
        }

        private void iRmoscow_CheckedChanged(object sender, EventArgs e)
        {
            MapNavPageChange();
        }

        private void iRpiter_CheckedChanged(object sender, EventArgs e)
        {
            MapNavPageChange();
        }

        private void iRtoliatti_CheckedChanged(object sender, EventArgs e)
        {
            MapNavPageChange();
        }

        private void iRomsk_CheckedChanged(object sender, EventArgs e)
        {
            MapNavPageChange();
        }

        private void iRkazan_CheckedChanged(object sender, EventArgs e)
        {
            MapNavPageChange();
        }

        private void iRekaterinburg_CheckedChanged(object sender, EventArgs e)
        {
            MapNavPageChange();
        }

        private void iRsamara_CheckedChanged(object sender, EventArgs e)
        {
            MapNavPageChange();
        }

        private void iRnnovgorod_CheckedChanged(object sender, EventArgs e)
        {
            MapNavPageChange();
        }

        private void iRvolgograd_CheckedChanged(object sender, EventArgs e)
        {
            MapNavPageChange();
        }

        private void iRkirov_CheckedChanged(object sender, EventArgs e)
        {
            MapNavPageChange();
        }

        private void iBAIDUm_CheckedChanged(object sender, EventArgs e)
        {
            MapNavPageChange();
        }

        private void iMAP2GOm_CheckedChanged(object sender, EventArgs e)
        {
            MapNavPageChange();
        }

        private void MapNavPageChange()
        {
            Minzoom.Text = "0";

            CopyIcons.Checked = true;

            NoCoords.Checked = false;
            NoCoords.Enabled = true;

            if (iBAIDUm.Checked)
            {
                wB.Navigate("http://map.baidu.com");
                MessageBox.Show(msgBaidu.Text);

                Minzoom.Text = "2";
                CopyIcons.Checked = false;

                NoCoords.Checked = true;
                NoCoords.Enabled = false;
            }
            else if (iMAP2GOm.Checked)
            {
                wB.Navigate("http://map.sogou.com/new/");
                MessageBox.Show(map2goMsg.Text);
            }
            else if (MapType().StartsWith("iR"))
            {
                Minzoom.Text = "1";

                CopyIcons.Checked = false;

                NoCoords.Checked = true;
                NoCoords.Enabled = false;

                if (iRmoscow.Checked)
                    wB.Navigate("http://nakarte.rambler.ru/moscow/");
                if (iRpiter.Checked)
                    wB.Navigate("http://nakarte.rambler.ru/piter/");
                if (iRtogliatti.Checked)
                    wB.Navigate("http://nakarte.rambler.ru/togliatti/");
                if (iRomsk.Checked)
                    wB.Navigate("http://nakarte.rambler.ru/omsk/");
                if (iRkazan.Checked)
                    wB.Navigate("http://nakarte.rambler.ru/kazan/");
                if (iReburg.Checked)
                    wB.Navigate("http://nakarte.rambler.ru/eburg/");
                if (iRsamara.Checked)
                    wB.Navigate("http://nakarte.rambler.ru/samara/");
                if (iRnnov.Checked)
                    wB.Navigate("http://nakarte.rambler.ru/nnov/");
                if (iRvgrad.Checked)
                    wB.Navigate("http://nakarte.rambler.ru/vgrad/");
                if (iRkirov.Checked)
                    wB.Navigate("http://nakarte.rambler.ru/kirov/");
            }
            else
            {
                wB.Navigate("http://maps.google.com");
            }

            //bGN_Click(Type.Missing, EventArgs.Empty);
        }

        private void dirLegacy_CheckedChanged(object sender, EventArgs e)
        {
            if (dirLegacy.Checked)
            {
                dirSplit400.Enabled = true;
            }
            else
            {
                dirSplit400.Enabled = false;
            }
        }

        private void poiRemoveDupes_Click(object sender, EventArgs e)
        {
            int dupe_names = 0;
            int dupe_latlon = 0;
            int dupe_tot = 0;

            POI.Columns.Add("remove", typeof(bool));

            string last_name = "$$$";

            foreach (DataRow row in POI.Select("", "Name"))
            {
                if (last_name == row["Name"].ToString())
                {
                    row["remove"] = true;
                    dupe_names++;
                }
                else
                {
                    last_name = row["Name"].ToString();
                    row["remove"] = false;
                }
            }

            decimal last_lat = -99;
            decimal last_lon = -99;

            foreach (DataRow row in POI.Select("", "lat, lon"))
            {
                if (last_lat == (decimal)row["lat"] && last_lon == (decimal)row["lon"])
                {
                    row["remove"] = true;
                    dupe_latlon++;
                }
                else
                {
                    last_lat = (decimal)row["lat"];
                    last_lon = (decimal)row["lon"];
                    row["remove"] = false;
                }
            }

            int i = 0;
            while (i < POI.Rows.Count)
            {
                if ((bool)POI.Rows[i]["remove"])
                {
                    POI.Rows[i].Delete();
                    dupe_tot++;
                }
                else
                {
                    i++;
                }
            }

            POI.Columns.Remove("remove");

            MessageBox.Show("Removed " + dupe_tot.ToString() + " duplicates (" + dupe_names.ToString() + " names, " + dupe_latlon.ToString() + " lat/lon)");
        }

        private void SetMC_Click(object sender, EventArgs e)
        {
            string dir = System.IO.Directory.GetCurrentDirectory();

            FolderBrowserDialog filed = new FolderBrowserDialog();
            filed.ShowDialog();

            System.IO.Directory.SetCurrentDirectory(dir);

            if (filed.SelectedPath != "")
            {
                if (map_name.Text == "")
                {
                    string mn = filed.SelectedPath;
                    mn = mn.Substring(0, mn.LastIndexOf("\\"));
                    mn = mn.Substring(mn.LastIndexOf("\\") + 1, mn.Length - 1 - mn.LastIndexOf("\\"));
                    map_name.Text = "_" + mn;
                }

                SetMC.Text = filed.SelectedPath;

                SetMCload();

                if (sender != Type.Missing)
                {
                    MessageBox.Show("Click Pull Tiles to generate the map.\n\nNote: Ignore Missing Tiles has been checked,\nhowever deselecting areas without cover will speed up the map creation\n\nYou may wish to uncheck JPEG to keep the original, usually larger, PNGs.");
                }
                else
                {
                    Application.DoEvents();
                }
            }
            else
            {
                SetMC.Text = "Set";
            }
        }

        private void SetMCload()
        {
            string shortest = "";
            string longest = "";

            foreach (FileInfo file in new DirectoryInfo(SetMC.Text).GetFiles("*.png"))
            {
                if (file.Name.Length - 4 > longest.Length)
                    longest = file.Name.Substring(0, file.Name.Length - 4);
            }

            int x = -1;
            int y = -1;

            for (int i = 1; i < 20; i++)
            {
                int lfiles = 0;
                foreach (FileInfo file in new DirectoryInfo(SetMC.Text).GetFiles(new string('?', i) + ".png"))
                {
                    if (file.Name.Length - 4 == i)
                        lfiles++;
                }

                int min_x = 999999;
                int max_x = -1;
                int min_y = 999999;
                int max_y = -1;
                if (lfiles >= 1)
                {
                    foreach (FileInfo file in new DirectoryInfo(SetMC.Text).GetFiles(new string('?', i) + ".png"))
                    {
                        if (file.Name.Length - 4 == i)
                        {
                            shortest = file.Name.Substring(0, file.Name.Length - 4);
                            int temp_x = 0;
                            int temp_y = 0;
                            for (int i2 = 0; i2 < shortest.Length; i2++)
                            {
                                temp_x *= 2;
                                temp_y *= 2;
                                if (shortest.Substring(i2, 1) == "1")
                                    temp_x++;
                                else if (shortest.Substring(i2, 1) == "2")
                                    temp_y++;
                                else if (shortest.Substring(i2, 1) == "3")
                                {
                                    temp_x++;
                                    temp_y++;
                                }
                            }
                            if (temp_x < min_x)
                                min_x = temp_x;
                            if (temp_x > max_x)
                                max_x = temp_x;
                            if (temp_y < min_y)
                                min_y = temp_y;
                            if (temp_y > max_y)
                                max_y = temp_y;
                        }
                    }
                    if (min_x != 999999)
                    {
                        if (max_x - min_x > 1 || max_y - min_y > 1)
                        {
                            i = 20;
                        }
                        else
                        {
                            x = min_x;
                            y = min_y;
                        }
                    }
                }
            }

            Mzoom.Text = (17 - shortest.Length + 1).ToString(); // since overshot
            Minzoom.Text = (17 - longest.Length).ToString(); // ?

            iMC.Checked = true;

            Mx.Text = x.ToString();
            My.Text = y.ToString();

            UserMode.Text = bAdvSimp.Text;
            AdvancedPanel.Visible = true;

            bSP_Click(Type.Missing, EventArgs.Empty);
        }

        private void MCmashupJPG_Click(object sender, EventArgs e)
        {
            if (SetMC.Text == "Set")
            {
                SetMC_Click(Type.Missing, EventArgs.Empty);
            }

            if (SetMC.Text != "Set")
            {
                DirectoryInfo source = new DirectoryInfo(SetMC.Text.Substring(0, SetMC.Text.LastIndexOf("\\")));
                DirectoryInfo destination = new DirectoryInfo(source.FullName + "_JPEG");
                if (destination.Exists)
                {
                    MessageBox.Show("Destination *_JPEG directory already exists");
                }
                else
                {
                    destination.Create();
                    foreach (FileInfo file in source.GetFiles())
                    {
                        if (file.Name == "MapLayers.crunched.xml")
                        {
                            StreamWriter sw = new StreamWriter(destination.FullName + "\\" + file.Name);
                            StreamReader sr = new StreamReader(file.FullName);
                            while (sr.EndOfStream == false)
                            {
                                sw.WriteLine(sr.ReadLine().Replace(".png", ".jpg"));
                            }
                            sr.Close();
                            sw.Close();
                        }
                        else
                        {
                            file.CopyTo(destination.FullName + "\\" + file.Name);
                        }
                    }

                    foreach (DirectoryInfo dir in source.GetDirectories())
                    {
                        if (dir.GetFiles("0.png").Length == 1 || dir.GetFiles("1.png").Length == 1 || dir.GetFiles("2.png").Length == 1 || dir.GetFiles("3.png").Length == 1)
                        {
                            new DirectoryInfo(destination.FullName + "\\" + dir.Name).Create();
                            FileInfo[] idir = dir.GetFiles();
                            int total = idir.Length;
                            int count = 0;
                            foreach (FileInfo image in idir)
                            {
                                if (image.Name.EndsWith(".png"))
                                {
                                    new Bitmap(new MemoryStream(File.ReadAllBytes(image.FullName))).Save(destination.FullName + "\\" + dir.Name + "\\" + image.Name.Replace(".png", ".jpg"), System.Drawing.Imaging.ImageFormat.Jpeg);
                                }
                                else
                                {
                                    image.CopyTo(destination.FullName + "\\" + dir.Name + "\\" + image.Name);
                                }
                                count++;
                                percent_done = (100 * count / total).ToString("0") + "% - ";
                                if (this.Text.IndexOf("%") == -1)
                                    this.Text = percent_done + this.Text;
                                else
                                    this.Text = percent_done + this.Text.Substring(this.Text.IndexOf("%") + 4, this.Text.Length - 4 - this.Text.IndexOf("%"));
                                FilesDone.Text = percent_done + count.ToString() + " out of " + total.ToString() + " (roughly)";
                                Application.DoEvents();
                            }
                        }
                        else
                        {
                            CopyDir.Copy(dir.FullName, destination.FullName + "\\" + dir.Name);
                        }
                    }

                    FilesDone.Text = "";
                    Application.DoEvents();

                    MessageBox.Show("Done: " + destination.FullName);
                }
            }
        }

        private void MCmashupJPGon_Click(object sender, EventArgs e)
        {
            MCmashupJPG.Enabled = true;
            MCmashupSITE.Enabled = true;
            YUMcruncherBTN.Enabled = true;
        }

        private void MCmashupSITE_Click(object sender, EventArgs e)
        {
            if (SetMC.Text == "Set")
            {
                SetMC_Click(Type.Missing, EventArgs.Empty);
            }

            if (SetMC.Text != "Set")
            {
                DirectoryInfo source = new DirectoryInfo(SetMC.Text.Substring(0, SetMC.Text.LastIndexOf("\\")));
                string type = "_PNG";
                if (MCtoJPG.Checked)
                    type = "_JPEG";
                DirectoryInfo destination = new DirectoryInfo(source.FullName + type + "_SITE");
                if (destination.Exists)
                {
                    MessageBox.Show("Destination *_SITE directory already exists");
                }
                else
                {
                    CopyDir.Copy("resources\\mashup", destination.FullName);
                    
                    string fzoom = (17 - Int32.Parse(Mzoom.Text) + 1).ToString();
                    decimal[] fll = LLXY.getLatLong(Int32.Parse(Mx.Text) + 1, Int32.Parse(My.Text) + 1, Int32.Parse(Mzoom.Text));
                    string flat = fll[1].ToString("0.000000");
                    string flon = fll[0].ToString("0.000000");

                    new FileInfo(destination.FullName + "\\index.html").Delete();
                    StreamWriter sw = new StreamWriter(destination.FullName + "\\index.html");
                    StreamReader sr = new StreamReader("resources\\mashup\\index.html");
                    while (sr.EndOfStream == false)
                    {
                        string fline = sr.ReadLine();
                        if (MCtoJPG.Checked)
                            fline = fline.Replace("\"./tiles/\", {type:'png'", "\"./tiles/\", {type:'jpg'");
                        fline = fline.Replace("lon=0", "lon=" + flon);
                        fline = fline.Replace("lat=52", "lat=" + flat);
                        fline = fline.Replace("zoom=9", "zoom=" + fzoom);
                        fline = fline.Replace("<title>. . .</title>", "<title>" + destination.Name + "</title>");
                        fline = fline.Replace("layer_name", destination.Name);
                        sw.WriteLine(fline);
                    }
                    sr.Close();
                    sw.Close();

                    foreach (DirectoryInfo dir in source.GetDirectories())
                    {
                        if (dir.GetFiles("0.png").Length == 1 || dir.GetFiles("1.png").Length == 1 || dir.GetFiles("2.png").Length == 1 || dir.GetFiles("3.png").Length == 1)
                        {
                            FileInfo[] idir = dir.GetFiles();
                            int total = idir.Length;
                            int count = 0;
                            foreach (FileInfo image in idir)
                            {
                                if (image.Name.EndsWith(".png"))
                                {
                                    string shortest = image.Name;
                                    shortest = shortest.Substring(0, shortest.Length - 4);

                                    int zoom = shortest.Length;

                                    int x = 0;
                                    int y = 0;

                                    for (int i = 0; i < shortest.Length; i++)
                                    {
                                        x *= 2;
                                        y *= 2;
                                        if (shortest.Substring(i, 1) == "1")
                                            x++;
                                        else if (shortest.Substring(i, 1) == "2")
                                            y++;
                                        else if (shortest.Substring(i, 1) == "3")
                                        {
                                            x++;
                                            y++;
                                        }
                                    }

                                    DirectoryInfo zdir = new DirectoryInfo(destination.FullName + "\\tiles\\" + zoom.ToString());
                                    if (zdir.Exists == false)
                                        zdir.Create();
                                    DirectoryInfo xdir = new DirectoryInfo(destination.FullName + "\\tiles\\" + zoom.ToString() + "\\" + x.ToString());
                                    if (xdir.Exists == false)
                                        xdir.Create();

                                    if (MCtoJPG.Checked)
                                    {
                                        new Bitmap(new MemoryStream(File.ReadAllBytes(image.FullName))).Save(destination.FullName + "\\tiles\\" + zoom.ToString() + "\\" + x.ToString() + "\\" + y.ToString() + ".jpg", System.Drawing.Imaging.ImageFormat.Jpeg);
                                    }
                                    else
                                    {
                                        image.CopyTo(destination.FullName + "\\tiles\\" + zoom.ToString() + "\\" + x.ToString() + "\\" + y.ToString() + ".png");
                                    }
                                }

                                count++;
                                percent_done = (100 * count / total).ToString("0") + "% - ";
                                if (this.Text.IndexOf("%") == -1)
                                    this.Text = percent_done + this.Text;
                                else
                                    this.Text = percent_done + this.Text.Substring(this.Text.IndexOf("%") + 4, this.Text.Length - 4 - this.Text.IndexOf("%"));
                                FilesDone.Text = percent_done + count.ToString() + " out of " + total.ToString() + " (roughly)";
                                Application.DoEvents();
                            }
                        }
                    }

                    FilesDone.Text = "";
                    Application.DoEvents();

                    MessageBox.Show("Done: " + destination.FullName 
                        + "\n\nNote: replace ./tiles/ with the full URL in index.html");
                }
            }
        }

        private void iIRtopo_CheckedChanged(object sender, EventArgs e)
        {
            Minzoom.Text = "0";
            if (iIRtopo.Checked)
            {
                Minzoom.Text = "3";
                wB.Navigate("http://www.in7ane.com/topomaps");
            }
            else
            {
                MSNasNAV();
            }
        }

        private void iMSNm_CheckedChanged(object sender, EventArgs e)
        {
            if (AutoWeb.Checked)
                MSNasNAV();
        }

        private void iMSNmH_CheckedChanged(object sender, EventArgs e)
        {
            if (AutoWeb.Checked)
                MSNasNAV();
        }

        private void iMSNh_CheckedChanged(object sender, EventArgs e)
        {
            if (AutoWeb.Checked)
                MSNasNAV();
        }

        private void iMSNs_CheckedChanged(object sender, EventArgs e)
        {
            if (AutoWeb.Checked)
                MSNasNAV();
        }

        private void iYs_CheckedChanged(object sender, EventArgs e)
        {
            if (AutoWeb.Checked)
                MSNasNAV();
        }

        private void iYm_CheckedChanged(object sender, EventArgs e)
        {
            if (AutoWeb.Checked)
                MSNasNAV();
        }

        private void MSNasNAV()
        {
            if (MapType().StartsWith("iMSN"))
            {
                WebLocalLive_Click(Type.Missing, EventArgs.Empty);
            }
            else if (MapType().StartsWith("iY"))
            {
                WebYahoo_Click(Type.Missing, EventArgs.Empty);
            }
            else
            {
                WebGoogle_Click(Type.Missing, EventArgs.Empty);
            }
        }

        private void YUMcruncherBTN_Click(object sender, EventArgs e)
        {
            new YUM_Assembler().ShowDialog();
        }

        private void TestDir_Click(object sender, EventArgs e)
        {
            if (map_name.Text == "")
            {
                MessageBox.Show("No directory specified");
            }
            else
            {
                DirectoryInfo gpsfsdir = new DirectoryInfo(map_name.Text);
                if (gpsfsdir.Exists == false || gpsfsdir.GetFiles("GPSFS").Length == 0)
                {
                    MessageBox.Show("Not a GPSFS map directory");
                }
                else
                {
                    new GPSFSdirTester(map_name.Text).ShowDialog();
                }
            }
        }

        private void ViewDir_Click(object sender, EventArgs e)
        {
            if (map_name.Text == "")
            {
                MessageBox.Show("No directory specified");
            }
            else
            {
                DirectoryInfo gpsfsdir = new DirectoryInfo(map_name.Text);
                if (gpsfsdir.Exists == false || gpsfsdir.GetFiles("GPSFS").Length == 0)
                {
                    MessageBox.Show("Not a GPSFS map directory");
                }
                else
                {
                    new GPSFSdirViewer(map_name.Text).ShowDialog();
                }
            }
        }

        private void SetSI_Click(object sender, EventArgs e)
        {
            string dir = System.IO.Directory.GetCurrentDirectory();

            FolderBrowserDialog filed = new FolderBrowserDialog();
            filed.ShowDialog();

            System.IO.Directory.SetCurrentDirectory(dir);

            if (filed.SelectedPath != "")
            {
                if (map_name.Text == "")
                {
                    string mn = filed.SelectedPath;
                    mn = mn.Substring(0, mn.LastIndexOf("\\"));
                    mn = mn.Substring(mn.LastIndexOf("\\") + 1, mn.Length - 1 - mn.LastIndexOf("\\"));
                    map_name.Text = "_" + mn;
                }

                string ext = "jpg";

                int zoom = 20;
                int min_zoom = 20;

                int x = -1;
                int y = -1;

                foreach (DirectoryInfo zdir in new DirectoryInfo(filed.SelectedPath).GetDirectories())
                {
                    if (17 - Int32.Parse(zdir.Name) < min_zoom)
                    {
                        min_zoom = 17 - Int32.Parse(zdir.Name);
                    }
                    if (zdir.GetDirectories().Length <= 2)
                    {
                        bool yok = true;
                        foreach (DirectoryInfo xdir in zdir.GetDirectories())
                        {
                            if (xdir.GetFiles("*.png").Length != 0)
                            {
                                ext = "png";
                            }

                            if (xdir.GetFiles().Length > 2)
                                yok = false;
                        }
                        if (yok && 17 - Int32.Parse(zdir.Name) < zoom)
                        {
                            zoom = 17 - Int32.Parse(zdir.Name);
                            x = 999999;
                            y = 999999;
                            foreach (DirectoryInfo xdir in zdir.GetDirectories())
                            {
                                if (Int32.Parse(xdir.Name) < x)
                                {
                                    x = Int32.Parse(xdir.Name);
                                    foreach (FileInfo yfil in xdir.GetFiles())
                                    {
                                        if (Int32.Parse(yfil.Name.Substring(0, yfil.Name.Length - 4)) < y)
                                            y = Int32.Parse(yfil.Name.Substring(0, yfil.Name.Length - 4));
                                    }
                                }
                            }
                        }
                    }
                }
                SetSI.Text = ext + filed.SelectedPath;

                Mzoom.Text = zoom.ToString();
                Minzoom.Text = min_zoom.ToString();

                Mx.Text = x.ToString();
                My.Text = y.ToString();

                iSI.Checked = true;

                UserMode.Text = bAdvSimp.Text;
                AdvancedPanel.Visible = true;

                bSP_Click(Type.Missing, EventArgs.Empty);

                if (sender != Type.Missing)
                {
                    MessageBox.Show("Click Pull Tiles to generate the map.\n\nNote: Ignore Missing Tiles has been checked,\nhowever deselecting areas without cover will speed up the map creation\n\nYou may wish to uncheck JPEG to keep the original, usually larger, PNGs.");
                }
                else
                {
                    Application.DoEvents();
                }
            }
            else
            {
                SetSI.Text = "Set";
            }
        }

        private void wB_DocumentCompleted(object sender, WebBrowserDocumentCompletedEventArgs e)
        {
            wB.Document.Window.Error += new HtmlElementErrorEventHandler(Window_Error);
        }

        void Window_Error(object sender, HtmlElementErrorEventArgs e)
        {
            e.Handled = true;
        }

        private void SiteToGPSFS_Click(object sender, EventArgs e)
        {
            if (SetSI.Text == "Set")
            {
                SetSI_Click(Type.Missing, EventArgs.Empty);
            }
            
            if (SetSI.Text != "Set")
            {
                FilesDone.Text = "Wait . . .";
                Application.DoEvents();

                bool worked = new GPSFS().CreateGPSFSfromSite(SetSI.Text.Substring(3, SetSI.Text.Length - 3), Int32.Parse(Mzoom.Text), Int32.Parse(Mx.Text), 
                    Int32.Parse(My.Text), Int32.Parse(Minzoom.Text), SetSI.Text.Substring(0,3));

                if (worked)
                    MessageBox.Show(msgGPFcreated.Text);
                else
                    MessageBox.Show(msgGPFerror.Text);

                FilesDone.Text = "";
            }
        }

        private void ToporamaBase_TextChanged(object sender, EventArgs e)
        {
            try
            {
                mu.ToporamaBase = Int32.Parse(ToporamaBase.Text);
            }
            catch
            {
                mu.ToporamaBase = 20000;
                ToporamaBase.Text = "20000";
            }
        }

        private void iToporama_CheckedChanged(object sender, EventArgs e)
        {
            Toporama800tiles.Enabled = false;

            if (iToporama.Checked)
            {
                MessageBox.Show("This will NOT download by clicking Download Map or Pull Tiles, previews kindof work (you probably want to preview using one of the other sources)\n\nTo download a map: click 800x800 tiles to MC.yum to downlaod and generate an aligned MapCruncher project (which will then render)");
                Toporama800tiles.Enabled = true;
            }
        }

        ToporamaProjJS ProjJS = new ToporamaProjJS("EPSG:42304");

        private double MaxDouble(double a, double b)
        {
            if (a > b)
                return a;
            return b;
        }
        private double MinDouble(double a, double b)
        {
            if (a < b)
                return a;
            return b;
        }

        private int MaxInt(int a, int b)
        {
            if (a > b)
                return a;
            return b;
        }

        private void Toporama800tiles_Click(object sender, EventArgs e)
        {
            string pageE = "";
            string imgE = "";

            try
            {
                if (Int32.Parse(ToporamaBase.Text) < 20000)
                {
                    MessageBox.Show("Base needs to be at least 20000 to download");
                }
                else
                {
                    bool reset_span = false;

                    int[] the_numbers = GetNumbers(wB.Document.Body.OuterHtml);

                    int zoom = the_numbers[0];
                    int x = the_numbers[1];
                    int y = the_numbers[2];

                    if (AdvancedPanel.Visible)
                    {
                        zoom = Int32.Parse(Mzoom.Text);
                        x = Int32.Parse(Mx.Text);
                        y = Int32.Parse(My.Text);
                    }

                    if (ToporamaSpan.Text == "1" && zoom == 8 && MessageBox.Show("Do you want to set Tx to 2 (needed for the YUM file to be renderable at this map size)?", "", MessageBoxButtons.YesNo) == DialogResult.Yes) // 512
                    {
                        reset_span = true;
                        ToporamaSpan.Text = "2";
                    }
                    if (ToporamaSpan.Text == "1" && zoom == 9 && MessageBox.Show("Do you want to set Tx to 3 (needed for the YUM file to be renderable at this map size)?", "", MessageBoxButtons.YesNo) == DialogResult.Yes) //1024
                    {
                        reset_span = true;
                        ToporamaSpan.Text = "3";
                    }

                    if (ToporamaSpan.Text == "1" && zoom >= 10 && MessageBox.Show("This will produce an unrenderable YUM file, do you want to abort?", "", MessageBoxButtons.YesNo) == DialogResult.Yes)
                    {
                        MessageBox.Show("Suggestion: higher than 20000 base or Tx > 3 - review to code to understand the issues");
                    }
                    else
                    {
                        if (map_name.Text == "")
                        {
                            map_name.Text = "_Map of " + x.ToString() + " by " + y.ToString() + " at " + zoom.ToString() + " to " + ToporamaBase.Text;
                        }

                        map_name.Text = map_name.Text + "_source";

                        DirectoryInfo dir = new DirectoryInfo(map_name.Text);
                        if (dir.Exists && RepairDir.Checked == false)
                        {
                            MessageBox.Show("Already there");
                        }
                        else
                        {
                            bool full_auto = false;
                            if (MessageBox.Show("Do you want to automatically render the map and then convert it to GPSFS?\n\nYou need to have MapCruncher (latest version in " + MCdriveLTR.Text + ":\\Program Files\\MSR MapCruncher for Virtual Earth\\ is used, note: you can change the drive letter) installed for this to work.", "", MessageBoxButtons.YesNo) == DialogResult.Yes)
                            {
                                full_auto = true;
                                SelectiveDetail.Checked = false;
                            }

                            FilesDone.Text = "Starting up";
                            Application.DoEvents();

                            if (dir.Exists == false)
                                dir.Create();

                            StreamWriter yum = new StreamWriter(map_name.Text + "\\map.yum", false);
                            yum.WriteLine("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"?>");
                            yum.WriteLine("<MapGrinderMashupFile Version=\"1.7\">");
                            yum.WriteLine("  <RenderOptions>");
                            yum.WriteLine("    <PublishSourceData Value=\"False\" />");
                            yum.WriteLine("    <PermitComposition Value=\"False\" />");
                            yum.WriteLine("    <Output Folder=\"" + map_name.Text.Replace("_source", "_MCrendered") + "\" />");
                            yum.WriteLine("  </RenderOptions>");
                            yum.WriteLine("  <LayerList>");
                            yum.WriteLine("    <Layer DisplayName=\"New Layer\" Expanded=\"True\" id=\"0\">");

                            decimal[] TLcoord = LLXY.getLatLong(x, y, zoom); // top left
                            double maxlat = System.Convert.ToDouble(TLcoord[1]);
                            double minlon = System.Convert.ToDouble(TLcoord[0]);
                            decimal[] BRcoord = LLXY.getLatLong(x + 2, y + 2, zoom); // bottom right
                            double minlat = System.Convert.ToDouble(BRcoord[1]);
                            double maxlon = System.Convert.ToDouble(BRcoord[0]);

                            decimal[] TRcoord = LLXY.getLatLong(x + 2, y, zoom); // top right
                            double maxlatTR = System.Convert.ToDouble(TRcoord[1]);
                            double minlonTR = System.Convert.ToDouble(TRcoord[0]);
                            decimal[] BLcoord = LLXY.getLatLong(x, y + 2, zoom); // bottom left
                            double minlatBL = System.Convert.ToDouble(BLcoord[1]);
                            double maxlonBL = System.Convert.ToDouble(BLcoord[0]);

                            decimal[] BCcoord = LLXY.getLatLong(x + 1, y + 2, zoom); // bottom center (see: curvature)
                            double minlatBC = System.Convert.ToDouble(BCcoord[1]);
                            double maxlonBC = System.Convert.ToDouble(BCcoord[0]);

                            double scale = Int32.Parse(ToporamaBase.Text);
                            double jump = 5644.441396 * scale / 20000;

                            double[] xyTL = ProjJS.ll2lcc(minlon, maxlat);
                            double[] xyTR = ProjJS.ll2lcc(minlonTR, maxlatTR);
                            double[] xyBR = ProjJS.ll2lcc(maxlon, minlat);
                            double[] xyBL = ProjJS.ll2lcc(maxlonBL, minlatBL);

                            double[] xyBC = ProjJS.ll2lcc(maxlonBC, minlatBC);

                            double TxTL = MinDouble(xyTL[0], xyBL[0]);
                            double TyTL = MaxDouble(xyTL[1], xyTR[1]);
                            double TxBR = MaxDouble(xyBR[0], xyTR[0]);
                            double TyBR = MinDouble(xyBR[1], xyBL[1]);

                            TyBR = MinDouble(TyBR, xyBC[1]);

                            int x_span = 0;
                            int y_span = 0;

                            int total = 0;
                            double cX = TxTL;
                            while (cX <= TxBR)
                            {
                                int loc_y_span = 0;
                                double cY = TyTL;
                                while (cY >= TyBR)
                                {
                                    total++;

                                    cY -= jump;
                                    loc_y_span++;
                                }
                                if (loc_y_span > y_span)
                                    y_span = loc_y_span;
                                cX += jump;
                                x_span++;
                            }

                            double tile_span = Double.Parse(ToporamaSpan.Text); // 10 max (checked on text change)
                            if (tile_span > MaxInt(x_span, y_span))
                                tile_span = MaxInt(x_span, y_span);
                            string ext = ".gif";
                            string pre = "";
                            if (tile_span > 1)
                            {
                                ext = ".png";
                                pre = tile_span.ToString() + "x";
                            }

                            int SourceMapID = 1;

                            int count = 0;
                            cX = TxTL;
                            int xI = 0;
                            while (cX <= TxBR)
                            {
                                double cY = TyTL;
                                int yI = 0;
                                while (cY >= TyBR)
                                {
                                    if (new FileInfo(map_name.Text + "\\" + yI.ToString() + "_" + xI.ToString() + ".gif").Exists == false)
                                    {
                                        string page = wc.DownloadString("http://atlas.nrcan.gc.ca/cgi-bin/mapserv?map=/home/atlas/mapdata/english/toporama.map&map_web_template=/home/atlas/mapdata/to_zope_new.html&scale=" + scale.ToString().Replace(",", ".") + "&mapxy=" + cX.ToString().Replace(",", ".") + "%20" + cY.ToString().Replace(",", ".") + "&layers=other_features%20million_grid%20t50k_grid%20grid_50k_3%20roads%20hydrography%20boundary%20builtup%20vegetation%20populated_places%20railway%20power_network%20manmade_features%20designated_areas%20water_features%20water_saturated_soils%20relief%20contours%20toponymy%20contour%20nodata_ntdb_50k%3F%3F%3F%3Fqt%3FA%F7%3F%3F%3F%FF%3F%3F&mapsize=800%20800");
                                        pageE = page;
                                        int start = page.IndexOf("image");
                                        start = page.IndexOf("/", start) + 1;
                                        start = page.IndexOf("/", start);
                                        string img_url = "http://atlas.nrcan.gc.ca" + page.Substring(start, page.IndexOf(".", start) + 4 - start);
                                        imgE = img_url;
                                        wc.DownloadFile(img_url, map_name.Text + "\\" + yI.ToString() + "_" + xI.ToString() + ".gif");
                                    }

                                    if (Math.IEEERemainder(xI, tile_span) == 0 && Math.IEEERemainder(yI, tile_span) == 0)
                                    {
                                        yum.WriteLine("      <SourceMap DisplayName=\"" + pre + (yI / tile_span).ToString() + "_" + (xI / tile_span).ToString() + "\" Expanded=\"False\" id=\"" + SourceMapID.ToString() + "\">");
                                        yum.WriteLine("        <Document>");
                                        yum.WriteLine("          <FileDocument Filename=\"" + pre + (yI / tile_span).ToString() + "_" + (xI / tile_span).ToString() + ext + "\" PageNumber=\"0\" />");
                                        yum.WriteLine("        </Document>");
                                        yum.WriteLine("        <SourceMapInfo>");
                                        yum.WriteLine("          <MapFileURL url=\"\" />");
                                        yum.WriteLine("          <MapHomePage url=\"\" />");
                                        yum.WriteLine("          <MapDescription />");
                                        yum.WriteLine("        </SourceMapInfo>");
                                        yum.WriteLine("        <SourceMapRenderOptions MaxZoom=\"" + ToporamaAutoZoom.Text + "\" />"); // will auto calc?
                                        yum.WriteLine("        <TransparencyOptions Enabled=\"True\" Inverted=\"False\" />");
                                        yum.WriteLine("        <SourceMapView locked=\"False\">");
                                        yum.WriteLine("          <SourceMapPosition>");
                                        yum.WriteLine("            <LatLonZoom zoom=\"5\">");
                                        yum.WriteLine("              <LatLon lat=\"0.5\" lon=\"0.5\" />");
                                        yum.WriteLine("            </LatLonZoom>");
                                        yum.WriteLine("          </SourceMapPosition>");
                                        yum.WriteLine("          <ReferenceMapPosition>");
                                        yum.WriteLine("            <MapPosition>");
                                        yum.WriteLine("              <LatLonZoom zoom=\"" + (16 - zoom).ToString() + "\">");
                                        yum.WriteLine("                <LatLon lat=\"" + ((maxlat + minlat) / 2).ToString().Replace(",", ".") + "\" lon=\"" + ((maxlon + minlon) / 2).ToString().Replace(",", ".") + "\" />");
                                        yum.WriteLine("              </LatLonZoom>");
                                        yum.WriteLine("            </MapPosition>");
                                        yum.WriteLine("          </ReferenceMapPosition>");
                                        yum.WriteLine("        </SourceMapView>");
                                        yum.WriteLine("        <RegistrationDefinition WarpQuality=\"Automatic\">");

                                        //TL 1,0
                                        //TR 1,1
                                        //BL 0,0
                                        //BR 0,1
                                        //CC 0.5,0.5

                                        double tile_span_x = 0;
                                        double tempX = cX;
                                        while (tempX <= TxBR)
                                        {
                                            tile_span_x++;
                                            tempX += jump;
                                        }
                                        if (tile_span_x > tile_span)
                                            tile_span_x = tile_span;
                                        double tile_span_y = 0;
                                        double tempY = cY;
                                        while (tempY >= TyBR)
                                        {
                                            tile_span_y++;
                                            tempY -= jump;
                                        }
                                        if (tile_span_y > tile_span)
                                            tile_span_y = tile_span;

                                        int pinId = 0;
                                        int div = Int32.Parse(ToporamaDiv.Text);
                                        double pX = cX - jump / 2;
                                        double pXi = 0;
                                        while (pXi <= div)
                                        {
                                            double pY = cY + jump / 2; // +tile_span * jump;
                                            double pYi = 0;
                                            while (pYi <= div)
                                            {
                                                if (ToporamaNoBorder.Checked == false || (pXi != 0 && pXi != div && pYi != 0 && pYi != div))
                                                {
                                                    double[] pin = ProjJS.lcc2ll(pX, pY);
                                                    yum.WriteLine("          <PositionAssociation pinId=\"" + pinId.ToString() + "\" associationName=\"" + pYi.ToString() + "_" + pXi.ToString() + "\">");
                                                    yum.WriteLine("            <SourcePosition>");
                                                    yum.WriteLine("              <LatLonZoom zoom=\"5\">"); // need to set, will def? (what if lock = true?)
                                                    string laty = ((div - pYi) / div).ToString().Replace(",", ".");
                                                    string lonx = (pXi / div).ToString().Replace(",", ".");
                                                    yum.WriteLine("                <LatLon lat=\"" + laty + "\" lon=\"" + lonx + "\" />");
                                                    yum.WriteLine("              </LatLonZoom>");
                                                    yum.WriteLine("            </SourcePosition>");
                                                    yum.WriteLine("            <GlobalPosition>");
                                                    yum.WriteLine("              <LatLonZoom zoom=\"" + (16 - zoom).ToString() + "\">");
                                                    yum.WriteLine("                <LatLon lat=\"" + pin[1].ToString().Replace(",", ".") + "\" lon=\"" + pin[0].ToString().Replace(",", ".") + "\" />");
                                                    yum.WriteLine("              </LatLonZoom>");
                                                    yum.WriteLine("            </GlobalPosition>");
                                                    yum.WriteLine("          </PositionAssociation>");

                                                    pinId++;
                                                }

                                                pY -= tile_span * jump / div;
                                                pYi++;
                                            }
                                            pX += tile_span * jump / div;
                                            pXi++;
                                        }

                                        yum.WriteLine("        </RegistrationDefinition>");
                                        yum.WriteLine("        <RenderRegion>");
                                        yum.WriteLine("          <LatLon lat=\"1\" lon=\"0\" />");
                                        yum.WriteLine("          <LatLon lat=\"" + (1 - tile_span_y / tile_span).ToString().Replace(",", ".") + "\" lon=\"0\" />");
                                        yum.WriteLine("          <LatLon lat=\"" + (1 - tile_span_y / tile_span).ToString().Replace(",", ".") + "\" lon=\"" + (tile_span_x / tile_span).ToString().Replace(",", ".") + "\" />");
                                        yum.WriteLine("          <LatLon lat=\"1\" lon=\"" + (tile_span_x / tile_span).ToString().Replace(",", ".") + "\" />");
                                        yum.WriteLine("        </RenderRegion>");
                                        yum.WriteLine("        <LegendList />");
                                        yum.WriteLine("      </SourceMap>");

                                        SourceMapID++;
                                    }
                                    count++;
                                    percent_done = (100 * count / total).ToString("0") + "% - ";
                                    if (this.Text.IndexOf("%") == -1)
                                        this.Text = percent_done + this.Text;
                                    else
                                        this.Text = percent_done + this.Text.Substring(this.Text.IndexOf("%") + 4, this.Text.Length - 4 - this.Text.IndexOf("%"));
                                    FilesDone.Text = percent_done + count.ToString() + " out of " + total.ToString();
                                    Application.DoEvents();

                                    cY -= jump;
                                    yI++;
                                }
                                cX += jump;
                                xI++;
                            }

                            yum.WriteLine("      <LayerView>");
                            yum.WriteLine("        <MapPosition>");
                            yum.WriteLine("          <LatLonZoom zoom=\"" + (16 - zoom).ToString() + "\">");
                            yum.WriteLine("            <LatLon lat=\"" + ((maxlat + minlat) / 2).ToString().Replace(",", ".") + "\" lon=\"" + ((maxlon + minlon) / 2).ToString().Replace(",", ".") + "\" />");
                            yum.WriteLine("          </LatLonZoom>");
                            yum.WriteLine("        </MapPosition>");
                            yum.WriteLine("      </LayerView>");
                            yum.WriteLine("    </Layer>");
                            yum.WriteLine("  </LayerList>");
                            yum.WriteLine("</MapGrinderMashupFile>");
                            yum.Close();

                            if (tile_span > 1)
                            {
                                FilesDone.Text = "Grouping tiles into " + tile_span.ToString() + "x" + tile_span.ToString() + " ones";
                                Application.DoEvents();

                                cX = TxTL;
                                xI = 0;
                                while (cX <= TxBR)
                                {
                                    double cY = TyTL;
                                    int yI = 0;
                                    while (cY >= TyBR)
                                    {
                                        if (Math.IEEERemainder(xI, tile_span) == 0 && Math.IEEERemainder(yI, tile_span) == 0)
                                        {
                                            double tile_span_x = 0;
                                            double tempX = cX;
                                            while (tempX <= TxBR)
                                            {
                                                tile_span_x++;
                                                tempX += jump;
                                            }
                                            double tile_span_y = 0;
                                            double tempY = cY;
                                            while (tempY >= TyBR)
                                            {
                                                tile_span_y++;
                                                tempY -= jump;
                                            }

                                            Bitmap tileBIG = new Bitmap(System.Convert.ToInt32(tile_span) * 800, System.Convert.ToInt32(tile_span) * 800);

                                            int tile_off_x = 0;
                                            while (tile_off_x < tile_span_x)
                                            {
                                                int tile_off_y = 0;
                                                while (tile_off_y < tile_span_y)
                                                {
                                                    Bitmap src = new Bitmap(map_name.Text + "\\" + (yI + tile_off_y).ToString() + "_" + (xI + tile_off_x).ToString() + ".gif");

                                                    Rectangle srcRect = new Rectangle();
                                                    Rectangle destRect = new Rectangle();

                                                    using (Graphics g = Graphics.FromImage(tileBIG))
                                                    {
                                                        Brush b = new SolidBrush(Color.Transparent);
                                                        g.FillRectangle(b, destRect);
                                                        srcRect.Width = 800;
                                                        srcRect.Height = 800;

                                                        destRect.Width = 800;
                                                        destRect.Height = 800;
                                                        destRect.X = tile_off_x * 800;
                                                        destRect.Y = tile_off_y * 800;

                                                        g.DrawImage(src, destRect, srcRect, System.Drawing.GraphicsUnit.Pixel);
                                                    }
                                                    src.Dispose();

                                                    tile_off_y++;
                                                }
                                                tile_off_x++;
                                            }

                                            new FileInfo(map_name.Text + "\\" + tile_span + "x" + (yI / tile_span).ToString() + "_" + (xI / tile_span).ToString() + ".png").Delete();
                                            tileBIG.Save(map_name.Text + "\\" + tile_span + "x" + (yI / tile_span).ToString() + "_" + (xI / tile_span).ToString() + ".png", System.Drawing.Imaging.ImageFormat.Png);
                                            tileBIG.Dispose();
                                        }

                                        cY -= jump;
                                        yI++;
                                    }
                                    cX += jump;
                                    xI++;
                                }
                            }

                            FilesDone.Text = "";
                            if (full_auto)
                            {
                                // render & wait
                                string file_name = map_name.Text + "\\map.yum";
                                if (file_name.StartsWith("\\\\") == false && (file_name.Length < 2 || file_name.Substring(1, 1) != ":"))
                                {
                                    file_name = Directory.GetCurrentDirectory() + "\\" + file_name;
                                }
                                string suffix = " -render";

                                // get version
                                string version = "";
                                foreach (DirectoryInfo dirMC in new DirectoryInfo(MCdriveLTR.Text + ":\\Program Files\\MSR MapCruncher for Virtual Earth\\").GetDirectories())
                                {
                                    if (String.Compare(version, dirMC.Name) < 0)
                                    {
                                        version = dirMC.Name;
                                    }
                                }

                                Process proc = new Process();
                                proc.StartInfo.FileName = MCdriveLTR.Text + ":\\Program Files\\MSR MapCruncher for Virtual Earth\\" + version + "\\MapCruncher.exe";
                                proc.StartInfo.Arguments = "\"" + file_name + "\"" + suffix;
                                proc.Start();
                                proc.WaitForExit();

                                // load
                                SetMC.Text = file_name.Replace("_source\\map.yum", "_MCrendered\\Layer_NewLayer");
                                SetMCload();

                                // name wo _source
                                map_name.Text = map_name.Text.Replace("_source", "");

                                // process
                                bPF_Click(Type.Missing, EventArgs.Empty);
                            }
                            else
                            {
                                MessageBox.Show("Done: " + map_name.Text + "\\map.yum");
                                map_name.Text = map_name.Text.Replace("_source", "");
                                SelectiveDetail.Checked = true;
                            }
                        }
                    }

                    if (reset_span)
                        ToporamaSpan.Text = "1";
                }
            }
            catch (Exception e2)
            {
                MessageBox.Show("ERROR: " + "\n\n" + e2.Message + "\n\n" + e2.StackTrace + "\n\n" + imgE + "\n\n" + pageE);
            }
        }

        private void ToporamaSpan_TextChanged(object sender, EventArgs e)
        {
            try
            {
                int test = Int32.Parse(ToporamaSpan.Text);
                if (test < 1 || test > 10)
                    ToporamaSpan.Text = "10";
            }
            catch
            {
                ToporamaSpan.Text = "10";
            }
        }

        private void ToporamaDiv_TextChanged(object sender, EventArgs e)
        {
            try
            {
                int test = Int32.Parse(ToporamaDiv.Text);
                if (test < 1)
                    ToporamaDiv.Text = "3";
            }
            catch
            {
                ToporamaDiv.Text = "3";
            }
        }

        private void WebLocalLive_Click(object sender, EventArgs e)
        {
            if (wB.Url.ToString().IndexOf("live.com") == -1)
                wB.Navigate("http://maps.live.com");
        }

        private void WebGoogle_Click(object sender, EventArgs e)
        {
            if (wB.Url.ToString().IndexOf("google.com") == -1)
                wB.Navigate("http://maps.google.com");
        }

        private void WebYahoo_Click(object sender, EventArgs e)
        {
            if (wB.Url.ToString().IndexOf("yahoo.com") == -1)
                wB.Navigate("http://in.maps.yahoo.com");
        }

        struct String2
        {
            public string Text;
            public string Text2;

            public override string ToString()
            {
                return Text;
            }
        }

        private void WMSlist_Click(object sender, EventArgs e)
        {
            WMSlayer.Items.Clear();
            WMSlayer.Text = "";

            string url = WMSserver.Text + "?VERSION=" + WMSversion.Text + "&request=GetCapabilities&service=wms";

            try
            {
                XmlDocument xmld = new XmlDocument();
                xmld.Load(url);

                foreach (XmlNode xmln in xmld.GetElementsByTagName("Name"))
                {
                    if (xmln.ParentNode.Name == "Layer")
                    {
                        string desc = "";
                        foreach (XmlNode xmldesc in xmln.ParentNode.ChildNodes)
                        {
                            if (xmldesc.Name == "Title" || xmldesc.Name == "Abstract")
                                desc = desc + xmldesc.InnerText.Trim() + "\n\n";
                            else if (xmldesc.Name == "LatLonBoundingBox")
                                desc = desc + xmldesc.OuterXml.Trim() + "\n\n";
                        }
                        if (desc.Length > 0)
                            desc = desc.Substring(0, desc.Length - 2);

                        String2 s2 = new String2();
                        s2.Text = xmln.InnerText;
                        s2.Text2 = desc;
                        WMSlayer.Items.Add(s2);
                    }
                }

                if (WMSlayer.Items.Count > 0)
                {
                    WMSlayer.SelectedIndex = 0;
                    MessageBox.Show("Sucessfully retrieved list of " + WMSlayer.Items.Count.ToString() + " layers from: " + url);
                }
                else
                {
                    MessageBox.Show("No layers found at: " + url);
                }
            }
            catch
            {
                MessageBox.Show("FAILED to load: " + url);
            }
        }

        private void iWMS_CheckedChanged(object sender, EventArgs e)
        {
            WMSpanel.Visible = false;

            if (iWMS.Checked)
                WMSpanel.Visible = true;
        }

        private void WMSserver_TextChanged(object sender, EventArgs e)
        {
            WMSlayer.Items.Clear();
            WMSlayer.Text = "";
            if (WMSserver.Text.IndexOf("?") != -1)
                WMSserver.Text = WMSserver.Text.Substring(0, WMSserver.Text.IndexOf("?"));
        }

        private void WMSlayer_TextChanged(object sender, EventArgs e)
        {
            toolTip1.SetToolTip(WMSlayer, "");
            if (WMSlayer.SelectedIndex != -1)
            {
                toolTip1.SetToolTip(WMSlayer, ((String2)WMSlayer.SelectedItem).Text2);
            }
        }

        private void wmsL1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Process proc = new Process();
            proc.StartInfo.FileName = "http://www.ogc-services.net/";
            proc.Start();
        }

        private void wmsL2_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Process proc = new Process();
            proc.StartInfo.FileName = "http://www.skylab-mobilesystems.com/en/wms_serverlist.html";
            proc.Start();
        }

        private void wmsL3_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Process proc = new Process();
            proc.StartInfo.FileName = "http://www.refractions.net/white_papers/ogcsurvey/index.php";
            proc.Start();
        }

        private void wmsL4_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Process proc = new Process();
            proc.StartInfo.FileName = "http://wms-sites.com/catalog";
            proc.Start();
        }

        private void wmsL5_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Process proc = new Process();
            proc.StartInfo.FileName = "http://exploreourpla.net/gis/maps/";
            proc.Start();
        }

        private void iShadedRelief_CheckedChanged(object sender, EventArgs e)
        {
            Minzoom.Text = "0";
            if (iShadedRelief.Checked)
            {
                Minzoom.Text = "8";
                MessageBox.Show("Minzoom set to 8, will be reset to 0");
            }
        }

        private void iASKp_CheckedChanged(object sender, EventArgs e)
        {
            Minzoom.Text = "0";
            if (iASKp.Checked)
            {
                Minzoom.Text = "9";
                MessageBox.Show("Minzoom set to 9, will be reset to 0");
            }
        }

        private void tOverlay_TextChanged(object sender, EventArgs e)
        {
            if (tOverlay.Text.Trim() == "Google Hybrid")
                iS.Checked = true;
            else if (tOverlay.Text.Trim() == "Ask Hybrid")
            {
                if (MapType() != "iASKs" && MapType() != "iASKp")
                    iASKs.Checked = true;
            }
            else if (tOverlay.Text.Trim() == "Yahoo Hybrid")
                iYs.Checked = true;
        }

        private void MoreSourcesTabs_SelectedIndexChanged(object sender, EventArgs e)
        {
            foreach (Control cont in SelectedMap.Controls)
            {
                if (cont.Tag != null)
                {
                    if (cont.Tag.ToString() == MoreSourcesTabs.SelectedTab.Text)
                    {
                        cont.Visible = true;
                        cont.Left = 8;
                    }
                    else
                    {
                        foreach (TabPage tp in MoreSourcesTabs.TabPages)
                        {
                            if (cont.Tag.ToString() == tp.Text)
                            {
                                cont.Visible = false;
                            }
                        }
                    }
                }
            }
        }

        string png_sample = "http://dev.openstreetmap.org/~ojw/Tiles/tile.php/$17-z$/$x$/$y$.png";
        string jpg_sample = "http://h0.ortho.tiles.virtualearth.net/tiles/h$0123$.jpeg?g=25";

        private void iCUSTOMpng_CheckedChanged(object sender, EventArgs e)
        {
            CUSTOMpanel.Visible = false;

            if (iCUSTOMpng.Checked)
            {
                CUSTOMpanel.Visible = true;
                if (CUSTOMurl.Text == "" || CUSTOMurl.Text == jpg_sample)
                {
                    CUSTOMurl.Text = png_sample;
                }
            }
        }

        private void iCUSTOMjpg_CheckedChanged(object sender, EventArgs e)
        {
            CUSTOMpanel.Visible = false;

            if (iCUSTOMjpg.Checked)
            {
                CUSTOMpanel.Visible = true;
                if (CUSTOMurl.Text == "" || CUSTOMurl.Text == png_sample)
                {
                    CUSTOMurl.Text = jpg_sample;
                }
            }
        }

        private void Cx_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            CUSTOMurl.SelectedText = "$x$";
        }

        private void Cy_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            CUSTOMurl.SelectedText = "$y$";
        }

        private void Cz_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            CUSTOMurl.SelectedText = "$z$";
        }

        private void C17z_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            CUSTOMurl.SelectedText = "$17-z$";
        }

        private void Cqrts_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            CUSTOMurl.SelectedText = "$qrts$";
        }

        private void C0123_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            CUSTOMurl.SelectedText = "$0123$";
        }

        private void GoogleEarthOverlay_Click(object sender, EventArgs e)
        {
            if (Mzoom.Text == "" || Mx.Text == "" || My.Text == "")
            {
                bGN_Click(Type.Missing, EventArgs.Empty);
            }
            else if (MessageBox.Show("Get location from map (click No if you want to use the numbers entered in Advanced)?", "", MessageBoxButtons.YesNo) == DialogResult.Yes)
            {
                bGN_Click(Type.Missing, EventArgs.Empty);
            }

            if (map_name.Text == "")
            {
                MessageBox.Show("No name");
            }
            else
            {
                if (new FileInfo(map_name.Text + ".kml").Exists)
                {
                    MessageBox.Show("Already exists");
                }
                else
                {
                    StreamWriter sw = new StreamWriter(map_name.Text + ".kml");

                    LatLonXYcalcs LLXY = new LatLonXYcalcs();

                    sw.WriteLine("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    sw.WriteLine("<kml xmlns=\"http://earth.google.com/kml/2.1\">");
                    sw.WriteLine("<Folder>");
                    sw.WriteLine("<name>" + map_name.Text + "</name>");
                    sw.WriteLine("<description>remote tile overlay</description>");

                    int last_z = -99;

                    string map_type = MapType();

                    int zoom_multiple = 1;
                    for (int i = Int32.Parse(Mzoom.Text); i > Int32.Parse(Minzoom.Text); i--)
                    {
                        zoom_multiple *= 2;
                    }

                    int span = 2;

                    int the_zoom = Int32.Parse(Mzoom.Text);
                    int dir_multiple = 1;
                    for (int dir_zoom = zoom_multiple; dir_zoom >= 1; dir_zoom /= 2, the_zoom--, dir_multiple *= 2)
                    {
                        if (GoogleEarthOverlayOne.Checked == false || dir_zoom == 1)
                        {
                            int Zx = Int32.Parse(Mx.Text) * dir_multiple;
                            int Zy = Int32.Parse(My.Text) * dir_multiple;

                            for (int dir_row = 0; dir_row < span * dir_multiple; dir_row++)
                            {
                                for (int fil_col = 0; fil_col < span * dir_multiple; fil_col++)
                                {
                                    string url = mu.MapByType(the_zoom, Zx + fil_col, Zy + dir_row, map_type);
                                    url = url.Replace("&", "&amp;");

                                    if (url.IndexOf("mt.google.com") == -1 && (url.IndexOf("x=") != -1 || url.IndexOf("y=") != -1))
                                    {
                                        url = url.Replace("http://", "http://mt.google.com@");
                                    }

                                    decimal[] Tcoord = LLXY.getLatLong(Zx + fil_col, Zy + dir_row, the_zoom); // top left
                                    decimal north = Tcoord[1];
                                    decimal west = Tcoord[0];
                                    decimal[] Bcoord = LLXY.getLatLong(Zx + fil_col + 1, Zy + dir_row + 1, the_zoom); // bottom right
                                    decimal south = Bcoord[1];
                                    decimal east = Bcoord[0];

                                    if (last_z != the_zoom)
                                    {
                                        if (last_z != -99)
                                        {
                                            sw.WriteLine("</Folder>");
                                        }

                                        last_z = the_zoom;

                                        sw.WriteLine("<Folder>");
                                        sw.WriteLine("<name>zoom = " + the_zoom.ToString() + "</name>");
                                        //sw.WriteLine("<description></description>");
                                    }

                                    sw.WriteLine("<GroundOverlay>");
                                    sw.WriteLine("<name>x = " + (Zx + fil_col).ToString() + ", y = " + (Zy + dir_row).ToString() + "</name>");
                                    sw.WriteLine("<description>" + url + "</description>");
                                    sw.WriteLine("<Icon>");
                                    sw.WriteLine("<href>" + url + "</href>");
                                    sw.WriteLine("</Icon>");
                                    sw.WriteLine("<LatLonBox>");
                                    sw.WriteLine("<north>" + north.ToString() + "</north>");
                                    sw.WriteLine("<south>" + south.ToString() + "</south>");
                                    sw.WriteLine("<east>" + east.ToString() + "</east>");
                                    sw.WriteLine("<west>" + west.ToString() + "</west>");
                                    sw.WriteLine("<rotation>0</rotation>");
                                    sw.WriteLine("</LatLonBox>");
                                    sw.WriteLine("</GroundOverlay>");
                                }
                            }
                        }
                    }

                    sw.WriteLine("</Folder>");
                    sw.WriteLine("</Folder>");
                    sw.WriteLine("</kml>");
                    sw.Close();

                    MessageBox.Show("Done: " + map_name.Text + ".kml");
                }
            }
        }

        private void GoogleEarthSuperOverlay_Click(object sender, EventArgs e)
        {
            if (Mzoom.Text == "" || Mx.Text == "" || My.Text == "")
            {
                bGN_Click(Type.Missing, EventArgs.Empty);
            }
            else if (MessageBox.Show("Get location from map (click No if you want to use the numbers entered in Advanced)?", "", MessageBoxButtons.YesNo) == DialogResult.Yes)
            {
                bGN_Click(Type.Missing, EventArgs.Empty);
            }

            if (map_name.Text == "")
            {
                MessageBox.Show("No name");
            }
            else
            {
                if (new DirectoryInfo(map_name.Text).Exists)
                {
                    MessageBox.Show("Already exists");
                }
                else
                {
                    new GEsuperOverlay(map_name.Text, Int32.Parse(Mx.Text), Int32.Parse(My.Text), Int32.Parse(Mzoom.Text), Int32.Parse(Minzoom.Text), MapType(), false, wc, Int32.Parse(GEscaleLow.Text), Int32.Parse(GEscaleHigh.Text), "");

                    MessageBox.Show("Done: " + map_name.Text + "/overlay.kml");
                }
            }
        }

        private void SiteDirGoogleEarthSuperOverlay_Click(object sender, EventArgs e)
        {
            if (SetSI.Text == "Set")
            {
                SetSI_Click(Type.Missing, EventArgs.Empty);
            }

            if (SetSI.Text != "Set")
            {
                FilesDone.Text = "Wait . . .";
                Application.DoEvents();

                string map_dir = SetSI.Text.Substring(3, SetSI.Text.Length - 3);
                map_dir = map_dir.Substring(0, map_dir.Length - 6);
                string ext = SetSI.Text.Substring(0, 3);

                string map_type = "iGESO" + ext + map_dir;

                new GEsuperOverlay(map_dir, Int32.Parse(Mx.Text), Int32.Parse(My.Text), Int32.Parse(Mzoom.Text), Int32.Parse(Minzoom.Text), map_type, true, wc, Int32.Parse(GEscaleLow.Text), Int32.Parse(GEscaleHigh.Text), GEsoPrePath.Text);

                FilesDone.Text = "";

                MessageBox.Show("Done: " + map_dir + "/overlay.kml");
            }
        }

        private void Zoom1xTip_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            MessageBox.Show("1. Click Advanced\n\n2. Set min zoom to a higher value (1 will disable 1x, 2 will disable 1x and 2x, etc.)\n\n3. Proceed as before\n\n\n(if you have a better idea of how to implement this - let me know)");
        }

        private void GPSFS_util_BTN_Click(object sender, EventArgs e)
        {
            if (new FileInfo(GPSFS_util_exe).Exists)
            {
                Process proc = new Process();
                proc.StartInfo.FileName = GPSFS_util_exe;
                if (map_name.Text != "")
                {
                    DirectoryInfo map_dir_nfo = new DirectoryInfo(map_name.Text);
                    if (map_dir_nfo.Exists)
                    {
                        string full_map_path = map_dir_nfo.FullName;
                        proc.StartInfo.Arguments = full_map_path;
                    }
                }
                proc.Start();
            }
            else
            {
                MessageBox.Show("GPSFS_util not found, it should be here: " + GPSFS_util_exe);
            }
        }

        

        

        



        

        



        // msn route?
        // http://www.elsewhere.org/GMapToGPX/gmaptogpx.js --- has elevation for points (USE!!!)
        // http://badsegue.org/samples/msngpxripdiv.js --- any route ideas?
        // http://badsegue.org/samples/googgpxripdiv.js

        // http://www.viavirtualearth.com/VVE/Articles/Directions.ashx
        // One thing that is missing is the ability to plot the path of the route along the roads.
        // This is more complicated than simply drawing lines between the points as roads are generally not that straight.
        // If you require functionality such as plotting the lines you can either delve deeper into the local.live.com directions code or
        // (and I would recommend this) explore a product such as
        // MapPoint Web Service (http://msdn.microsoft.com/MapPoint) that provides this functionality.

        /* To Do:
         * 
         * calc yahoo mile radius
         * 
         * msn birds eye view (all 4 dir's?)
         * 
         * if max'd auto scroll to top left
         *
         * */
    }
}