using System;
using System.Collections.Generic;
using System.Text;

using System.IO;

using System.Net;

namespace GMDL
{
    class GEsuperOverlay
    {
        LatLonXYcalcs LLXY;
        mapURL mu;

        // for GPSFS
        public GEsuperOverlay()
        {
            WebClient wc = new WebClient();
            mu = new mapURL(wc);
            LLXY = new LatLonXYcalcs();
        }

        public void CreateOverlayXMLforSO(string dir_name, int x, int y, int z, string map_type, bool check_xml_below, string pre_path)
        {
            // create overlay.kml (at this stage pointing at unexistant files)
            StreamWriter sw = new StreamWriter(dir_name + "\\overlay.kml");
            sw.WriteLine("<kml>");
            sw.WriteLine("<Document>");

            Region(x, y, z, sw, 2, true);

            bool e_xy = true;
            bool e_x1y = true;
            bool e_xy1 = true;
            bool e_x1y1 = true;

            if (check_xml_below)
            {
                e_xy = CheckXMLexists(dir_name, x, y, z);
                e_x1y = CheckXMLexists(dir_name, x + 1, y, z);
                e_xy1 = CheckXMLexists(dir_name, x, y + 1, z);
                e_x1y1 = CheckXMLexists(dir_name, x + 1, y + 1, z);
            }

            if (e_xy)
                NetworkLink(x, y, z, sw, false, pre_path);
            if (e_x1y)
                NetworkLink(x + 1, y, z, sw, false, pre_path);
            if (e_xy1)
                NetworkLink(x, y + 1, z, sw, false, pre_path);
            if (e_x1y1)
                NetworkLink(x + 1, y + 1, z, sw, false, pre_path);

            // need an image?

            sw.WriteLine("</Document>");
            sw.WriteLine("</kml>");
            sw.Close();
        }

        // pass the dir above tiles
        // if overwriting - extract top level first (unlike tiles)
        // assumes more than one level
        public GEsuperOverlay(string dir_name, int x, int y, int z_top, int z_bottom, string map_type, bool check_tiles, WebClient wc, int ScaleLow, int ScaleHigh, string pre_path)
        {
            scale_low = ScaleLow;
            scale_high = ScaleHigh;

            DirectoryInfo main_dir = new DirectoryInfo(dir_name);
            if (main_dir.Exists == false)
            {
                main_dir.Create();
            }

            mu = new mapURL(wc);
            LLXY = new LatLonXYcalcs();
            
            CreateOverlayXMLforSO(dir_name, x, y, z_top, map_type, false, pre_path);

            create_tile(dir_name, x, y, z_top, z_bottom, map_type, check_tiles, true, false, pre_path);
            create_tile(dir_name, x + 1, y, z_top, z_bottom, map_type, check_tiles, true, false, pre_path);
            create_tile(dir_name, x, y + 1, z_top, z_bottom, map_type, check_tiles, true, false, pre_path);
            create_tile(dir_name, x + 1, y + 1, z_top, z_bottom, map_type, check_tiles, true, false, pre_path);
        }

        private void Region(int x, int y, int z, StreamWriter sw, int span, bool always_visible)
        {
            decimal[] Tcoord = LLXY.getLatLong(x, y, z); // top left
            decimal north = Tcoord[1];
            decimal west = Tcoord[0];
            decimal[] Bcoord = LLXY.getLatLong(x + span, y + span, z); // bottom right
            decimal south = Bcoord[1];
            decimal east = Bcoord[0];

            int minLodPixels = scale_low * span;
            int maxLodPixels = scale_high * span;
            if (scale_high == -1)
                maxLodPixels = -1;
            if (always_visible)
            {
                minLodPixels = 0;
                maxLodPixels = -1;
            }

            sw.WriteLine("<Region>");
            sw.WriteLine("<LatLonAltBox>");
            sw.WriteLine("<north>" + north.ToString() + "</north><south>" + south.ToString() + "</south>");
            sw.WriteLine("<east>" + east.ToString() + "</east><west>" + west.ToString() + "</west>");
            sw.WriteLine("<minAltitude>0.000000</minAltitude><maxAltitude>0.000000</maxAltitude>");
            sw.WriteLine("</LatLonAltBox>");
            sw.WriteLine("<Lod>");
            sw.WriteLine("<minLodPixels>" + minLodPixels.ToString() + "</minLodPixels><maxLodPixels>" + maxLodPixels.ToString() + "</maxLodPixels>");
            sw.WriteLine("<minFadeExtent>0</minFadeExtent><maxFadeExtent>0</maxFadeExtent>");
            sw.WriteLine("</Lod>");
            sw.WriteLine("</Region>");
        }

        int scale_low = 225; // 128;
        int scale_high = -1; // 512;

        private void NetworkLink(int x, int y, int z, StreamWriter sw, bool relative, string pre_path)
        {
            string Kxy = mu.CoordsToKeyhole(x, y, z);

            string xy = "";
            if (pre_path != "")
            {
                xy = pre_path + ToPath(Kxy).Replace("\\", "/") + ".kml";
            }
            else if (relative)
            {
                xy = ToRelPath(Kxy) + ".kml";
            }
            else
            {
                xy = ToPath(Kxy) + ".kml";
            }

            decimal[] Tcoord = LLXY.getLatLong(x, y, z); // top left
            decimal north = Tcoord[1];
            decimal west = Tcoord[0];
            decimal[] Bcoord = LLXY.getLatLong(x + 1, y + 1, z); // bottom right
            decimal south = Bcoord[1];
            decimal east = Bcoord[0];

            int minLodPixels = scale_low;
            int maxLodPixels = scale_high;
            if (relative == false) // top level
            {
                minLodPixels = 0;
                maxLodPixels = -1;
            }

            sw.WriteLine("<NetworkLink>");
            sw.WriteLine("<name>" + Kxy + "</name>");
            sw.WriteLine("<Region>");
            sw.WriteLine("<LatLonAltBox>");
            sw.WriteLine("<north>" + north.ToString() + "</north><south>" + south.ToString() + "</south>");
            sw.WriteLine("<east>" + east.ToString() + "</east><west>" + west.ToString() + "</west>");
            sw.WriteLine("<minAltitude>0.000000</minAltitude><maxAltitude>0.000000</maxAltitude>");
            sw.WriteLine("</LatLonAltBox>");
            sw.WriteLine("<Lod>");
            sw.WriteLine("<minLodPixels>" + minLodPixels.ToString() + "</minLodPixels><maxLodPixels>" + maxLodPixels.ToString() + "</maxLodPixels>");
            sw.WriteLine("<minFadeExtent>0</minFadeExtent><maxFadeExtent>0</maxFadeExtent>");
            sw.WriteLine("</Lod>");
            sw.WriteLine("</Region>");
            sw.WriteLine("<Link>");
            sw.WriteLine("<href>" + xy + "</href>");
            sw.WriteLine("<viewRefreshMode>onRegion</viewRefreshMode>");
            sw.WriteLine("</Link>");
            sw.WriteLine("</NetworkLink>");
        }

        private string ToPath(string name)
        {
            int i = 3;
            while (i < name.Length)
            {
                name = name.Substring(0, i) + "\\" + name.Substring(i, name.Length - i);
                i = i + 4;
            }
            return name;
        }

        private string ToRelPath(string name)
        {
            name = ToPath(name);
            if (name.LastIndexOf("\\") == name.Length - 2)
            {
                name = name.Substring(name.LastIndexOf("\\") - 3, name.Length + 3 - name.LastIndexOf("\\"));
            }
            else
            {
                name = name.Substring(name.LastIndexOf("\\") + 1, name.Length - 1 - name.LastIndexOf("\\"));
            }

            return name;
        }

        private void CreatePath(string name, string dir_name)
        {
            int i = 3;
            while (i < name.Length)
            {
                DirectoryInfo test = new DirectoryInfo(dir_name + "\\" + name.Substring(0, i));
                if (test.Exists == false)
                {
                    test.Create();
                }
                name = name.Substring(0, i) + "\\" + name.Substring(i, name.Length - i);
                i = i + 4;
            }
        }

        private bool CheckXMLexists(string dir_name, int x, int y, int z_top)
        {
            string Kxy = mu.CoordsToKeyhole(x, y, z_top);
            string xy = ToPath(Kxy) + ".kml";
            if (new FileInfo(dir_name + "\\" + xy).Exists)
                return true;
            else
                return false;
        }

        public void create_tile(string dir_name, int x, int y, int z_top, int z_bottom, string map_type, bool check_tiles, bool top_level, bool check_xml_below, string pre_url)
        {
            CreatePath(mu.CoordsToKeyhole(x, y, z_top), dir_name);

            string url = mu.MapByType(z_top, x, y, map_type);

            if (pre_url != "")
            {
                url = pre_url + url;
                url = url.Replace("../", "");
            }

            bool tile_exists = true;
            if (check_tiles)
            {
                string tile_path = url; // if tile dir - relative to kml ie ../../../tiles/ etc.
                if (tile_path.IndexOf("../") != -1)
                {
                    tile_path = tile_path.Substring(tile_path.LastIndexOf("../") + 3, tile_path.Length - 3 - tile_path.LastIndexOf("../"));
                }
                if (pre_url != "")
                {
                    tile_path = tile_path.Replace(pre_url, "");
                }
                tile_path = dir_name + "\\" + tile_path.Replace("/", "\\");

                if (new FileInfo(tile_path).Exists == false)
                {
                    tile_exists = false;
                }
            }

            string Kxy = mu.CoordsToKeyhole(x, y, z_top);
            string xy = ToPath(Kxy) + ".kml";
            StreamWriter sw = new StreamWriter(dir_name + "\\" + xy);
            sw.WriteLine("<kml>");
            sw.WriteLine("<Document>");

            Region(x, y, z_top, sw, 1, top_level);

            bool e_xy = true;
            bool e_x1y = true;
            bool e_xy1 = true;
            bool e_x1y1 = true;

            if (check_xml_below)
            {
                e_xy = CheckXMLexists(dir_name, x * 2, y * 2, z_top - 1);
                e_x1y = CheckXMLexists(dir_name, x * 2 + 1, y * 2, z_top - 1);
                e_xy1 = CheckXMLexists(dir_name, x * 2, y * 2 + 1, z_top - 1);
                e_x1y1 = CheckXMLexists(dir_name, x * 2 + 1, y * 2 + 1, z_top - 1);
            }

            if (z_top > z_bottom && tile_exists)
            {
                if (e_xy)
                    NetworkLink(x * 2, y * 2, z_top - 1, sw, true, pre_url);
                if (e_x1y)
                    NetworkLink(x * 2 + 1, y * 2, z_top - 1, sw, true, pre_url);
                if (e_xy1)
                    NetworkLink(x * 2, y * 2 + 1, z_top - 1, sw, true, pre_url);
                if (e_x1y1)
                    NetworkLink(x * 2 + 1, y * 2 + 1, z_top - 1, sw, true, pre_url);
            }

            if (tile_exists)
            {
                url = url.Replace("&", "&amp;");

                if (url.IndexOf("mt.google.com") == -1 && (url.IndexOf("x=") != -1 || url.IndexOf("y=") != -1))
                {
                    url = url.Replace("http://", "http://mt.google.com@");
                }

                decimal[] Tcoord = LLXY.getLatLong(x, y, z_top); // top left
                decimal north = Tcoord[1];
                decimal west = Tcoord[0];
                decimal[] Bcoord = LLXY.getLatLong(x + 1, y + 1, z_top); // bottom right
                decimal south = Bcoord[1];
                decimal east = Bcoord[0];

                sw.WriteLine("<GroundOverlay>");
                sw.WriteLine("<drawOrder>" + (27 - z_top).ToString() + "</drawOrder>");
                sw.WriteLine("<Icon>");
                sw.WriteLine("<href>" + url + "</href>");
                sw.WriteLine("</Icon>");
                sw.WriteLine("<LatLonBox>");
                sw.WriteLine("<north>" + north.ToString() + "</north><south>" + south.ToString() + "</south>");
                sw.WriteLine("<east>" + east.ToString() + "</east><west>" + west.ToString() + "</west>");
                sw.WriteLine("</LatLonBox>");
                sw.WriteLine("</GroundOverlay>");
            }
            else
            {
                // proper kml termination - see doc
            }

            sw.WriteLine("</Document>");
            sw.WriteLine("</kml>");
            sw.Close();

            if (z_top > z_bottom && tile_exists)
            {
                if (e_xy)
                    create_tile(dir_name, x * 2, y * 2, z_top - 1, z_bottom, map_type, check_tiles, false, check_xml_below, pre_url);
                if (e_x1y)
                    create_tile(dir_name, x * 2 + 1, y * 2, z_top - 1, z_bottom, map_type, check_tiles, false, check_xml_below, pre_url);
                if (e_xy1)
                    create_tile(dir_name, x * 2, y * 2 + 1, z_top - 1, z_bottom, map_type, check_tiles, false, check_xml_below, pre_url);
                if (e_x1y1)
                    create_tile(dir_name, x * 2 + 1, y * 2 + 1, z_top - 1, z_bottom, map_type, check_tiles, false, check_xml_below, pre_url);
            }
        }
    }
}
