using System;
using System.Collections.Generic;
using System.Text;

using System.Net;
using System.Drawing;
using System.IO;

namespace GMDL
{
    public class mapURL
    {
        private Random random = new Random();
        private WebClient wc;

        public mapURL(WebClient WC)
        {
            wc = WC;
        }

        public bool CheckGoogleSatOK()
        {
            int zoom = random.Next(12, 17);
            try
            {
                Bitmap test = new Bitmap(new MemoryStream(wc.DownloadData(GoogleSatellite(zoom, random.Next(0, (int)Math.Pow(2, 17 - zoom) - 1), random.Next(0, (int)Math.Pow(2, 17 - zoom) - 1)))));
                test.Dispose();
            }
            catch
            {
                try
                {
                    Bitmap test = new Bitmap(new MemoryStream(wc.DownloadData(GoogleSatellite(zoom, random.Next(0, (int)Math.Pow(2, 17 - zoom) - 1), random.Next(0, (int)Math.Pow(2, 17 - zoom) - 1)))));
                    test.Dispose();
                }
                catch
                {
                    try
                    {
                        Bitmap test = new Bitmap(new MemoryStream(wc.DownloadData(GoogleSatellite(zoom, random.Next(0, (int)Math.Pow(2, 17 - zoom) - 1), random.Next(0, (int)Math.Pow(2, 17 - zoom) - 1)))));
                        test.Dispose();
                    }
                    catch
                    {
                        return false;
                    }
                }
            }

            return true;
        }

        public string MapByType(int zoom, int x, int y, string map_type)
        {
            if (map_type == "iM")
                return GoogleMap(zoom, x, y);
            if (map_type == "iS")
                return GoogleSatellite(zoom, x, y);

            if (map_type == "iMabc")
                return MapABC(zoom, x, y);

            if (map_type == "iMSNm")
                return MSNMap(zoom, x, y);
            if (map_type == "iMSNh")
                return MSNHybrid(zoom, x, y);
            if (map_type == "iMSNs")
                return MSNSatellite(zoom, x, y);

            if (map_type == "iASKm")
                return AskMap(zoom, x, y);
            if (map_type == "iASKp")
                return AskPhysical(zoom, x, y);
            if (map_type == "iASKs")
                return AskSatellite(zoom, x, y);

            if (map_type == "iYs")
                return YahooSatellite(zoom, x, y);
            if (map_type == "iYm")
                return YahooMap(zoom, x, y);

            if (map_type == "iBAIDUm")
                return BaiduMap(zoom, x, y);

            if (map_type == "iMAP2GOm")
                return Map2goMap(zoom, x, y);

            if (map_type == "iMoon")
                return GoogleMoon(zoom, x, y);
            if (map_type == "iMarsE")
                return GoogleMarsElevation(zoom, x, y);
            if (map_type == "iMarsV")
                return GoogleMarsVisible(zoom, x, y);
            if (map_type == "iMarsI")
                return GoogleMarsInfraRed(zoom, x, y);

            if (map_type == "iOSM")
                return OpenStreetMap(zoom, x, y);
            if (map_type == "iOSMdev")
                return OpenStreetMapDev(zoom, x, y);

            if (map_type == "itCM")
                return ThaiChangMai(zoom, x, y);
            if (map_type == "itP")
                return ThaiPhuket(zoom, x, y);
            if (map_type == "itB")
                return ThaiBangkok(zoom, x, y);

            if (map_type.StartsWith("iR"))
                return Rambler(zoom, x, y, map_type.Substring(2, map_type.Length - 2));

            if (map_type == "iMetroNY")
                return MetroNY(zoom, x, y);

            if (map_type == "iMETROdc")
                return MetroDC(zoom, x, y);
            if (map_type == "iMETROboston")
                return MetroBoston(zoom, x, y);
            if (map_type == "iMETROphilly")
                return MetroPhilly(zoom, x, y);
            if (map_type == "iMETROchicago")
                return MetroChicago(zoom, x, y);

            if (map_type == "iUBsu")
                return MetroBerlinSU(zoom, x, y);
            if (map_type == "iUBstr")
                return MetroBerlinStr(zoom, x, y);

            if (map_type == "iUSGStopo")
                return USGS(zoom, x, y, "DRG");
            if (map_type == "iUSGSortho")
                return USGS(zoom, x, y, "DOQ");
            if (map_type == "iUSGSuortho")
                return USGS(zoom, x, y, "UrbanArea");

            if (map_type == "iFMnpe")
                return FreemapNPE(zoom, x, y);
            if (map_type == "iFMnpeGPS")
                return FreemapNPEgps(zoom, x, y);

            if (map_type == "iSubNY")
                return GypsyMapsNY(zoom, x, y, "subway");
            if (map_type == "iSubNYbus")
                return GypsyMapsNY(zoom, x, y, "bus");

            if (map_type.StartsWith("iMC"))
                return MapCruncher(zoom, x, y, map_type.Substring(6, map_type.Length - 6));
            if (map_type.StartsWith("iSI"))
                return Site(zoom, x, y, map_type.Substring(6, map_type.Length - 6), map_type.Substring(3, 3));

            if (map_type == "iIRtopo")
                return RussianTopo(zoom, x, y);

            if (map_type == "iToporama")
                return Toporama(zoom, x, y);

            if (map_type.StartsWith("iNASA"))
                return NASA(zoom, x, y, map_type.Substring(5, map_type.Length - 5));

            if (map_type.StartsWith("iWMS"))
                return WMS(zoom, x, y, map_type);

            if (map_type == "iShadedRelief")
                return ShadedRelief(zoom, x, y);

            if (map_type == "Google Hybrid")
                return GoogleTransparent(zoom, x, y);
            if (map_type == "Ask Hybrid")
                return AskTransparent(zoom, x, y);
            if (map_type == "Yahoo Hybrid")
                return YahooTransparent(zoom, x, y);

            //else
                return "about:null";
        }

        public string ExtByType(string map_type)
        {
            if (map_type == "iM")
                return ".png";
            if (map_type == "iS")
                return ".jpg";

            if (map_type == "iMabc")
                return ".png";

            if (map_type == "iMSNm")
                return ".png";
            if (map_type == "iMSNh")
                return ".jpg";
            if (map_type == "iMSNs")
                return ".jpg";

            if (map_type == "iASKm")
                return ".png";
            if (map_type == "iASKp")
                return ".jpg";
            if (map_type == "iASKs")
                return ".jpg";

            if (map_type == "iYs")
                return ".jpg";
            if (map_type == "iYm")
                return ".png";

            if (map_type == "iBAIDUm")
                return ".png";

            if (map_type == "iMAP2GOm")
                return ".png";

            if (map_type == "iMoon")
                return ".jpg";
            if (map_type == "iMarsE")
                return ".jpg";
            if (map_type == "iMarsV")
                return ".jpg";
            if (map_type == "iMarsI")
                return ".jpg";

            if (map_type == "iOSM")
                return ".png";
            if (map_type == "iOSMdev")
                return ".png";

            if (map_type == "itCM")
                return ".jpg";
            if (map_type == "itP")
                return ".jpg";
            if (map_type == "itB")
                return ".png";

            if (map_type.StartsWith("iR"))
                return ".png";

            if (map_type == "iMetroNY")
                return ".png";

            // gif
            if (map_type.StartsWith("iMETRO"))
                return ".png";
            //gif
            if (map_type.StartsWith("iUB"))
                return ".png";

            if (map_type.StartsWith("iUSGS"))
                return ".jpg";

            if (map_type.StartsWith("iFM"))
                return ".png";

            if (map_type.StartsWith("iSubNY"))
                return ".png";

            if (map_type.StartsWith("iMC"))
                return "." + map_type.Substring(3, 3);
            if (map_type.StartsWith("iSI"))
                return "." + map_type.Substring(3, 3);

            if (map_type == "iIRtopo")
                return ".jpg";

            if (map_type == "iToporama")
                return ".png";

            if (map_type.StartsWith("iNASA"))
                return ".jpg";

            if (map_type.StartsWith("iWMS$$$png"))
                return ".png";
            if (map_type.StartsWith("iWMS$$$jpeg"))
                return ".jpg";

            if (map_type == "iShadedRelief")
                return ".jpg";

            //else
                return ".err";
        }

        private string RandomGoogle()
        {
            int ran = random.Next(-1, 3);
            return ran.ToString().Replace("-1", "");
        }

        private string RandomMSN()
        {
            int ran = random.Next(0, 3);
            return ran.ToString();
        }

        private string RandomAsk()
        {
            int ran = random.Next(1, 4);
            return ran.ToString();
        }

        public string iMversion;
        public string iTversion;
        public string iSversion;
        public string iMabcversion;

        public string GoogleMap(int zoom, int x, int y)
        {
            return "http://mt" + RandomGoogle() + ".google.com/mt?n=404&v=" + iMversion + "&x=" + x.ToString() + "&y=" + y.ToString() + "&zoom=" + zoom.ToString();
        }

        public string GoogleTransparent(int zoom, int x, int y)
        {
            return "http://mt" + RandomGoogle() + ".google.com/mt?n=404&v=" + iTversion + "&x=" + x.ToString() + "&y=" + y.ToString() + "&zoom=" + zoom.ToString();
        }

        public string GoogleSatellite(int zoom, int x, int y)
        {
            return "http://kh" + RandomGoogle() + ".google.com/kh?n=404&v=" + iSversion + "&t=" + CoordsToKeyhole(x, y, zoom);
        }

        
        public string GoogleMoon(int zoom, int x, int y)
        {
            return "http://moon.google.com/kh?v=2&t=" + CoordsToKeyhole(x, y, zoom);
        }
        public string GoogleMarsElevation(int zoom, int x, int y)
        {
            return "http://kh.google.com/movl?ov=52&t=" + CoordsToKeyhole(x, y, zoom);
        }
        public string GoogleMarsVisible(int zoom, int x, int y)
        {
            return "http://kh.google.com/movl?ov=50&t=" + CoordsToKeyhole(x, y, zoom);
        }
        public string GoogleMarsInfraRed(int zoom, int x, int y)
        {
            return "http://kh.google.com/movl?ov=51&t=" + CoordsToKeyhole(x, y, zoom);
        }
        

        public string MSNMap(int zoom, int x, int y)
        {
            string msn_loc = CoordsToMSN(x, y, zoom);
            return "http://r" + RandomMSN() + ".ortho.tiles.virtualearth.net/tiles/r" + msn_loc + ".png?g=25";
        }

        public string MSNHybrid(int zoom, int x, int y)
        {
            string msn_loc = CoordsToMSN(x, y, zoom);
            return "http://h" + RandomMSN() + ".ortho.tiles.virtualearth.net/tiles/h" + msn_loc + ".jpeg?g=25";
        }

        public string MSNSatellite(int zoom, int x, int y)
        {
            string msn_loc = CoordsToMSN(x, y, zoom);
            return "http://a" + RandomMSN() + ".ortho.tiles.virtualearth.net/tiles/a" + msn_loc + ".jpeg?g=25";
        }


        private string CoordsToMSN(int x, int y, int zoom)
        {
            string to_return = CoordsToKeyhole(x, y, zoom);

            to_return = to_return.Substring(1, to_return.Length - 1);

            to_return = to_return.Replace("q", "0").Replace("r", "1").Replace("t", "2").Replace("s", "3");

            return to_return;
        }

        #region borrowed code
        private string CoordsToKeyhole(int x, int y, int zoom)
        {
            String s = "";
            double myX = x;
            double myY = y;

            for (int i = 17; i > zoom; i--)
            {
                double rx = (fmod(myX, 2));
                myX = Math.Floor(myX / 2);
                double ry = (fmod(myY, 2));
                myY = Math.Floor(myY / 2);
                s = getKeyholeDirection(rx, ry) + s;
            }
            return 't' + s;
        }

        private double fmod(double myX, int i)
        {
            return myX % i;
        }

        public String getKeyholeDirection(double x, double y)
        {
            if (x == 1)
            {
                if (y == 1)
                {
                    return "s";
                }
                else if (y == 0)
                {
                    return "r";
                }
            }
            else if (x == 0)
            {
                if (y == 1)
                {
                    return "t";
                }
                else if (y == 0)
                {
                    return "q";
                }
            }

            return "";
        }
        #endregion

        public string AskMap(int zoom, int x, int y)
        {
            int mt = System.Convert.ToInt32(Math.Pow(2, 17 - zoom)); // (mt is the max number of tiles at this level - 16 for google's zoom level 13, 8 for 14, and so on) 
            int Az = zoom + 2;
            int Ax = x - mt / 2;
            int Ay = y - mt / 2;
            return "http://mapstatic" + RandomAsk() + ".ask.com/map/" + Az.ToString() + "/" + Ax.ToString() + "/" + Ay.ToString();
        }

        public string AskPhysical(int zoom, int x, int y)
        {
            int mt = System.Convert.ToInt32(Math.Pow(2, 17 - zoom)); // (mt is the max number of tiles at this level - 16 for google's zoom level 13, 8 for 14, and so on) 
            int Az = zoom + 2;
            int Ax = x - mt / 2;
            int Ay = y - mt / 2;
            return "http://mapstatic" + RandomAsk() + ".ask.com/phy/" + Az.ToString() + "/" + Ax.ToString() + "/" + Ay.ToString();
        }

        public string AskTransparent(int zoom, int x, int y)
        {
            int mt = System.Convert.ToInt32(Math.Pow(2, 17 - zoom)); // (mt is the max number of tiles at this level - 16 for google's zoom level 13, 8 for 14, and so on) 
            int Az = zoom + 2;
            int Ax = x - mt / 2;
            int Ay = y - mt / 2;
            return "http://mapstatic" + RandomAsk() + ".ask.com/mapt/" + Az.ToString() + "/" + Ax.ToString() + "/" + Ay.ToString();
        }

        public string AskSatellite(int zoom, int x, int y)
        {
            int mt = System.Convert.ToInt32(Math.Pow(2, 17 - zoom)); // (mt is the max number of tiles at this level - 16 for google's zoom level 13, 8 for 14, and so on) 
            int Az = zoom + 2;
            int Ax = x - mt / 2;
            int Ay = y - mt / 2;
            return "http://mapstatic" + RandomAsk() + ".ask.com/sat/" + Az.ToString() + "/" + Ax.ToString() + "/" + Ay.ToString();
        }

        public string YahooSatellite(int zoom, int x, int y)
        {
            // http://us.maps3.yimg.com/aerial.maps.yimg.com/tile?v=1.6&t=a&x=13&y=3&z=14 // doesn't work wo v,a
            int Yz = zoom + 1;
            int Yx = x;
            int Yy = System.Convert.ToInt32(Math.Pow(2, 16 - zoom)) - y - 1;
            // ALSO NOTE IN 2nd TRY
            return "http://us.maps3.yimg.com/aerial.maps.yimg.com/img?&v=1.5&t=a&x=" + Yx.ToString() + "&y=" + Yy.ToString() + "&z=" + Yz.ToString();
        }

        public string YahooMap(int zoom, int x, int y)
        {
            // http://maps.yimg.com/tile.in.maps.yahoo.com/tile?v=0.9&x=10&y=0&z=14 // works wo v - latest?
            int Yz = zoom + 1;
            int Yx = x;
            int Yy = System.Convert.ToInt32(Math.Pow(2, 16 - zoom)) - y - 1;
            // ALSO NOTE IN 2nd TRY
            return "http://maps.yimg.com/tile.in.maps.yahoo.com/tile?x=" + Yx.ToString() + "&y=" + Yy.ToString() + "&z=" + Yz.ToString();
        }

        public string YahooTransparent(int zoom, int x, int y)
        {
            // http://maps.yimg.com/aerial.in.maps.yahoo.com/tile?v=0.9&x=10&y=0&z=14 // works wo v - latest?
            int Yz = zoom + 1;
            int Yx = x;
            int Yy = System.Convert.ToInt32(Math.Pow(2, 16 - zoom)) - y - 1;
            // ALSO NOTE IN 2nd TRY
            return "http://maps.yimg.com/aerial.in.maps.yahoo.com/tile?x=" + Yx.ToString() + "&y=" + Yy.ToString() + "&z=" + Yz.ToString();
        }

        public string BaiduMap(int zoom, int x, int y)
        {
            // going to use google zoom, and 'redirect' y
            int Tl = 14 - zoom; // 12 -> 2
            int Tx = x; // 15 -> -1 <= x is ok
            int Ty = System.Convert.ToInt32(Math.Pow(2, Tl + 2)) - y - 1; // 10 -> 6

            // chi80: it's a little different from zoom 9, the level_2 from 10*10 to 50*50.
            int multiplier = 10;
            if (Tl >= 9)
                multiplier = 50;

            int TxO = Tx / multiplier; // check 99, - 99, -91 <= doesn't matter for China
            int TyO = Ty / multiplier;

            Tx = Tx - TxO * multiplier;
            Ty = Ty - TyO * multiplier;
            
            /*if (Tl >= 9) // since 'scaled' to 100
            {
                Tx /= 2;
                Ty /= 2;
            }*/

            return "http://mappng.baidu.com/maplite/mapbank/baidu/" + Tl.ToString().Replace("-1", "W") + "/" + TxO.ToString() + "_" + TyO.ToString() + "/" + Tx.ToString() + "_" + Ty.ToString() + ".png";

        }

        public string Map2goMap(int zoom, int x, int y)
        {
            // http://pic1.go2map.com/seamless/0/174/724/0/0/5_0.GIF

            int Ty = System.Convert.ToInt32(Math.Pow(2, 16 - zoom)) - y - 1;
            int Tz = 711 + zoom;

            int Sx = x / 200;
            int Sy = Ty / 200;

            if (x < 0)
                Sx--;
            if (Ty < 0)
                Sy--;

            return "http://pic1.go2map.com/seamless/0/174/" + Tz.ToString() + "/" + Sx.ToString().Replace("-", "M") + "/" + Sy.ToString().Replace("-", "M") + "/" + x.ToString().Replace("-", "M") + "_" + Ty.ToString().Replace("-", "M") + ".GIF";
        }

        public string OpenStreetMap(int zoom, int x, int y)
        {
            return "http://tile.openstreetmap.org/" + (17 - zoom).ToString() + "/" + x.ToString() + "/" + y.ToString() + ".png";
        }

        public string OpenStreetMapDev(int zoom, int x, int y)
        {
            return "http://dev.openstreetmap.org/~ojw/Tiles/tile.php/" + (17 - zoom).ToString() + "/" + x.ToString() + "/" + y.ToString() + ".png";
        }

        public string ThaiChangMai(int zoom, int x, int y)
        {
            return "http://www.thaitcc.ws/CMD_MEDIA/Chiang%20Mai/0/" + zoom.ToString() + "/" + x.ToString() + "_" + y.ToString() + "_" + zoom.ToString() + ".jpg";
        }
        
        public string ThaiPhuket(int zoom, int x, int y)
        {
            return "http://www.thaitcc.ws/CMD_MEDIA/Phuket/0/" + zoom.ToString() + "/" + x.ToString() + "_" + y.ToString() + "_" + zoom.ToString() + ".jpg";
        }

        public string ThaiBangkok(int zoom, int x, int y)
        {
            return "http://www.moffle.com/img/" + x.ToString() + "_" + y.ToString() + "_" + (17 - zoom).ToString() + ".png";
        }

        public string MapABC(int zoom, int x, int y)
        {
            return "http://mapgoogle.mapabc.com/googlechina/maptile?v=" + iMabcversion + "&x=" + x.ToString() + "&y=" + y.ToString() + "&zoom=" + zoom.ToString();
        }

        public string Rambler(int zoom, int x, int y, string city)
        {
            int zoomS = System.Convert.ToInt32(Math.Pow(2, zoom));

            return "http://nakarte.rambler.ru/" + city + "/tiles/" + city + "_ru/" + zoomS.ToString("00000000") + "000/" + y.ToString("000000") + "/" + x.ToString("000000") + y.ToString("000000") + ".png";
        }

        public string MetroNY(int zoom, int x, int y)
        {
            return "http://www.onnyturf.com/subway/maps/subway/onnyturf_only.php?x=" + x.ToString() + "&y=" + y.ToString() + "&zoom=" + zoom.ToString();
        }

        public string MetroDC(int zoom, int x, int y)
        {
            return "http://metromapr.com/MapFiles2.aspx?x=" + x.ToString() + "&y=" + y.ToString() + "&zoom=" + zoom.ToString() + "&map=DCMetro";
        }

        public string MetroBoston(int zoom, int x, int y)
        {
            return "http://metromapr.com/MapFiles2.aspx?x=" + x.ToString() + "&y=" + y.ToString() + "&zoom=" + zoom.ToString() + "&map=BostonT";
        }

        public string MetroPhilly(int zoom, int x, int y)
        {
            return "http://metromapr.com/MapFiles2.aspx?x=" + x.ToString() + "&y=" + y.ToString() + "&zoom=" + zoom.ToString() + "&map=Philadelphia";
        }

        public string MetroChicago(int zoom, int x, int y)
        {
            return "http://metromapr.com/MapFiles2.aspx?x=" + x.ToString() + "&y=" + y.ToString() + "&zoom=" + zoom.ToString() + "&map=Chicago";
        }

        public string MetroBerlinSU(int zoom, int x, int y)
        {
            return "http://www.uberbahn.com/tiles/metro.php?x=" + x.ToString() + "&y=" + y.ToString() + "&zoom=" + zoom.ToString();
        }

        public string MetroBerlinStr(int zoom, int x, int y)
        {
            return "http://www.uberbahn.com/tiles/tram.php?x=" + x.ToString() + "&y=" + y.ToString() + "&zoom=" + zoom.ToString();
        }

        private LatLonXYcalcs LLXY = new LatLonXYcalcs();

        // http://www.terraserver-usa.com/ogcwms.aspx
        public string USGS(int zoom, int x, int y, string layer)
        {
            decimal[] Tcoord = LLXY.getLatLong(x, y, zoom); // top left
            decimal maxlat = Tcoord[1];
            decimal minlon = Tcoord[0];
            decimal[] Bcoord = LLXY.getLatLong(x + 1, y + 1, zoom); // bottom right
            decimal minlat = Bcoord[1];
            decimal maxlon = Bcoord[0];

            return "http://www.terraserver-usa.com/ogcmap6.ashx?&REQUEST=GetMap&SERVICE=WMS&reaspect=false&VERSION=1.1.1&LAYERS=" + layer + "&STYLES=default&FORMAT=image/jpeg&BGCOLOR=0xFFFFFF&TRANSPARENT=TRUE&SRS=EPSG:4326&BBOX="
                + minlon.ToString() + "," + minlat.ToString() + "," + maxlon.ToString() + "," + maxlat.ToString()
                + "&WIDTH=256&HEIGHT=256&GroupName=DRG";
        }

        public double latC; // used in lat/lon to NE, set to the center of the map
        public double lonC;

        //npe - png
        //http://nick.dev.openstreetmap.org/openpaths/freemap.php?LAYERS=npe&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&STYLES=&EXCEPTIONS=application/vnd.ogc.se_inimage&FORMAT=image/jpeg&SRS=EPSG:4326&BBOX=489472,126976,491520,129024&WIDTH=256&HEIGHT=256
        public string FreemapNPE(int zoom, int x, int y)
        {
            decimal[] Tcoord = LLXY.getLatLong(x, y, zoom); // top left
            double maxlat = System.Convert.ToDouble(Tcoord[1]);
            double minlon = System.Convert.ToDouble(Tcoord[0]);
            decimal[] Bcoord = LLXY.getLatLong(x + 1, y + 1, zoom); // bottom right
            double minlat = System.Convert.ToDouble(Bcoord[1]);
            double maxlon = System.Convert.ToDouble(Bcoord[0]);

            int[] max_en = LLXY.LLtoNEjs(maxlat, maxlon, latC, lonC);
            int max_east = max_en[0];
            int max_north = max_en[1];
            int[] min_en = LLXY.LLtoNEjs(minlat, minlon, latC, lonC);
            int min_east = min_en[0];
            int min_north = min_en[1];

            return "http://nick.dev.openstreetmap.org/openpaths/freemap.php?LAYERS=npe&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&STYLES=&EXCEPTIONS=application/vnd.ogc.se_inimage&FORMAT=image/jpeg&SRS=EPSG:4326&BBOX="
                + min_east.ToString() + "," + min_north.ToString() + "," + max_east.ToString() + "," + max_north.ToString()
                + "&WIDTH=256&HEIGHT=256";
        }

        public string FreemapNPEgps(int zoom, int x, int y)
        {
            decimal[] Tcoord = LLXY.getLatLong(x, y, zoom); // top left
            double maxlat = System.Convert.ToDouble(Tcoord[1]);
            double minlon = System.Convert.ToDouble(Tcoord[0]);
            decimal[] Bcoord = LLXY.getLatLong(x + 1, y + 1, zoom); // bottom right
            double minlat = System.Convert.ToDouble(Bcoord[1]);
            double maxlon = System.Convert.ToDouble(Bcoord[0]);

            int[] max_en = LLXY.LLtoNEjs(maxlat, maxlon, maxlat, maxlon);
            int max_east = max_en[0];
            int max_north = max_en[1];
            int[] min_en = LLXY.LLtoNEjs(minlat, minlon, minlat, minlon);
            int min_east = min_en[0];
            int min_north = min_en[1];

            return "http://nick.dev.openstreetmap.org/openpaths/freemap.php?LAYERS=npe&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&STYLES=&EXCEPTIONS=application/vnd.ogc.se_inimage&FORMAT=image/jpeg&SRS=EPSG:4326&BBOX="
                + min_east.ToString() + "," + min_north.ToString() + "," + max_east.ToString() + "," + max_north.ToString()
                + "&WIDTH=256&HEIGHT=256";
        }

        private string RandomGypsy()
        {
            int ran = random.Next(-1, 3);
            if (ran == -1)
                return "www";
            else
                return "ts" + ran.ToString();
        }

        public string GypsyMapsNY(int zoom, int x, int y, string type)
        {
            return "http://" + RandomGypsy() + ".gypsymaps.com/tiles/" + type + "/?x=" + x.ToString() + "&y=" + y.ToString() + "&zoom=" + zoom.ToString();
        }

        public string MapCruncher(int zoom, int x, int y, string map_dir)
        {
            string msn_loc = CoordsToMSN(x, y, zoom);
            return map_dir + "\\" + msn_loc + ".png";
        }

        public string Site(int zoom, int x, int y, string map_dir, string ext)
        {
            return map_dir + "\\" + (17 - zoom).ToString() + "\\" + x.ToString() + "\\" + y.ToString() + "." + ext;
        }

        public string RussianTopo(int zoom, int x, int y)
        {
            return "http://www.in7ane.com/topomaps/tiles/" + (17 - zoom).ToString() + "/" + x.ToString() + "/" + y.ToString() + ".jpg";
        }

        ToporamaProjJS ProjJS = new ToporamaProjJS("EPSG:42304");
        public int ToporamaBase = 17000;

        public string Toporama(int zoom, int x, int y)
        {
            decimal[] Tcoord = LLXY.getLatLong(x, y, zoom); // top left
            double maxlat = System.Convert.ToDouble(Tcoord[1]);
            double minlon = System.Convert.ToDouble(Tcoord[0]);
            decimal[] Bcoord = LLXY.getLatLong(x + 1, y + 1, zoom); // bottom right
            double minlat = System.Convert.ToDouble(Bcoord[1]);
            double maxlon = System.Convert.ToDouble(Bcoord[0]);

            int scale = ToporamaBase * System.Convert.ToInt32(Math.Pow(2, zoom - 3));

            double[] xy = ProjJS.ll2lcc((minlon + maxlon) / 2, (minlat + maxlat) / 2);
            double Tx = xy[0];
            double Ty = xy[1];

            string page = wc.DownloadString("http://atlas.nrcan.gc.ca/cgi-bin/mapserv?map=/home/atlas/mapdata/english/toporama.map&map_web_template=/home/atlas/mapdata/to_zope_new.html&scale=" + scale.ToString() + "&mapxy=" + Tx.ToString() + "%20" + Ty.ToString() + "&layers=other_features%20million_grid%20t50k_grid%20grid_50k_3%20roads%20hydrography%20boundary%20builtup%20vegetation%20populated_places%20railway%20power_network%20manmade_features%20designated_areas%20water_features%20water_saturated_soils%20relief%20contours%20toponymy%20contour%20nodata_ntdb_50k%3F%3F%3F%3Fqt%3FA%F7%3F%3F%3F%FF%3F%3F&mapsize=256%20256");
            // set min zoom
            // no 2nd try of tiles
            // msg about it

            int start = page.IndexOf("image");
            start = page.IndexOf("/", start) + 1;
            start = page.IndexOf("/", start);
            string img_url = "http://atlas.nrcan.gc.ca" + page.Substring(start, page.IndexOf(".", start) + 4 - start);
            return img_url;

            // query
            // http://atlas.nrcan.gc.ca/cgi-bin/mapserv?map=/home/atlas/mapdata/english/toporama.map&map_web_template=/home/atlas/mapdata/to_zope_new.html&scale=25000.000000&mapxy=1292628.0382975%20-198522.99600410002&layers=other_features%20million_grid%20t50k_grid%20grid_50k_3%20roads%20hydrography%20boundary%20builtup%20vegetation%20populated_places%20railway%20power_network%20manmade_features%20designated_areas%20water_features%20water_saturated_soils%20relief%20contours%20toponymy%20contour%20nodata_ntdb_50k%3F%3F%3F%3Fqt%3FA%F7%3F%3F%3F%FF%3F%3F&mapsize=256%20256
            // get
            // image	/tmp/ntdb_mspaserv461117361934816968.gif

            //return "http://atlas.nrcan.gc.ca";
        }

        // http://onearth.jpl.nasa.gov/WK/bmng/
        public string NASA(int zoom, int x, int y, string layer)
        {
            decimal[] Tcoord = LLXY.getLatLong(x, y, zoom); // top left
            decimal maxlat = Tcoord[1];
            decimal minlon = Tcoord[0];
            decimal[] Bcoord = LLXY.getLatLong(x + 1, y + 1, zoom); // bottom right
            decimal minlat = Bcoord[1];
            decimal maxlon = Bcoord[0];

            return "http://onearth.jpl.nasa.gov/wms.cgi?request=GetMap&layers=" + layer + "&srs=EPSG:4326&format=image/jpeg&styles=&BBOX="
                + minlon.ToString() + "," + minlat.ToString() + "," + maxlon.ToString() + "," + maxlat.ToString()
                + "&WIDTH=256&HEIGHT=256";
        }

        public string WMS(int zoom, int x, int y, string settings)
        {
            int start = settings.IndexOf("$$$") + 3;
            int end = settings.IndexOf("$$$", start);
            string format = settings.Substring(start, end - start);
            start = end + 3;
            end = settings.IndexOf("$$$", start);
            string server = settings.Substring(start, end - start);
            start = end + 3;
            end = settings.IndexOf("$$$", start);
            string version = settings.Substring(start, end - start);
            start = end + 3;
            end = settings.IndexOf("$$$", start);
            string layer = settings.Substring(start, end - start);

            decimal[] Tcoord = LLXY.getLatLong(x, y, zoom); // top left
            decimal maxlat = Tcoord[1];
            decimal minlon = Tcoord[0];
            decimal[] Bcoord = LLXY.getLatLong(x + 1, y + 1, zoom); // bottom right
            decimal minlat = Bcoord[1];
            decimal maxlon = Bcoord[0];

            return server + "?VERSION=" + version + "&request=GetMap&layers=" + layer + "&srs=EPSG:4326&format=image/" + format + "&styles=&BBOX="
                + minlon.ToString() + "," + minlat.ToString() + "," + maxlon.ToString() + "," + maxlat.ToString()
                + "&WIDTH=256&HEIGHT=256";
        }

        // http://www.shaded-relief.com/
        public string ShadedRelief(int zoom, int x, int y)
        {
            return "http://www.andalucia-direct.com/googletiles/demo/tile_" + x.ToString() + "_" + y.ToString() + "_" + zoom.ToString() + ".jpg";
        }

        // http://www.maps.data-spain.com/autonomous_communities/
        // http://www.maps.data-spain.com/zoomed/spain-shaded/TileGroup10/6-24-22.jpg

        // Old OS (PE not NPE)
        //http://tiles.snaffle.me.uk/08/tqs/rsr/srt/r.jpg

        // NASA
        /* 
         * Blue Marble Next Generation imagery
         * 
         * // START SAME south pole as 0 from dayline (diff 0,0) - 4 vert spans world at zoom 0
         * Blue Marble 200401 to 200412
         * http://worldwind25.arc.nasa.gov/tile/tile.aspx?T=bmng.topo.200409&L=4&X=44&Y=51
         * 
         * Blue Marble 200401 to 200412 (Bathymetry)
         * http://worldwind25.arc.nasa.gov/tile/tile.aspx?T=bmng.topo.bathy.200412&L=4&X=41&Y=52
         * // END SAME
         * 
         * // START SAME 'eq' as 0 from 'dayline' (diff 0,0) - 0 is quite zoomed in
         * Landsat 7 imagery
         * 
         * NLT Landsat (Visible & Pseudo Color)
         * 
         * NLT LandSat7 (Visible Color)
         * http://worldwind25.arc.nasa.gov/tile/tile.aspx?T=105&L=3&X=297&Y=442
         * 
         * NLT LandSat7 (Pseudo Color)
         * http://worldwind28.arc.nasa.gov/TestWebApp/WebForm1.aspx?T=nlt_pseudo&L=4&X=589&Y=883
         * 
         * Geocover 1990 & 2000 (pseudo)
         * 
         * NLT LandSat7 (Pseudo Color) GeoCover 2000
         * http://worldwind25.arc.nasa.gov/tile/tile.aspx?T=geocover2000&L=1&X=73&Y=110
         * 
         * NLT LandSat7 (Pseudo Color) GeoCover 1990
         * http://worldwind28.arc.nasa.gov/TestWebApp/WebForm1.aspx?T=es_1990jpg&L=2&X=147&Y=220
         * // END SAME
         * 
         * Landsat 7 imagery
         * OnEarth (visible & pseudo) -- where?
         * 
         * http://worldwind25.arc.nasa.gov/tile/tile.aspx?T=bmng.topo.200409&L=4&X=27&Y=54
         * MATCHES!!! (diff L)
         * http://worldwind25.arc.nasa.gov/tile/tile.aspx?T=105&L=0&X=27&Y=54
         * // 
         * http://worldwind25.arc.nasa.gov/tile/tile.aspx?T=105&L=2&X=109&Y=219
         * COMPLETE MISMATCH
         * http://nww.terraserver-usa.com/nwwtile.ashx?T=102&L=1&X=153&Y=308
         * 
         * 
         * http://worldwind25.arc.nasa.gov/tile/tile.aspx?T=105&L=2&X=109&Y=219
         * 'MATCH'? - no
         * http://mt1.google.com/mt?n=404&v=w2.21&x=87&y=205&zoom=8
         * or
         * http://mt1.google.com/mt?n=404&v=w2.21&x=175&y=411&zoom=7
         * 'MATCH'? - not really either
         * http://nww.terraserver-usa.com/nwwtile.ashx?T=102&L=2&X=308&Y=616
         * 
         * 
         * 
         * USGS imagery
         * 
         * Digital Ortho (monochrome declassified NRO KH-11 spy satellite photographs)
         * 
         * // START SAME 'eq' as 0 from 'dayline' (diff 0,0) - quite zoomed in
         * USGS Digital Ortho 1m
         * http://nww.terraserver-usa.com/nwwtile.ashx?T=101&L=0&X=100&Y=150
         * http://nww.terraserver-usa.com/nwwtile.ashx?T=101&L=1&X=209&Y=311
         * http://nww.terraserver-usa.com/nwwtile.ashx?T=101&L=2&X=417&Y=621
         * 
         * Topographic maps
         * 
         * USGS Topo Maps
         * http://nww.terraserver-usa.com/nwwtile.ashx?T=102&L=0&X=100&Y=150
         * http://nww.terraserver-usa.com/nwwtile.ashx?T=102&L=1&X=209&Y=311
         * http://nww.terraserver-usa.com/nwwtile.ashx?T=102&L=2&X=417&Y=621
         * // END SAME
         * 
         * Urban Area Ortho (montaged color aerial photography of many major US metropolitan areas)
         * 
         * // SAME BUT DOWN?
         * USGS Urban Area Ortho
         * http://nww.terraserver-usa.com/nwwtile.ashx?T=104&L=2&X=416&Y=621
         * 
         * 
         * Zoomit! imagery (community produced layer)
         * 
         * ZoomIt! Data
         * LINZ (montaged color aerial photography of New Zealand)
         * http://madmappers.tileservice.worldwindcentral.org/getTile?T=nz_linz2001_2.5m&version=1&interface=worldwind&firstLevel=11&L=3&X=15968&Y=2030
         * 
         * GSWA (Topographic and geological maps of Western Australia)
         * FIND!!!
         * 
         * US imagery (montaged color aerial photography of many major US metropolitan areas)
         * FIND!!!
         * 
         * South Africa Robben Island 0.5 m
         * FIND!!!
         * 
         */

    }
}
