using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;
using System.Xml;

namespace GMDL
{
    public partial class YumCruncher : Form
    {
        public YumCruncher()
        {
            InitializeComponent();
        }

        private void SetMain_Click(object sender, EventArgs e)
        {
            string dir = System.IO.Directory.GetCurrentDirectory();

            OpenFileDialog file = new OpenFileDialog();
            file.Filter = "YUM File - MapCruncher (*.yum)|*.yum";
            file.ShowDialog();

            System.IO.Directory.SetCurrentDirectory(dir);

            if (file.FileName != "")
            {
                FileMain.Text = file.FileName;
            }
        }

        private void SetSecond_Click(object sender, EventArgs e)
        {
            string dir = System.IO.Directory.GetCurrentDirectory();

            OpenFileDialog file = new OpenFileDialog();
            file.Filter = "YUM File - MapCruncher (*.yum)|*.yum";
            file.ShowDialog();

            System.IO.Directory.SetCurrentDirectory(dir);

            if (file.FileName != "")
            {
                FileSecond.Text = file.FileName;
            }
        }

        private void CombineFiles_Click(object sender, EventArgs e)
        {
            if (FileMain.Text != "" && FileSecond.Text != "")
            {
                string file_out = FileMain.Text + "_" + new FileInfo(FileSecond.Text).Name;

                if (new FileInfo(file_out).Exists)
                {
                    MessageBox.Show("Output file already exists");
                }
                else
                {
                    XmlDocument in1 = new XmlDocument();
                    in1.Load(FileMain.Text);

                    XmlDocument in2 = new XmlDocument();
                    in2.Load(FileSecond.Text);

                    int max_id = 0;
                    foreach (XmlNode res in in1.GetElementsByTagName("SourceMap"))
                    {
                        if (max_id < Int32.Parse(res.Attributes["id"].Value))
                        {
                            max_id = Int32.Parse(res.Attributes["id"].Value);
                        }
                    }

                    foreach (XmlNode res in in2.GetElementsByTagName("SourceMap"))
                    {
                        res.Attributes["id"].Value = (max_id + Int32.Parse(res.Attributes["id"].Value)).ToString();
                    }

                    bool added = false; // will add to the first layer
                    foreach (XmlNode res in in1.GetElementsByTagName("Layer"))
                    {
                        if (added == false)
                        {
                            foreach (XmlNode res2 in in2.GetElementsByTagName("SourceMap"))
                            {
                                res.AppendChild(in1.ImportNode(res2.Clone(), true));
                            }
                        }
                        added = true;
                    }

                    in1.Save(file_out);

                    MessageBox.Show("Saved combined YUM to: " + file_out + "\n\ncopy the source files if they are in a different directory");
                }
            }
        }

        private void LayerViewToMapPos_Click(object sender, EventArgs e)
        {
            if (FileMain.Text != "")
            {
                string file_out = FileMain.Text + "_view.yum";

                if (new FileInfo(file_out).Exists)
                {
                    MessageBox.Show("Output file already exists");
                }
                else
                {
                    XmlDocument in1 = new XmlDocument();
                    in1.Load(FileMain.Text);
                    string zoom = "";
                    string lat = "";
                    string lon = "";
                    bool searching = true; // first layer
                    foreach (XmlNode res in in1.GetElementsByTagName("LayerView"))
                    {
                        if (searching)
                        {
                            zoom = res.ChildNodes[0].ChildNodes[0].Attributes["zoom"].Value;
                            lat = res.ChildNodes[0].ChildNodes[0].ChildNodes[0].Attributes["lat"].Value;
                            lon = res.ChildNodes[0].ChildNodes[0].ChildNodes[0].Attributes["lon"].Value;
                        }
                        searching = false;
                    }

                    if (zoom != "" && lat != "" && lon != "")
                    {
                        int done = 0;

                        foreach (XmlNode res in in1.GetElementsByTagName("ReferenceMapPosition"))
                        {
                            if (res.ChildNodes[0].ChildNodes[0].Attributes["zoom"].Value == "1"
                                && res.ChildNodes[0].ChildNodes[0].ChildNodes[0].Attributes["lat"].Value == "0"
                                && res.ChildNodes[0].ChildNodes[0].ChildNodes[0].Attributes["lon"].Value == "0")
                            {
                                res.ChildNodes[0].ChildNodes[0].Attributes["zoom"].Value = zoom;
                                res.ChildNodes[0].ChildNodes[0].ChildNodes[0].Attributes["lat"].Value = lat;
                                res.ChildNodes[0].ChildNodes[0].ChildNodes[0].Attributes["lon"].Value = lon;

                                done++;
                            }
                        }

                        in1.Save(file_out);

                        MessageBox.Show("Saved YUM to: " + file_out + "\n\nwith " + done.ToString() + " changes");
                    }
                    else
                    {
                        MessageBox.Show("No LayerView MapPosition it seems");
                    }
                }
            }
        }
    }
}