using System;
using System.Collections.Generic;
using System.Text;

using System.Windows.Forms;

using System.IO;

using System.Data;

namespace GMDL
{
    class Translation
    {
        public void GenerateFile(Form form)
        {
            StreamWriter sr = new StreamWriter("translation.txt", true);
            foreach (Control cont in form.Controls)
            {
                if (cont.Text != "")
                {
                    string ret = "";
                    ret = ret + form.Name + "." + cont.Name + "(";
                    if (cont.Tag != null)
                    {
                        ret = ret + cont.Tag.ToString() + ")=" + cont.Text;
                    }
                    else
                    {
                        ret = ret + cont.Text + ")="; // no translated value
                    }
                    sr.WriteLine(ret);
                }
                GenerateString(cont, form.Name, sr);
            }
            sr.Close();
        }

        private void GenerateString(Control control, string form, StreamWriter sr)
        {
            foreach (Control cont in control.Controls)
            {
                if (cont.Text != "")
                {
                    string ret = "";
                    ret = ret + form + "." + cont.Name + "(";
                    if (cont.Tag != null)
                    {
                        ret = ret + cont.Tag.ToString() + ")=" + cont.Text;
                    }
                    else
                    {
                        ret = ret + cont.Text + ")="; // no translated value
                    }
                    sr.WriteLine(ret);
                }
                GenerateString(cont, form, sr);
            }
        }

        public void LoadFile(Form form)
        {
            if (new FileInfo("translation.txt").Exists)
            {
                try
                {
                    bool file_ok = true;

                    DataTable trans = new DataTable();
                    trans.Columns.Add("Form", typeof(String));
                    trans.Columns.Add("Control", typeof(String));
                    trans.Columns.Add("Old", typeof(String));
                    trans.Columns.Add("New", typeof(String));

                    try
                    {
                        StreamReader sr = new StreamReader("translation.txt");
                        
                        while (sr.EndOfStream == false)
                        {
                            string line = sr.ReadLine();
                            DataRow new_row = trans.NewRow();

                            new_row["Form"] = line.Substring(0, line.IndexOf("."));
                            new_row["Control"] = line.Substring(line.IndexOf(".") + 1, line.IndexOf("(") - 1 - line.IndexOf("."));
                            new_row["Old"] = line.Substring(line.IndexOf("(") + 1, line.IndexOf(")=") - 1 - line.IndexOf("("));
                            new_row["New"] = line.Substring(line.LastIndexOf(")=") + 2, line.Length - 2 - line.LastIndexOf(")="));

                            if (new_row["New"].ToString() != "")
                                trans.Rows.Add(new_row);
                        }
                    }
                    catch
                    {
                        file_ok = false;
                        MessageBox.Show("Invalid translation.txt file");
                    }

                    if (file_ok)
                    {
                        foreach (Control cont in form.Controls)
                        {
                            if (cont.Text != "")
                            {
                                foreach (DataRow Trow in trans.Select("Form = '" + form.Name + "' AND Control = '" + cont.Name + "' AND New <> ''"))
                                {
                                    cont.Tag = cont.Text;
                                    cont.Text = Trow["New"].ToString();
                                }
                            }
                            LoadControl(cont, form.Name, trans);
                        }
                    }
                }
                catch
                {
                    MessageBox.Show("Something went wrong while applying the translation");
                }
            }
        }

        private void LoadControl(Control control, string form, DataTable trans)
        {
            foreach (Control cont in control.Controls)
            {
                if (cont.Text != "")
                {
                    foreach (DataRow Trow in trans.Select("Form = '" + form + "' AND Control = '" + cont.Name + "' AND New <> ''"))
                    {
                        cont.Tag = cont.Text;
                        cont.Text = Trow["New"].ToString();
                    }
                }
                LoadControl(cont, form, trans);
            }
        }
    }
}
