using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;
using System.Net;

namespace GMDL
{
    public partial class SelectDetail4x : Form
    {
        public SelectDetail4x(int zoom, int min_zoom, int x, int y, string map_type, mapURL MU, WebClient WC)
        {
            InitializeComponent();

            mu = MU;

            wc = WC;

            Zoom = zoom;
            MinZoom = min_zoom;
            X = x;
            Y = y;
            MapType = map_type;

            TilesToIgnore = new DataTable();
            TilesToIgnore.Columns.Add("zoom", typeof(Int32));
            TilesToIgnore.Columns.Add("min_x", typeof(Int32));
            TilesToIgnore.Columns.Add("min_y", typeof(Int32));
            TilesToIgnore.Columns.Add("max_x", typeof(Int32));
            TilesToIgnore.Columns.Add("max_y", typeof(Int32));
        }

        private int Zoom;
        private int MinZoom;
        private int X;
        private int Y;
        private string MapType;

        public DataTable TilesToIgnore;
        public bool DoCancel = false;

        public mapURL mu;

        private WebClient wc;

        private void SelectDetail4x_Load(object sender, EventArgs e)
        {
            int max_x_zoom = (int)Math.Pow(2, Zoom - MinZoom);
            int folder_zoom = 1;
            int offset = 1;
            while (max_x_zoom >= 1)
            {
                CheckBox cb = new CheckBox();
                cb.Location = new Point(0, 20 * offset);
                cb.Checked = true;
                cb.Width = 60;
                cb.Text = folder_zoom.ToString() + "x";
                if (max_x_zoom == 4)
                    cb.Text = cb.Text + " <";
                cb.Name = "zl" + ((Zoom - MinZoom) - offset + 1).ToString();
                if (offset == 1 || max_x_zoom == 1)
                    cb.Enabled = false;
                this.Controls.Add(cb);

                offset++;
                max_x_zoom = max_x_zoom / 2;
                folder_zoom = folder_zoom * 2;
            }

            for (int i = 0; i < 8; i++)
            {
                for (int j = 0; j < 8; j++)
                {
                    CheckBox cb = new CheckBox();
                    cb.Location = new Point(0 + i * 128 + 64, 24 + j * 128 + 64);
                    cb.Checked = true;
                    cb.Width = 20;
                    cb.Name = "cb" + (X * 4 + i).ToString() + "_" + (Y * 4 + j).ToString();
                    this.Controls.Add(cb);

                    PictureBox pb = new PictureBox();
                    pb.Location = new Point(0 + i * 128, 24 + j * 128);
                    pb.Width = 128;
                    pb.Height = 128;
                    pb.SizeMode = PictureBoxSizeMode.StretchImage;
                    pb.BorderStyle = BorderStyle.FixedSingle;

                    try
                    {
                        if (MapType.StartsWith("iMC") || MapType.StartsWith("iSI"))
                            pb.Image = new Bitmap(new MemoryStream(File.ReadAllBytes(mu.MapByType(Zoom - 2, X * 4 + i, Y * 4 + j, MapType))));
                        else
                            pb.Image = new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(Zoom - 2, X * 4 + i, Y * 4 + j, MapType))));
                    }
                    catch
                    {
                        cb.Checked = false;
                    }

                    pb.Name = "pb" + (X * 4 + i).ToString() + "_" + (Y * 4 + j).ToString();
                    pb.Click += new EventHandler(pb_Click);
                    
                    this.Controls.Add(pb);
                }
            }
        }

        void pb_Click(object sender, EventArgs e)
        {
            foreach (Control cn in this.Controls)
            {
                if (cn.Name == ((PictureBox)sender).Name.Replace("pb", "cb"))
                {
                    if (((CheckBox)cn).Checked)
                        ((CheckBox)cn).Checked = false;
                    else
                        ((CheckBox)cn).Checked = true;
                }
            }
        }

        private void Done_Click(object sender, EventArgs e)
        {
            int missed_tiles = 0;

            // THE LAYERS (if not already exluded)
            foreach (Control cn in this.Controls)
            {
                if (cn.Name.StartsWith("zl"))
                {
                    if (((CheckBox)cn).Checked == false)
                    {
                        int zoom_off_layer = Int32.Parse(cn.Name.Substring(2, cn.Name.Length - 2));

                        DataRow new_row = TilesToIgnore.NewRow();
                        new_row["zoom"] = Zoom - zoom_off_layer;
                        new_row["min_x"] = -1;
                        new_row["min_y"] = -1;
                        new_row["max_x"] = -1;
                        new_row["max_y"] = -1;
                        TilesToIgnore.Rows.Add(new_row);

                        missed_tiles += System.Convert.ToInt32(Math.Pow(2, 2 * (zoom_off_layer + 1)));
                    }
                }
            }

            foreach (Control cn in this.Controls)
            {
                if (cn.Name.StartsWith("cb"))
                {
                    if (((CheckBox)cn).Checked == false)
                    {
                        int x = Int32.Parse(cn.Name.Substring(2, cn.Name.IndexOf("_") - 2));
                        int y = Int32.Parse(cn.Name.Substring(cn.Name.IndexOf("_") + 1, cn.Name.Length - 1 - cn.Name.IndexOf("_")));
                        int zoom_span = 2;
                        for (int zoom_off = 3; Zoom - zoom_off >= MinZoom; zoom_off++, zoom_span *= 2)
                        {
                            if (TilesToIgnore.Select("zoom = " + (Zoom - zoom_off).ToString() 
                                + " AND min_x = -1 AND min_y = -1 AND max_x = -1 AND max_y = -1").Length == 0)
                            {
                                DataRow new_row = TilesToIgnore.NewRow();
                                new_row["zoom"] = Zoom - zoom_off;
                                new_row["min_x"] = x * zoom_span;
                                new_row["min_y"] = y * zoom_span;
                                new_row["max_x"] = x * zoom_span + zoom_span - 1;
                                new_row["max_y"] = y * zoom_span + zoom_span - 1;
                                TilesToIgnore.Rows.Add(new_row);

                                missed_tiles += zoom_span * zoom_span;
                            }
                        }
                    }
                }
            }

            DataRow missed_row = TilesToIgnore.NewRow();
            missed_row["zoom"] = -99;
            missed_row["min_x"] = missed_tiles;
            missed_row["min_y"] = -1;
            missed_row["max_x"] = -1;
            missed_row["max_y"] = -1;
            TilesToIgnore.Rows.Add(missed_row);

            this.Close();
        }

        private void CancelBTN_Click(object sender, EventArgs e)
        {
            DoCancel = true;
            this.Close();
        }
    }
}