using System;
using System.Collections.Generic;
using System.Text;

//using GMDL.com.terraserver_usa;

namespace GMDL
{
    public class LatLonXYcalcs
    {
        #region borrowed code NE js
        //http://www.nearby.org.uk/tests/geotools.js

        public int[] LLtoNEjs(double lat, double lon, double latC, double lonC)
        {
            int e = System.Convert.ToInt32(Lat_Long_to_East(latC, lon, 6377563.396, 6356256.910, 400000, 0.999601272, 49.00000, -2.00000));
            int n = System.Convert.ToInt32(Lat_Long_to_North(lat, lonC, 6377563.396, 6356256.910, 400000, -100000, 0.999601272, 49.00000, -2.00000));
            return new int[] { e, n };
        }

        private double Lat_Long_to_East(double PHI, double LAM, double a, double b, double e0, double f0, double PHI0, double LAM0)
        {
	        //Project Latitude and longitude to Transverse Mercator eastings.
	        //Input: - _
	        //    Latitude (PHI) and Longitude (LAM) in decimal degrees; _
	        //    ellipsoid axis dimensions (a & b) in meters; _
	        //    eastings of false origin (e0) in meters; _
	        //    central meridian scale factor (f0); _
	        // latitude (PHI0) and longitude (LAM0) of false origin in decimal degrees.

	        // Convert angle measures to radians
            double Pi = 3.14159265358979;
            double RadPHI = PHI * (Pi / 180);
            double RadLAM = LAM * (Pi / 180);
            double RadPHI0 = PHI0 * (Pi / 180);
            double RadLAM0 = LAM0 * (Pi / 180);

            double af0 = a * f0;
            double bf0 = b * f0;
            double e2 = (Math.Pow(af0,2) - Math.Pow(bf0,2)) / Math.Pow(af0,2);
            double n = (af0 - bf0) / (af0 + bf0);
            double nu = af0 / (Math.Sqrt(1 - (e2 * Math.Pow(Math.Sin(RadPHI),2) )));
            double rho = (nu * (1 - e2)) / (1 - (e2 * Math.Pow(Math.Sin(RadPHI),2) ));
            double eta2 = (nu / rho) - 1;
            double p = RadLAM - RadLAM0;
            
            double IV = nu * (Math.Cos(RadPHI));
            double V = (nu / 6) * ( Math.Pow(Math.Cos(RadPHI),3)) * ((nu / rho) - (Math.Pow(Math.Tan(RadPHI),2)));
            double VI = (nu / 120) * (Math.Pow(Math.Cos(RadPHI),5)) * (5 - (18 * (Math.Pow(Math.Tan(RadPHI),2))) + (Math.Pow(Math.Tan(RadPHI),4)) + (14 * eta2) - (58 * (Math.Pow(Math.Tan(RadPHI),2)) * eta2));
            
            return e0 + (p * IV) + (Math.Pow(p,3) * V) + (Math.Pow(p,5) * VI);
        }

        private double Lat_Long_to_North(double PHI, double LAM, double a, double b, double e0, double n0, double f0, double PHI0, double LAM0) 
        {
	        // Project Latitude and longitude to Transverse Mercator northings
	        // Input: - _
	        // Latitude (PHI) and Longitude (LAM) in decimal degrees; _
	        // ellipsoid axis dimensions (a & b) in meters; _
	        // eastings (e0) and northings (n0) of false origin in meters; _
	        // central meridian scale factor (f0); _
	        // latitude (PHI0) and longitude (LAM0) of false origin in decimal degrees.

	        // REQUIRES THE "Marc" FUNCTION

	        // Convert angle measures to radians
            double Pi = 3.14159265358979;
            double RadPHI = PHI * (Pi / 180);
            double RadLAM = LAM * (Pi / 180);
            double RadPHI0 = PHI0 * (Pi / 180);
            double RadLAM0 = LAM0 * (Pi / 180);

            double af0 = a * f0;
            double bf0 = b * f0;
            double e2 = (Math.Pow(af0, 2) - Math.Pow(bf0, 2)) / Math.Pow(af0, 2);
            double n = (af0 - bf0) / (af0 + bf0);
            double nu = af0 / (Math.Sqrt(1 - (e2 * Math.Pow(Math.Sin(RadPHI), 2))));
            double rho = (nu * (1 - e2)) / (1 - (e2 * Math.Pow(Math.Sin(RadPHI), 2)));
            double eta2 = (nu / rho) - 1;
            double p = RadLAM - RadLAM0;
            double M = MarcJS(bf0, n, RadPHI0, RadPHI);

            double I = M + n0;
            double II = (nu / 2) * (Math.Sin(RadPHI)) * (Math.Cos(RadPHI));
            double III = ((nu / 24) * (Math.Sin(RadPHI)) * (Math.Pow(Math.Cos(RadPHI), 3))) * (5 - (Math.Pow(Math.Tan(RadPHI), 2)) + (9 * eta2));
            double IIIA = ((nu / 720) * (Math.Sin(RadPHI)) * (Math.Pow(Math.Cos(RadPHI), 5))) * (61 - (58 * (Math.Pow(Math.Tan(RadPHI), 2))) + (Math.Pow(Math.Tan(RadPHI), 4)));

            return I + (Math.Pow(p, 2) * II) + (Math.Pow(p, 4) * III) + (Math.Pow(p, 6) * IIIA);
        }

        private double MarcJS(double bf0, double n, double PHI0, double PHI) 
        {
	        //Compute meridional arc.
	        //Input: - _
	        // ellipsoid semi major axis multiplied by central meridian scale factor (bf0) in meters; _
	        // n (computed from a, b and f0); _
	        // lat of false origin (PHI0) and initial or final latitude of point (PHI) IN RADIANS.

	        //THIS FUNCTION IS CALLED BY THE - _
	        // "Lat_Long_to_North" and "InitialLat" FUNCTIONS
	        // THIS FUNCTION IS ALSO USED ON IT'S OWN IN THE "Projection and Transformation Calculations.xls" SPREADSHEET

		        return bf0 * (((1 + n + ((5 / 4) * Math.Pow(n,2)) + ((5 / 4) * Math.Pow(n,3))) * (PHI - PHI0)) - (((3 * n) + (3 * Math.Pow(n,2)) + ((21 / 8) * Math.Pow(n,3))) * (Math.Sin(PHI - PHI0)) * (Math.Cos(PHI + PHI0))) + ((((15 / 8
	        ) * Math.Pow(n,2)) + ((15 / 8) * Math.Pow(n,3))) * (Math.Sin(2 * (PHI - PHI0))) * (Math.Cos(2 * (PHI + PHI0)))) - (((35 / 24) * Math.Pow(n,3)) * (Math.Sin(3 * (PHI - PHI0))) * (Math.Cos(3 * (PHI + PHI0)))));
        }

        #endregion

        #region borrowed code NE cs (unused)
        //http://www.developerfusion.co.uk/show/4634/
        /*
        private static double deg2rad = Math.PI / 180;
        //private static double rad2deg = 180.0 / Math.PI;

        // a function used in LLtoNE  - that's all I know about it
        private double MarcCS(double bf0, double n, double phi0, double phi)
        {
            return bf0 * (((1 + n + ((5 / 4) * (n * n)) + ((5 / 4) * (n * n * n))) * (phi - phi0))
               - (((3 * n) + (3 * (n * n)) + ((21 / 8) * (n * n * n))) * (Math.Sin(phi - phi0)) * (Math.Cos(phi + phi0)))
               + ((((15 / 8) * (n * n)) + ((15 / 8) * (n * n * n))) * (Math.Sin(2 * (phi - phi0))) * (Math.Cos(2 * (phi + phi0))))
               - (((35 / 24) * (n * n * n)) * (Math.Sin(3 * (phi - phi0))) * (Math.Cos(3 * (phi + phi0)))));
        }

        //converts lat and lon (OSGB36)  to OS 6 figure northing and easting
        public int[] LLtoNEcs(double lat, double lon)
        {
            double phi = lat * deg2rad;          // convert latitude to radians
            double lam = lon * deg2rad;          // convert longitude to radians
            double a = 6377563.396;              // OSGB semi-major axis
            double b = 6356256.91;               // OSGB semi-minor axis
            double e0 = 400000;                  // easting of false origin
            double n0 = -100000;                 // northing of false origin
            double f0 = 0.9996012717;            // OSGB scale factor on central meridian
            double e2 = 0.0066705397616;         // OSGB eccentricity squared
            double lam0 = -0.034906585039886591; // OSGB false east
            double phi0 = 0.85521133347722145;   // OSGB false north
            double af0 = a * f0;
            double bf0 = b * f0;

            // easting
            double slat2 = Math.Sin(phi) * Math.Sin(phi);
            double nu = af0 / (Math.Sqrt(1 - (e2 * (slat2))));
            double rho = (nu * (1 - e2)) / (1 - (e2 * slat2));
            double eta2 = (nu / rho) - 1;
            double p = lam - lam0;
            double IV = nu * Math.Cos(phi);
            double clat3 = Math.Pow(Math.Cos(phi), 3);
            double tlat2 = Math.Tan(phi) * Math.Tan(phi);
            double V = (nu / 6) * clat3 * ((nu / rho) - tlat2);
            double clat5 = Math.Pow(Math.Cos(phi), 5);
            double tlat4 = Math.Pow(Math.Tan(phi), 4);
            double VI = (nu / 120) * clat5 * ((5 - (18 * tlat2)) + tlat4 + (14 * eta2) - (58 * tlat2 * eta2));
            double east = e0 + (p * IV) + (Math.Pow(p, 3) * V) + (Math.Pow(p, 5) * VI);

            // northing
            double n = (af0 - bf0) / (af0 + bf0);
            double M = MarcCS(bf0, n, phi0, phi);
            double I = M + (n0);
            double II = (nu / 2) * Math.Sin(phi) * Math.Cos(phi);
            double III = ((nu / 24) * Math.Sin(phi) * Math.Pow(Math.Cos(phi), 3)) * (5 - Math.Pow(Math.Tan(phi), 2) + (9 * eta2));
            double IIIA = ((nu / 720) * Math.Sin(phi) * clat5) * (61 - (58 * tlat2) + tlat4);
            double north = I + ((p * p) * II) + (Math.Pow(p, 4) * III) + (Math.Pow(p, 6) * IIIA);

            // make whole number values
            east = Math.Round(east);   // round to whole number
            north = Math.Round(north); // round to whole number

            return new int[] { System.Convert.ToInt32(east), System.Convert.ToInt32(north) };

            // Notify the calling application of the change
            //if (NorthingEastingReceived != null) NorthingEastingReceived(north, east);

            // convert to nat grid ref
            //NE2NGR(east, north);
        }
        */
        #endregion

        #region borrowed code
        // this seems to work (ref http://mapki.com/getLonLat.php)
        public decimal[] getLatLong(int x, int y, int zoom)
        {
            double lon = -180; // x
            double lonWidth = 360; // width 360

            double lat = -1;
            double latHeight = 2;

            int tilesAtThisZoom = 1 << (17 - zoom);
            lonWidth = 360.0 / (double)tilesAtThisZoom;
            lon = -180 + ((double)x * lonWidth);
            latHeight = -2.0 / (double)tilesAtThisZoom;
            lat = 1 + ((double)y * latHeight);

            // convert lat and latHeight to degrees in a transverse mercator projection
            // note that in fact the coordinates go from about -85 to +85 not -90 to 90!
            latHeight += lat;
            latHeight = ((double)2 * Math.Atan(Math.Exp(Math.PI * latHeight))) - (Math.PI / (double)2);
            latHeight *= ((double)180 / Math.PI);

            lat = ((double)2 * Math.Atan(Math.Exp(Math.PI * lat))) - (Math.PI / (double)2);
            lat *= ((double)180 / Math.PI);

            latHeight -= lat;

            if (lonWidth < 0)
            {
                lon = lon + lonWidth;
                lonWidth = -lonWidth;
            }

            if (latHeight < 0)
            {
                lat = lat + latHeight;
                latHeight = -latHeight;
            }

            //Coord c;
            //c.lat = lat;
            //c.lon = lon;
            //c.lonWidth = lonWidth;
            //c.latHeight = latHeight;
            // returns the top left corner's coords
            return new decimal[] { (decimal)lon, (decimal)lat + (decimal)latHeight };
        }
        #endregion

        public int[] CalculateXY(decimal lat, decimal lon, decimal zoom)
        {
            int our_zoom = 16;
            int our_x = 0; // at 17
            int our_y = 0;

            while (our_zoom >= zoom)
            {
                decimal[] TL = getLatLong(our_x * 2, our_y * 2, our_zoom);
                decimal[] MM = getLatLong(our_x * 2 + 1, our_y * 2 + 1, our_zoom);
                decimal[] BR = getLatLong(our_x * 2 + 2, our_y * 2 + 2, our_zoom);

                decimal Lon1 = TL[0];
                decimal Lon2 = MM[0];
                decimal Lon3 = BR[0];

                decimal Lat1 = TL[1];
                decimal Lat2 = MM[1];
                decimal Lat3 = BR[1];

                if (lat < Lat1 && lat > Lat2 && lon > Lon1 && lon < Lon2)
                {
                    our_x = our_x * 2;
                    our_y = our_y * 2;
                }
                if (lat < Lat2 && lat > Lat3 && lon > Lon2 && lon < Lon3)
                {
                    our_x = our_x * 2 + 1;
                    our_y = our_y * 2 + 1;
                }
                if (lat < Lat1 && lat > Lat2 && lon > Lon2 && lon < Lon3)
                {
                    our_x = our_x * 2 + 1;
                    our_y = our_y * 2;
                }
                if (lat < Lat2 && lat > Lat3 && lon > Lon1 && lon < Lon2)
                {
                    our_x = our_x * 2;
                    our_y = our_y * 2 + 1;
                }

                our_zoom--;
            }

            return new int[] { our_x, our_y };
        }

        public string MinutesToProper(string the_text)
        {
            if (the_text.IndexOf(":") != -1)
            {
                if (the_text.Length - the_text.IndexOf(":") == 3)
                {
                    decimal hours = Decimal.Parse(the_text.Substring(0, the_text.IndexOf(":")));
                    decimal minutes = Decimal.Parse(the_text.Substring(the_text.IndexOf(":") + 1, the_text.Length - 1 - the_text.IndexOf(":")));

                    if (hours >= 0)
                        the_text = (hours + minutes / 60).ToString("0.000000");
                    else
                        the_text = (hours - minutes / 60).ToString("0.000000");
                }
            }

            return the_text;
        }

        /*public int[] CalculateXYterraserver(decimal lat, decimal lon, decimal zoom)
        {
            TerraService ts = new TerraService();
            LonLatPt l = new LonLatPt();
            l.Lon = (double)lon;
            l.Lat = (double)lat;
            UtmPt p = ts.ConvertLonLatPtToUtmPt(l);


            // http://www.dasnet.org/node/101

            int x = (int)(p.X / (double)zoom);
            int y = (int)(p.Y / (double)zoom);

            return new int[] { x, y };
        }*/

        // this seems to round wrong (try? http://cfis.savagexi.com/articles/2006/05/03/google-maps-deconstructed)
        /*private int[] CalculateXY(decimal lat, decimal lon, decimal zoom)
        {
            #region borrowed code

            decimal bc = (decimal)6.28318530717958652866;
            decimal Wa = (decimal)0.017453292519943295912944444444444;

            decimal c = 256;
            decimal d = 17;

            decimal pixelsPerLonDegree = 0;
            decimal pixelsPerLonRadian = 0;
            decimal bitmapOrigo = 0;

            while (d >= zoom)
            {
                d = d - 1;
                pixelsPerLonDegree = c / 360;
                pixelsPerLonRadian = c / bc;
                bitmapOrigo = c / 2;
                c = c * 2;
            }

            decimal x = (bitmapOrigo + lon * pixelsPerLonDegree) / 256;
            decimal e = (decimal)Math.Sin(System.Convert.ToDouble(lat * Wa));
            decimal y = (bitmapOrigo + (decimal)0.5 * (decimal)Math.Log(System.Convert.ToDouble((1 + (e)) / (1 - (e)))) * -1 * pixelsPerLonRadian) / 256;
            #endregion

            return new int[] { Int32.Parse(x.ToString("0")), Int32.Parse(y.ToString("0")) };
        }*/
    }
}
