using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;

namespace GMDL
{
    public partial class GPSFSdirViewer : Form
    {
        public GPSFSdirViewer(string MapDir)
        {
            InitializeComponent();

            map_name.Text = MapDir;
        }

        int max_zoom;

        int zoom_mid;
        int x_mid;
        int y_mid;

        int x_pos_mid;
        int y_pos_mid;

        private void GPSFSdirViewer_Resize(object sender, EventArgs e)
        {
            AdjustToSize();

            LoadTiles();
        }

        byte[] IDXba;
        int max_size;

        private void GPSFSdirViewer_Load(object sender, EventArgs e)
        {
            this.Show();

            FilesDone.Text = "Opening File";
            Application.DoEvents();

            BinaryReader sr = new BinaryReader(new FileStream(map_name.Text + "/GPSFS", FileMode.Open));
            try
            {
                string gpsfsv = "";
                Int64 x = -1;
                Int64 y = -1;
                Int64 basezoom = 0;
                Int64 filetype = -1;
                Int64 maxsize = -1;

                gpsfsv += sr.ReadChar();
                gpsfsv += sr.ReadChar();
                gpsfsv += sr.ReadChar();
                gpsfsv += sr.ReadChar();
                gpsfsv += sr.ReadChar();
                gpsfsv += sr.ReadChar();
                gpsfsv += sr.ReadChar();
                gpsfsv += sr.ReadChar();

                x = sr.ReadInt64();
                y = sr.ReadInt64();
                basezoom = sr.ReadInt64();
                filetype = sr.ReadInt64();
                maxsize = sr.ReadInt64();

                max_size = System.Convert.ToInt32(maxsize);
                Potential.Text = maxsize.ToString();

                if (filetype == 0)
                    MapType.Text = "png";
                else
                    MapType.Text = "jpg";

                FilesDone.Text = "Reading Index";
                Application.DoEvents();

                // get N + 1 coords

                GPSFS gfs = new GPSFS();

                max_zoom = 1;
                int tiles = 0;
                while (tiles < maxsize)
                {
                    tiles = System.Convert.ToInt32(gfs.TotalTiles(max_zoom));
                    max_zoom *= 2;
                }
                max_zoom /= 2;

                MapSize.Text = max_zoom.ToString() + "x (" + (max_zoom * 2).ToString() + "x" + (max_zoom * 2).ToString() + " tiles)";

                IDXba = sr.ReadBytes(8 * (System.Convert.ToInt32(maxsize) + 1));
            }
            catch
            {
                MessageBox.Show("Something went wrong");
            }

            sr.Close();

            zoom_mid = max_zoom;
            x_mid = 1;
            y_mid = 1;

            FilesDone.Text = "";
            Application.DoEvents();

            AdjustToSize();

            LoadTiles();
        }

        private void AdjustToSize()
        {
            // delete existing
            foreach (Control cn in this.Controls)
            {
                if (cn.Name.StartsWith("pb"))
                {
                    cn.Dispose();
                }
            }

            // create new
            int x_pos = 0;
            int y_pos = 0;
            while (x_pos * 256 < this.Width)
            {
                y_pos = 0;
                while (y_pos * 256 < this.Height)
                {
                    PictureBox pb = new PictureBox();
                    pb.Location = new Point(x_pos * 256, y_pos * 256);
                    pb.Width = 256;
                    pb.Height = 256;
                    pb.BorderStyle = BorderStyle.None;

                    pb.Name = "pb" + x_pos.ToString() + "_" + y_pos.ToString();
                    pb.Tag = new int[2] { x_pos, y_pos };
                    pb.Click += new EventHandler(pb_Click);
                    pb.MouseEnter += new EventHandler(pb_MouseEnter);

                    this.Controls.Add(pb);

                    y_pos++;
                }
                x_pos++;
            }
            x_pos_mid = x_pos / 2;
            y_pos_mid = y_pos / 2;
        }

        void pb_MouseEnter(object sender, EventArgs e)
        {
            foreach (Control cont in this.Controls)
            {
                if (cont.Name.StartsWith("pb"))
                {
                    ((PictureBox)cont).BorderStyle = BorderStyle.None;
                }
            }

            if (OutlineTile.Checked)
                ((PictureBox)sender).BorderStyle = BorderStyle.FixedSingle;
        }

        void pb_Click(object sender, EventArgs e)
        {
            if (zoom_mid > 1)
            {
                Control cn = (Control)sender;

                int x_pos = ((int[])cn.Tag)[0];
                int y_pos = ((int[])cn.Tag)[1];

                int x = x_mid + (x_pos - x_pos_mid);
                int y = y_mid + (y_pos - y_pos_mid);

                x_mid = x * 2;
                y_mid = y * 2;

                zoom_mid /= 2;

                LoadTiles();
            }
        }

        private void LoadTiles()
        {
            FilesDone.Text = "Loading Tiles";
            Application.DoEvents();
            this.Enabled = false;

            int x_pos;
            int y_pos;

            int x;
            int y;

            int IDXfile = 0;
            BinaryReader sr = new BinaryReader(new FileStream(map_name.Text + "/GPSFS", FileMode.Open));
            foreach (Control cn in this.Controls)
            {
                if (cn.Name.StartsWith("pb"))
                {
                    x_pos = ((int[])cn.Tag)[0];
                    y_pos = ((int[])cn.Tag)[1];

                    x = x_mid + (x_pos - x_pos_mid);
                    y = y_mid + (y_pos - y_pos_mid);

                    // load tile (set nulls if empty / non existant)
                    ((PictureBox)cn).Image = null;
                    if (x >= 0 && y >= 0)
                    {
                        int[] fol = TileFileOffsetLength(zoom_mid, x, y);
                        if (fol[2] > 0)
                        {
                            if (IDXfile != fol[0]) // (int)tile["IDXfile"])
                            {
                                IDXfile = fol[0]; // (int)tile["IDXfile"];
                                sr.Close();
                                string file_suff = IDXfile.ToString();
                                if (file_suff == "0")
                                    file_suff = "";
                                sr = new BinaryReader(new FileStream(map_name.Text + "/GPSFS" + file_suff, FileMode.Open));
                            }
                            // seek
                            sr.BaseStream.Position = fol[1]; // (int)tile["IDXoffset"];
                            // read
                            ((PictureBox)cn).Image = new Bitmap(new MemoryStream(sr.ReadBytes(fol[2]))); // (int)tile["length"])));
                        }
                    }
                    Application.DoEvents();
                }
            }
            sr.Close();

            FilesDone.Text = "@ " + zoom_mid.ToString() + "x of " + max_zoom.ToString() + "x";
            Application.DoEvents();
            this.Enabled = true;
        }

        private int[] TileFileOffsetLength(int zoom, int x, int y)
        {
            int tile = 0;

            int file = -1;
            int offset = -1;
            int length = 0;

            int s_zoom = 1;
            while (s_zoom < zoom)
            {
                tile += System.Convert.ToInt32(Math.Pow((max_zoom / s_zoom) * 2, 2));
                s_zoom *= 2;
            }

            int span = 2 * max_zoom / s_zoom;

            if (x < span && y < span)
            {
                tile += span * y;
                tile += x;

                if (tile < max_size)
                {
                    file = System.BitConverter.ToInt32(IDXba, tile * 8);
                    offset = System.BitConverter.ToInt32(IDXba, tile * 8 + 4);
                    if (offset >= 0)
                    {
                        int offset1 = System.BitConverter.ToInt32(IDXba, (tile + 1) * 8 + 4);
                        if (offset1 > 0)
                        {
                            length = offset1 - offset;
                        }
                        else if (System.BitConverter.ToInt32(IDXba, (tile + 1) * 8 + 4) < 0)
                        {
                            length = offset1 * -1;
                        }
                        else // if (offset1 == 0)
                        {
                            string file_suff = file.ToString();
                            if (file_suff == "0")
                                file_suff = "";
                            length = System.Convert.ToInt32(new FileInfo(map_name.Text + "/GPSFS" + file_suff).Length) - offset;
                        }
                    }
                }
            }

            return (new int[] { file, offset, length });
        }

        private void sUP_Click(object sender, EventArgs e)
        {
            if (y_mid >= Int32.Parse(JumpTiles.Text))
            {
                y_mid -= Int32.Parse(JumpTiles.Text);
                LoadTiles();
            }
        }

        private void sDOWN_Click(object sender, EventArgs e)
        {
            y_mid += Int32.Parse(JumpTiles.Text);
            LoadTiles();
        }

        private void sLEFT_Click(object sender, EventArgs e)
        {
            if (x_mid >= Int32.Parse(JumpTiles.Text))
            {
                x_mid -= Int32.Parse(JumpTiles.Text);
                LoadTiles();
            }
        }

        private void sRIGHT_Click(object sender, EventArgs e)
        {
            x_mid += Int32.Parse(JumpTiles.Text);
            LoadTiles();
        }

        private void sZOOMin_Click(object sender, EventArgs e)
        {
            if (zoom_mid > 1)
            {
                x_mid *= 2;
                y_mid *= 2;

                zoom_mid /= 2;

                LoadTiles();
            }
        }

        private void sZOOMout_Click(object sender, EventArgs e)
        {
            if (zoom_mid < max_zoom)
            {
                x_mid /= 2;
                y_mid /= 2;

                zoom_mid *= 2;

                LoadTiles();
            }
        }

        private void sRESET_Click(object sender, EventArgs e)
        {
            zoom_mid = max_zoom;
            x_mid = 1;
            y_mid = 1;

            LoadTiles();
        }

        private void JumpTiles_TextUpdate(object sender, EventArgs e)
        {
            try
            {
                int test = Int32.Parse(JumpTiles.Text);
            }
            catch
            {
                JumpTiles.Text = "1";
            }
        }

        private void Save8192_Click(object sender, EventArgs e)
        {
            if (new FileInfo(map_name.Text + "\\0_0.png").Exists)
            {
                MessageBox.Show("Tiles already there");
            }
            else
            {
                FilesDone.Text = "Wait . . .";
                Application.DoEvents();

                int x_off = 0;

                int tile_size = 8192;

                int off_max = max_zoom * 2 * 256 / tile_size; // since truncates

                int IDXfile = 0;
                BinaryReader sr = new BinaryReader(new FileStream(map_name.Text + "/GPSFS", FileMode.Open));
            
                while (x_off <= off_max)
                {
                    int y_off = 0;
                    while (y_off <= off_max)
                    {
                        int x_tile_max = tile_size / 256;
                        int y_tile_max = tile_size / 256;

                        if (x_off == off_max)
                        {
                            x_tile_max = (max_zoom * 2 * 256 - off_max * tile_size) / 256;
                        }

                        if (y_off == off_max)
                        {
                            y_tile_max = (max_zoom * 2 * 256 - off_max * tile_size) / 256;
                        }

                        if (x_tile_max > 0 && y_tile_max > 0)
                        {
                            Bitmap tileBIG = new Bitmap(x_tile_max * 256, y_tile_max * 256);

                            int x_tile = 0;
                            while (x_tile < x_tile_max)
                            {
                                int y_tile = 0;
                                while (y_tile < y_tile_max)
                                {
                                    int[] fol = TileFileOffsetLength(1, x_off * tile_size / 256 + x_tile, y_off * tile_size / 256 + y_tile);
                                    if (fol[2] > 0)
                                    {
                                        if (IDXfile != fol[0]) // (int)tile["IDXfile"])
                                        {
                                            IDXfile = fol[0]; // (int)tile["IDXfile"];
                                            sr.Close();
                                            string file_suff = IDXfile.ToString();
                                            if (file_suff == "0")
                                                file_suff = "";
                                            sr = new BinaryReader(new FileStream(map_name.Text + "/GPSFS" + file_suff, FileMode.Open));
                                        }
                                        // seek
                                        sr.BaseStream.Position = fol[1]; // (int)tile["IDXoffset"];
                                        // read
                                        // load into tileBIG
                                        Bitmap src = new Bitmap(new MemoryStream(sr.ReadBytes(fol[2]))); // (int)tile["length"])));

                                        Rectangle srcRect = new Rectangle();
                                        Rectangle destRect = new Rectangle();

                                        using (Graphics g = Graphics.FromImage(tileBIG))
                                        {
                                            Brush b = new SolidBrush(Color.Transparent);
                                            g.FillRectangle(b, destRect);
                                            srcRect.Width = 256;
                                            srcRect.Height = 256;

                                            destRect.Width = 256;
                                            destRect.Height = 256;
                                            destRect.X = x_tile * 256;
                                            destRect.Y = y_tile * 256;

                                            g.DrawImage(src, destRect, srcRect, System.Drawing.GraphicsUnit.Pixel);
                                        }
                                        src.Dispose();
                                    }
                                    y_tile++;
                                }
                                x_tile++;
                            }

                            tileBIG.Save(map_name.Text + "\\" + x_off.ToString() + "_" + y_off.ToString() + ".png", System.Drawing.Imaging.ImageFormat.Png);
                            tileBIG.Dispose();
                        }
                        y_off++;
                    }
                    x_off++;
                }
                sr.Close();

                FilesDone.Text = "";
                MessageBox.Show("Done");
            }
        }

        private void GPSFStoSiteDirWoLL_Click(object sender, EventArgs e)
        {
            bool worked = new GPSFS().ExtractGPSFStoSiteDir(map_name.Text);

            if (worked)
                MessageBox.Show("GPSFS extracted into GPSFS_Extracted_tiles");
            else
                MessageBox.Show("Something went wrong, invalid dir, GPSFS_Extracted_tiles already exists, etc.");
        }
    }
}