using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;

namespace GMDL
{
    public partial class GPSFSdirTester : Form
    {
        public GPSFSdirTester(string MapDir)
        {
            InitializeComponent();

            map_name.Text = MapDir;

            eIDX = new DataTable();
            eIDX.Columns.Add("Location", typeof(String));
            eIDX.Columns.Add("IDXfile", typeof(Int32));
            eIDX.Columns.Add("IDXoffset", typeof(Int32));

            Grid.DataSource = eIDX;

            IDX = new DataTable();
            IDX.Columns.Add("Location", typeof(String));
            IDX.Columns.Add("IDXfile", typeof(Int32));
            IDX.Columns.Add("IDXoffset", typeof(Int32));
        }

        DataTable eIDX;
        DataTable IDX;

        // code copied from ExtractGPSFS and GetGPSFStileReverse (for future changes)
        private void GPSFSdirTester_Load(object sender, EventArgs e)
        {
            this.Show();

            string percent_done = "";

            FilesDone.Text = "Opening File";
            Application.DoEvents();

            BinaryReader sr = new BinaryReader(new FileStream(map_name.Text + "/GPSFS", FileMode.Open));
            try
            {
                string gpsfsv = "";
                Int64 x = -1;
                Int64 y = -1;
                Int64 basezoom = 0;
                Int64 filetype = -1;
                Int64 maxsize = -1;

                gpsfsv += sr.ReadChar();
                gpsfsv += sr.ReadChar();
                gpsfsv += sr.ReadChar();
                gpsfsv += sr.ReadChar();
                gpsfsv += sr.ReadChar();
                gpsfsv += sr.ReadChar();
                gpsfsv += sr.ReadChar();
                gpsfsv += sr.ReadChar();

                x = sr.ReadInt64();
                y = sr.ReadInt64();
                basezoom = sr.ReadInt64();
                filetype = sr.ReadInt64();
                maxsize = sr.ReadInt64();

                Potential.Text = maxsize.ToString();

                if (filetype == 0)
                    MapType.Text = "png";
                else
                    MapType.Text = "jpg";

                FilesDone.Text = "Reading Index (will take a while for large maps)";
                Application.DoEvents();

                // get N + 1 coords

                GPSFS gfs = new GPSFS();

                int top_dir = 0;
                int tiles = 0;
                while (tiles < maxsize)
                {
                    top_dir++;
                    tiles = System.Convert.ToInt32(gfs.TotalTiles(top_dir));
                }

                // table of tiles loc, with length, length++ (in order)
                int zoom = 1;
                while (zoom <= top_dir)
                {
                    //new DirectoryInfo(map_dir + "/GPSFS_Extracted/" + zoom.ToString() + "x").Create();
                    int row = 0;
                    while (row < (top_dir * 2) / zoom)
                    {
                        //new DirectoryInfo(map_dir + "/GPSFS_Extracted/" + zoom.ToString() + "x/" + row.ToString("000")).Create();
                        int col = 0;
                        while (col < (top_dir * 2) / zoom)
                        {
                            DataRow new_row = IDX.NewRow();
                            new_row["Location"] = "/" + zoom.ToString() + "x/" + row.ToString("000") + "/" + zoom.ToString() + "x" + row.ToString("000") + col.ToString("000") + "." + MapType.Text;
                            new_row["IDXfile"] = sr.ReadInt32();
                            new_row["IDXoffset"] = sr.ReadInt32();
                            IDX.Rows.Add(new_row);

                            col++;
                        }
                        row++;
                    }
                    zoom = zoom * 2; // will round down to 0
                }

                DataRow new_rowE = IDX.NewRow();
                new_rowE["Location"] = "";
                new_rowE["IDXfile"] = sr.ReadInt32(); // the last one
                new_rowE["IDXoffset"] = sr.ReadInt32(); // the last one
                IDX.Rows.Add(new_rowE);

                FilesDone.Text = "Processing Tiles";
                Application.DoEvents();

                int IDXfile = 0;

                int specified = 0;
                int empty = 0;
                int good = 0;
                int bad = 0;

                for (int i = 0; i < maxsize; )
                {
                    if ((int)IDX.Rows[i]["IDXoffset"] >= 0)
                    {
                        int length;
                        if ((int)IDX.Rows[i + 1]["IDXoffset"] > 0)
                        {
                            length = (int)IDX.Rows[i + 1]["IDXoffset"] - (int)IDX.Rows[i]["IDXoffset"];
                        }
                        else if ((int)IDX.Rows[i + 1]["IDXoffset"] < 0)
                        {
                            length = (int)IDX.Rows[i + 1]["IDXoffset"] * -1;
                        }
                        else // if ((int)IDX.Rows[i + 1]["IDXoffset"] == 0)
                        {
                            length = System.Convert.ToInt32(sr.BaseStream.Length) - (int)IDX.Rows[i]["IDXoffset"];
                        }

                        if (IDXfile != (int)IDX.Rows[i]["IDXfile"])
                        {
                            IDXfile = (int)IDX.Rows[i]["IDXfile"];
                            sr.Close();
                            sr = new BinaryReader(new FileStream(map_name.Text + "/GPSFS" + IDXfile.ToString(), FileMode.Open));
                        }

                        specified++;

                        try
                        {
                            Bitmap bm = new Bitmap(new MemoryStream(sr.ReadBytes(System.Convert.ToInt32(length))));
                            if (ShowTiles.Checked)
                                tile.Image = bm;

                            good++;
                        }
                        catch
                        {
                            bad++;

                            eIDX.Rows.Add(IDX.Rows[i].ItemArray);
                            eIDX.Rows.Add(IDX.Rows[i + 1].ItemArray); // for length calc
                        }
                    }
                    else
                    {
                        empty++;
                    }

                    i++;

                    Specified.Text = specified.ToString();
                    Empty.Text = empty.ToString();
                    Good.Text = good.ToString();
                    Bad.Text = bad.ToString();

                    percent_done = (100 * i / maxsize).ToString("0") + "% - ";
                    if (this.Text.IndexOf("%") == -1)
                        this.Text = percent_done + this.Text;
                    else
                        this.Text = percent_done + this.Text.Substring(this.Text.IndexOf("%") + 4, this.Text.Length - 4 - this.Text.IndexOf("%"));
                    FilesDone.Text = percent_done + i.ToString() + " out of " + maxsize.ToString();
                    Application.DoEvents();
                }

                MessageBox.Show("Done");
            }
            catch
            {
                MessageBox.Show("Something went wrong");
            }
            
            sr.Close();
        }

        private void SaveIDX_Click(object sender, EventArgs e)
        {
            if (new FileInfo(map_name.Text + "/index.txt").Exists)
            {
                MessageBox.Show("index.txt already exists");
            }
            else
            {
                StreamWriter srI = new StreamWriter(map_name.Text + "/index.txt");
                foreach (DataRow row in IDX.Rows)
                {
                    srI.WriteLine(row["Location"].ToString() + "," + row["IDXfile"].ToString() + "," + row["IDXoffset"].ToString());
                }
                srI.Close();

                MessageBox.Show("Saved to index.txt in the map directory");
            }
        }
    }
}