using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Net;

using System.IO;

namespace GMDL
{
    public partial class GMdl_2ndTryDL : Form
    {
        public GMdl_2ndTryDL(DataTable Missing_tiles, mapURL MU, WebClient WC)
        {
            InitializeComponent();

            mu = MU;

            wc = WC;
            
            missing_tiles = Missing_tiles.Copy(); // so removing rows doesn't give an error (works?)

            Grid.DataSource = missing_tiles;
        }

        private DataTable missing_tiles;

        public mapURL mu;

        private WebClient wc;
        private Random ran = new Random();

        private void GiveUp_Click(object sender, EventArgs e)
        {
            string map_name = missing_tiles.Rows[0]["File"].ToString();
            map_name = map_name.Substring(0, map_name.IndexOf("/"));

            StreamWriter sr2 = new StreamWriter(map_name + "/ERROR_LOG.txt", true);

            foreach (DataRow row in missing_tiles.Rows)
            {
                sr2.WriteLine(mu.MapByType((int)row["z"], (int)row["x"], (int)row["y"], (string)row["map_type"]) + " TO " + (string)row["File"]);
            }

            sr2.Close();

            MessageBox.Show("See ERROR_LOG.txt in the map folder for a list of tiles that were missed");
            this.Close();
        }

        private bool ThumbnailCallback()
        {
            return false;
        }

        private void CheckGoogleSat()
        {
            if (mu.CheckGoogleSatOK() == false)
                MessageBox.Show("Google Satellite tile test failed\n\nMay be an idea to change connection");
        }

        private void TryAgain_Click(object sender, EventArgs e)
        {
            Progress.Visible = true;
            int total = missing_tiles.Rows.Count;
            int count = 0;
            int done_ok = 0;
            int row_num = 0;

            string percent_done = "";

            while (row_num < missing_tiles.Rows.Count)
            {
                DataRow row = missing_tiles.Rows[row_num];
                if (WarnOnTileFail.Checked)
                {
                    if (ran.Next(1, 10) == 1)
                    {
                        CheckGoogleSat();
                    }
                }
                count++;
                percent_done = (100 * count / total).ToString("0") + "% - ";
                if (this.Text.IndexOf("%") == -1)
                    this.Text = percent_done + this.Text;
                else
                    this.Text = percent_done + this.Text.Substring(this.Text.IndexOf("%") + 4, this.Text.Length - 4 - this.Text.IndexOf("%"));
                Progress.Text = "On tile " + count.ToString() + " out of " + total.ToString() + " got " + done_ok.ToString();
                Application.DoEvents();
                try
                {
                    GetThreadTile(new Object[] { (int)missing_tiles.Rows[row_num]["z"], (int)missing_tiles.Rows[row_num]["x"], (int)missing_tiles.Rows[row_num]["y"],
                        (string)missing_tiles.Rows[row_num]["File"], (string)missing_tiles.Rows[row_num]["map_type"], (string)missing_tiles.Rows[row_num]["overlay"] });
                    
                    row.Delete();
                    
                    done_ok++;
                }
                catch
                {
                    row_num++;

                    if (WarnOnTileFail.Checked)
                    {
                        CheckGoogleSat();
                    }
                }
            }
            Progress.Visible = false;

            if (missing_tiles.Rows.Count == 0)
            {
                MessageBox.Show("Got all tiles successfully");
                this.Close();
            }
            else
            {
                MessageBox.Show(missing_tiles.Rows.Count.ToString() + " missing tiles still remain (" + total.ToString() + " previously) got " + done_ok.ToString() + ", you may want to try again");
            }
        }

        private void GetThreadTile(object Thread_xyz) // static?
        {
            Object[] thread_xyz = (Object[])Thread_xyz;
            int thread_z = (int)thread_xyz[0];
            int thread_x = (int)thread_xyz[1];
            int thread_y = (int)thread_xyz[2];
            string full_file_name = (string)thread_xyz[3];
            string map_type = (string)thread_xyz[4];
            string overlay = (string)thread_xyz[5];

            if (new FileInfo(full_file_name).Exists == false)
            {
                if (WarnOnTileFail.Checked)
                {
                    if (ran.Next(1, 10) == 1)
                    {
                        CheckGoogleSat();
                    }
                }

                if (overlay != "")
                {
                    Bitmap sat = new Bitmap(1, 1);
                    Bitmap trans = new Bitmap(1, 1);

                    try
                    {
                        if (map_type == "iYs")
                        {
                            sat = (Bitmap)new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type)))).GetThumbnailImage(256, 256, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero);
                        }
                        else
                        {
                            sat = new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type))));
                        }
                    }
                    catch { }

                    try
                    {
                        if (overlay == "Yahooo Hybrid")
                        {
                            trans = (Bitmap)new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, overlay)))).GetThumbnailImage(256, 256, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero);
                        }
                        else
                        {
                            trans = new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, overlay))));
                        }
                    }
                    catch { }

                    if (sat.Width != 1 && trans.Width != 1)
                    {
                        Graphics.FromImage(sat).DrawImage(trans, new Rectangle(0, 0, 256, 256), new Rectangle(0, 0, 256, 256), System.Drawing.GraphicsUnit.Pixel);
                        sat.Save(full_file_name, System.Drawing.Imaging.ImageFormat.Jpeg);
                        sat.Dispose();
                        trans.Dispose();
                    }
                    else
                    {
                        int i1 = Int32.Parse("Need an error thrown");
                    }
                }
                else
                {
                    try
                    {
                        GetTile(thread_z, thread_x, thread_y, full_file_name, map_type);
                    }
                    catch
                    {
                        int i1 = Int32.Parse("Need an error thrown");
                    }
                }
            }
        }

        private void GetTile(int thread_z, int thread_x, int thread_y, string full_file_name, string map_type)
        {
            if (map_type == "iBAIDUm")
                new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type)))).GetThumbnailImage(256, 256, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero).Save(full_file_name, System.Drawing.Imaging.ImageFormat.Png);
            else if (map_type == "iMAP2GOm")
                new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type)))).Save(full_file_name, System.Drawing.Imaging.ImageFormat.Png);
            else if (map_type == "iYs")
                new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type)))).GetThumbnailImage(256, 256, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero).Save(full_file_name, System.Drawing.Imaging.ImageFormat.Jpeg);
            else if (map_type == "iYm")
                new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type)))).GetThumbnailImage(256, 256, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero).Save(full_file_name, System.Drawing.Imaging.ImageFormat.Png);
            else if (map_type == "iMabc")
                new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type)))).Save(full_file_name, System.Drawing.Imaging.ImageFormat.Png);
            else if (map_type.StartsWith("iMETRO") || map_type.StartsWith("iUB"))
                new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(thread_z, thread_x, thread_y, map_type)))).Save(full_file_name, System.Drawing.Imaging.ImageFormat.Png);
            else
                wc.DownloadFile(mu.MapByType(thread_z, thread_x, thread_y, map_type), full_file_name);

            if (map_type.StartsWith("iNASA") || map_type.StartsWith("iWMS") || map_type.StartsWith("iUSGSortho") || map_type.StartsWith("iUSGStopo") || map_type.StartsWith("iUSGSuortho"))
            {
                FileInfo file_info = new FileInfo(full_file_name);
                try
                {
                    Bitmap testbm = new Bitmap(new MemoryStream(File.ReadAllBytes(file_info.FullName)));
                    testbm.Dispose();
                }
                catch
                {
                    MessageBox.Show("WMS server is probably busy, wait a while then continue:\n\n" + new StreamReader(file_info.FullName).ReadToEnd());
                    file_info.Delete();

                    int i1 = Int32.Parse("Need an error thrown");
                }
            }
        }

        private void GMdl_2ndTryDL_Load(object sender, EventArgs e)
        {
            if (missing_tiles.Rows[0]["map_type"].ToString() == "iS")
            {
                WarnOnTileFail.Enabled = true;
                WarnOnTileFail.Checked = true;
            }
            else
            {
                WarnOnTileFail.Enabled = false;
                WarnOnTileFail.Checked = false;
            }

            if (WarnOnTileFail.Enabled)
            {
                string page = wc.DownloadString("http://maps.google.com");

                string google_mt = "google.com/mt?n=404&v=";
                int start = page.IndexOf(google_mt);
                while (start != -1)
                {
                    start += google_mt.Length;
                    string google_ver = page.Substring(start, page.IndexOf("&", start) - start);
                    if (google_ver.IndexOf("t") != -1)
                        mu.iTversion = google_ver;
                    else
                        mu.iMversion = google_ver;
                    start = page.IndexOf(google_mt, start);
                }

                string google_s = "google.com/kh?n=404&v=";
                start = page.IndexOf(google_s);
                while (start != -1)
                {
                    start += google_mt.Length;
                    string google_ver = page.Substring(start, page.IndexOf("&", start) - start);
                    mu.iSversion = google_ver;
                    start = page.IndexOf(google_s, start);
                }
            }
        }
    }
}