using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;

using System.Diagnostics;

using System.Globalization;

using System.Net;

namespace GMDL
{
    public partial class CustomMap : Form
    {
        public CustomMap(mapURL MU, WebClient WC)
        {
            InitializeComponent();

            mu = MU;

            wc = WC;
        }

        public mapURL mu;

        private Bitmap source_image;

        LatLonXYcalcs LLXY = new LatLonXYcalcs();
        
        private WebClient wc;
        private Random ran = new Random();

        bool processed_source = false;

        private void LoadImage_Click(object sender, EventArgs e)
        {
            string dir = System.IO.Directory.GetCurrentDirectory();

            OpenFileDialog file = new OpenFileDialog();
            file.Filter = "PNG File - and proper size (*.png)|*.png";
            file.ShowDialog();

            System.IO.Directory.SetCurrentDirectory(dir);

            if (file.FileName != "")
            {
                FileStream image_file = new FileStream(file.FileName, FileMode.Open);
                Bitmap image = new Bitmap(image_file);
                image_file.Close();

                bool image_ok = true;

                if (image.Width != image.Height)
                {
                    image_ok = false;
                }
                if (image_ok)
                {
                    image_ok = false;
                    for (int i = 512; i <= 262144; i *= 2)
                    {
                        if (image.Width == i)
                            image_ok = true;
                    }
                }

                if (image_ok)
                {
                    source_image = image;
                    processed_source = false;
                    SourceImage.Image = (Bitmap)source_image.GetThumbnailImage(512, 512, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero);
                    Mzoom.Text = "";
                    string file_name = new FileInfo(file.FileName).Name;
                    file_name = file_name.Substring(0, file_name.LastIndexOf(".")).Trim();
                    map_name.Text = "_" + file_name;

                    int size = 2;
                    int num_tiles = size * size;
                    while (size * 256 < source_image.Width)
                    {
                        size *= 2;
                        num_tiles += size * size;
                    }
                    dimensions.Text = size.ToString();
                    tiles.Text = num_tiles.ToString();

                    NoCoords.Checked = true;
                }
                else
                {
                    image.Dispose();
                    MessageBox.Show("The source image needs to be square and 512*2^n pixels per side\n\n(512x512, 1024x1024, 2048x2048, etc. max 262144x262144 = 1024x1024 tiles)");
                }
            }
        }

        private void Mzoom_TextChanged(object sender, EventArgs e)
        {
            CalcBottom();
        }

        private void Mx_TextChanged(object sender, EventArgs e)
        {
            CalcBottom();
        }

        private void My_TextChanged(object sender, EventArgs e)
        {
            CalcBottom();
        }

        private string MapType()
        {
            foreach (Control cn in SelectedMap.Controls)
            {
                if (((RadioButton)cn).Checked)
                    return cn.Name;
            }

            return "";
        }

        private void CalcBottom()
        {
            if (Mzoom.Text != "" && Mx.Text != "" && My.Text != "")
            {
                try
                {
                    int zoom = Int32.Parse(Mzoom.Text);
                    int zoomed_size = 512;
                    while (zoomed_size < source_image.Width)
                    {
                        zoomed_size *= 2;
                        zoom--;
                    }
                    Minzoom.Text = zoom.ToString();
                    wTLx.Text = (Int32.Parse(Mx.Text) * Math.Pow(2, Int32.Parse(Mzoom.Text) - zoom)).ToString();
                    wTLy.Text = (Int32.Parse(My.Text) * Math.Pow(2, Int32.Parse(Mzoom.Text) - zoom)).ToString();

                    if (ShowComparison.Checked)
                    {
                        i00.Image = new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(Int32.Parse(Mzoom.Text), Int32.Parse(Mx.Text), Int32.Parse(My.Text), MapType()))));
                        i01.Image = new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(Int32.Parse(Mzoom.Text), Int32.Parse(Mx.Text), Int32.Parse(My.Text) + 1, MapType()))));
                        i10.Image = new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(Int32.Parse(Mzoom.Text), Int32.Parse(Mx.Text) + 1, Int32.Parse(My.Text), MapType()))));
                        i11.Image = new Bitmap(new MemoryStream(wc.DownloadData(mu.MapByType(Int32.Parse(Mzoom.Text), Int32.Parse(Mx.Text) + 1, Int32.Parse(My.Text) + 1, MapType()))));
                    }
                    else
                    {
                        i00.Image = null;
                        i01.Image = null;
                        i10.Image = null;
                        i11.Image = null;
                    }
                }
                catch
                {
                    i00.Image = null;
                    i01.Image = null;
                    i10.Image = null;
                    i11.Image = null;

                    Minzoom.Text = "";
                    wTLx.Text = "";
                    wTLy.Text = "";
                }
            }
            else
            {
                i00.Image = null;
                i01.Image = null;
                i10.Image = null;
                i11.Image = null;

                Minzoom.Text = "";
                wTLx.Text = "";
                wTLy.Text = "";
            }
        }

        private bool ThumbnailCallback()
        {
            return false;
        }

        private void SaveTiles_Click(object sender, EventArgs e)
        {
            if (map_name.Text == "")
            {
                SetMapDir_Click(Type.Missing, EventArgs.Empty);
            }

            int empty = 0;

            if ((Minzoom.Text == "" && NoCoords.Checked == false) || map_name.Text.Trim() == "")
            {
                MessageBox.Show("No settings or no name, try again");
            }
            else
            {
                DirectoryInfo map_dir = new DirectoryInfo(map_name.Text);
                if (map_dir.Exists && map_dir.GetFiles().Length + map_dir.GetDirectories().Length > 0)
                {
                    MessageBox.Show("Already There\n\nnote: if specifying an existing directory it needs to be empty");
                }
                else
                {
                    bool diff_drive = false;
                    if (map_name.Text.Length >= 2) // C:...
                    {
                        if (map_name.Text.Substring(1, 1) == ":") // C:
                        {
                            if (map_name.Text.Substring(0, 1).ToUpper() != Directory.GetCurrentDirectory().Substring(0, 1).ToUpper()) // C vs D
                            {
                                diff_drive = true;
                            }
                        }
                    }
                    string dest_dir = map_name.Text;
                    if (LocalGPSFStemp.Checked && diff_drive)
                    {
                        map_name.Text = ran.Next(100000, 999999).ToString();
                        map_dir = new DirectoryInfo(map_name.Text);
                    }

                    if (map_dir.Exists == false)
                        map_dir.Create();

                    if (NoCoords.Checked == false)
                    {
                        StreamWriter sr = new StreamWriter(map_name.Text + "/coords.txt");
                        sr.WriteLine(wTLx.Text + " " + wTLy.Text + " " + Minzoom.Text);
                        sr.Close();
                    }

                    string ext;
                    if (outPNG.Checked)
                        ext = ".png";
                    else //if (outJPEG.Checked)
                        ext = ".jpg";

                    int done_files = 0;
                    int dir_zoom = 1;

                    string percent_done = "";
                    int total = Int32.Parse(tiles.Text);

                    while (dir_zoom * 512 <= source_image.Width)
                    {
                        Bitmap image;
                        if (dir_zoom == 1 && (ReprocessBase.Checked == false || processed_source))
                            image = source_image;
                        else
                            image = (Bitmap)source_image.GetThumbnailImage(source_image.Width / dir_zoom, source_image.Height / dir_zoom, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero);

                        new DirectoryInfo(map_name.Text + "/" + dir_zoom.ToString() + "x").Create();

                        int row = 0;
                        int row_pixel = 0;
                        int col = 0;
                        int col_pixel = 0;

                        while (row_pixel < image.Height)
                        {
                            new DirectoryInfo(map_name.Text + "/" + dir_zoom.ToString() + "x" + "/" + row.ToString("000")).Create();
                            while (col_pixel < image.Width)
                            {
                                string file_name = dir_zoom.ToString() + "x" + row.ToString("000") + col.ToString("000");
                                string file_url = map_name.Text + "/" + dir_zoom.ToString() + "x" + "/" + row.ToString("000") + "/" + file_name + ext;

                                Rectangle rectangle = new Rectangle(col_pixel, row_pixel, 256, 256);
                                Bitmap cutVersion = image.Clone(rectangle, image.PixelFormat);

                                #region unused programatic emty test
                                /*Bitmap white256 = new Bitmap(256, 256);
                                Graphics g = Graphics.FromImage(white256);
                                g.FillRectangle(new SolidBrush(Color.White), new Rectangle(0, 0, 256, 256));

                                if (cutVersion == white256)
                                {
                                    int tt = 5;
                                }

                                bool not_empty = false;
                                int i = 0;
                                int j = 0;
                                Color white_pixel = Color.White;
                                while (i < 256)
                                {
                                    while (j < 256)
                                    {
                                        Color this_pixel = cutVersion.GetPixel(i, j);
                                        if (this_pixel.A != white_pixel.A || this_pixel.R != white_pixel.R || this_pixel.G != white_pixel.G || this_pixel.B != white_pixel.B)
                                        {
                                            not_empty = true;
                                            j = 256;
                                            i = 256;
                                        }
                                        j++;
                                    }
                                    j = 0;
                                    i++;
                                }*/
                                #endregion

                                //if (not_empty)
                                if (outPNG.Checked)
                                    cutVersion.Save(file_url, System.Drawing.Imaging.ImageFormat.Png);
                                else //if (outJPEG.Checked)
                                    cutVersion.Save(file_url, System.Drawing.Imaging.ImageFormat.Jpeg);
                                //else
                                cutVersion.Dispose();
                                if (RemoveEmptyTiles.Checked)
                                {
                                    FileInfo empty_file_test = new FileInfo(file_url);
                                    if (empty_file_test.Length < 2000) // seems to get them
                                    {
                                        empty_file_test.Delete();
                                        empty++;
                                    }
                                }
                                
                                done_files++;
                                percent_done = (100 * done_files / total).ToString("0") + "% - ";
                                if (this.Text.IndexOf("%") == -1)
                                    this.Text = percent_done + this.Text;
                                else
                                    this.Text = percent_done + this.Text.Substring(this.Text.IndexOf("%") + 4, this.Text.Length - 4 - this.Text.IndexOf("%"));
                                FilesDone.Text = percent_done + done_files.ToString() + " out of " + total.ToString() + " now at zoom " + dir_zoom.ToString() + "x [" + empty.ToString() + " empty tiles removed]";
                                Application.DoEvents();

                                col++;
                                col_pixel += 256;
                            }
                            col = 0;
                            col_pixel = 0;
                            row++;
                            row_pixel += 256;
                        }

                        if (dir_zoom == 1 && (ReprocessBase.Checked == false || processed_source))
                        {
                        }   // do nothing
                        else
                            image.Dispose();
                        dir_zoom *= 2;
                    }

                    // top left and bottom right (directories exist)
                    try
                    {
                        if (new FileInfo(map_name.Text + "\\1x\\000\\1x000000" + ext).Exists == false)
                        {
                            new FileInfo("resources\\empty_tile" + ext).CopyTo(map_name.Text + "\\1x\\000\\1x000000" + ext);
                        }
                    }
                    catch { }
                    try
                    {
                        string bottom_right = (source_image.Width / 256 - 1).ToString("000"); //(Math.Pow(2, 1 + Int32.Parse(Mzoom.Text) - Int32.Parse(Minzoom.Text)) - 1).ToString("000");
                        if (new FileInfo(map_name.Text + "\\1x\\" + bottom_right + "\\1x" + bottom_right + bottom_right + ext).Exists == false)
                        {
                            new FileInfo("resources\\empty_tile" + ext).CopyTo(map_name.Text + "\\1x\\" + bottom_right + "\\1x" + bottom_right + bottom_right + ext);
                        }
                    }
                    catch { }


                    // empty directories
                    foreach (DirectoryInfo dir_x in new DirectoryInfo(map_name.Text).GetDirectories())
                    {
                        foreach (DirectoryInfo dir_n in dir_x.GetDirectories())
                        {
                            if (dir_n.GetFiles().Length == 0)
                                dir_n.Delete();
                        }
                    }

                    if (CopyIcons.Checked && new DirectoryInfo("icons").Exists)
                    {
                        foreach (FileInfo icon in new DirectoryInfo("icons").GetFiles("*.png"))
                        {
                            icon.CopyTo(map_name.Text + "\\" + icon.Name);
                        }
                    }

                    // Same as mail GMDL w part commented out
                    //if (new DirectoryInfo(map_name.Text).Exists) // didn't get deleted by an error thrown
                    //{
                        if (NoGPSFS.Checked)
                        {
                            FilesDone.Text = "Finishing up, wait";

                            // directories
                            DirectoryInfo temp_dirDI = new DirectoryInfo(map_name.Text);

                            if (diff_drive) // move?
                            {
                                DirectoryInfo dest_dirDI = new DirectoryInfo(dest_dir);
                                if (dest_dirDI.Exists == false)
                                    dest_dirDI.Create();
                                foreach (FileInfo file in temp_dirDI.GetFiles())
                                {
                                    file.MoveTo(dest_dirDI.FullName + "\\" + file.Name);
                                }
                                foreach (DirectoryInfo file_dir in temp_dirDI.GetDirectories())
                                {
                                    CopyDir.Copy(file_dir.FullName, dest_dirDI.FullName + "\\" + file_dir.Name); // because...
                                }
                                temp_dirDI.Delete(true);
                            }

                            map_name.Text = dest_dir;

                            //if (show_map_ok)
                            //{
                            //    if (tiles_missed)
                            //        MessageBox.Show("Finished downlaoding the map\nbut there were missed tiles, see ERROR_LOG.txt in the map folder");
                            //    else
                                    MessageBox.Show("Finished downlaoding the map");
                            //}
                        }
                        else
                        {
                            // encode
                            FilesDone.Text = "Creating GPSFS, wait";
                            Application.DoEvents();
                            bool worked = new GPSFS().CreateGPSFS(map_name.Text);

                            if (worked)
                            {
                                // directories
                                DirectoryInfo temp_dirDI = new DirectoryInfo(map_name.Text);
                                new FileInfo(temp_dirDI.FullName + "\\" + "coords.txt").Delete();
                                foreach (DirectoryInfo dir_x in temp_dirDI.GetDirectories())
                                {
                                    dir_x.Delete(true);
                                }
                                if (diff_drive) // move?
                                {
                                    DirectoryInfo dest_dirDI = new DirectoryInfo(dest_dir);
                                    if (dest_dirDI.Exists == false)
                                        dest_dirDI.Create();
                                    foreach (FileInfo file in temp_dirDI.GetFiles())
                                    {
                                        file.MoveTo(dest_dirDI.FullName + "\\" + file.Name);
                                    }
                                    temp_dirDI.Delete();
                                }

                                map_name.Text = dest_dir;

                                //if (show_map_ok)
                                //{
                                //    if (tiles_missed)
                                //        MessageBox.Show("Finished downlaoding the map\nbut there were missed tiles, see ERROR_LOG.txt in the map folder" + "\n\nand\n\nGPSFS created");
                                //    else
                                        MessageBox.Show("Finished downlaoding the map" + "\n\nand\n\nGPSFS created");
                                //}
                            }
                            else
                            {
                                //if (show_map_ok)
                                //{
                                    MessageBox.Show("Something went wrong, invalid dir, GPSFS already exists, etc.\n\n" + map_name.Text + " + is where it's (temp) at\n\nnever having made it to" + dest_dir + " (if different)");
                                //}
                            }
                        }
                    //}
                }
            }
        }

        private void ShowComparison_CheckedChanged(object sender, EventArgs e)
        {
            CalcBottom();
        }

        private void LoadAnyImage_Click(object sender, EventArgs e)
        {
            decimal top_lat = 0;
            decimal top_lon = 0;

            decimal bot_lat = 0;
            decimal bot_lon = 0;

            int top_zoom = 0;
            int bot_zoom = 0;

            bool val_ok = true;
            try
            {
                top_lat = Decimal.Parse(topLat.Text, NumberFormatInfo.InvariantInfo);
                top_lon = Decimal.Parse(topLon.Text, NumberFormatInfo.InvariantInfo);

                bot_lat = Decimal.Parse(botLat.Text, NumberFormatInfo.InvariantInfo);
                bot_lon = Decimal.Parse(botLon.Text, NumberFormatInfo.InvariantInfo);

                top_zoom = Int32.Parse(baseZoom.Text, NumberFormatInfo.InvariantInfo);
                bot_zoom = Int32.Parse(baseZoom.Text, NumberFormatInfo.InvariantInfo);
            }
            catch
            {
                val_ok = false;
            }

            if (val_ok == false)
            {
                MessageBox.Show("Map parameters are incorrect");
            }
            else
            {
                bool fit2x2 = false;
                while (fit2x2 == false)
                {
                    int[] top = LLXY.CalculateXY(top_lat, top_lon, (decimal)top_zoom);
                    int[] bot = LLXY.CalculateXY(bot_lat, bot_lon, (decimal)top_zoom);

                    if (top[0] + 1 == bot[0] && top[1] == bot[1])
                    {
                        fit2x2 = true;
                    }
                    else if (top[0] == bot[0] && top[1] + 1 == bot[1])
                    {
                        fit2x2 = true;
                    }
                    else if (top[0] + 1 == bot[0] && top[1] + 1 == bot[1])
                    {
                        fit2x2 = true;
                    }
                    else
                    {
                        top_zoom++;
                    }
                }

                int tile_size = System.Convert.ToInt32(Math.Pow(2, 1 + top_zoom - bot_zoom));

                if (tile_size > 32)
                {
                    MessageBox.Show("This would generate a " + tile_size.ToString() + " map, max is 32 for now (due to Bitmap's ~54*256^2 limit), try again with higher base zoom");
                }
                else
                {
                    int[] top = LLXY.CalculateXY(top_lat, top_lon, (decimal)top_zoom);

                    decimal[] Tcoord = LLXY.getLatLong(top[0], top[1], top_zoom);
                    decimal Tlat = Tcoord[1];
                    decimal Tlon = Tcoord[0];
                    decimal[] Bcoord = LLXY.getLatLong(top[0] + 2, top[1] + 2, top_zoom);
                    decimal Blat = Bcoord[1];
                    decimal Blon = Bcoord[0];

                    string dir = System.IO.Directory.GetCurrentDirectory();

                    OpenFileDialog file = new OpenFileDialog();
                    file.Filter = "PNG File - whatever size (*.png)|*.png";
                    file.ShowDialog();

                    System.IO.Directory.SetCurrentDirectory(dir);

                    if (file.FileName != "")
                    {
                        try
                        {
                            source_image.Dispose();
                        }
                        catch { }

                        FileStream image_file = new FileStream(file.FileName, FileMode.Open);
                        Bitmap file_image = new Bitmap(image_file);
                        image_file.Close();

                        int Swidth = System.Convert.ToInt32((top_lon - bot_lon) / (Tlon - Blon) * (decimal)tile_size * (decimal)256);
                        int Sheight = System.Convert.ToInt32((top_lat - bot_lat) / (Tlat - Blat) * (decimal)tile_size * (decimal)256);
                        int Sy = System.Convert.ToInt32((Tlat - top_lat) / (Tlat - Blat) * (decimal)tile_size * (decimal)256);
                        int Sx = System.Convert.ToInt32((Tlon - top_lon) / (Tlon - Blon) * (decimal)tile_size * (decimal)256);

                        Bitmap src = (Bitmap)file_image.GetThumbnailImage(Swidth, Sheight, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero);
                        file_image.Dispose();

                        // create bitmap
                        // needs to be < 64?!!! (~54 max)
                        source_image = new Bitmap(tile_size * 256, tile_size * 256);
                        processed_source = true;

                        // http://msdn.microsoft.com/coding4fun/weekend/imageshrinker/default.aspx

                        Rectangle srcRect = new Rectangle();
                        Rectangle destRect = new Rectangle();

                        destRect.Width = source_image.Width;
                        destRect.Height = source_image.Height;
                        using (Graphics g = Graphics.FromImage(source_image))
                        {
                            Brush b = new SolidBrush(Color.White);
                            g.FillRectangle(b, destRect);
                            srcRect.Width = src.Width;
                            srcRect.Height = src.Height;

                            destRect.Width = src.Width;
                            destRect.Height = src.Height;
                            destRect.X = Sx;
                            destRect.Y = Sy;

                            g.DrawImage(src, destRect, srcRect, System.Drawing.GraphicsUnit.Pixel);
                        }
                        src.Dispose();
                        SourceImage.Image = (Bitmap)source_image.GetThumbnailImage(512, 512, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero);

                        string file_name = new FileInfo(file.FileName).Name;
                        file_name = file_name.Substring(0, file_name.LastIndexOf(".")).Trim();
                        map_name.Text = "_" + file_name;

                        Mzoom.Text = top_zoom.ToString();

                        Mx.Text = top[0].ToString();
                        My.Text = top[1].ToString();

                        int size = 2;
                        int num_tiles = size * size;
                        while (size * 256 < source_image.Width)
                        {
                            size *= 2;
                            num_tiles += size * size;
                        }
                        dimensions.Text = size.ToString();
                        tiles.Text = num_tiles.ToString();

                        NoCoords.Checked = false;
                    }
                }
            }
        }


        private void SourceImage_MouseDown(object sender, MouseEventArgs e)
        {
            if (source_image != null)
            {
                int click_x = e.X;
                int click_y = e.Y;

                int img_x = source_image.Width * click_x / 512;
                if (img_x < 256)
                    img_x = 256;
                if (img_x > source_image.Width - 256)
                    img_x = source_image.Width - 256;
                int img_y = source_image.Height * click_y / 512;
                if (img_y < 256)
                    img_y = 256;
                if (img_y > source_image.Height - 256)
                    img_y = source_image.Height - 256;

                Rectangle rectangle = new Rectangle(img_x - 256, img_y - 256, 512, 512);
                Bitmap cutVersion = source_image.Clone(rectangle, source_image.PixelFormat);

                new CustomMapZoom(cutVersion).ShowDialog();

                cutVersion.Dispose();
            }
        }

        private void LatLonWebLink_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Process proc = new Process();
            proc.StartInfo.FileName = LatLonWebLink.Text;
            proc.Start();
        }



        private void topLat_TextChanged(object sender, EventArgs e)
        {
            if (topLat.Text != LLXY.MinutesToProper(topLat.Text))
                topLat.Text = LLXY.MinutesToProper(topLat.Text);
        }

        private void topLon_TextChanged(object sender, EventArgs e)
        {
            if (topLon.Text != LLXY.MinutesToProper(topLon.Text))
                topLon.Text = LLXY.MinutesToProper(topLon.Text);
        }

        private void botLat_TextChanged(object sender, EventArgs e)
        {
            if (botLat.Text != LLXY.MinutesToProper(botLat.Text))
                botLat.Text = LLXY.MinutesToProper(botLat.Text);
        }

        private void botLon_TextChanged(object sender, EventArgs e)
        {
            if (botLon.Text != LLXY.MinutesToProper(botLon.Text))
                botLon.Text = LLXY.MinutesToProper(botLon.Text);
        }

        private void PositioningWebLink_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            Process proc = new Process();
            proc.StartInfo.FileName = PositioningWebLink.Text;
            proc.Start();
        }

        private void SetMapDir_Click(object sender, EventArgs e)
        {
            string dir = System.IO.Directory.GetCurrentDirectory();

            FolderBrowserDialog file = new FolderBrowserDialog();
            file.ShowDialog();

            System.IO.Directory.SetCurrentDirectory(dir);

            if (file.SelectedPath != "")
            {
                map_name.Text = file.SelectedPath;
            }
        }

        private void LoadScaleUpAnyImage_Click(object sender, EventArgs e)
        {
            string dir = System.IO.Directory.GetCurrentDirectory();

            OpenFileDialog file = new OpenFileDialog();
            file.Filter = "PNG File - any size (*.png)|*.png";
            file.ShowDialog();

            System.IO.Directory.SetCurrentDirectory(dir);

            if (file.FileName != "")
            {
                FileStream image_file = new FileStream(file.FileName, FileMode.Open);
                Bitmap file_image = new Bitmap(image_file);
                image_file.Close();

                bool image_ok = true;

                int dimension = file_image.Width;
                if (dimension < file_image.Height)
                    dimension = file_image.Height;

                int dimension_sq = 512;
                while (dimension_sq < dimension)
                {
                    dimension_sq *= 2;
                }

                if (dimension_sq > 32 * 256)
                    image_ok = false;

                if (image_ok)
                {
                    try
                    {
                        source_image.Dispose();
                    }
                    catch { }

                    int Swidth = System.Convert.ToInt32((decimal)file_image.Width * (decimal)dimension_sq / (decimal)dimension);
                    int Sheight = System.Convert.ToInt32((decimal)file_image.Height * (decimal)dimension_sq / (decimal)dimension);
                    int Sy = System.Convert.ToInt32(((decimal)dimension_sq - (decimal)Sheight) / (decimal)2);
                    int Sx = System.Convert.ToInt32(((decimal)dimension_sq - (decimal)Swidth) / (decimal)2);

                    Bitmap src = (Bitmap)file_image.GetThumbnailImage(Swidth, Sheight, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero);
                    file_image.Dispose();

                    source_image = new Bitmap(dimension_sq, dimension_sq);
                    processed_source = true;

                    // http://msdn.microsoft.com/coding4fun/weekend/imageshrinker/default.aspx

                    Rectangle srcRect = new Rectangle();
                    Rectangle destRect = new Rectangle();

                    destRect.Width = source_image.Width;
                    destRect.Height = source_image.Height;
                    using (Graphics g = Graphics.FromImage(source_image))
                    {
                        Brush b = new SolidBrush(Color.White);
                        g.FillRectangle(b, destRect);
                        srcRect.Width = src.Width;
                        srcRect.Height = src.Height;

                        destRect.Width = src.Width;
                        destRect.Height = src.Height;
                        destRect.X = Sx;
                        destRect.Y = Sy;

                        g.DrawImage(src, destRect, srcRect, System.Drawing.GraphicsUnit.Pixel);
                    }
                    src.Dispose();
                    SourceImage.Image = (Bitmap)source_image.GetThumbnailImage(512, 512, new Image.GetThumbnailImageAbort(ThumbnailCallback), System.IntPtr.Zero);

                    string file_name = new FileInfo(file.FileName).Name;
                    file_name = file_name.Substring(0, file_name.LastIndexOf(".")).Trim();
                    map_name.Text = "_" + file_name;

                    int size = 2;
                    int num_tiles = size * size;
                    while (size * 256 < source_image.Width)
                    {
                        size *= 2;
                        num_tiles += size * size;
                    }
                    dimensions.Text = size.ToString();
                    tiles.Text = num_tiles.ToString();

                    NoCoords.Checked = true;
                }
                else
                {
                    file_image.Dispose();
                    MessageBox.Show("This would generate a " + (dimension_sq / 256).ToString() + " map, max is 32 for now (due to Bitmap's ~54*256^2 limit), try again with a smaller source image");
                }
            }
        }

        private void outJPEG_CheckedChanged(object sender, EventArgs e)
        {
            RemoveEmptyTiles.Checked = true;
            if (outJPEG.Checked)
            {
                RemoveEmptyTiles.Checked = false;
            }
        }
    }
}